/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format.dateFormat;

import oracle.dss.util.format.dateFormat.DateConstants;
import oracle.dss.util.format.dateFormat.DateFormatToken;
import oracle.dss.util.format.dateFormat.LiteralToken;
import oracle.dss.util.format.dateFormat.ModifierToken;
import oracle.dss.util.format.dateFormat.TimeUnitToken;

class Scanner {
    private String formatString;
    private int formatStringLen;
    private int startPos = 1;
    private int level;
    private int endPos = 47;
    private char curChar;
    private int curPos;
    private int theCase = 1;
    private boolean endFlag;
    private DateFormatToken lookToken;

    public Scanner(String string) {
        this.formatString = string;
        this.formatStringLen = string.length();
        if (!this.getNextChar()) {
            this.endFlag = true;
        }
    }

    public DateFormatToken getNextToken() {
        String string = "";
        if (this.formatStringLen >= this.curPos + 1) {
            string = this.formatString.substring(this.curPos - 1, this.curPos + 1);
        }
        if (this.endFlag) {
            this.lookToken = new TimeUnitToken(0);
        } else if (this.curChar == '\"') {
            int n = this.formatString.indexOf(34, this.curPos);
            if (n == -1) {
                this.lookToken = new LiteralToken(this.formatString.substring(this.curPos), 1000);
                this.endFlag = true;
            } else {
                this.lookToken = new LiteralToken(this.formatString.substring(this.curPos, n), 1000);
                this.curPos = n + 1;
                if (!this.getNextChar()) {
                    this.endFlag = true;
                }
            }
        } else if (!Character.isLetterOrDigit(this.curChar)) {
            int n = this.curPos - 1;
            if (this.curChar == '|') {
                n = this.curPos;
            }
            while (!Character.isLetterOrDigit(this.curChar) && this.curChar != '\"') {
                if (this.getNextChar()) continue;
                this.endFlag = true;
                break;
            }
            String string2 = this.endFlag ? this.formatString.substring(n, this.curPos) : this.formatString.substring(n, this.curPos - 1);
            this.lookToken = new LiteralToken(string2, 2000);
        } else if (this.formatStringLen >= this.curPos + 1 && (string.equalsIgnoreCase("FM") || string.equalsIgnoreCase("FX") || string.equalsIgnoreCase("SP") || string.equalsIgnoreCase("TH"))) {
            int n = 0;
            boolean bl = false;
            int n2 = 2;
            if (Character.isUpperCase(string.charAt(0))) {
                n2 = 1;
            }
            if (string.equalsIgnoreCase("FM")) {
                n = 100;
                bl = true;
            } else if (string.equalsIgnoreCase("FX")) {
                n = 200;
                bl = true;
            } else {
                n = string.equalsIgnoreCase("SP") ? 300 : 400;
            }
            this.lookToken = new ModifierToken(n, bl, string, n2);
            if (this.formatStringLen == this.curPos + 1) {
                this.endFlag = true;
            } else {
                this.getNextChar();
                this.getNextChar();
            }
        } else {
            int n = this.curPos - 1;
            while (this.charSearch(this.curChar)) {
                if (this.getNextChar()) continue;
                this.endFlag = true;
                break;
            }
            int n3 = this.curPos - 1;
            if (this.endFlag) {
                n3 = this.curPos;
            }
            if (DateConstants.AllFormats[this.startPos].length() == this.level) {
                if (this.startPos == 5 || this.startPos == 1 || this.startPos == 2 || this.startPos == 28) {
                    this.theCase = Character.isUpperCase(this.formatString.charAt(n)) ? 1 : 2;
                }
                this.lookToken = new TimeUnitToken(this.startPos, this.formatString.substring(n, n3), this.theCase, DateConstants.InputAllowed[this.startPos]);
            } else if (this.endPos == 43) {
                if (this.endFlag) {
                    this.curPos -= this.level - 1;
                    this.endFlag = false;
                } else {
                    this.curPos -= this.level;
                }
                this.getNextChar();
                String string3 = this.formatString.substring(n, n + 1);
                if (Character.isLowerCase(this.formatString.charAt(n))) {
                    this.theCase = 2;
                }
                this.lookToken = new TimeUnitToken(42, string3, this.theCase, DateConstants.InputAllowed[this.endPos - 1]);
            } else if (this.endPos == 36 && this.curPos - n == 4) {
                this.curPos -= 2;
                this.getNextChar();
                String string4 = this.formatString.substring(n, n3 - 1);
                this.lookToken = new TimeUnitToken(35, string4, this.theCase, DateConstants.InputAllowed[this.endPos - 1]);
            } else {
                this.lookToken = new TimeUnitToken(48, this.formatString.substring(n, n3));
            }
            this.level = 0;
            this.startPos = 1;
            this.endPos = 47;
            this.theCase = 1;
        }
        return this.lookToken;
    }

    private boolean charSearch(char c) {
        boolean bl = false;
        int n = this.endPos;
        int n2 = this.startPos;
        while (n2 <= n) {
            if (this.level < DateConstants.AllFormats[n2].length() && Character.toUpperCase(c) == DateConstants.AllFormats[n2].charAt(this.level)) {
                if (this.level == 0 && Character.isLowerCase(c)) {
                    this.theCase = 2;
                } else if (this.level == 1 && Character.isLowerCase(c) && this.theCase == 1) {
                    this.theCase = 3;
                }
                if (!bl) {
                    bl = true;
                    this.startPos = n2;
                }
                this.endPos = n2;
            }
            ++n2;
        }
        if (bl) {
            ++this.level;
        }
        return bl;
    }

    private boolean getNextChar() {
        if (this.curPos < this.formatStringLen) {
            this.curChar = this.formatString.charAt(this.curPos++);
            return true;
        }
        return false;
    }
}

