/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format.dateFormat;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.format.dateFormat.BadOracleDateFormatException;
import oracle.dss.util.format.dateFormat.DateConstants;
import oracle.dss.util.format.dateFormat.DateFormatToken;
import oracle.dss.util.format.dateFormat.LiteralToken;
import oracle.dss.util.format.dateFormat.LocaleDealer;
import oracle.dss.util.format.dateFormat.ModifierToken;
import oracle.dss.util.format.dateFormat.Scanner;
import oracle.dss.util.format.dateFormat.StringBasedDateFormat;
import oracle.dss.util.format.dateFormat.TimeUnitToken;

public class OracleDateFormat
extends StringBasedDateFormat {
    protected transient ErrorHandler m_eh;
    private Vector tokenList = new Vector();
    private Locale thisLocale;
    private TimeZone thisTimeZone;
    private String formatString = "";
    private String[] MonthNameInAbbr;
    private String[] MonthNameInFull;
    private String[] WeekDayInFull;
    private String[] WeekDayInAbbr;
    private String[] AmPmLowerCase;
    private String[] AmPmLowerCaseWithPeriods;
    private String[] AmPmUpperCase;
    private String[] AmPmUpperCaseWithPeriods;
    private String[] ErasLowerCase;
    private String[] ErasLowerCaseWithPeriods;
    private String[] ErasUpperCase;
    private String[] ErasUpperCaseWithPeriods;
    private char m_groupingSeparator = (char)44;
    private static final boolean DEBUG = false;

    public OracleDateFormat(String string) throws BadOracleDateFormatException {
        Locale locale = Locale.getDefault();
        this.thisTimeZone = TimeZone.getDefault();
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            this.setCalendar(new GregorianCalendar(locale));
        }
        this.FormatTheString(string, locale);
    }

    public OracleDateFormat(String string, Locale locale) throws BadOracleDateFormatException {
        this.thisTimeZone = TimeZone.getDefault();
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            this.setCalendar(new GregorianCalendar(locale));
        }
        this.FormatTheString(string, locale);
    }

    public OracleDateFormat(Locale locale) {
        this.thisLocale = locale;
        this.formatString = "";
        this.thisTimeZone = TimeZone.getDefault();
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            this.setCalendar(new GregorianCalendar(locale));
        }
    }

    public OracleDateFormat(Locale locale, TimeZone timeZone) {
        this.thisLocale = locale;
        this.formatString = "";
        this.thisTimeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        Calendar calendar = null;
        calendar = locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0 ? new GregorianCalendar(this.thisTimeZone, locale) : Calendar.getInstance(this.thisTimeZone, locale);
        this.setCalendar(calendar);
        LocaleDealer localeDealer = new LocaleDealer(locale);
        this.WeekDayInFull = localeDealer.getWeekDayName(false);
        this.WeekDayInAbbr = localeDealer.getWeekDayName(true);
        this.MonthNameInAbbr = localeDealer.getMonthName(true);
        this.MonthNameInFull = localeDealer.getMonthName(false);
        this.AmPmLowerCase = localeDealer.getAmPm(true, false);
        this.AmPmLowerCaseWithPeriods = localeDealer.getAmPm(true, true);
        this.AmPmUpperCase = localeDealer.getAmPm(false, false);
        this.AmPmUpperCaseWithPeriods = localeDealer.getAmPm(false, true);
        this.ErasLowerCase = localeDealer.getEras(true, false);
        this.ErasLowerCaseWithPeriods = localeDealer.getEras(true, true);
        this.ErasUpperCase = localeDealer.getEras(false, false);
        this.ErasUpperCaseWithPeriods = localeDealer.getEras(false, true);
        this.m_groupingSeparator = localeDealer.getGroupingSeparator();
    }

    private void FormatTheString(String string, Locale locale) throws BadOracleDateFormatException {
        Object object;
        this.formatString = string;
        Scanner scanner = new Scanner(this.formatString);
        this.tokenList = new Vector();
        int n = 0;
        DateFormatToken dateFormatToken = scanner.getNextToken();
        while (dateFormatToken.getType() != 0) {
            int n2 = dateFormatToken.getType();
            if (n2 == 48) {
                throw new BadOracleDateFormatException(String.valueOf(String.valueOf("Bad Format: ")) + dateFormatToken.getValue());
            }
            if (n2 == 13 || n2 == 14) {
                throw new BadOracleDateFormatException("Era not supported!");
            }
            if (n2 == 400 || n2 == 300) {
                if (n == 0) {
                    throw new BadOracleDateFormatException("Date format not recognized");
                }
                object = (DateFormatToken)this.tokenList.elementAt(n - 1);
                int n3 = ((DateFormatToken)object).getType();
                if (n3 == 23 && ((DateFormatToken)object).getCase() == 1 && dateFormatToken.getCase() == 2) {
                    ((TimeUnitToken)object).setCase(3);
                }
                int n4 = 0;
                while (n4 < 16) {
                    if (n3 == DateConstants.TokenFollowedByTHSP[n4]) {
                        throw new BadOracleDateFormatException(String.valueOf(String.valueOf("Bad Format: TH or SP can't modify ")) + ((DateFormatToken)object).getValue());
                    }
                    ++n4;
                }
                if (n2 == 400) {
                    if (!((TimeUnitToken)this.tokenList.elementAt(n - 1)).setTH()) {
                        throw new BadOracleDateFormatException("Bad Format: No two THs together.");
                    }
                } else if (!((TimeUnitToken)this.tokenList.elementAt(n - 1)).setSP()) {
                    throw new BadOracleDateFormatException("Bad Format: No two SPs together.");
                }
            } else {
                this.tokenList.addElement(dateFormatToken);
                ++n;
            }
            dateFormatToken = scanner.getNextToken();
        }
        if (locale != this.thisLocale) {
            this.thisLocale = locale;
            Calendar calendar = null;
            calendar = locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0 ? new GregorianCalendar(this.thisTimeZone, locale) : Calendar.getInstance(this.thisTimeZone, locale);
            this.setCalendar(calendar);
            object = new LocaleDealer(locale);
            this.WeekDayInFull = ((LocaleDealer)object).getWeekDayName(false);
            this.WeekDayInAbbr = ((LocaleDealer)object).getWeekDayName(true);
            this.MonthNameInAbbr = ((LocaleDealer)object).getMonthName(true);
            this.MonthNameInFull = ((LocaleDealer)object).getMonthName(false);
            this.AmPmLowerCase = ((LocaleDealer)object).getAmPm(true, false);
            this.AmPmLowerCaseWithPeriods = ((LocaleDealer)object).getAmPm(true, true);
            this.AmPmUpperCase = ((LocaleDealer)object).getAmPm(false, false);
            this.AmPmUpperCaseWithPeriods = ((LocaleDealer)object).getAmPm(false, true);
            this.ErasLowerCase = ((LocaleDealer)object).getEras(true, false);
            this.ErasLowerCaseWithPeriods = ((LocaleDealer)object).getEras(true, true);
            this.ErasUpperCase = ((LocaleDealer)object).getEras(false, false);
            this.ErasUpperCaseWithPeriods = ((LocaleDealer)object).getEras(false, true);
            this.m_groupingSeparator = ((LocaleDealer)object).getGroupingSeparator();
        }
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String string) {
        block7: {
            String string2 = this.formatString;
            try {
                this.FormatTheString(string, this.thisLocale);
                this.formatString = string;
            }
            catch (BadOracleDateFormatException badOracleDateFormatException) {
                if (this.m_eh != null) {
                    this.m_eh.error(badOracleDateFormatException, this.getClass().getName(), "setFormatString");
                } else {
                    badOracleDateFormatException.printStackTrace();
                }
                this.formatString = string2;
                if (this.formatString.equals("")) break block7;
                try {
                    this.FormatTheString(this.formatString, this.thisLocale);
                }
                catch (BadOracleDateFormatException badOracleDateFormatException2) {
                    this.formatString = "";
                    if (this.m_eh != null) {
                        this.m_eh.error(badOracleDateFormatException, this.getClass().getName(), "setFormatString");
                        break block7;
                    }
                    badOracleDateFormatException2.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            } else {
                System.out.println("Oracle date format string hasn't been set");
            }
            stringBuffer.append(date.toString());
            return stringBuffer;
        }
        int n = this.tokenList.size();
        Calendar calendar = this.getCalendar();
        calendar.setTime(date);
        int n2 = calendar.get(1);
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = 0;
        while (n3 < n) {
            DateFormatToken dateFormatToken = (DateFormatToken)this.tokenList.elementAt(n3);
            if (dateFormatToken instanceof LiteralToken) {
                stringBuffer.append(dateFormatToken.getValue());
            } else if (dateFormatToken instanceof ModifierToken) {
                if (dateFormatToken.getType() == 100) {
                    bl = !bl;
                } else if (dateFormatToken.getType() != 200) {
                    // empty if block
                }
            } else {
                stringBuffer.append(this.processToken((TimeUnitToken)dateFormatToken, date, bl, calendar, n2));
            }
            ++n3;
        }
        return stringBuffer;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    private String processToken(TimeUnitToken timeUnitToken, Date date, boolean bl, Calendar calendar, int n) {
        String string = "";
        int n2 = timeUnitToken.getType();
        switch (n2) {
            case 1: 
            case 5: {
                if (calendar.get(0) == 1) {
                    if (timeUnitToken.getCase() == 1) {
                        string = this.ErasUpperCaseWithPeriods[1];
                        break;
                    }
                    string = this.ErasLowerCaseWithPeriods[1];
                    break;
                }
                if (timeUnitToken.getCase() == 1) {
                    string = this.ErasUpperCaseWithPeriods[0];
                    break;
                }
                string = this.ErasLowerCaseWithPeriods[0];
                break;
            }
            case 2: 
            case 28: {
                if (calendar.get(9) == 1) {
                    if (timeUnitToken.getCase() == 1) {
                        string = this.AmPmUpperCaseWithPeriods[1];
                        break;
                    }
                    string = this.AmPmLowerCaseWithPeriods[1];
                    break;
                }
                if (timeUnitToken.getCase() == 1) {
                    string = this.AmPmUpperCaseWithPeriods[0];
                    break;
                }
                string = this.AmPmLowerCaseWithPeriods[0];
                break;
            }
            case 3: 
            case 6: {
                if (calendar.get(0) == 1) {
                    if (timeUnitToken.getCase() == 1) {
                        string = this.ErasUpperCase[1];
                        break;
                    }
                    string = this.ErasLowerCase[1];
                    break;
                }
                if (timeUnitToken.getCase() == 1) {
                    string = this.ErasUpperCase[0];
                    break;
                }
                string = this.ErasLowerCase[0];
                break;
            }
            case 4: 
            case 29: {
                if (calendar.get(9) == 1) {
                    if (timeUnitToken.getCase() == 1) {
                        string = this.AmPmUpperCase[1];
                        break;
                    }
                    string = this.AmPmLowerCase[1];
                    break;
                }
                if (timeUnitToken.getCase() == 1) {
                    string = this.AmPmUpperCase[0];
                    break;
                }
                string = this.AmPmLowerCase[0];
                break;
            }
            case 7: 
            case 34: {
                int n3 = n / 100;
                if (n % 100 != 0) {
                    ++n3;
                }
                string = Integer.toString(n3);
                if (n3 < 10 && bl) {
                    string = String.valueOf(String.valueOf("0")) + string;
                }
                String string2 = " ";
                if (calendar.get(0) != 1) {
                    string2 = "-";
                }
                if (n2 != 34) break;
                string = String.valueOf(string2) + string;
                break;
            }
            case 8: {
                string = Integer.toString(calendar.get(7));
                break;
            }
            case 9: {
                int n4 = calendar.get(7);
                string = this.WeekDayInFull[n4 - 1];
                if (timeUnitToken.getCase() == 1) {
                    string = string.toUpperCase();
                } else if (timeUnitToken.getCase() == 2) {
                    string = string.toLowerCase();
                }
                if (bl) break;
                string = string.trim();
                break;
            }
            case 10: {
                int n5 = calendar.get(5);
                if (n5 < 10 && bl) {
                    string = String.valueOf(String.valueOf("0")) + Integer.toString(n5);
                    break;
                }
                string = Integer.toString(n5);
                break;
            }
            case 11: {
                int n6 = calendar.get(6);
                if (!bl) {
                    string = Integer.toString(n6);
                    break;
                }
                String string3 = "";
                if (n6 < 10) {
                    string3 = "00";
                } else if (n6 < 100) {
                    string3 = "0";
                }
                string = String.valueOf(string3) + Integer.toString(n6);
                break;
            }
            case 12: {
                int n7 = calendar.get(7);
                string = this.WeekDayInAbbr[n7 - 1];
                if (timeUnitToken.getCase() == 1) {
                    string = string.toUpperCase();
                    break;
                }
                if (timeUnitToken.getCase() != 2) break;
                string = string.toLowerCase();
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("h");
                simpleDateFormat.setCalendar(this.getCalendar());
                string = simpleDateFormat.format(date);
                if (!bl || string.length() != 1) break;
                string = String.valueOf(String.valueOf("0")) + string;
                break;
            }
            case 17: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H");
                simpleDateFormat.setCalendar(this.getCalendar());
                string = simpleDateFormat.format(date);
                if (!bl || string.length() != 1) break;
                string = String.valueOf(String.valueOf("0")) + string;
                break;
            }
            case 19: {
                int n8 = this.weekInISO(calendar);
                string = Integer.toString(n8);
                if (!bl || n8 >= 10) break;
                string = String.valueOf(String.valueOf("0")) + string;
                break;
            }
            case 23: {
                int n9;
                int n10;
                int n11 = calendar.get(2) + 1;
                int n12 = calendar.get(5);
                int n13 = 0;
                int n14 = n;
                if (calendar.get(0) != 1) {
                    n14 = -n;
                }
                if (n14 < 1582 || n14 == 1582 && n11 < 10 || n14 == 1582 && n11 == 10 && n12 < 5) {
                    n10 = (4712 + n) * 365;
                    n9 = 1178 + (n - 1) / 4;
                    if (calendar.get(0) != 1) {
                        n10 = (4712 - n) * 365;
                        n9 = (4712 - n + 1) / 4 - 1;
                        if (n9 < 0) {
                            n9 = 0;
                        }
                    }
                    n13 = n10 + n9 + calendar.get(6);
                } else if (n14 == 1582 && n11 == 10 && n12 > 4 && n12 < 16) {
                    n13 = 2299161;
                } else {
                    n10 = (4712 + n) * 365;
                    n9 = (n - 1) / 100;
                    int n15 = 1179 + (n - 1) / 4 - n9 + n9 / 4 + 1;
                    n13 = n10 + n15 + calendar.get(6);
                }
                string = Integer.toString(n13);
                n10 = string.length();
                if (n10 == 7 || !bl) break;
                n9 = 0;
                while (n9 < 7 - n10) {
                    string = String.valueOf(String.valueOf("0")) + string;
                    ++n9;
                }
                break;
            }
            case 24: {
                int n16 = calendar.get(12);
                string = Integer.toString(n16);
                if (!bl || n16 >= 10) break;
                string = String.valueOf(String.valueOf("0")) + string;
                break;
            }
            case 25: {
                int n17 = calendar.get(2) + 1;
                string = Integer.toString(n17);
                if (!bl || n17 >= 10) break;
                string = String.valueOf(String.valueOf("0")) + string;
                break;
            }
            case 26: {
                string = this.MonthNameInAbbr[calendar.get(2)];
                if (timeUnitToken.getCase() == 1) {
                    string = string.toUpperCase();
                    break;
                }
                if (timeUnitToken.getCase() != 2) break;
                string = string.toLowerCase();
                break;
            }
            case 27: {
                string = this.MonthNameInFull[calendar.get(2)];
                if (timeUnitToken.getCase() == 1) {
                    string = string.toUpperCase();
                } else if (timeUnitToken.getCase() == 2) {
                    string = string.toLowerCase();
                }
                if (bl) break;
                string = string.trim();
                break;
            }
            case 30: {
                int n18 = calendar.get(2) / 3 + 1;
                string = Integer.toString(n18);
                break;
            }
            case 31: {
                string = DateConstants.MonthInRoman[calendar.get(2)];
                if (timeUnitToken.getCase() == 1) {
                    string = string.toUpperCase();
                } else if (timeUnitToken.getCase() == 2) {
                    string = string.toLowerCase();
                }
                if (bl) break;
                string = string.trim();
                break;
            }
            case 35: {
                int n19 = calendar.get(13);
                string = Integer.toString(n19);
                if (!bl || n19 >= 10) break;
                string = String.valueOf(String.valueOf("0")) + string;
                break;
            }
            case 36: {
                int n20 = calendar.get(11);
                int n21 = calendar.get(12);
                int n22 = calendar.get(13);
                string = Integer.toString(n20 * 3600 + n21 * 60 + n22);
                if (!bl) break;
                int n23 = 5 - string.length();
                int n24 = 0;
                while (n24 < n23) {
                    string = String.valueOf(String.valueOf("0")) + string;
                    ++n24;
                }
                break;
            }
            case 40: {
                int n25 = calendar.get(5);
                string = Integer.toString((n25 - 1) / 7 + 1);
                break;
            }
            case 41: {
                int n26 = calendar.get(6);
                int n27 = (n26 - 1) / 7 + 1;
                string = Integer.toString(n27);
                if (!bl || n27 >= 10) break;
                string = String.valueOf(String.valueOf("0")) + string;
                break;
            }
            case 18: 
            case 42: {
                int n28 = n;
                if (n2 == 18) {
                    n28 = this.yearInISO(calendar);
                }
                String string4 = Integer.toString(n28);
                int n29 = string4.length();
                string = string4.substring(n29 - 1, n29);
                break;
            }
            case 38: {
                String string5 = " ";
                string = this.spellYear(n, timeUnitToken.getCase());
                if (calendar.get(0) != 1) {
                    string5 = "-";
                }
                string = String.valueOf(string5) + string;
                break;
            }
            case 44: {
                string = this.spellYear(n, timeUnitToken.getCase());
                break;
            }
            case 20: 
            case 32: 
            case 45: {
                String string6;
                int n30;
                int n31 = n;
                if (n2 == 20) {
                    n31 = this.yearInISO(calendar);
                }
                if ((n30 = (string6 = Integer.toString(n31)).length()) == 1) {
                    if (bl) {
                        string = String.valueOf(String.valueOf("0")) + string6;
                        break;
                    }
                    string = string6;
                    break;
                }
                string = string6.substring(n30 - 2, n30);
                if (bl || string.charAt(0) != '0') break;
                string = string.substring(1, 2);
                break;
            }
            case 21: 
            case 46: {
                int n32;
                int n33 = n;
                if (n2 == 21) {
                    n33 = this.yearInISO(calendar);
                }
                if ((n32 = (string = Integer.toString(n33)).length()) == 1) {
                    if (!bl) break;
                    string = String.valueOf(String.valueOf("00")) + string;
                    break;
                }
                if (n32 == 2) {
                    if (!bl) break;
                    string = String.valueOf(String.valueOf("0")) + string;
                    break;
                }
                string = string.substring(n32 - 3, n32);
                if (bl) break;
                if (string.startsWith("00")) {
                    string = string.substring(2, 3);
                    break;
                }
                if (!string.startsWith("0")) break;
                string = string.substring(1, 3);
                break;
            }
            case 22: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 47: {
                int n34;
                int n35 = n;
                if (n2 == 22) {
                    n35 = this.yearInISO(calendar);
                }
                if ((n34 = (string = Integer.toString(n35)).length()) == 1) {
                    if (bl) {
                        string = String.valueOf(String.valueOf("000")) + string;
                    }
                } else if (n34 == 2) {
                    if (bl) {
                        string = String.valueOf(String.valueOf("00")) + string;
                    }
                } else if (n34 == 3 && bl) {
                    string = String.valueOf(String.valueOf("0")) + string;
                }
                n34 = string.length();
                String string7 = " ";
                if (calendar.get(0) == 0) {
                    string7 = "-";
                }
                if (n2 == 43 && n34 == 4) {
                    string = String.valueOf(string.substring(0, 1)) + this.m_groupingSeparator + string.substring(1, 4);
                    break;
                }
                if (n2 == 37) {
                    if (n34 == 4) {
                        string = String.valueOf(string7) + string.substring(0, 1) + this.m_groupingSeparator + string.substring(1, 4);
                        break;
                    }
                    string = String.valueOf(string7) + string;
                    break;
                }
                if (n2 != 39) break;
                string = String.valueOf(string7) + string;
                break;
            }
            default: {
                System.out.println("Shouldn't be here at all!");
            }
        }
        if (timeUnitToken.getTH() && !timeUnitToken.getSP()) {
            int n36 = timeUnitToken.getCase();
            string = this.processTH(string, n36);
        } else if (timeUnitToken.getSP()) {
            int n37 = timeUnitToken.getCase();
            boolean bl2 = timeUnitToken.getTH();
            boolean bl3 = false;
            if (timeUnitToken.getType() == 23) {
                bl3 = true;
            }
            string = this.processSP(string, bl2, n37, bl3);
        }
        return string;
    }

    private String processTH(String string, int n) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = new Integer(string);
        if (n3 > 99) {
            n3 = new Integer(string.substring(n2 - 2, n2));
        }
        int n4 = 0;
        String string2 = "th";
        if (n == 1) {
            string2 = string2.toUpperCase();
        }
        if (n3 > 10 && n3 < 14) {
            return String.valueOf(string) + string2;
        }
        n4 = n2 == 1 ? new Integer(string).intValue() : new Integer(string.substring(n2 - 1, n2)).intValue();
        if (n4 == 1) {
            string2 = "st";
        } else if (n4 == 2) {
            string2 = "nd";
        } else if (n4 == 3) {
            string2 = "rd";
        }
        if (n == 1) {
            string2 = string2.toUpperCase();
        }
        return String.valueOf(string) + string2;
    }

    private String processSP(String string, boolean bl, int n, boolean bl2) {
        String string2 = string;
        String string3 = "";
        int n2 = string.indexOf(this.m_groupingSeparator);
        if (n2 != -1) {
            string2 = String.valueOf(string.substring(0, n2)) + string.substring(n2 + 1);
        }
        string2 = string2.replace('-', ' ');
        int n3 = new Integer(string2 = string2.trim());
        if (n3 == 0) {
            string3 = bl ? DateConstants.NumInTH[0] : DateConstants.NumSpelledOut[0];
        } else if (!bl2 && n3 < 10000) {
            int n4 = n3 / 1000;
            if (n3 % 1000 == 0) {
                string3 = DateConstants.NumSpelledOut[n4];
                string3 = !bl ? String.valueOf(string3) + " " + DateConstants.NumSpelledOut[29] : String.valueOf(string3) + " " + DateConstants.NumInTH[29];
            } else {
                if (n4 > 0) {
                    string3 = String.valueOf(DateConstants.NumSpelledOut[n4]) + " " + DateConstants.NumSpelledOut[29];
                }
                int n5 = n3 % 1000;
                String string4 = " ";
                if (n4 == 0) {
                    string4 = "";
                }
                string3 = String.valueOf(string3) + string4 + this.constructThreeDigits(n5, bl);
            }
        } else {
            int n6 = n3 / 1000000;
            int n7 = n3 % 1000000 / 1000;
            int n8 = n3 % 1000;
            String string5 = "";
            if (n6 != 0) {
                string3 = DateConstants.NumSpelledOut[n6];
                string3 = n3 % 1000000 == 0 && bl ? String.valueOf(string3) + " " + DateConstants.NumInTH[30] : String.valueOf(string3) + " " + DateConstants.NumSpelledOut[30];
                string5 = " ";
            }
            if (n7 != 0) {
                string3 = String.valueOf(string3) + string5 + this.constructThreeDigits(n7, false);
                string3 = n3 % 1000 == 0 && bl ? String.valueOf(string3) + " " + DateConstants.NumInTH[29] : String.valueOf(string3) + " " + DateConstants.NumSpelledOut[29];
                string5 = " ";
            }
            if (n8 != 0) {
                string3 = String.valueOf(string3) + string5 + this.constructThreeDigits(n8, bl);
            }
        }
        if (n == 1) {
            string3 = string3.toUpperCase();
        } else if (n == 2) {
            string3 = string3.toLowerCase();
        }
        return string3;
    }

    private String constructThreeDigits(int n, boolean bl) {
        int n2 = n;
        String string = "";
        int n3 = n2 / 100;
        if (n2 % 100 == 0) {
            string = bl ? DateConstants.NumInTH[28] : DateConstants.NumSpelledOut[28];
            string = String.valueOf(DateConstants.NumSpelledOut[n3]) + " " + string;
        } else if (n2 < 21) {
            string = bl ? DateConstants.NumInTH[n2] : DateConstants.NumSpelledOut[n2];
        } else {
            if (n2 > 99) {
                string = String.valueOf(DateConstants.NumSpelledOut[n3]) + " " + DateConstants.NumSpelledOut[28];
                n2 %= 100;
            }
            if (n2 < 21) {
                string = bl ? String.valueOf(string) + " " + DateConstants.NumInTH[n2] : String.valueOf(string) + " " + DateConstants.NumSpelledOut[n2];
            } else {
                int n4 = n2 / 10;
                int n5 = n2 % 10;
                if (n5 == 0) {
                    if (string.length() != 0) {
                        string = String.valueOf(string) + " ";
                    }
                    string = bl ? String.valueOf(string) + DateConstants.NumInTH[18 + n4] : String.valueOf(string) + DateConstants.NumSpelledOut[18 + n4];
                } else {
                    String string2 = "-";
                    if (string.length() != 0) {
                        string = String.valueOf(string) + " ";
                    }
                    if (n4 != 0) {
                        string = String.valueOf(string) + DateConstants.NumSpelledOut[18 + n4];
                    } else {
                        string2 = " ";
                        if (string.length() != 0) {
                            string2 = "";
                        }
                    }
                    string = bl ? String.valueOf(string) + string2 + DateConstants.NumInTH[n5] : String.valueOf(string) + string2 + DateConstants.NumSpelledOut[n5];
                }
            }
        }
        return string;
    }

    private String spellYear(int n, int n2) {
        String string = "";
        if (n >= 1000) {
            if (n % 1000 == 0) {
                string = String.valueOf(DateConstants.NumSpelledOut[n / 1000]) + " " + DateConstants.NumSpelledOut[29];
            } else if (n / 10 % 10 == 0) {
                string = String.valueOf(DateConstants.NumSpelledOut[n / 1000]) + " " + DateConstants.NumSpelledOut[29];
                int n3 = n / 100 % 10;
                if (n3 != 0) {
                    string = String.valueOf(string) + " " + DateConstants.NumSpelledOut[n3] + " " + DateConstants.NumSpelledOut[28];
                }
                if (n % 10 != 0) {
                    string = String.valueOf(string) + " " + DateConstants.NumSpelledOut[n % 10];
                }
            } else {
                string = String.valueOf(this.constructTwoDigits(n / 100)) + " " + this.constructTwoDigits(n % 100);
            }
        } else if (n >= 100) {
            int n4 = n / 10 % 10;
            if (n4 == 0) {
                string = String.valueOf(DateConstants.NumSpelledOut[n / 100]) + " " + DateConstants.NumSpelledOut[28];
                int n5 = n % 10;
                if (n5 != 0) {
                    string = String.valueOf(string) + " " + DateConstants.NumSpelledOut[n5];
                }
            } else {
                string = String.valueOf(DateConstants.NumSpelledOut[n / 100]) + " " + this.constructTwoDigits(n % 100);
            }
        } else {
            string = this.constructTwoDigits(n % 100);
        }
        if (n2 == 1) {
            string = string.toUpperCase();
        } else if (n2 == 2) {
            string = string.toLowerCase();
        }
        return string;
    }

    private String constructTwoDigits(int n) {
        int n2 = n / 10;
        int n3 = n % 10;
        if (n < 21) {
            return DateConstants.NumSpelledOut[n];
        }
        if (n3 == 0) {
            return DateConstants.NumSpelledOut[18 + n2];
        }
        return String.valueOf(DateConstants.NumSpelledOut[18 + n2]) + "-" + DateConstants.NumSpelledOut[n3];
    }

    private boolean firstWeekInPreYear(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.set(n, 0, 1);
        int n2 = gregorianCalendar.get(7);
        return n2 == 1 || n2 == 6 || n2 == 7;
    }

    private int weekInISO(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(3);
        int n3 = this.yearInISO(calendar);
        if (n3 == n) {
            int n4 = calendar.get(7);
            if (n4 == 1) {
                --n2;
            }
            if (this.firstWeekInPreYear(n)) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
                gregorianCalendar.set(n, 0, 1);
                int n5 = gregorianCalendar.get(7);
                if (n5 == 1) {
                    return n2;
                }
                return n2 - 1;
            }
            return n2;
        }
        if (n3 == n + 1) {
            return 1;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.set(n3, 11, 31);
        int n6 = gregorianCalendar.get(3);
        if (this.firstWeekInPreYear(n3)) {
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(Locale.US);
            gregorianCalendar2.set(n3, 0, 1);
            int n7 = gregorianCalendar2.get(7);
            if (n7 == 1) {
                return n6;
            }
            return n6 - 1;
        }
        return n6;
    }

    private int yearInISO(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        if (n2 != 0 && n2 != 11) {
            return n;
        }
        int n3 = calendar.get(5);
        if (n2 == 0) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
            gregorianCalendar.set(n, 0, 1);
            int n4 = gregorianCalendar.get(7);
            if (n4 == 6 && n3 <= 3) {
                return n - 1;
            }
            if (n4 == 7 && n3 <= 2) {
                return n - 1;
            }
            if (n4 == 1 && n3 == 1) {
                return n - 1;
            }
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
            gregorianCalendar.set(n, 11, 31);
            int n5 = gregorianCalendar.get(7);
            int n6 = 31 - n3;
            if (n5 == 2 && n6 == 0) {
                return n + 1;
            }
            if (n5 == 3 && n6 <= 1) {
                return n + 1;
            }
            if (n5 == 4 && n6 <= 2) {
                return n + 1;
            }
        }
        return n;
    }

    public Date parse(String string) throws ParseException {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            }
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        return this.myParse(string, parsePosition);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            }
            return null;
        }
        Date date = null;
        int n = parsePosition.getIndex();
        try {
            date = this.myParse(string, parsePosition);
        }
        catch (ParseException parseException) {
            parsePosition.setIndex(n);
        }
        return date;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        if (this.formatString == "") {
            if (this.m_eh != null) {
                this.m_eh.log("Oracle date format string hasn't been set", this.getClass().getName(), "format");
            }
            return null;
        }
        return super.parseObject(string, parsePosition);
    }

    public Object clone() {
        OracleDateFormat oracleDateFormat = new OracleDateFormat(this.thisLocale, this.thisTimeZone);
        oracleDateFormat.setErrorHandler(this.m_eh);
        return oracleDateFormat;
    }

    private Date myParse(String string, ParsePosition parsePosition) throws ParseException {
        if (string.indexOf(34) != -1) {
            throw new ParseException("Literal does not match format string", 0);
        }
        int n = -1;
        boolean bl = false;
        Calendar calendar = this.getCalendar();
        Vector vector = (Vector)this.tokenList.clone();
        int n2 = parsePosition.getIndex();
        while (!bl) {
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = true;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            int n3 = -5000;
            int n4 = -5000;
            int n5 = -1;
            int n6 = 0;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            int n11 = -1;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            parsePosition.setIndex(n2);
            String string2 = string;
            int n15 = vector.size();
            try {
                int n16 = 0;
                while (n16 < n15) {
                    int n17;
                    boolean bl14 = false;
                    DateFormatToken dateFormatToken = (DateFormatToken)vector.elementAt(n16);
                    if (!dateFormatToken.getInputAllowed()) {
                        throw new ParseException(String.valueOf(dateFormatToken.getValue()) + " can't be used as input", parsePosition.getIndex());
                    }
                    if (dateFormatToken instanceof ModifierToken) {
                        if (dateFormatToken.getType() == 100) {
                            bl2 = !bl2;
                        } else {
                            boolean bl15 = bl3 = !bl3;
                        }
                        bl4 = bl3 && bl2;
                    } else if (dateFormatToken instanceof LiteralToken) {
                        if (string2.length() != 0) {
                            int n18 = dateFormatToken.getType();
                            n17 = this.processLiteral(dateFormatToken.getValue(), n18, string2, parsePosition, bl3);
                            if (n17 == -1) {
                                bl5 = true;
                            } else {
                                string2 = string2.substring(n17);
                                parsePosition.setIndex(parsePosition.getIndex() + n17);
                            }
                        }
                    } else {
                        TimeUnitToken timeUnitToken = (TimeUnitToken)dateFormatToken;
                        if (timeUnitToken.getTH() || timeUnitToken.getSP()) {
                            throw new ParseException("TH and SP can't be used as input", parsePosition.getIndex());
                        }
                        if (!bl3) {
                            if (string2.length() > 0 && string2.charAt(0) == ' ') {
                                bl14 = true;
                            }
                            string2 = string2.trim();
                        }
                        int n19 = string2.length();
                        n17 = dateFormatToken.getType();
                        switch (n17) {
                            case 1: 
                            case 5: {
                                int[] nArray = this.processADBC(n17, string2, parsePosition, bl8);
                                n13 = nArray[0];
                                bl8 = true;
                                string2 = string2.substring(nArray[1]);
                                parsePosition.setIndex(parsePosition.getIndex() + nArray[1]);
                                break;
                            }
                            case 3: 
                            case 6: {
                                int[] nArray = this.processADBC(n17, string2, parsePosition, bl8);
                                n13 = nArray[0];
                                bl8 = true;
                                string2 = string2.substring(nArray[1]);
                                parsePosition.setIndex(parsePosition.getIndex() + nArray[1]);
                                break;
                            }
                            case 2: 
                            case 28: {
                                int[] nArray = this.processAMPM(n17, string2, parsePosition, bl9);
                                n12 = nArray[0];
                                bl9 = true;
                                string2 = string2.substring(nArray[1]);
                                parsePosition.setIndex(parsePosition.getIndex() + nArray[1]);
                                break;
                            }
                            case 4: 
                            case 29: {
                                int[] nArray = this.processAMPM(n17, string2, parsePosition, bl9);
                                n12 = nArray[0];
                                bl9 = true;
                                string2 = string2.substring(nArray[1]);
                                parsePosition.setIndex(parsePosition.getIndex() + nArray[1]);
                                break;
                            }
                            case 8: {
                                if (bl12) {
                                    throw new ParseException("Day of week may only be specified once", parsePosition.getIndex());
                                }
                                bl12 = true;
                                if (n19 < 1) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                char c = string2.charAt(0);
                                if (!Character.isDigit(c)) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                n14 = Character.digit(c, 10);
                                if (n14 > 7 || n14 == 0) {
                                    throw new ParseException("Not a valid day for the week", parsePosition.getIndex());
                                }
                                string2 = string2.substring(1);
                                parsePosition.setIndex(parsePosition.getIndex() + 1);
                                break;
                            }
                            case 9: {
                                if (bl12) {
                                    throw new ParseException("Day of week may only be specified once", parsePosition.getIndex());
                                }
                                bl12 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n20 = parsePosition.getIndex();
                                n14 = this.checkArray(this.WeekDayInFull, 7, string2, parsePosition);
                                if (n14 == 0) {
                                    throw new ParseException("Not a valid day of week", parsePosition.getIndex());
                                }
                                int n21 = parsePosition.getIndex() - n20;
                                string2 = string2.substring(n21);
                                break;
                            }
                            case 12: {
                                if (bl12) {
                                    throw new ParseException("Day of week may only be specified once", parsePosition.getIndex());
                                }
                                bl12 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n22 = parsePosition.getIndex();
                                n14 = this.checkArray(this.WeekDayInAbbr, 7, string2, parsePosition);
                                if (n14 == 0) {
                                    throw new ParseException("Not a valid day of week", parsePosition.getIndex());
                                }
                                int n23 = parsePosition.getIndex() - n22;
                                string2 = string2.substring(n23);
                                break;
                            }
                            case 10: {
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n24 = this.readAtMost(string2, 2);
                                if (n24 == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n24 != 2) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n24 != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string3 = string2.substring(0, n24);
                                int n25 = new Integer(string3);
                                if (n25 > 31 || n25 == 0) {
                                    throw new ParseException("Day of month must be between 1 and last day of month", parsePosition.getIndex());
                                }
                                n6 = n25;
                                string2 = string2.substring(n24);
                                parsePosition.setIndex(parsePosition.getIndex() + n24);
                                break;
                            }
                            case 11: {
                                if (bl13) {
                                    throw new ParseException("Format code appears twice", parsePosition.getIndex());
                                }
                                bl13 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n26 = this.readAtMost(string2, 3);
                                if (n26 == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n26 != 3) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n26 != 3) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string4 = string2.substring(0, n26);
                                int n27 = new Integer(string4);
                                if (n27 > 366 || n27 == 0) {
                                    throw new ParseException("Day of year must be between 1 and last day of year", parsePosition.getIndex());
                                }
                                n10 = n27;
                                string2 = string2.substring(n26);
                                parsePosition.setIndex(parsePosition.getIndex() + n26);
                                break;
                            }
                            case 15: 
                            case 16: 
                            case 17: {
                                int n28;
                                if (bl10) {
                                    throw new ParseException("Hour may only be specified once", parsePosition.getIndex());
                                }
                                bl10 = true;
                                if (n17 == 17) {
                                    if (bl9) {
                                        throw new ParseException("Format code appears twice", parsePosition.getIndex());
                                    }
                                    bl9 = true;
                                }
                                if ((n28 = this.readAtMost(string2, 2)) == 0) {
                                    if (n19 == 0) {
                                        if (!bl3) {
                                            n7 = 0;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n28 != 2) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n28 != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string5 = string2.substring(0, n28);
                                int n29 = new Integer(string5);
                                if (n17 == 17) {
                                    if (n29 > 23) {
                                        throw new ParseException("Hour must be between 0 and 23", parsePosition.getIndex());
                                    }
                                } else if (n29 == 0 || n29 > 12) {
                                    throw new ParseException("Hour must be between 1 and 12", parsePosition.getIndex());
                                }
                                n7 = n29;
                                string2 = string2.substring(n28);
                                parsePosition.setIndex(parsePosition.getIndex() + n28);
                                break;
                            }
                            case 23: {
                                int n30;
                                int n31;
                                int n32;
                                if (bl13) {
                                    throw new ParseException("Julian date precludes use of day of year", parsePosition.getIndex());
                                }
                                bl13 = true;
                                int n33 = this.readAtMost(string2, 7);
                                if (n33 == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n33 != 7) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n33 != 7) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                int n34 = 1461;
                                String string6 = string2.substring(0, n33);
                                int n35 = new Integer(string6);
                                if (n35 < 1721424) {
                                    if (n35 < 1826) {
                                        n4 = (n35 - 1) / 365 - 4712;
                                        n10 = n35 - (n35 - 1) / 365 * 365;
                                    } else {
                                        int n36 = ((n35 -= 1826) - 1) / n34;
                                        n32 = n35 - n36 * n34;
                                        n36 = n36 * 4 + 5 - 4712;
                                        if (n32 <= 365) {
                                            n4 = n36;
                                            n10 = n32;
                                        } else if (n32 <= 730) {
                                            n4 = n36 + 1;
                                            n10 = n32 - 365;
                                        } else if (n32 <= 1095) {
                                            n4 = n36 + 2;
                                            n10 = n32 - 730;
                                        } else {
                                            n4 = n36 + 3;
                                            n10 = n32 - 1095;
                                        }
                                    }
                                    if (n4 == 0) {
                                        throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                    }
                                } else if (n35 < 2299161) {
                                    int n37 = ((n35 -= 1721423) - 1) / n34;
                                    n32 = n35 - n37 * n34;
                                    n4 = n37 * 4;
                                    n31 = n32 / 365;
                                    n4 += n31 + 1;
                                    n10 = n32 - n31 * 365;
                                } else if (n35 == 2299161) {
                                    n4 = 1582;
                                    n10 = 288;
                                } else {
                                    int n38 = 146097;
                                    n32 = ((n35 -= 1721423) - 1) / n38;
                                    n31 = n35 - n32 * n38;
                                    n4 = n32 * 400;
                                    n32 = (n31 - 1) / 36524;
                                    if (n32 == 4) {
                                        --n32;
                                    }
                                    n4 += n32 * 100;
                                    n31 -= n32 * 36524;
                                    n32 = (n31 - 1) / n34;
                                    n4 += n32 * 4;
                                    n30 = (n31 -= n32 * n34) / 365;
                                    n4 += n30 + 1;
                                    n10 = n31 - n30 * 365 - 2;
                                }
                                string2 = string2.substring(n33);
                                parsePosition.setIndex(parsePosition.getIndex() + n33);
                                break;
                            }
                            case 24: {
                                int n39 = this.readAtMost(string2, 2);
                                if (n39 == 0) {
                                    if (n19 == 0) {
                                        if (!bl3) {
                                            n8 = 0;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n39 != 2) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n39 != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string7 = string2.substring(0, n39);
                                int n40 = new Integer(string7);
                                if (n40 > 59) {
                                    throw new ParseException("Minute must be between 0 and 59", parsePosition.getIndex());
                                }
                                n8 = n40;
                                string2 = string2.substring(n39);
                                parsePosition.setIndex(parsePosition.getIndex() + n39);
                                break;
                            }
                            case 25: {
                                if (bl11) {
                                    throw new ParseException("Month may only be specified once", parsePosition.getIndex());
                                }
                                bl11 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n41 = this.readAtMost(string2, 2);
                                if (n41 == 0) {
                                    if (bl3) {
                                        throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                    }
                                    int n42 = parsePosition.getIndex();
                                    n5 = this.checkArray(this.MonthNameInFull, 12, string2, parsePosition);
                                    if (n5 != 0) {
                                        string2 = string2.substring(parsePosition.getIndex() - n42);
                                        --n5;
                                        break;
                                    }
                                    n5 = this.checkArray(this.MonthNameInAbbr, 12, string2, parsePosition);
                                    if (n5 != 0) {
                                        string2 = string2.substring(parsePosition.getIndex() - n42);
                                        --n5;
                                        break;
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n41 != 2) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n41 != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string8 = string2.substring(0, n41);
                                int n43 = new Integer(string8);
                                if (n43 == 0 || n43 > 12) {
                                    throw new ParseException("Month must be between 1 and 12", parsePosition.getIndex());
                                }
                                n5 = n43 - 1;
                                string2 = string2.substring(n41);
                                parsePosition.setIndex(parsePosition.getIndex() + n41);
                                break;
                            }
                            case 26: {
                                if (bl11) {
                                    throw new ParseException("Month may only be specified once", parsePosition.getIndex());
                                }
                                bl11 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n44 = parsePosition.getIndex();
                                if (bl3 ? (n5 = this.checkArray(this.MonthNameInAbbr, 12, string2, parsePosition)) == 0 : (n5 = this.checkArray(this.MonthNameInFull, 12, string2, parsePosition)) == 0 && (n5 = this.checkArray(this.MonthNameInAbbr, 12, string2, parsePosition)) == 0) {
                                    throw new ParseException("Not a valid month", n44);
                                }
                                --n5;
                                string2 = string2.substring(parsePosition.getIndex() - n44);
                                break;
                            }
                            case 27: {
                                if (bl11) {
                                    throw new ParseException("Month may only be specified once", parsePosition.getIndex());
                                }
                                bl11 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n45 = parsePosition.getIndex();
                                n5 = this.checkArray(this.MonthNameInFull, 12, string2, parsePosition);
                                if (n5 == 0) {
                                    if (bl3) {
                                        throw new ParseException("Not a valid month", n45);
                                    }
                                    n5 = this.checkArray(this.MonthNameInAbbr, 12, string2, parsePosition);
                                    if (n5 == 0) {
                                        throw new ParseException("Not a valid month", n45);
                                    }
                                }
                                --n5;
                                string2 = string2.substring(parsePosition.getIndex() - n45);
                                break;
                            }
                            case 31: {
                                if (bl11) {
                                    throw new ParseException("Month may only be specified once", parsePosition.getIndex());
                                }
                                bl11 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n46 = parsePosition.getIndex();
                                n5 = this.checkArray(DateConstants.MonthInRoman, 12, string2, parsePosition);
                                if (n5 == 0) {
                                    throw new ParseException("Not a valid month", n46);
                                }
                                --n5;
                                string2 = string2.substring(parsePosition.getIndex() - n46);
                                break;
                            }
                            case 32: 
                            case 33: {
                                int n47;
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                bl7 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                if (!bl3 && n17 == 32) {
                                    n = n16;
                                }
                                int n48 = 2;
                                if (n17 == 33) {
                                    n48 = 4;
                                }
                                if ((n47 = this.readAtMost(string2, n48)) == 0) {
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n47 != n48) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n47 != n48) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string9 = string2.substring(0, n47);
                                int n49 = new Integer(string9);
                                Calendar calendar2 = this.getCalendar();
                                calendar2.setTime(new Date());
                                int n32 = calendar2.get(1);
                                int n31 = n32 % 100;
                                int n30 = n32 / 100;
                                if (n17 == 33) {
                                    if (n49 > 99 || n47 > 2) {
                                        n3 = n49;
                                        string2 = string2.substring(n47);
                                        parsePosition.setIndex(parsePosition.getIndex() + n47);
                                        break;
                                    }
                                    n49 %= 100;
                                }
                                if (n31 > 49 && n49 < 50) {
                                    ++n30;
                                }
                                if (n31 < 50 && n49 > 49) {
                                    --n30;
                                }
                                n3 = n30 * 100 + n49;
                                string2 = string2.substring(n47);
                                parsePosition.setIndex(parsePosition.getIndex() + n47);
                                break;
                            }
                            case 35: {
                                int n50 = this.readAtMost(string2, 2);
                                if (n50 == 0) {
                                    if (n19 == 0) {
                                        if (!bl3) {
                                            n9 = 0;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n50 != 2) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n50 != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string10 = string2.substring(0, n50);
                                n9 = new Integer(string10);
                                if (n9 > 59) {
                                    throw new ParseException("Second of minute must be between 0 and 59", parsePosition.getIndex());
                                }
                                string2 = string2.substring(n50);
                                parsePosition.setIndex(parsePosition.getIndex() + n50);
                                break;
                            }
                            case 36: {
                                int n51 = this.readAtMost(string2, 5);
                                if (n51 == 0) {
                                    if (n19 == 0) {
                                        if (!bl3) {
                                            n11 = -1;
                                            break;
                                        }
                                        throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                    }
                                    throw new ParseException("A non-numeric character was found where a numeric was expected", parsePosition.getIndex());
                                }
                                if (n51 != 5) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n51 != 5) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string11 = string2.substring(0, n51);
                                n11 = new Integer(string11);
                                if (n11 > 86399) {
                                    throw new ParseException("Second of day must be between 0 and 86399", parsePosition.getIndex());
                                }
                                string2 = string2.substring(n51);
                                parsePosition.setIndex(parsePosition.getIndex() + n51);
                                break;
                            }
                            case 37: {
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                if (bl8) {
                                    throw new ParseException("Signed year precludes use of BC/AD", parsePosition.getIndex());
                                }
                                bl7 = true;
                                bl8 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input string not long enough for date format", parsePosition.getIndex());
                                }
                                boolean bl16 = false;
                                char c = string2.charAt(0);
                                if (!bl14 && c != '-') {
                                    bl6 = false;
                                }
                                if (c == '-') {
                                    bl16 = true;
                                    string2 = string2.substring(1);
                                } else if (bl2 && bl3) {
                                    if (c == ' ') {
                                        string2 = string2.substring(1);
                                    } else {
                                        throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                    }
                                }
                                int n52 = parsePosition.getIndex();
                                n3 = this.processCommaYear(string2, parsePosition, bl3 && bl2);
                                if (n3 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                int n53 = parsePosition.getIndex() - n52;
                                if (n53 != 5) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n53 != 5) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                if (bl16) {
                                    n3 = -n3;
                                }
                                string2 = string2.substring(n53);
                                break;
                            }
                            case 39: {
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                if (bl8) {
                                    throw new ParseException("Signed year precludes use of BC/AD", parsePosition.getIndex());
                                }
                                bl7 = true;
                                bl8 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input string not long enough for date format", parsePosition.getIndex());
                                }
                                boolean bl17 = false;
                                char c = string2.charAt(0);
                                if (!bl14 && c != '-') {
                                    bl6 = false;
                                }
                                if (c == '-') {
                                    bl17 = true;
                                    parsePosition.setIndex(parsePosition.getIndex() + 1);
                                    string2 = string2.substring(1);
                                } else if (bl2 && bl3) {
                                    if (c == ' ') {
                                        string2 = string2.substring(1);
                                    } else {
                                        throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                    }
                                }
                                int n54 = this.readAtMost(string2, 4);
                                if (n54 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                if (n54 != 4) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n54 != 4) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string12 = string2.substring(0, n54);
                                n3 = new Integer(string12);
                                if (n3 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                if (bl17) {
                                    n3 = -n3;
                                }
                                string2 = string2.substring(n54);
                                parsePosition.setIndex(parsePosition.getIndex() + n54);
                                break;
                            }
                            case 42: {
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                bl7 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n55 = this.readAtMost(string2, 1);
                                if (n55 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                char c = string2.charAt(0);
                                int n56 = Character.digit(c, 10);
                                Calendar calendar3 = this.getCalendar();
                                calendar3.setTime(new Date());
                                int n57 = calendar3.get(1);
                                n3 = n57 / 10 * 10 + n56;
                                string2 = string2.substring(1);
                                parsePosition.setIndex(parsePosition.getIndex() + 1);
                                break;
                            }
                            case 43: {
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                bl7 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n58 = parsePosition.getIndex();
                                n3 = this.processCommaYear(string2, parsePosition, bl3 && bl2);
                                if (n3 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                int n59 = parsePosition.getIndex() - n58;
                                if (n59 != 5) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n59 != 5) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                string2 = string2.substring(n59);
                                break;
                            }
                            case 45: {
                                int n60;
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                bl7 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                if (!bl3) {
                                    n = n16;
                                }
                                if ((n60 = this.readAtMost(string2, 2)) == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                if (n60 != 2) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n60 != 2) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string13 = string2.substring(0, n60);
                                int n61 = new Integer(string13);
                                Calendar calendar4 = this.getCalendar();
                                calendar4.setTime(new Date());
                                int n62 = calendar4.get(1);
                                n3 = n62 / 100 * 100 + n61;
                                string2 = string2.substring(n60);
                                parsePosition.setIndex(parsePosition.getIndex() + n60);
                                break;
                            }
                            case 46: {
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                bl7 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n63 = this.readAtMost(string2, 3);
                                if (n63 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                if (n63 != 3) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n63 != 3) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string14 = string2.substring(0, n63);
                                int n64 = new Integer(string14);
                                Calendar calendar5 = this.getCalendar();
                                calendar5.setTime(new Date());
                                int n65 = calendar5.get(1);
                                n3 = n65 / 1000 * 1000 + n64;
                                string2 = string2.substring(n63);
                                parsePosition.setIndex(parsePosition.getIndex() + n63);
                                break;
                            }
                            case 47: {
                                if (bl7) {
                                    throw new ParseException("Year may only be specified once", parsePosition.getIndex());
                                }
                                bl7 = true;
                                if (n19 == 0) {
                                    throw new ParseException("Input value not long enough for date format", parsePosition.getIndex());
                                }
                                int n66 = this.readAtMost(string2, 4);
                                if (n66 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                if (n66 != 4) {
                                    bl6 = false;
                                }
                                if (bl5 && !bl6) {
                                    throw new ParseException("Literal does not match format string", parsePosition.getIndex());
                                }
                                if (bl4 && n66 != 4) {
                                    throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
                                }
                                String string15 = string2.substring(0, n66);
                                n3 = new Integer(string15);
                                if (n3 == 0) {
                                    throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
                                }
                                string2 = string2.substring(n66);
                                parsePosition.setIndex(parsePosition.getIndex() + n66);
                                break;
                            }
                            default: {
                                System.out.println("Shouldn't be here at all!");
                            }
                        }
                    }
                    ++n16;
                }
                if (string2.length() != 0) {
                    throw new ParseException("Date format picture ends before converting entire input string", 0);
                }
                calendar = this.checkIntegrity(n3, n4, n5, n6, n7, n8, n9, n10, n14, n11, n13, n12);
            }
            catch (ParseException parseException) {
                if (n == -1) {
                    throw parseException;
                }
                DateFormatToken dateFormatToken = (DateFormatToken)vector.elementAt(n);
                int n67 = 47;
                if (dateFormatToken.getType() == 32) {
                    n67 = 33;
                }
                TimeUnitToken timeUnitToken = new TimeUnitToken(n67, dateFormatToken.getValue(), dateFormatToken.getCase(), DateConstants.InputAllowed[n67]);
                vector.setElementAt(timeUnitToken, n);
                n = -1;
                continue;
            }
            return calendar.getTime();
        }
        return calendar.getTime();
    }

    private Calendar checkIntegrity(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) throws ParseException {
        int n13;
        int n14;
        int n15;
        int n16 = n;
        int n17 = n3;
        int n18 = n4;
        int n19 = n5;
        int n20 = n6;
        int n21 = n7;
        if (n2 != -5000 && n != -5000 && n != n2) {
            throw new ParseException("Year conflicts with Julian date", 0);
        }
        if (n2 != -5000 && n == -5000) {
            n16 = n2;
        }
        if (n16 > 0 && (n11 == 5 || n11 == 6)) {
            n16 = -n16;
        }
        Calendar calendar = this.getCalendar();
        if (n16 == -5000) {
            n16 = calendar.get(1);
        }
        if (n8 != 0) {
            int n22;
            int n23;
            n15 = 31;
            n14 = 59;
            n13 = 90;
            int n24 = 120;
            int n25 = 151;
            int n26 = 181;
            int n27 = 212;
            int n28 = 243;
            int n29 = 273;
            int n30 = 304;
            int n31 = 334;
            int n32 = 365;
            if (new GregorianCalendar().isLeapYear(n16)) {
                ++n14;
                ++n13;
                ++n24;
                ++n25;
                ++n26;
                ++n27;
                ++n28;
                ++n29;
                ++n30;
                ++n31;
                ++n32;
            }
            if (n8 <= n15) {
                n23 = 0;
                n22 = n8;
            } else if (n8 <= n14) {
                n23 = 1;
                n22 = n8 - n15;
            } else if (n8 <= n13) {
                n23 = 2;
                n22 = n8 - n14;
            } else if (n8 <= n24) {
                n23 = 3;
                n22 = n8 - n13;
            } else if (n8 <= n25) {
                n23 = 4;
                n22 = n8 - n24;
            } else if (n8 <= n26) {
                n23 = 5;
                n22 = n8 - n25;
            } else if (n8 <= n27) {
                n23 = 6;
                n22 = n8 - n26;
            } else if (n8 <= n28) {
                n23 = 7;
                n22 = n8 - n27;
            } else if (n8 <= n29) {
                n23 = 8;
                n22 = n8 - n28;
            } else if (n8 <= n30) {
                n23 = 9;
                n22 = n8 - n29;
            } else if (n8 <= n31) {
                n23 = 10;
                n22 = n8 - n30;
            } else if (n8 <= n32) {
                n23 = 11;
                n22 = n8 - n31;
            } else {
                throw new ParseException("Day of year must be between 1 and the last day of the year", 0);
            }
            if (n17 != -1 && n17 != n23) {
                throw new ParseException("Month of year conflicts with Julian date", 0);
            }
            n17 = n23;
            if (n18 != 0 && n18 != n22) {
                throw new ParseException("Date of month conflicts with Julian date", 0);
            }
            n18 = n22;
        }
        if (n17 == -1) {
            n17 = calendar.get(2);
        }
        if (n18 == 0) {
            n18 = 1;
        }
        if (n17 == 1 && n18 > 29) {
            throw new ParseException("Date not valid for month specified", 0);
        }
        if (n18 == 31 && (n17 == 3 || n17 == 5 || n17 == 8 || n17 == 10)) {
            throw new ParseException("Date not valid for month specified", 0);
        }
        if (n17 == 1 && n18 > 28 && !new GregorianCalendar().isLeapYear(n16)) {
            throw new ParseException("Date not valid for month specified", 0);
        }
        if (n12 != 0 && (n12 == 28 || n12 == 29) && n19 != 12 && n19 != -1) {
            n19 += 12;
        }
        if (n10 != -1) {
            n15 = n10 / 3600;
            n14 = n10 % 3600 / 60;
            n13 = n10 % 3600 % 60;
            if (n19 == -1) {
                n19 = n15;
            } else if (n19 != n15) {
                throw new ParseException("Hour conflicts with second of hour", 0);
            }
            if (n20 == -1) {
                n20 = n14;
            } else if (n20 != n14) {
                throw new ParseException("Minute conflicts with second of hour", 0);
            }
            if (n21 == -1) {
                n21 = n13;
            } else if (n21 != n13) {
                throw new ParseException("Second conflicts with second of hour", 0);
            }
        }
        if (n19 == -1) {
            n19 = 0;
        }
        if (n20 == -1) {
            n20 = 0;
        }
        if (n21 == -1) {
            n21 = 0;
        }
        Calendar calendar2 = this.getCalendar();
        calendar2.clear();
        calendar2.set(n16, n17, n18, n19, n20, n21);
        if (n9 != 0 && (n14 = calendar2.get(7)) != n9) {
            throw new ParseException("Day of week conflicts with Julian date", 0);
        }
        return calendar2;
    }

    private int processCommaYear(String string, ParsePosition parsePosition, boolean bl) throws ParseException {
        String string2;
        if (bl && string.length() < 5) {
            throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
        }
        int n = this.readAtMost(string, 4);
        if (n == 0) {
            throw new ParseException("(full) year must be between -4713 and +9999, and not be 0", parsePosition.getIndex());
        }
        String string3 = string.substring(0, n);
        int n2 = new Integer(string3);
        parsePosition.setIndex(parsePosition.getIndex() + n);
        if (n == 4) {
            if (string.length() > 4 && string.charAt(4) == this.m_groupingSeparator) {
                parsePosition.setIndex(parsePosition.getIndex() + 1);
                return n2;
            }
            if (!bl) {
                return n2;
            }
            if (string.charAt(5) != this.m_groupingSeparator) {
                throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
            }
        }
        if ((string2 = string.substring(n)).length() == 0) {
            return n2;
        }
        if (string2.charAt(0) != this.m_groupingSeparator) {
            if (bl) {
                throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
            }
            return n2;
        }
        string2 = string2.substring(1);
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        int n3 = this.readAtMost(string2, 4 - n);
        if (bl && n3 != 4 - n) {
            throw new ParseException("The numeric value does not match the length of the format item", parsePosition.getIndex());
        }
        if (n3 == 0) {
            return n2;
        }
        string2 = string2.substring(0, n3);
        string3 = String.valueOf(string3) + string2;
        int n4 = new Integer(string3);
        parsePosition.setIndex(parsePosition.getIndex() + n3);
        return n4;
    }

    private int processLiteral(String string, int n, String string2, ParsePosition parsePosition, boolean bl) throws ParseException {
        if (string.length() == 0) {
            return 0;
        }
        if (n == 2000) {
            int n2 = 0;
            int n3 = string2.length();
            while (n2 < n3 && !Character.isLetterOrDigit(string2.charAt(n2))) {
                ++n2;
            }
            String string3 = string2.substring(0, n2);
            int n4 = string3.length();
            String string4 = string;
            int n5 = string4.length();
            if (!bl) {
                if (n4 > n5) {
                    if (string3.trim().length() <= n5) {
                        return n4;
                    }
                    throw new ParseException("literal does not match format string", parsePosition.getIndex());
                }
                if (n4 > 0) {
                    return n4;
                }
                return -1;
            }
            if (!string3.equals(string4)) {
                throw new ParseException("literal does not match format string", parsePosition.getIndex());
            }
            return n4;
        }
        int n6 = string.length();
        if (string2.length() < n6) {
            throw new ParseException("Literal does not match format string", parsePosition.getIndex());
        }
        String string5 = string2.substring(0, n6);
        if (!string5.equalsIgnoreCase(string)) {
            throw new ParseException("Literal does not match format string", parsePosition.getIndex());
        }
        return n6;
    }

    private int readAtMost(String string, int n) {
        int n2 = n;
        if (string.length() < n) {
            n2 = string.length();
        }
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (!Character.isDigit(c)) {
                return n3;
            }
            ++n3;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] processADBC(int n, String string, ParsePosition parsePosition, boolean bl) throws ParseException {
        int[] nArray = new int[]{0, -1};
        if (bl) {
            throw new ParseException("Format code appears twice", parsePosition.getIndex());
        }
        if (n == 1 || n == 5) {
            if (string.startsWith(this.ErasUpperCaseWithPeriods[1])) {
                nArray[0] = 1;
                nArray[1] = this.ErasUpperCaseWithPeriods[1].length();
                return nArray;
            } else if (string.startsWith(this.ErasLowerCaseWithPeriods[1])) {
                nArray[0] = 1;
                nArray[1] = this.ErasLowerCaseWithPeriods[1].length();
                return nArray;
            } else if (string.startsWith(this.ErasUpperCaseWithPeriods[0])) {
                nArray[0] = 5;
                nArray[1] = this.ErasUpperCaseWithPeriods[0].length();
                return nArray;
            } else {
                if (!string.startsWith(this.ErasLowerCaseWithPeriods[0])) throw new ParseException("B.C. or A.D. required", parsePosition.getIndex());
                nArray[0] = 5;
                nArray[1] = this.ErasLowerCaseWithPeriods[0].length();
            }
            return nArray;
        } else if (string.startsWith(this.ErasUpperCase[1])) {
            nArray[0] = 3;
            nArray[1] = this.ErasUpperCase[1].length();
            return nArray;
        } else if (string.startsWith(this.ErasLowerCase[1])) {
            nArray[0] = 3;
            nArray[1] = this.ErasLowerCase[1].length();
            return nArray;
        } else if (string.startsWith(this.ErasUpperCase[0])) {
            nArray[0] = 6;
            nArray[1] = this.ErasUpperCase[0].length();
            return nArray;
        } else {
            if (!string.startsWith(this.ErasLowerCase[0])) throw new ParseException("BC or AD required", parsePosition.getIndex());
            nArray[0] = 6;
            nArray[1] = this.ErasLowerCase[0].length();
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] processAMPM(int n, String string, ParsePosition parsePosition, boolean bl) throws ParseException {
        int[] nArray = new int[]{0, -1};
        if (bl) {
            throw new ParseException("Format code appears twice", parsePosition.getIndex());
        }
        if (n == 2 || n == 28) {
            if (string.startsWith(this.AmPmUpperCaseWithPeriods[0])) {
                nArray[0] = 2;
                nArray[1] = this.AmPmUpperCaseWithPeriods[0].length();
                return nArray;
            } else if (string.startsWith(this.AmPmLowerCaseWithPeriods[0])) {
                nArray[0] = 2;
                nArray[1] = this.AmPmLowerCaseWithPeriods[0].length();
                return nArray;
            } else if (string.startsWith(this.AmPmUpperCaseWithPeriods[1])) {
                nArray[0] = 28;
                nArray[1] = this.AmPmUpperCaseWithPeriods[1].length();
                return nArray;
            } else {
                if (!string.startsWith(this.AmPmLowerCaseWithPeriods[1])) throw new ParseException("A.M. or P.M. required", parsePosition.getIndex());
                nArray[0] = 28;
                nArray[1] = this.AmPmLowerCaseWithPeriods[1].length();
            }
            return nArray;
        } else if (string.startsWith(this.AmPmUpperCase[0])) {
            nArray[0] = 4;
            nArray[1] = this.AmPmUpperCase[0].length();
            return nArray;
        } else if (string.startsWith(this.AmPmLowerCase[0])) {
            nArray[0] = 4;
            nArray[1] = this.AmPmLowerCase[0].length();
            return nArray;
        } else if (string.startsWith(this.AmPmUpperCase[1])) {
            nArray[0] = 29;
            nArray[1] = this.AmPmUpperCase[1].length();
            return nArray;
        } else {
            if (!string.startsWith(this.AmPmLowerCase[1])) throw new ParseException("AM or PM required", parsePosition.getIndex());
            nArray[0] = 29;
            nArray[1] = this.AmPmLowerCase[1].length();
        }
        return nArray;
    }

    private int checkArray(String[] stringArray, int n, String string, ParsePosition parsePosition) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            String string2;
            String string3 = stringArray[n5].trim();
            int n6 = string3.length();
            if (n2 >= n6 && (string2 = string.substring(0, n6)).equalsIgnoreCase(string3) && n6 > n3) {
                n3 = n6;
                n4 = n5;
            }
            ++n5;
        }
        if (n3 == 0) {
            return 0;
        }
        parsePosition.setIndex(parsePosition.getIndex() + n3);
        return n4 + 1;
    }
}

