/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JTextField;
import oracle.dss.util.dimensionList.DimListCellEditor;
import oracle.dss.util.dimensionList.DimListCellEditorEvent;
import oracle.dss.util.dimensionList.DimListCellEditorListener;

public class DefaultListCellEditor
extends JTextField
implements DimListCellEditor,
Serializable {
    private transient Vector m_listeners = new Vector();
    private transient int m_index = -1;

    public DefaultListCellEditor() {
        this.setVisible(false);
        this.setText("");
    }

    public synchronized void addEditListener(DimListCellEditorListener dimListCellEditorListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(dimListCellEditorListener)) {
            this.m_listeners.addElement(dimListCellEditorListener);
        }
    }

    public synchronized void removeEditListener(DimListCellEditorListener dimListCellEditorListener) {
        if (this.m_listeners != null && this.m_listeners.contains(dimListCellEditorListener)) {
            this.m_listeners.removeElement(dimListCellEditorListener);
        }
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public synchronized void startEdit(Component component, String string, int n, Rectangle rectangle) {
        this.m_index = n;
        this.setText(string);
        this.setBounds(rectangle);
        this.setVisible(true);
        this.requestFocus();
        DimListCellEditorEvent dimListCellEditorEvent = new DimListCellEditorEvent(this, DimListCellEditorEvent.START);
        this.notifyListeners(dimListCellEditorEvent);
    }

    public synchronized void acceptEdit() {
        DimListCellEditorEvent dimListCellEditorEvent = new DimListCellEditorEvent(this, DimListCellEditorEvent.ACCEPT, this.getText(), this.getIndex());
        this.notifyListeners(dimListCellEditorEvent);
    }

    public synchronized void stopEdit() {
        DimListCellEditorEvent dimListCellEditorEvent = new DimListCellEditorEvent(this, DimListCellEditorEvent.CANCEL);
        this.notifyListeners(dimListCellEditorEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            this.acceptEdit();
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.acceptEdit();
        } else if (n == 27) {
            this.stopEdit();
        }
    }

    private void notifyListeners(DimListCellEditorEvent dimListCellEditorEvent) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector vector;
            DefaultListCellEditor defaultListCellEditor = this;
            synchronized (defaultListCellEditor) {
                try {
                    vector = (Vector)this.m_listeners.clone();
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
            int n = vector.size();
            DimListCellEditorListener dimListCellEditorListener = null;
            int n2 = 0;
            while (n2 < n) {
                dimListCellEditorListener = (DimListCellEditorListener)vector.elementAt(n2);
                if (dimListCellEditorListener != null) {
                    dimListCellEditorListener.DimListCellEditorAction(dimListCellEditorEvent);
                }
                ++n2;
            }
        }
    }
}

