/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccess2;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.dimensionList.DefaultListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;

public class DataAccessDimensionModel
implements DimListDataModel,
Serializable {
    private transient DataAccess m_dataAccess;
    private transient MemberListAccess m_memberAccess;
    private boolean m_isDragable = true;
    private boolean m_isDropTarget = true;
    private transient Vector m_listeners;
    private transient Object m_selItem;
    private String m_labelType = "longName";
    private transient boolean m_initOK;
    private String m_dimensionName = "";
    private boolean m_verbose;
    private transient int m_dimEdge;
    private transient int m_dimDepth = -1;
    private boolean m_first;
    private boolean m_isHierarchical = true;
    private Vector slices;
    private boolean m_isTable;
    private Vector m_values;
    private Vector m_names;
    private boolean _memberListExist;
    private List m_list;

    public DataAccessDimensionModel() {
    }

    public DataAccessDimensionModel(DataAccess dataAccess, String string) {
        this(dataAccess, null, string, false);
    }

    public DataAccessDimensionModel(DataAccess dataAccess, MemberListAccess memberListAccess, String string, boolean bl) {
        this.setDimensionName(string);
        this.setDataAccess(dataAccess);
        this.m_memberAccess = memberListAccess;
        this.m_isTable = bl;
    }

    public void addElement(Object object) {
    }

    public boolean collapseAll() {
        return true;
    }

    public boolean expandAll() {
        return true;
    }

    public boolean drill(int n, int n2) {
        return true;
    }

    public boolean isHierarchical() {
        return this.m_isHierarchical;
    }

    public void insertElementAt(Object object, int n) {
    }

    public void setElementAt(Object object, int n) {
    }

    public void refresh() {
        long l = this.size();
        this.notifyListDataListeners(new ListDataEvent(this, 0, 0, (int)l));
    }

    public void removeAllElements() {
    }

    public void removeElementAt(int n) {
    }

    public void moveElement(int n, int n2) {
    }

    public int find(String string, int n, int n2) {
        boolean bl = true;
        int n3 = -1;
        if (n2 > 0) {
            // empty if block
        }
        int[] nArray = new int[]{++n2};
        if (this.m_initOK) {
            try {
                n3 = this.m_dataAccess.findMember(0, nArray, 0, string, this.m_labelType, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n3;
    }

    public Object getSelectedItem() {
        return this.m_selItem;
    }

    public void setSelectedItem(Object object) {
        this.m_selItem = object;
    }

    public Object elementAt(int n) {
        return this.getElementAt(n);
    }

    public int getSize() {
        long l = 0L;
        if (this.m_initOK) {
            try {
                if (!this.m_isTable || this.m_dimEdge == 2) {
                    if (this.m_memberAccess != null) {
                        l = this.m_memberAccess.getAllMembers(this.m_dimEdge, this.m_dimDepth, "value").length;
                    } else {
                        if (this.m_dataAccess instanceof DataAccess2) {
                            if (!this._memberListExist) {
                                this.m_list = ((DataAccess2)this.m_dataAccess).getUniqueMemberMetadata(this.m_dimEdge, this.m_dimDepth, new String[]{"value", this.m_labelType, "relHierInfo", "hierLevel", "drillState"}, 0, -1);
                                this._memberListExist = true;
                            }
                            if (this.m_list != null) {
                                l = this.m_list.size();
                            }
                        }
                        if (this.m_list == null) {
                            int[] nArray = new int[this.m_dimDepth];
                            int n = this.m_dataAccess.getMemberSiblingCount(this.m_dimEdge, nArray, this.m_dimDepth);
                            if ((long)n == l) {
                                int n2 = (int)l;
                                return n2;
                            }
                            int n3 = 0;
                            Vector<Object> vector = new Vector<Object>();
                            this.slices = new Vector();
                            while (n3 < this.m_dataAccess.getEdgeExtent(this.m_dimEdge)) {
                                Object object;
                                if (this.m_dataAccess.getMemberStartLayer(this.m_dimEdge, this.m_dimDepth, n3) == this.m_dimDepth && vector.indexOf(object = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, n3, "value")) == -1) {
                                    vector.addElement(object);
                                    this.slices.addElement(new Integer(n3));
                                }
                                n3 += this.m_dataAccess.getMemberExtent(this.m_dimEdge, this.m_dimDepth, n3);
                            }
                            l = vector.size();
                        }
                    }
                } else if (this.m_dimEdge == 0) {
                    this.m_values = new Vector();
                    this.m_names = new Vector();
                    Object[] objectArray = null;
                    if (this.m_dataAccess instanceof DataAccess2) {
                        if (!this._memberListExist) {
                            this.m_list = ((DataAccess2)this.m_dataAccess).getUniqueDataValues(this.m_dimensionName, new String[]{"value", "dataUnformatted"}, 0, -1);
                            this._memberListExist = true;
                        }
                        if (this.m_list != null) {
                            l = this.m_list.size();
                        }
                    }
                    if (this.m_list == null) {
                        if (this.m_memberAccess != null) {
                            objectArray = this.m_memberAccess.getAllMembers(0, this.m_dimDepth, "dataUnformatted");
                        }
                        int n = 0;
                        while (n < this.m_dataAccess.getEdgeExtent(1)) {
                            Object object = null;
                            Object object2 = objectArray != null ? objectArray[n] : this.m_dataAccess.getValue(n, this.m_dimDepth, "dataUnformatted");
                            object = this.m_dataAccess.getValue(n, this.m_dimDepth, "value");
                            if (object == null) {
                                object = this.m_dataAccess.getValue(n, this.m_dimDepth, "dataUnformatted");
                            }
                            if (this.m_names.indexOf(object2) == -1) {
                                this.m_names.addElement(object2);
                                this.m_values.addElement(null.new ValueData(object, object2));
                            }
                            ++n;
                        }
                        l = this.m_values.size();
                    }
                }
            }
            catch (SliceOutOfRangeException sliceOutOfRangeException) {
                sliceOutOfRangeException.printStackTrace();
            }
            catch (LayerOutOfRangeException layerOutOfRangeException) {
                layerOutOfRangeException.printStackTrace();
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                edgeOutOfRangeException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return (int)l;
    }

    public int size() {
        return this.getSize();
    }

    protected void notifyListDataListeners(ListDataEvent listDataEvent) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector vector = null;
            DataAccessDimensionModel dataAccessDimensionModel = this;
            synchronized (dataAccessDimensionModel) {
                try {
                    vector = (Vector)this.m_listeners.clone();
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ListDataListener listDataListener = (ListDataListener)vector.elementAt(n2);
                if (listDataListener != null) {
                    if (listDataEvent.getType() == 1) {
                        listDataListener.intervalAdded(listDataEvent);
                    } else if (listDataEvent.getType() == 2) {
                        listDataListener.intervalRemoved(listDataEvent);
                    } else {
                        listDataListener.contentsChanged(listDataEvent);
                    }
                }
                ++n2;
            }
        }
    }

    public void addListDataListener(ListDataListener listDataListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(listDataListener)) {
            this.m_listeners.addElement(listDataListener);
            long l = this.size();
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, (int)l);
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        if (this.m_listeners != null && this.m_listeners.contains(listDataListener)) {
            this.m_listeners.removeElement(listDataListener);
        }
    }

    public boolean isDragable(long l) {
        return this.m_isDragable;
    }

    public void setIsDragable(boolean bl) {
        this.m_isDragable = bl;
    }

    public boolean isDropTarget(long l, Object object) {
        return this.m_isDropTarget;
    }

    public void setIsDropTarget(boolean bl) {
        this.m_isDropTarget = bl;
    }

    public Object getElementAt(int n) {
        DefaultListDataItem defaultListDataItem = null;
        Object object = null;
        Object object2 = null;
        String string = "";
        int n2 = -1;
        int n3 = 0;
        if (this.m_initOK && n != -1) {
            if (this.m_isTable && this.m_dimEdge != 2) {
                try {
                    string = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "relHierInfo");
                    if (string == null || string.equals(object2) || string.equals(object)) {
                        string = "";
                    }
                    try {
                        n2 = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "hierLevel");
                        n3 = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "drillState");
                    }
                    catch (Exception exception) {
                        n2 = 0;
                        n3 = 0;
                    }
                    if (this.m_dataAccess instanceof DataAccess2) {
                        if (!this._memberListExist) {
                            this.m_list = ((DataAccess2)this.m_dataAccess).getUniqueDataValues(this.m_dimensionName, new String[]{"value", "dataUnformatted"}, 0, -1);
                            this._memberListExist = true;
                        }
                        if (this.m_list != null) {
                            Object[] objectArray = (Object[])this.m_list.get(n);
                            object2 = objectArray[0];
                            object = objectArray[1];
                        }
                    }
                    if (this.m_list == null) {
                        object = this.m_names.elementAt(n);
                        object2 = ((ValueData)this.m_values.elementAt((int)n)).value;
                    }
                    defaultListDataItem = new DefaultListDataItem(object.toString(), n2, n3, object.toString(), object2.toString(), string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                Object[] objectArray;
                if (this.m_dataAccess instanceof DataAccess2) {
                    try {
                        if (!this._memberListExist) {
                            this.m_list = ((DataAccess2)this.m_dataAccess).getUniqueMemberMetadata(this.m_dimEdge, this.m_dimDepth, new String[]{"value", this.m_labelType, "relHierInfo", "hierLevel", "drillState"}, 0, -1);
                            this._memberListExist = true;
                        }
                        if (this.m_list != null) {
                            objectArray = (Object[])this.m_list.get(n);
                            object2 = objectArray[0];
                            object = objectArray[1];
                            string = (String)objectArray[2];
                            n2 = objectArray[3] != null ? (Integer)objectArray[3] : 0;
                            n3 = objectArray[4] != null ? (Integer)objectArray[4] : 0;
                            defaultListDataItem = new DefaultListDataItem(object.toString(), n2, n3, object.toString(), object2.toString(), string);
                        }
                    }
                    catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                    }
                    catch (LayerOutOfRangeException layerOutOfRangeException) {
                    }
                    catch (SliceOutOfRangeException sliceOutOfRangeException) {
                        // empty catch block
                    }
                }
                if (this.m_list == null) {
                    objectArray = null;
                    int[] nArray = new int[this.m_dimDepth];
                    try {
                        if (this.slices != null) {
                            int n4 = (Integer)this.slices.elementAt(n);
                            object = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, n4, this.m_labelType);
                            object2 = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, n4, "value");
                            if (object == null) {
                                object = object2;
                            }
                            try {
                                string = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, n4, "relHierInfo");
                                if (string == null || string.equals(object2) || string.equals(object)) {
                                    string = "";
                                }
                                try {
                                    n2 = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, n4, "hierLevel");
                                    n3 = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, n4, "drillState");
                                }
                                catch (Exception exception) {
                                    n2 = 0;
                                    n3 = 0;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            object = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, nArray, this.m_dimDepth, n, this.m_labelType);
                            object2 = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, nArray, this.m_dimDepth, n, "value");
                            if (object == null) {
                                object = object2;
                            }
                            try {
                                string = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, nArray, this.m_dimDepth, n, "relHierInfo");
                                if (string == null || string.equals(object2) || string.equals(object)) {
                                    string = "";
                                }
                                try {
                                    n2 = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, nArray, this.m_dimDepth, n, "hierLevel");
                                    n3 = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, nArray, this.m_dimDepth, n, "drillState");
                                }
                                catch (Exception exception) {
                                    n2 = 0;
                                    n3 = 0;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        defaultListDataItem = new DefaultListDataItem(object.toString(), n2, n3, object.toString(), object2.toString(), string);
                    }
                    catch (SliceOutOfRangeException sliceOutOfRangeException) {
                        sliceOutOfRangeException.printStackTrace();
                    }
                    catch (LayerOutOfRangeException layerOutOfRangeException) {
                        layerOutOfRangeException.printStackTrace();
                    }
                    catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                        edgeOutOfRangeException.printStackTrace();
                    }
                }
            }
        }
        return defaultListDataItem;
    }

    public void setLabelType(String string) {
        this.m_labelType = string;
    }

    public String getLabelType() {
        return this.m_labelType;
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public void setDimensionName(String string) {
        this.m_dimensionName = string;
    }

    public String getDimensionName() {
        return this.m_dimensionName;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.m_dataAccess = dataAccess;
        this.initDataAccess();
    }

    public void setHierarchical(boolean bl) {
        this.m_isHierarchical = bl;
    }

    private void initDataAccess() {
        if (this.m_dataAccess != null && this.m_dimensionName != null) {
            try {
                int n = 0;
                while (n < this.m_dataAccess.getEdgeCount()) {
                    int n2 = 0;
                    while (n2 < this.m_dataAccess.getLayerCount(n)) {
                        String string = (String)this.m_dataAccess.getLayerMetadata(n, n2, "dimName");
                        if (string != null && this.m_dimensionName.equals(string)) {
                            this.m_dimEdge = n;
                            this.m_dimDepth = n2;
                            if (!this.m_first) {
                                this.m_first = true;
                            }
                            this.m_initOK = true;
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ValueData {
        Object value;
        Object name;

        public ValueData(Object object, Object object2) {
            this.value = object;
            this.name = object2;
        }
    }
}

