/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dss.util.MemberContext;
import oracle.dss.util.Utility;

public class RuleMemberContext
implements MemberContext {
    protected int m_dimIndex;
    protected String m_dimension;
    protected List m_members;

    public RuleMemberContext() {
    }

    public RuleMemberContext(String string) {
        this.m_dimension = string;
        this.m_members = new ArrayList();
    }

    public String getDimID() {
        return this.m_dimension;
    }

    public void setDimIndex(int n) {
        this.m_dimIndex = n;
    }

    public int getDimIndex() {
        return this.m_dimIndex;
    }

    public String getMemberID(int n) {
        return (String)this.m_members.get(n);
    }

    public int getMemberCount() {
        return this.m_members.size();
    }

    public int getMemberIndex(String string) {
        int n = 0;
        while (n < this.m_members.size()) {
            String string2 = (String)this.m_members.get(n);
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        this.m_members.add(string);
        return this.m_members.size() - 1;
    }

    public static int addDimensionMembers(List list, String string) {
        RuleMemberContext ruleMemberContext = new RuleMemberContext(string);
        int n = 0;
        while (n < list.size()) {
            MemberContext memberContext = (MemberContext)list.get(n);
            if (memberContext.equals(ruleMemberContext)) {
                return n;
            }
            ++n;
        }
        n = list.size();
        list.add(ruleMemberContext);
        ruleMemberContext.setDimIndex(n);
        return n;
    }

    public boolean equals(MemberContext memberContext) {
        return Utility.compareObj(memberContext.getDimID(), this.getDimID());
    }

    public boolean equals(Object object) {
        if (object instanceof RuleMemberContext) {
            RuleMemberContext ruleMemberContext = (RuleMemberContext)object;
            return Utility.compareObj(ruleMemberContext.getDimID(), this.getDimID());
        }
        return false;
    }

    public void setStateString(String string, boolean bl) {
        String string2 = Utility.unescapeStateString(string, MemberContext.ESCAPE_CHARS, null, '-');
        int n = string2.indexOf(MemberContext.DIMENSION_SEPARATOR_S);
        if (n == -1) {
            return;
        }
        this.m_dimension = string2.substring(0, n);
        string2 = string2.substring(n + 1);
        this.m_members = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, MemberContext.MEMBER_SEPARATOR_S);
        while (stringTokenizer.hasMoreTokens()) {
            this.m_members.add(stringTokenizer.nextToken());
        }
    }

    public String getStateString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Utility.escapeStateString(this.getDimID(), MemberContext.ESCAPE_CHARS, null, '-'));
        String string = MemberContext.DIMENSION_SEPARATOR_S;
        int n = 0;
        while (n < this.m_members.size()) {
            stringBuffer.append(string);
            string = MemberContext.MEMBER_SEPARATOR_S;
            stringBuffer.append(Utility.escapeStateString((String)this.m_members.get(n), MemberContext.ESCAPE_CHARS, null, '-'));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static List deserializeDimMembersContext(String string) {
        ArrayList<RuleMemberContext> arrayList = new ArrayList<RuleMemberContext>();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, MemberContext.ENTRY_SEPARATOR_S);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                RuleMemberContext ruleMemberContext = new RuleMemberContext();
                ruleMemberContext.setDimIndex(arrayList.size());
                arrayList.add(ruleMemberContext);
                ruleMemberContext.setStateString(string2, false);
            }
        }
        return arrayList;
    }

    public static String serializeDimMembersContext(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof RuleMemberContext) {
                stringBuffer.append(((RuleMemberContext)e).getStateString());
                if (n < list.size() - 1) {
                    stringBuffer.append(MemberContext.ENTRY_SEPARATOR_S);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

