/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.util.MemberContext;
import oracle.dss.util.Utility;
import oracle.dss.util.VectorClone;
import oracle.dss.util.persistence.IDResolver;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.persistence.XMLizable;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class QDRMember
implements Cloneable,
Serializable,
VectorClone,
XMLizable {
    public static final int FIXED = 0;
    public static final int VARIES = 1;
    public static final int CURRENT = 2;
    public static final int LIST = 3;
    public static final String XML_NAME = "QDRMem";
    public static final String XML_LIST_NAME = "ListQDRMem";
    private static final String TYPE_PROPERTY = "memType";
    private static final String DATA_PROPERTY = "Data";
    private static final String MEMBER_PROPERTY = "mem";
    private static final String LIST_MEMBER_PROPERTY = "ListMem";
    private static final String XML_FIXED = "FIXED";
    private static final String XML_VARIES = "VARIES";
    private static final String XML_CURRENT = "CURRENT";
    private static final String XML_LIST = "LIST";
    private int m_intType = 0;
    private Object m_data;
    private static boolean DEBUG;

    public QDRMember() {
    }

    public QDRMember(int n) {
        this.setType(n);
    }

    public QDRMember(String string) {
        this.setData(string);
        this.setType(0);
    }

    public QDRMember(int n, Object object) {
        this.setType(n);
        this.setData(object);
    }

    public int hashCode() {
        switch (this.getType()) {
            case 0: {
                return this.m_data == null ? 0 : this.m_data.hashCode();
            }
            case 3: {
                if (!(this.m_data instanceof Vector)) break;
                int n = 0;
                Object object = null;
                Enumeration enumeration = ((Vector)this.m_data).elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (object == null) continue;
                    n += object.hashCode();
                }
                return n;
            }
            default: {
                return this.getType();
            }
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        QDRMember qDRMember = (QDRMember)super.clone();
        if (this.m_data != null) {
            if (this.m_data instanceof Vector) {
                qDRMember.setData(((Vector)this.m_data).clone());
            } else if (this.m_data instanceof String) {
                qDRMember.setData(new String((String)this.m_data));
            }
        }
        return qDRMember;
    }

    public boolean equals(QDRMember qDRMember) {
        if (qDRMember != null && this.getType() == qDRMember.getType()) {
            Object object = this.getData();
            Object object2 = qDRMember.getData();
            if (object == null && object2 == null) {
                return true;
            }
            if (object != null && object2 != null) {
                if (object.equals(object2)) {
                    return true;
                }
                if (this.getType() == 3 && object instanceof Vector && object2 instanceof Vector) {
                    Vector vector = (Vector)object;
                    Vector vector2 = (Vector)object2;
                    return vector.size() == vector2.size() && Utility.contains(vector, vector2);
                }
            }
        }
        return false;
    }

    public boolean contains(QDRMember qDRMember) {
        if (qDRMember == null) {
            return false;
        }
        if (this.getType() == 1) {
            return true;
        }
        if (this.equals(qDRMember)) {
            return true;
        }
        int n = qDRMember.getType();
        if (this.getType() == 3 && this.m_data instanceof Vector) {
            Vector vector = (Vector)this.m_data;
            Object object = qDRMember.getData();
            if (object != null) {
                if (n == 3 && object instanceof Vector) {
                    return Utility.contains(vector, (Vector)object);
                }
                if (n == 0) {
                    return vector.contains(object);
                }
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof QDRMember) {
            return this.equals((QDRMember)object);
        }
        return false;
    }

    public String toString() {
        String string = "";
        switch (this.m_intType) {
            case 0: 
            case 3: {
                if (this.m_data == null) break;
                string = String.valueOf(string) + this.m_data.toString();
                break;
            }
            case 1: {
                string = String.valueOf(string) + XML_VARIES;
                break;
            }
            case 2: {
                string = String.valueOf(string) + XML_CURRENT;
            }
        }
        return string;
    }

    public void setType(int n) {
        this.m_intType = n;
    }

    public int getType() {
        return this.m_intType;
    }

    public void setData(Object object) {
        this.m_data = object;
    }

    public Object getData() {
        return this.m_data;
    }

    public Object getXML(XMLContext xMLContext) {
        Serializable serializable;
        Object object;
        IDResolver iDResolver = null;
        boolean bl = true;
        if (xMLContext != null && (object = xMLContext.getScope()) != null) {
            iDResolver = (IDResolver)((ObjectScope)object).getObject("PersistableIDResolver");
            serializable = (Boolean)((ObjectScope)object).getObject("allProperties");
            if (serializable != null) {
                bl = (Boolean)serializable;
            }
        }
        Object object2 = object = this.m_intType == 3 ? XML_LIST_NAME : XML_NAME;
        if (this.m_intType != 3) {
            serializable = new ObjectNode((String)object);
            if (bl || this.getType() == 1 || this.getType() == 2) {
                ((BaseObjectNode)serializable).addProperty(TYPE_PROPERTY, this.convertTypeIntToString(this.getType()));
            }
            if (this.m_data != null && this.m_data instanceof String) {
                ((BaseObjectNode)serializable).addProperty(MEMBER_PROPERTY, (String)this.m_data);
            }
            return serializable;
        }
        serializable = new ContainerNode((String)object);
        if (this.m_data != null && this.m_data instanceof Vector) {
            Enumeration enumeration = ((Vector)this.m_data).elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ((ContainerNode)serializable).addContainedObject(new PropertyNode(LIST_MEMBER_PROPERTY, string));
            }
        }
        return serializable;
    }

    public void setXML(XMLContext xMLContext, Object object) {
        if (object instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)object;
            PropertyNode propertyNode = objectNode.getProperty(TYPE_PROPERTY);
            if (propertyNode != null) {
                this.setType(this.convertTypeStringToInt(propertyNode.getValueAsString()));
            } else {
                this.setType(0);
            }
            propertyNode = objectNode.getProperty(MEMBER_PROPERTY);
            if (propertyNode != null) {
                this.setData(propertyNode.getValueAsString());
            }
        } else {
            ContainerNode containerNode = (ContainerNode)object;
            this.setType(3);
            this.m_data = new Vector();
            Enumeration enumeration = containerNode.getPropertyNodes(LIST_MEMBER_PROPERTY);
            while (enumeration.hasMoreElements()) {
                PropertyNode propertyNode = (PropertyNode)enumeration.nextElement();
                ((Vector)this.m_data).addElement(propertyNode.getValueAsString());
            }
        }
    }

    public String getTagName() {
        if (this.m_intType == 3) {
            return XML_LIST_NAME;
        }
        return XML_NAME;
    }

    protected String convertTypeIntToString(int n) {
        String string = XML_FIXED;
        switch (n) {
            case 0: {
                string = XML_FIXED;
                break;
            }
            case 1: {
                string = XML_VARIES;
                break;
            }
            case 2: {
                string = XML_CURRENT;
                break;
            }
            case 3: {
                string = XML_LIST;
            }
        }
        return string;
    }

    protected int convertTypeStringToInt(String string) {
        if (string.equals(XML_FIXED)) {
            return 0;
        }
        if (string.equals(XML_VARIES)) {
            return 1;
        }
        if (string.equals(XML_CURRENT)) {
            return 2;
        }
        if (string.equals(XML_LIST)) {
            return 3;
        }
        return -1;
    }

    public String getStateString(MemberContext memberContext) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getType()) {
            case 0: {
                if (this.getData() == null) break;
                this.addMember(memberContext, stringBuffer, this.getData().toString());
                break;
            }
            case 3: {
                if (!(this.getData() instanceof Vector)) break;
                Vector vector = (Vector)this.getData();
                boolean bl = true;
                int n = 0;
                while (n < vector.size()) {
                    if (!bl) {
                        stringBuffer.append(MemberContext.MEMBER_SEPARATOR_S);
                    }
                    bl = false;
                    this.addMember(memberContext, stringBuffer, (String)vector.elementAt(n));
                    ++n;
                }
                break;
            }
        }
        return stringBuffer.toString();
    }

    private void addMember(MemberContext memberContext, StringBuffer stringBuffer, String string) {
        if (string != null) {
            int n = memberContext.getMemberIndex(string);
            stringBuffer.append(n);
            if (DEBUG) {
                System.out.println(String.valueOf(string) + ": " + n);
            }
        }
    }
}

