/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import oracle.dss.util.QDR;
import oracle.dss.util.Utility;

public class Parameter
implements Serializable {
    protected Object m_objValue;
    protected Class m_classType;

    public Parameter() {
    }

    public Parameter(Object object, Class clazz) {
        this.setValue(object);
        this.setType(clazz);
    }

    public Parameter(Object object) {
        if (object != null) {
            if (object instanceof String) {
                this.setValue(new String((String)object));
                this.setType(Class.forName("java.lang.String"));
            } else if (object instanceof QDR) {
                this.setValue(new QDR((QDR)object));
                this.setType(Class.forName("oracle.dss.util.QDR"));
            } else if (object instanceof Integer) {
                this.setValue(new Integer((Integer)object));
                this.setType(Class.forName("java.lang.Integer"));
            } else if (object instanceof Long) {
                this.setValue(new Long((Long)object));
                this.setType(Class.forName("java.lang.Long"));
            } else if (object instanceof Float) {
                this.setValue(new Float(((Float)object).floatValue()));
                this.setType(Class.forName("java.lang.Float"));
            } else if (object instanceof Double) {
                this.setValue(new Double((Double)object));
                this.setType(Class.forName("java.lang.Double"));
            } else if (object instanceof Boolean) {
                this.setValue(new Boolean((Boolean)object));
                this.setType(Class.forName("java.lang.Boolean"));
            }
        }
    }

    public Parameter(String string) {
        this.setValue(string != null ? new String(string) : null);
        this.setType(Class.forName("java.lang.String"));
    }

    public Parameter(int n) {
        this.setValue(new Integer(n));
        this.setType(Class.forName("java.lang.Integer"));
    }

    public Parameter(float f) {
        this.setValue(new Float(f));
        this.setType(Class.forName("java.lang.Float"));
    }

    public Parameter(long l) {
        this.setValue(new Long(l));
        this.setType(Class.forName("java.lang.Long"));
    }

    public Parameter(double d) {
        this.setValue(new Double(d));
        this.setType(Class.forName("java.lang.Double"));
    }

    public Parameter(boolean bl) {
        this.setValue(new Boolean(bl));
        this.setType(Class.forName("java.lang.Boolean"));
    }

    public Object clone() throws CloneNotSupportedException {
        Boolean bl;
        Parameter parameter = null;
        parameter = (Parameter)super.clone();
        parameter.setType(this.getType());
        if (this.getType() == Class.forName("oracle.dss.util.QDR")) {
            QDR qDR = (QDR)this.getValue();
            if (qDR != null) {
                parameter.setValue(qDR.clone());
            }
        } else if (this.getType() == Class.forName("java.lang.String")) {
            String string = (String)this.getValue();
            if (string != null) {
                parameter.setValue(new String(string));
            }
        } else if (this.getType() == Class.forName("java.lang.Integer")) {
            Integer n = (Integer)this.getValue();
            if (n != null) {
                parameter.setValue(new Integer(n));
            }
        } else if (this.getType() == Class.forName("java.lang.Long")) {
            Long l = (Long)this.getValue();
            if (l != null) {
                parameter.setValue(new Long(l));
            }
        } else if (this.getType() == Class.forName("java.lang.Float")) {
            Float f = (Float)this.getValue();
            if (f != null) {
                parameter.setValue(new Float(f.floatValue()));
            }
        } else if (this.getType() == Class.forName("java.lang.Double")) {
            Double d = (Double)this.getValue();
            if (d != null) {
                parameter.setValue(new Double(d));
            }
        } else if (this.getType() == Class.forName("java.lang.Boolean") && (bl = (Boolean)this.getValue()) != null) {
            parameter.setValue(new Boolean(bl));
        }
        return parameter;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Parameter)) {
            return false;
        }
        return Utility.compareObj(this.getValue(), ((Parameter)object).getValue()) && Utility.compareObj(this.getType(), ((Parameter)object).getType());
    }

    public Class getType() {
        return this.m_classType;
    }

    public Object getValue() {
        return this.m_objValue;
    }

    public void setValue(Object object) {
        this.m_objValue = object;
    }

    public void setType(Class clazz) {
        this.m_classType = clazz;
    }

    public String toString() {
        return Utility.arrayToString(this.getValue());
    }
}

