/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;

public class CustomStyle
implements Persistable {
    private String _title = "Unnamed Style";
    private String _xmlString;
    private CustomStyle _baseStyle;
    private String _persistableObjectType;
    private PersistableAttributes _attrs;

    public CustomStyle() {
    }

    public CustomStyle(String string) {
        this.setXMLAsString(string);
    }

    public CustomStyle(Class clazz, String string) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException();
        }
        char[] cArray = new char[2048];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = ((Reader)bufferedReader).read(cArray, 0, cArray.length)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        this.setXMLAsString(stringBuffer.toString());
    }

    public CustomStyle getBaseStyle() {
        return this._baseStyle;
    }

    public void setBaseStyle(CustomStyle customStyle) {
        this._baseStyle = customStyle;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getPersistableObjectType() {
        return this._persistableObjectType;
    }

    public void setPersistableObjectType(String string) {
        this._persistableObjectType = string;
    }

    public void initialize(Hashtable hashtable) {
    }

    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] aggregateInfoArray = null;
        CustomStyle customStyle = this.getBaseStyle();
        if (customStyle != null && customStyle instanceof Persistable) {
            aggregateInfoArray = new AggregateInfo[]{new AggregateInfo(customStyle, 0)};
        }
        return aggregateInfoArray;
    }

    public void setPersistableComponents(AggregateInfo[] aggregateInfoArray) {
        if (aggregateInfoArray != null && aggregateInfoArray.length > 0) {
            this.setBaseStyle((CustomStyle)aggregateInfoArray[0].getPersistable());
        }
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes persistableAttributes) {
        String string;
        PersistableAttributes persistableAttributes2 = null;
        persistableAttributes2 = this._attrs == null ? new PersistableAttributes() : (PersistableAttributes)this._attrs.clone();
        if (persistableAttributes != null) {
            persistableAttributes2.merge(persistableAttributes);
        }
        if ((string = this.getPersistableObjectType()) != null) {
            persistableAttributes2.setObjectType(string);
        } else {
            persistableAttributes2.setObjectType("GraphStyle");
        }
        persistableAttributes2.setTitle(this.getTitle());
        return persistableAttributes2;
    }

    public void setPersistableAttributes(PersistableAttributes persistableAttributes) {
        this._attrs = persistableAttributes;
    }

    public String getXMLAsString() {
        return this._xmlString;
    }

    public boolean setXMLAsString(String string) {
        this._xmlString = string;
        return true;
    }
}

