/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BASE64Decoder {
    private static final int s_atom_size = 4;
    private static final int s_line_size = 72;
    private static final char[] s_arr = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] s_con_arr = new byte[256];
    private byte[] m_decode_buffer = new byte[4];

    public byte[] decode(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (true) {
                int n = 0;
                while (n + 4 < 72) {
                    this.decodeAtom(byteArrayInputStream, byteArrayOutputStream, 4);
                    n += 4;
                }
                if (n + 4 == 72) {
                    this.decodeAtom(byteArrayInputStream, byteArrayOutputStream, 4);
                    continue;
                }
                this.decodeAtom(byteArrayInputStream, byteArrayOutputStream, 72 - n);
            }
        }
        catch (RuntimeException runtimeException) {
            return byteArrayOutputStream.toByteArray();
        }
    }

    private void decodeAtom(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        if (n < 2) {
            throw new IOException("Not enough bytes for an atom.");
        }
        int n6 = -1;
        do {
            if ((n6 = inputStream.read()) != -1) continue;
            throw new RuntimeException();
        } while (n6 == 10 || n6 == 13);
        this.m_decode_buffer[0] = (byte)n6;
        n6 = n - 1;
        int n7 = 0;
        while (n7 < n6) {
            int n8 = inputStream.read();
            if (n8 == -1) {
                if (n7 == 0) {
                    n6 = -1;
                    break;
                }
                n6 = n7;
                break;
            }
            this.m_decode_buffer[n7 + 1] = (byte)n8;
            ++n7;
        }
        if (n6 == -1) {
            throw new RuntimeException();
        }
        if (n > 3 && this.m_decode_buffer[3] == 61) {
            n = 3;
        }
        if (n > 2 && this.m_decode_buffer[2] == 61) {
            n = 2;
        }
        switch (n) {
            case 4: {
                n5 = s_con_arr[this.m_decode_buffer[3] & 0xFF];
            }
            case 3: {
                n4 = s_con_arr[this.m_decode_buffer[2] & 0xFF];
            }
            case 2: {
                n3 = s_con_arr[this.m_decode_buffer[1] & 0xFF];
                n2 = s_con_arr[this.m_decode_buffer[0] & 0xFF];
            }
        }
        switch (n) {
            case 2: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                return;
            }
            case 3: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                outputStream.write((byte)(n3 << 4 & 0xF0 | n4 >>> 2 & 0xF));
                return;
            }
            case 4: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                outputStream.write((byte)(n3 << 4 & 0xF0 | n4 >>> 2 & 0xF));
                outputStream.write((byte)(n4 << 6 & 0xC0 | n5 & 0x3F));
                return;
            }
        }
    }

    static {
        int n = 0;
        while (n < 255) {
            BASE64Decoder.s_con_arr[n] = -1;
            ++n;
        }
        n = 0;
        while (n < s_arr.length) {
            BASE64Decoder.s_con_arr[BASE64Decoder.s_arr[n]] = (byte)n;
            ++n;
        }
    }
}

