/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.Vector;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class StringValueDiscriminator
extends ValueDiscriminator {
    private Vector m_strings;
    public static final String NAME_STR_VAL_DISC = "StrValDisc";
    protected static final String a_stringValue = "StrVal";

    public StringValueDiscriminator() {
    }

    public StringValueDiscriminator(Vector vector, int n) {
        super(n);
        this.m_strings = vector;
    }

    public StringValueDiscriminator(String string, int n) {
        super(n);
        this.m_strings = new Vector();
        this.m_strings.addElement(string);
    }

    public Object clone() {
        return new StringValueDiscriminator(this.m_strings, this.m_relOperator);
    }

    public void setString(String string) {
        if (string != null) {
            this.m_strings = new Vector();
            this.m_strings.addElement(string);
        }
    }

    public void setStrings(Vector vector) {
        this.m_strings = vector;
    }

    public Vector getStrings() {
        return this.m_strings;
    }

    public String getString() {
        if (this.m_strings != null) {
            return (String)this.m_strings.elementAt(0);
        }
        return null;
    }

    public boolean applies(RuleContext ruleContext) {
        String string = (String)ruleContext.get("STRING_VALUE");
        if (string == null && this.m_strings == null) {
            return true;
        }
        if (string == null || this.m_strings == null) {
            return false;
        }
        switch (this.m_relOperator) {
            case 0: {
                int n = 0;
                while (n < this.m_strings.size()) {
                    if (this.m_strings.elementAt(n) != null && string.equals(this.m_strings.elementAt(n).toString())) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 1: {
                int n = 0;
                while (n < this.m_strings.size()) {
                    if (this.m_strings.elementAt(n) == null || string.compareTo(this.m_strings.elementAt(n).toString()) >= 0) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 2: {
                int n = 0;
                while (n < this.m_strings.size()) {
                    if (this.m_strings.elementAt(n) == null || string.compareTo(this.m_strings.elementAt(n).toString()) > 0) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 3: {
                int n = 0;
                while (n < this.m_strings.size()) {
                    if (this.m_strings.elementAt(n) == null || string.compareTo(this.m_strings.elementAt(n).toString()) <= 0) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 4: {
                int n = 0;
                while (n < this.m_strings.size()) {
                    if (this.m_strings.elementAt(n) == null || string.compareTo(this.m_strings.elementAt(n).toString()) < 0) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            case 5: {
                int n = 0;
                while (n < this.m_strings.size()) {
                    if (this.m_strings.elementAt(n) != null && string.equals(this.m_strings.elementAt(n).toString())) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        int n = 0;
        while (n < this.m_strings.size()) {
            if (this.m_strings.elementAt(n) != null && string.equals(this.m_strings.elementAt(n).toString())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringValueDiscriminator)) {
            return false;
        }
        StringValueDiscriminator stringValueDiscriminator = (StringValueDiscriminator)object;
        if (this.getRelOperator() != stringValueDiscriminator.getRelOperator()) {
            return false;
        }
        Vector vector = stringValueDiscriminator.getStrings();
        if (vector == null || this.m_strings == null || vector.size() != this.m_strings.size()) {
            return false;
        }
        int n = 0;
        while (n < this.m_strings.size()) {
            if (vector.elementAt(n) == null || !vector.elementAt(n).equals(this.m_strings.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean setXML(ObjectNode objectNode, ComponentTypeConverter componentTypeConverter, String string, int n) {
        ContainerNode containerNode = objectNode.getContainer(NAME_STR_VAL_DISC);
        if (containerNode != null) {
            Object object;
            PropertyNode propertyNode = containerNode.getProperty("relOp");
            if (propertyNode != null) {
                object = propertyNode.getValueAsString();
                this.setRelOperator(this.convertRelOperatorToInt((String)object));
            }
            this.m_strings = new Vector();
            object = containerNode.getPropertyNodes(a_stringValue);
            if (object != null) {
                while (object.hasMoreElements()) {
                    propertyNode = (PropertyNode)object.nextElement();
                    this.m_strings.addElement(propertyNode.getValueAsString());
                }
            }
        }
        return true;
    }

    public ObjectNode getXML(boolean bl, ComponentTypeConverter componentTypeConverter, boolean bl2) {
        ObjectNode objectNode = new ObjectNode(NAME_STR_VAL_DISC);
        boolean bl3 = false;
        objectNode.addProperty("relOp", this.convertRelOperatorToString(this.getRelOperator()));
        if (this.m_strings != null && this.m_strings.size() > 0) {
            int n = 0;
            while (n < this.m_strings.size()) {
                objectNode.addProperty(a_stringValue, (String)this.m_strings.elementAt(n), false);
                ++n;
            }
        }
        return objectNode;
    }
}

