/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.List;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class NumberValueDiscriminator
extends ValueDiscriminator
implements DiscriminatorState {
    private double m_number;
    protected static final String S_NAME_NUM_VAL_DISC = "ND";
    protected static final String s_number = "n";
    public static final String NAME_NUM_VAL_DISC = "NumValDisc";
    protected static final String a_number = "num";

    public NumberValueDiscriminator() {
    }

    public NumberValueDiscriminator(double d, int n) {
        super(n);
        this.m_number = d;
    }

    public Object clone() {
        return new NumberValueDiscriminator(this.m_number, this.m_relOperator);
    }

    public void setNumber(double d) {
        this.m_number = d;
    }

    public double getNumber() {
        return this.m_number;
    }

    public boolean applies(RuleContext ruleContext) {
        Number number = (Number)ruleContext.get("NUMBER_VALUE");
        if (number == null) {
            return false;
        }
        double d = number.doubleValue();
        switch (this.m_relOperator) {
            case 0: {
                return d == this.m_number;
            }
            case 1: {
                return d < this.m_number;
            }
            case 2: {
                return d <= this.m_number;
            }
            case 3: {
                return d > this.m_number;
            }
            case 4: {
                return d >= this.m_number;
            }
            case 5: {
                return d != this.m_number;
            }
        }
        return d == this.m_number;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NumberValueDiscriminator)) {
            return false;
        }
        NumberValueDiscriminator numberValueDiscriminator = (NumberValueDiscriminator)object;
        return this.getNumber() == numberValueDiscriminator.getNumber() && this.getRelOperator() == numberValueDiscriminator.getRelOperator();
    }

    public boolean setXML(ObjectNode objectNode, ComponentTypeConverter componentTypeConverter, String string, int n) {
        PropertyNode propertyNode = objectNode.getProperty("relOp");
        if (propertyNode != null) {
            String string2 = propertyNode.getValueAsString();
            this.setRelOperator(this.convertRelOperatorToInt(string2));
        }
        if ((propertyNode = objectNode.getProperty(a_number)) != null) {
            this.setNumber(propertyNode.getValueAsDouble());
        }
        return true;
    }

    public ObjectNode getXML(boolean bl, ComponentTypeConverter componentTypeConverter, boolean bl2) {
        ObjectNode objectNode = new ObjectNode(NAME_NUM_VAL_DISC);
        objectNode.addProperty("relOp", this.convertRelOperatorToString(this.getRelOperator()));
        objectNode.addProperty(a_number, this.m_number);
        return objectNode;
    }

    public void setStateAsObjectNode(List list, ObjectNode objectNode, DiscriminatorState discriminatorState) {
        NumberValueDiscriminator numberValueDiscriminator;
        PropertyNode propertyNode = objectNode.getProperty("r");
        NumberValueDiscriminator numberValueDiscriminator2 = numberValueDiscriminator = discriminatorState instanceof NumberValueDiscriminator ? (NumberValueDiscriminator)discriminatorState : null;
        if (propertyNode != null) {
            this.setRelOperator(propertyNode.getValueAsInteger());
        } else if (numberValueDiscriminator != null) {
            this.setRelOperator(numberValueDiscriminator.getRelOperator());
        } else {
            this.setRelOperator(0);
        }
        propertyNode = objectNode.getProperty(s_number);
        if (propertyNode != null) {
            this.setNumber(propertyNode.getValueAsDouble());
        } else if (numberValueDiscriminator != null) {
            this.setNumber(numberValueDiscriminator.getNumber());
        } else {
            this.setNumber(0.0);
        }
    }

    public ObjectNode getStateAsObjectNode(List list, DiscriminatorState discriminatorState) {
        NumberValueDiscriminator numberValueDiscriminator;
        ObjectNode objectNode = new ObjectNode(S_NAME_NUM_VAL_DISC);
        boolean bl = false;
        NumberValueDiscriminator numberValueDiscriminator2 = numberValueDiscriminator = discriminatorState instanceof NumberValueDiscriminator ? (NumberValueDiscriminator)discriminatorState : new NumberValueDiscriminator();
        if (numberValueDiscriminator.getRelOperator() != this.getRelOperator()) {
            objectNode.addProperty("r", this.getRelOperator());
            bl = true;
        }
        if (numberValueDiscriminator.getNumber() != this.getNumber()) {
            objectNode.addProperty(s_number, this.getNumber());
            bl = true;
        }
        return bl ? objectNode : null;
    }
}

