/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.utilities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class TDGGraphicsKit {
    public static void drawHorizontal(Graphics graphics, int n, int n2, int n3) {
        graphics.drawLine(n, n3, n2, n3);
    }

    public static void drawVertical(Graphics graphics, int n, int n2, int n3) {
        graphics.drawLine(n3, n, n3, n2);
    }

    public static void drawPixel(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, n2, n, n2);
    }

    public static void wipeImage(Image image, Color color, ImageObserver imageObserver) {
        Graphics graphics = image.getGraphics();
        int n = image.getWidth(imageObserver);
        int n2 = image.getHeight(imageObserver);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        graphics.dispose();
    }

    public static void drawCenteredString(Graphics graphics, String string, int n, int n2, FontMetrics fontMetrics) {
        Dimension dimension = new Dimension(n, n2);
        TDGGraphicsKit.drawCenteredString(graphics, string, dimension, fontMetrics);
    }

    public static void drawCenteredString(Graphics graphics, String string, Dimension dimension, FontMetrics fontMetrics) {
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getAscent();
        int n3 = dimension.width / 2 - n / 2;
        int n4 = dimension.height / 2 + n2 / 2;
        graphics.drawString(string, n3, n4);
    }

    public static Image loadImage(URL uRL) throws Exception {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.getImage(uRL);
    }
}

