/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.DeflaterOutputStream;

public class PNGDataWriter
implements ImageConsumer {
    private ImageProducer m_producer;
    private DeflaterOutputStream m_stream;
    private int m_bytesPerPixel;
    private int m_nWidth = -1;
    private int m_nHeight = -1;
    private int m_nHintflags;
    private boolean m_bStarted;
    private boolean m_bEncoding;
    private IOException m_iox;
    private byte[] m_xPNGValues;
    private boolean m_bAccumulate;
    private int[] m_intAccumulator;
    private static final ColorModel m_rgbModel = ColorModel.getRGBdefault();
    private int m_nNextLine;
    int[] m_nRGBPixels;

    public PNGDataWriter(Image image, DeflaterOutputStream deflaterOutputStream, byte by) {
        this.m_producer = image.getSource();
        this.m_stream = deflaterOutputStream;
        this.m_bytesPerPixel = 4;
        if (by == 2) {
            this.m_bytesPerPixel = 3;
        }
    }

    public synchronized void encode() throws IOException {
        this.m_bEncoding = true;
        this.m_iox = null;
        this.m_producer.startProduction(this);
        while (this.m_bEncoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_iox != null) {
            throw this.m_iox;
        }
    }

    private void encodePixelsWrapper(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        if (!this.m_bStarted) {
            this.m_bStarted = true;
            this.m_xPNGValues = new byte[this.m_nWidth * this.m_bytesPerPixel + 1];
        }
        if (!(this.m_bAccumulate || (this.m_nHintflags & 2) != 0 && (this.m_nHintflags & 4) != 0 || n == 0 && n2 == this.m_nNextLine && n6 == this.m_nWidth)) {
            this.m_bAccumulate = true;
            this.m_intAccumulator = new int[this.m_nWidth * (this.m_nHeight - this.m_nNextLine)];
        }
        if (this.m_bAccumulate) {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(nArray, n7 * n6 + n5, this.m_intAccumulator, (n2 + n7 - this.m_nNextLine) * this.m_nWidth + n, n3);
                ++n7;
            }
        } else {
            this.writePixels(n3, n4, nArray, n5);
            ++this.m_nNextLine;
        }
    }

    private void encodeFinish() throws IOException {
        if (this.m_bAccumulate) {
            this.writePixels(this.m_nWidth, this.m_nHeight - this.m_nNextLine, this.m_intAccumulator, 0);
        }
    }

    private void writePixels(int n, int n2, int[] nArray, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 * n + n3;
            int n6 = 0;
            while (n6 < n) {
                int n7 = nArray[n5 + n6];
                int n8 = n6 * this.m_bytesPerPixel;
                this.m_xPNGValues[n8 + 1] = (byte)(n7 >> 16);
                this.m_xPNGValues[n8 + 2] = (byte)(n7 >> 8);
                this.m_xPNGValues[n8 + 3] = (byte)n7;
                if (this.m_bytesPerPixel > 3) {
                    this.m_xPNGValues[n8 + 4] = (byte)(n7 >> 24);
                }
                ++n6;
            }
            this.m_stream.write(this.m_xPNGValues);
            ++n4;
        }
    }

    private synchronized void stop() {
        this.m_bEncoding = false;
        this.notifyAll();
    }

    public void setDimensions(int n, int n2) {
        this.m_nWidth = n;
        this.m_nHeight = n2;
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setHints(int n) {
        this.m_nHintflags = n;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.m_nRGBPixels == null) {
            this.m_nRGBPixels = new int[this.m_nWidth];
        }
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                this.m_nRGBPixels[n9] = colorModel.getRGB(byArray[n8 + n9] & 0xFF);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, this.m_nRGBPixels, 0, n3);
            }
            catch (IOException iOException) {
                this.m_iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == m_rgbModel) {
            try {
                this.encodePixelsWrapper(n, n2, n3, n4, nArray, n5, n6);
            }
            catch (IOException iOException) {
                this.m_iox = iOException;
                this.stop();
                return;
            }
        }
        if (this.m_nRGBPixels == null) {
            this.m_nRGBPixels = new int[this.m_nWidth];
        }
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                this.m_nRGBPixels[n9] = colorModel.getRGB(nArray[n8 + n9]);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, this.m_nRGBPixels, 0, n3);
            }
            catch (IOException iOException) {
                this.m_iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    public void imageComplete(int n) {
        this.m_producer.removeConsumer(this);
        if (n == 4) {
            this.m_iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
            }
            catch (IOException iOException) {
                this.m_iox = iOException;
            }
        }
        this.stop();
    }
}

