/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGDataWriter;
import oracle.dss.graph.pfj.png.PNGException;
import oracle.dss.graph.pfj.png.PNGInfo;

class PNGDataChunk
extends PNGChunk {
    private byte[] compressedData;
    private static final int MIN_BUFFER_SIZE = 256;
    private static final int MAX_BUFFER_SIZE = 20480;
    private static final int COMPRESSION_FACTOR = 20;

    PNGDataChunk() {
    }

    int getDataLength() throws PNGException {
        this.compressData();
        return this.compressedData.length;
    }

    String getChunkType() {
        return "IDAT";
    }

    byte[] getData() throws PNGException {
        if (this.compressedData == null) {
            this.compressData();
        }
        return this.compressedData;
    }

    boolean isCriticalChunk() {
        return true;
    }

    private void compressData() throws PNGException {
        PNGInfo pNGInfo = this.getPNGInfo();
        if (pNGInfo.getFilterType() != 0) {
            throw new PNGException(this, 6, "compressData()", "unknown PNG filter type specified");
        }
        if (pNGInfo.getCompressionType() != 0) {
            throw new PNGException(this, 6, "compressData()", "unknown PNG compression type specified");
        }
        if (pNGInfo.getColorType() != 6 && pNGInfo.getColorType() != 2) {
            throw new PNGException(this, 6, "compressData()", "color type specified is not standard java color type: 8 bps RGB with alpha channel");
        }
        if (pNGInfo.getInterlaceType() != 0) {
            throw new PNGException(this, 6, "compressData()", "interlacing value other than NO_INTERLACING specified; this encoder does not interlace image data");
        }
        int n = pNGInfo.getImageWidth() * pNGInfo.getImageHeight();
        double d = (double)n / (double)20;
        int n2 = (int)Math.ceil(d / (double)256) * 256;
        if (n2 > 20480) {
            n2 = 20480;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        Image image = pNGInfo.getImage();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(), 1024);
        try {
            PNGDataWriter pNGDataWriter = new PNGDataWriter(image, deflaterOutputStream, pNGInfo.getColorType());
            pNGDataWriter.encode();
            deflaterOutputStream.finish();
        }
        catch (IOException iOException) {
            System.err.println("IO exception occured in PNGDataChunk.java");
        }
        this.compressedData = byteArrayOutputStream.toByteArray();
    }
}

