/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DRibbonSeriesSolid
extends Model3DFlatFace {
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int BACK = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 5;
    public static final int BEVEL = 6;
    protected Point3d m_origin;
    protected Point3d m_size;
    protected Point3d[] m_points;
    private static int[][] m_myfaces = new int[][]{{0, 1, 3, 2}, {0, 2, 8, 6, 4}, {2, 3, 9, 8}, {6, 8, 9, 7}, {1, 5, 7, 9, 3}, {0, 4, 5, 1}, {4, 6, 7, 5}};

    public Model3DRibbonSeriesSolid(JChart_3D jChart_3D, IdentObj identObj, BlackBoxIF blackBoxIF, Point3d point3d, Point3d point3d2, Point3d[] point3dArray, boolean[][] blArray, boolean bl) {
        super(jChart_3D, identObj, blackBoxIF, 7, 10, blArray, bl);
        this.m_origin = new Point3d(point3d);
        this.m_size = new Point3d(point3d2);
        this.m_points = point3dArray;
        this.m_faces = m_myfaces;
        int n = 0;
        while (n < this.m_nVertices) {
            this.m_vertices[n] = new Point3d(this.m_points[n]);
            ++n;
        }
    }

    public Model3DRibbonSeriesSolid(Model3DRibbonSeriesSolid model3DRibbonSeriesSolid) {
        this(model3DRibbonSeriesSolid.m_chart, model3DRibbonSeriesSolid.m_id, model3DRibbonSeriesSolid.m_bb, model3DRibbonSeriesSolid.m_origin, model3DRibbonSeriesSolid.m_size, model3DRibbonSeriesSolid.m_points, model3DRibbonSeriesSolid.m_bGridStatus, model3DRibbonSeriesSolid.m_bAutoshading);
        this.m_distance = model3DRibbonSeriesSolid.m_distance;
    }

    protected Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / (double)2, this.m_origin.y, this.m_origin.z + this.m_size.z / (double)2);
    }

    public int getNumPtsPerFace(int n) {
        if (n == 1 || n == 4) {
            return 5;
        }
        return 4;
    }

    protected Point3d getGridLineStart(int n, int n2, double d) {
        Point3d point3d = null;
        block0 : switch (n) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                switch (n2) {
                    case 2: {
                        point3d = this.getGridLineStartAxisYTop(d);
                        break block0;
                    }
                    case 0: {
                        point3d = this.getGridLineStartAxisYFront(d);
                        break block0;
                    }
                    case 4: {
                        point3d = this.getGridLineStartAxisYRight(d);
                    }
                }
            }
        }
        return point3d;
    }

    protected Point3d getGridLineEnd(int n, int n2, double d) {
        Point3d point3d = null;
        block0 : switch (n) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                switch (n2) {
                    case 2: {
                        point3d = this.getGridLineEndAxisYTop(d);
                        break block0;
                    }
                    case 0: {
                        point3d = this.getGridLineEndAxisYFront(d);
                        break block0;
                    }
                    case 4: {
                        point3d = this.getGridLineEndAxisYRight(d);
                    }
                }
            }
        }
        return point3d;
    }

    protected Point3d getGridLineStartAxisYTop(double d) {
        double d2 = this.m_vertices[2].x;
        double d3 = this.m_vertices[2].y;
        double d4 = this.m_vertices[2].z;
        double d5 = this.m_vertices[3].x;
        double d6 = this.m_vertices[3].y;
        double d7 = this.m_vertices[3].z;
        double d8 = this.m_vertices[9].x;
        double d9 = this.m_vertices[9].y;
        double d10 = this.m_vertices[8].x;
        double d11 = this.m_vertices[8].y;
        double d12 = this.m_vertices[8].z;
        Point3d point3d = null;
        if (d > d3 && d < d11) {
            double d13 = MathExt.getIntercept(d4, d3, d12, d11, d);
            point3d = new Point3d(d2, d, d13);
        } else if (d > d3) {
            point3d = new Point3d(d2, d, d4);
        }
        return point3d;
    }

    protected Point3d getGridLineEndAxisYTop(double d) {
        Point3d point3d = null;
        double d2 = this.m_vertices[2].x;
        double d3 = this.m_vertices[2].y;
        double d4 = this.m_vertices[2].z;
        double d5 = this.m_vertices[3].x;
        double d6 = this.m_vertices[3].y;
        double d7 = this.m_vertices[3].z;
        double d8 = this.m_vertices[9].x;
        double d9 = this.m_vertices[9].y;
        double d10 = this.m_vertices[9].z;
        double d11 = this.m_vertices[8].x;
        double d12 = this.m_vertices[8].y;
        double d13 = this.m_vertices[8].z;
        Object var28_15 = null;
        if (d > d6 && d < d9) {
            double d14 = MathExt.getIntercept(d7, d6, d10, d9, d);
            point3d = new Point3d(d5, d, d14);
        } else {
            point3d = new Point3d(d5, d, d7);
        }
        return point3d;
    }

    protected Point3d getGridLineStartAxisYFront(double d) {
        double d2 = this.m_vertices[0].x;
        double d3 = this.m_vertices[0].y;
        double d4 = this.m_vertices[0].z;
        double d5 = this.m_vertices[2].x;
        double d6 = this.m_vertices[2].y;
        Point3d point3d = null;
        if (d > d3 && d < d6) {
            point3d = new Point3d(d2, d, d4);
        }
        return point3d;
    }

    protected Point3d getGridLineEndAxisYFront(double d) {
        double d2 = this.m_vertices[1].x;
        double d3 = this.m_vertices[0].z;
        return new Point3d(d2, d, d3);
    }

    protected Point3d getGridLineStartAxisYRight(double d) {
        Point3d point3d = null;
        double d2 = this.m_vertices[1].x;
        double d3 = this.m_vertices[1].y;
        double d4 = this.m_vertices[1].z;
        double d5 = this.m_vertices[3].y;
        double d6 = this.m_vertices[3].z;
        double d7 = this.m_vertices[7].y;
        double d8 = this.m_vertices[7].z;
        double d9 = this.m_vertices[9].y;
        double d10 = this.m_vertices[9].z;
        double d11 = this.m_vertices[5].x;
        double d12 = this.m_vertices[5].y;
        double d13 = this.m_vertices[5].z;
        if (d > d12 && d < d3) {
            double d14 = MathExt.getIntercept(d4, d3, d13, d12, d);
            point3d = new Point3d(d2, d, d14);
        } else if (d > d5 && d < d9) {
            double d15 = MathExt.getIntercept(d6, d5, d10, d9, d);
            point3d = new Point3d(d2, d, d15);
        } else {
            point3d = new Point3d(d2, d, d4);
        }
        return point3d;
    }

    protected Point3d getGridLineEndAxisYRight(double d) {
        Point3d point3d = null;
        double d2 = this.m_vertices[7].x;
        double d3 = this.m_vertices[7].y;
        double d4 = this.m_vertices[7].z;
        double d5 = this.m_vertices[9].x;
        double d6 = this.m_vertices[9].y;
        double d7 = this.m_vertices[9].z;
        double d8 = this.m_vertices[3].y;
        double d9 = this.m_vertices[3].z;
        double d10 = this.m_vertices[1].y;
        double d11 = this.m_vertices[1].z;
        double d12 = this.m_vertices[5].x;
        double d13 = this.m_vertices[5].y;
        double d14 = this.m_vertices[5].z;
        if (d < d8 && d > d6) {
            double d15 = MathExt.getIntercept(d9, d8, d7, d6, d);
            point3d = new Point3d(d2, d, d15);
        } else if (d > d13 && d < d3) {
            double d16 = MathExt.getIntercept(d14, d13, d4, d3, d);
            point3d = new Point3d(d2, d, d16);
        } else if (d > d10 && d < d3) {
            double d17 = MathExt.getIntercept(d11, d10, d4, d3, d);
            point3d = new Point3d(d2, d, d17);
        } else {
            point3d = new Point3d(d2, d, d4);
        }
        return point3d;
    }
}

