/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Matrix4d;
import oracle.dss.graph.pfj.model3d.Point3d;

public abstract class Model3DFlatFace
implements Serializable {
    public static final int XX = 0;
    public static final int YY = 1;
    public static final int ZZ = 2;
    public static final int MIN_POINTS = 3;
    public static final double BY_ANGLE_SCALE = 1.0;
    static final int OBJ_FACTOR = 1000;
    static final int FACE_FACTOR = 1000000;
    static final int AXIS_FACTOR = 100000000;
    protected JChart_3D m_chart;
    protected Point3d m_viewer;
    protected IdentObj m_id;
    protected BlackBoxIF m_bb;
    protected int m_nVertices;
    protected Point3d[] m_vertices;
    protected Point3d[] m_xVertices;
    protected Point[] m_projVertices;
    protected boolean m_bIsTransformed;
    protected boolean m_bIsProjected;
    protected int m_nFaces;
    protected int[][] m_faces;
    protected double m_distance;
    protected Detectiv m_Detectiv;
    protected Vector[][][] m_GridLines;
    protected Point3d m_boundMin;
    protected Point3d m_boundMax;
    protected boolean[][] m_bGridStatus;
    protected boolean m_bWantGrids;
    protected boolean m_bAutoshading;
    protected boolean m_bCanUseSimpleVisibility;
    protected Point3d[] m_ptsForNormal;
    protected int m_nPointsFound;
    protected double m_floorLevel;
    protected double m_fLightSourceX;
    protected double m_fLightSourceY;
    protected double m_fLightSourceZ;

    protected Model3DFlatFace(JChart_3D jChart_3D, IdentObj identObj, BlackBoxIF blackBoxIF, int n, int n2, boolean[][] blArray, boolean bl) {
        this.m_chart = jChart_3D;
        this.m_viewer = null;
        this.m_id = identObj;
        this.m_bb = blackBoxIF;
        this.m_nVertices = n2;
        this.m_nFaces = n;
        this.m_Detectiv = this.m_chart.getDetectiv();
        this.m_bIsTransformed = false;
        this.m_bIsProjected = false;
        this.m_vertices = new Point3d[this.m_nVertices];
        this.m_xVertices = new Point3d[this.m_nVertices];
        this.m_projVertices = new Point[this.m_nVertices];
        this.m_bGridStatus = blArray;
        this.m_bWantGrids = blArray == null ? false : blArray[1][0] || blArray[1][1] || blArray[1][2];
        this.m_bAutoshading = bl;
        this.m_bCanUseSimpleVisibility = false;
        this.m_GridLines = null;
        this.m_floorLevel = this.m_chart.getCubeWallThickY();
        this.m_fLightSourceX = this.m_chart.m_fColorLightSourceX;
        this.m_fLightSourceY = this.m_chart.m_fColorLightSourceY;
        this.m_fLightSourceZ = this.m_chart.m_fColorLightSourceZ;
    }

    public static double applyDiffuseLighting(double[] dArray, double[] dArray2) {
        double d;
        double d2 = Model3DFlatFace.dotProduct(dArray, dArray2);
        if (d2 < 0.0) {
            d2 = 5.0E-4;
        }
        if ((d = d2 * 1.5) < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        d *= d;
        return d;
    }

    private void calcBounds() {
        this.m_boundMin = new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, this.m_vertices[0].z);
        this.m_boundMax = new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, this.m_vertices[0].z);
        int n = 1;
        while (n < this.m_nVertices) {
            if (this.m_vertices[n].x < this.m_boundMin.x) {
                this.m_boundMin.x = this.m_vertices[n].x;
            }
            if (this.m_vertices[n].x > this.m_boundMax.x) {
                this.m_boundMax.x = this.m_vertices[n].x;
            }
            if (this.m_vertices[n].y < this.m_boundMin.y) {
                this.m_boundMin.y = this.m_vertices[n].y;
            }
            if (this.m_vertices[n].y > this.m_boundMax.y) {
                this.m_boundMax.y = this.m_vertices[n].y;
            }
            if (this.m_vertices[n].z < this.m_boundMin.z) {
                this.m_boundMin.z = this.m_vertices[n].z;
            }
            if (this.m_vertices[n].z > this.m_boundMax.z) {
                this.m_boundMax.z = this.m_vertices[n].z;
            }
            ++n;
        }
    }

    public void calcDistance(Matrix4d matrix4d, Point3d point3d) {
        Point3d point3d2 = this.getCenter();
        point3d2.y = this.m_floorLevel;
        this.transformPoint3d(point3d2, matrix4d);
        double d = (point3d.x - point3d2.x) * (point3d.x - point3d2.x) + (point3d.y - point3d2.y) * (point3d.y - point3d2.y) + (point3d.z - point3d2.z) * (point3d.z - point3d2.z);
        this.m_distance = Math.sqrt(d);
    }

    private void calcGridLines() {
        Point3d point3d = null;
        Point3d point3d2 = null;
        this.m_GridLines = new Vector[2][3][this.m_nFaces];
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 <= 2) {
                if (this.m_bGridStatus[n][n2]) {
                    double d;
                    double d2;
                    if (n2 == 0) {
                        d2 = this.m_boundMin.x;
                        d = this.m_boundMax.x;
                    } else if (n2 == 1) {
                        d2 = this.m_boundMin.y;
                        d = this.m_boundMax.y;
                    } else {
                        d2 = this.m_boundMin.z;
                        d = this.m_boundMax.z;
                    }
                    Vector vector = n == 0 ? this.m_chart.getMinorGridPositions(n2) : this.m_chart.getMajorGridPositions(n2);
                    int n3 = 0;
                    while (n3 < this.m_nFaces) {
                        this.m_GridLines[n][n2][n3] = null;
                        int n4 = vector.size();
                        int n5 = 0;
                        while (n5 < n4) {
                            double d3 = (Double)vector.elementAt(n5);
                            point3d = this.getGridLineStart(n2, n3, d3);
                            point3d2 = this.getGridLineEnd(n2, n3, d3);
                            if (point3d != null && point3d2 != null && d3 > d2 && d3 < d) {
                                if (this.m_GridLines[n][n2][n3] == null) {
                                    this.m_GridLines[n][n2][n3] = new Vector();
                                }
                                this.m_GridLines[n][n2][n3].addElement(point3d);
                                this.m_GridLines[n][n2][n3].addElement(point3d2);
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void calcGrids() {
        if (this.m_bWantGrids) {
            this.calcBounds();
            this.calcGridLines();
        }
    }

    public void display() {
        if (this.m_bCanUseSimpleVisibility && !this.m_bWantGrids) {
            BlackBoxIF blackBoxIF = this.m_bb != null ? this.m_bb : this.m_chart.getModelBlackBox(this.m_id);
            this.transformVertices();
            this.projectVertices();
            IdentObj identObj = new IdentObj(this.m_id);
            identObj.incrMiscID(0);
            Polygon polygon = this.projectVertices(0);
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, null, 1.0, true);
            identObj = new IdentObj(this.m_id);
            identObj.incrMiscID(2);
            polygon = this.projectVertices(2);
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, null, 1.0, true);
            identObj = new IdentObj(this.m_id);
            identObj.incrMiscID(4);
            polygon = this.projectVertices(4);
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, null, 1.0, true);
        } else {
            double[] dArray = null;
            double[] dArray2 = null;
            double[] dArray3 = null;
            double[] dArray4 = null;
            double[] dArray5 = null;
            double d = 1.0;
            BlackBoxIF blackBoxIF = this.m_bb == null ? this.m_chart.getModelBlackBox(this.m_id) : this.m_bb;
            this.transformVertices();
            if (this.m_bWantGrids) {
                this.transformGrids();
            }
            this.projectVertices();
            if (this.m_bAutoshading) {
                dArray = new double[3];
                dArray2 = new double[3];
                dArray3 = new double[3];
                dArray4 = new double[3];
                dArray5 = new double[3];
                dArray[0] = this.m_fLightSourceX;
                dArray[1] = this.m_fLightSourceY;
                dArray[2] = this.m_fLightSourceZ;
            }
            int n = 0;
            while (n < this.getNumFaces()) {
                if (this.m_bCanUseSimpleVisibility) {
                    if (this.isVisibleIpsoFacto(n) || blackBoxIF.getTransparentFillColor() || blackBoxIF.getFillColor().getAlpha() < 255) {
                        this.displayFace(n, blackBoxIF, d);
                    }
                } else {
                    double d2 = this.visibility(n);
                    if (!(d2 <= 0.0) || blackBoxIF.getTransparentFillColor() || blackBoxIF.getFillColor().getAlpha() != 255) {
                        if (this.m_bAutoshading && this.getPointsForNormal(n, dArray3, dArray4, dArray5)) {
                            Model3DFlatFace.OGL_CalcNormal(dArray3, dArray4, dArray5, dArray2);
                            d = Model3DFlatFace.applyDiffuseLighting(dArray2, dArray);
                        }
                        this.displayFace(n, blackBoxIF, d);
                    }
                }
                ++n;
            }
        }
    }

    public void displayFace(int n, BlackBoxIF blackBoxIF, double d) {
        Polygon polygon = this.projectVertices(n);
        IdentObj identObj = new IdentObj(this.m_id);
        identObj.incrMiscID(n);
        new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, null, d, true);
        if (this.m_bWantGrids) {
            this.displayGridFace(true, 0, n);
            this.displayGridFace(true, 1, n);
            this.displayGridFace(true, 2, n);
            this.displayGridFace(false, 0, n);
            this.displayGridFace(false, 1, n);
            this.displayGridFace(false, 2, n);
        }
    }

    private void displayGridFace(boolean bl, int n, int n2) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        int n3 = 0;
        Vector vector = this.projectGrids(bl, n, n2);
        if (vector == null) {
            return;
        }
        IdentObj identObj = bl ? this.m_chart.getMajorGridId(n) : this.m_chart.getMinorGridId(n);
        BlackBoxIF blackBoxIF = bl ? this.m_chart.getMajorGridsBlackBox(n) : this.m_chart.getMinorGridsBlackBox(n);
        int n4 = 0;
        try {
            object = this.m_Detectiv.getPerspective();
            serializable2 = this.m_chart.getAxisObj(n);
            serializable = new IdentObj(serializable2.getMajorGridId().getObjectID());
            if (bl) {
                n4 = ((Perspective)object).getLineWidth((IdentObj)serializable);
            }
        }
        catch (AssertionException assertionException) {
            // empty catch block
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            serializable2 = (Point)object.nextElement();
            serializable = (Point)object.nextElement();
            IdentObj identObj2 = new IdentObj(identObj.getObjectID(), this.m_id.getSeriesID(), this.m_id.getGroupID());
            identObj2.incrMiscID(n * 100000000 + n2 * 1000000 + this.m_id.getObjectID() * 1000 + n3);
            new DetLine(this.m_Detectiv, identObj2, ((Point)serializable2).x, ((Point)serializable2).y, ((Point)serializable).x, ((Point)serializable).y, blackBoxIF, null, n4);
            ++n3;
            ++n3;
        }
    }

    public static double dotProduct(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    public double getDistance() {
        return this.m_distance;
    }

    public int[] getFace(int n) {
        return this.m_faces[n];
    }

    public Point3d getFaceNormal(int n) {
        int n2 = this.getFace(n)[0];
        this.m_ptsForNormal = new Point3d[3];
        this.transformVertices();
        this.m_ptsForNormal[0] = new Point3d(this.m_xVertices[n2]);
        int n3 = 1;
        int n4 = 1;
        while (n4 < this.getNumPtsPerFace(n) && n3 < 3) {
            int n5 = this.getFace(n)[n4];
            if (n3 == 1) {
                if (!this.m_xVertices[n5].equals(this.m_ptsForNormal[0])) {
                    this.m_ptsForNormal[n3++] = new Point3d(this.m_xVertices[n5]);
                }
            } else if (n3 == 2 && !this.m_xVertices[n5].equals(this.m_ptsForNormal[0]) && !this.m_xVertices[n5].equals(this.m_ptsForNormal[1])) {
                this.m_ptsForNormal[n3++] = new Point3d(this.m_xVertices[n5]);
            }
            ++n4;
        }
        this.m_nPointsFound = n3;
        if (n3 < 3) {
            return null;
        }
        Point3d point3d = this.m_ptsForNormal[1].minus(this.m_ptsForNormal[0]);
        Point3d point3d2 = this.m_ptsForNormal[2].minus(this.m_ptsForNormal[0]);
        double d = point3d.y * point3d2.z - point3d.z * point3d2.y;
        double d2 = point3d.z * point3d2.x - point3d.x * point3d2.z;
        double d3 = point3d.x * point3d2.y - point3d.y * point3d2.x;
        return new Point3d(d, d2, d3);
    }

    public IdentObj getID() {
        return this.m_id;
    }

    public IdentObj getIDColor() {
        IdentObj identObj = this.m_id.getSeriesID() != -3 ? new IdentObj(-3, this.m_id.getSeriesID()) : this.m_id;
        return identObj;
    }

    public int getNumFaces() {
        return this.m_nFaces;
    }

    public boolean getPointsForNormal(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.m_nPointsFound > 0) {
            dArray[0] = this.m_ptsForNormal[0].x;
            dArray[1] = this.m_ptsForNormal[0].y;
            dArray[2] = this.m_ptsForNormal[0].z;
            if (this.m_nPointsFound > 1) {
                dArray2[0] = this.m_ptsForNormal[1].x;
                dArray2[1] = this.m_ptsForNormal[1].y;
                dArray2[2] = this.m_ptsForNormal[1].z;
                if (this.m_nPointsFound > 2) {
                    dArray3[0] = this.m_ptsForNormal[2].x;
                    dArray3[1] = this.m_ptsForNormal[2].y;
                    dArray3[2] = this.m_ptsForNormal[2].z;
                }
            }
        }
        return this.m_nPointsFound >= 3;
    }

    public Point3d getVertex(int n) {
        return this.m_vertices[n];
    }

    public boolean isVisibleIpsoFacto(int n) {
        throw new AssertionException("Simple visiblity is available only for rectangular solids");
    }

    public static void OGL_CalcNormal(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d;
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        dArray5[0] = dArray2[0] - dArray[0];
        dArray5[1] = dArray2[1] - dArray[1];
        dArray5[2] = dArray2[2] - dArray[2];
        dArray6[0] = dArray3[0] - dArray[0];
        dArray6[1] = dArray3[1] - dArray[1];
        dArray6[2] = dArray3[2] - dArray[2];
        dArray4[0] = dArray5[1] * dArray6[2] - dArray5[2] * dArray6[1];
        dArray4[1] = dArray5[2] * dArray6[0] - dArray5[0] * dArray6[2];
        dArray4[2] = dArray5[0] * dArray6[1] - dArray5[1] * dArray6[0];
        try {
            d = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        if (d != 0.0) {
            dArray4[0] = dArray4[0] / d;
            dArray4[1] = dArray4[1] / d;
            dArray4[2] = dArray4[2] / d;
        }
    }

    public Vector projectGrids(boolean bl, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        Vector<Point> vector = new Vector<Point>();
        if (this.m_GridLines[bl ? 1 : 0][n][n2] == null) {
            return null;
        }
        Enumeration enumeration = this.m_GridLines[bl ? 1 : 0][n][n2].elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(this.m_chart.projectPoint3d((Point3d)enumeration.nextElement()));
        }
        return vector;
    }

    public void projectVertices() {
        if (this.m_bIsProjected) {
            return;
        }
        int n = 0;
        while (n < this.m_nVertices) {
            this.m_projVertices[n] = this.m_chart.projectPoint3d(this.m_xVertices[n]);
            ++n;
        }
        this.m_bIsProjected = true;
    }

    public void projectVerticesInDouble(double[] dArray, double[] dArray2) {
        int n = 0;
        while (n < this.m_nVertices) {
            Point2D point2D = this.m_chart.projectPoint3dInDouble(this.m_xVertices[n]);
            dArray[n] = point2D.getX();
            dArray2[n] = point2D.getY();
            ++n;
        }
    }

    public Polygon projectVertices(int n) {
        Polygon polygon = new Polygon();
        int n2 = 0;
        int n3 = 0;
        PfjAssert.pfjAssert(this.m_bIsProjected);
        int n4 = 0;
        while (n4 < this.m_faces[n].length) {
            int n5 = this.m_faces[n][n4];
            Point point = this.m_projVertices[n5];
            polygon.addPoint(point.x, point.y);
            if (n4 == 0) {
                n2 = point.x;
                n3 = point.y;
            }
            ++n4;
        }
        polygon.addPoint(n2, n3);
        return polygon;
    }

    public void transformGrids() {
        if (this.m_GridLines == null) {
            throw new RuntimeException("Grid line not initialized in 3D Model");
        }
        int n = 1;
        int n2 = 0;
        while (n2 < 3) {
            int n3 = 0;
            while (n3 < this.m_nFaces) {
                if (this.m_GridLines[n][n2][n3] != null) {
                    Enumeration enumeration = this.m_GridLines[n][n2][n3].elements();
                    while (enumeration.hasMoreElements()) {
                        this.m_chart.transformPoint3d((Point3d)enumeration.nextElement());
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void transformPoint3d(Point3d point3d, Matrix4d matrix4d) {
        double d = point3d.x;
        double d2 = point3d.y;
        double d3 = point3d.z;
        point3d.x = d * matrix4d.m00 + d2 * matrix4d.m10 + d3 * matrix4d.m20 + matrix4d.m30;
        point3d.y = d * matrix4d.m01 + d2 * matrix4d.m11 + d3 * matrix4d.m21 + matrix4d.m31;
        point3d.z = d * matrix4d.m02 + d2 * matrix4d.m12 + d3 * matrix4d.m22 + matrix4d.m32;
    }

    public void transformVertices() {
        if (this.m_bIsTransformed) {
            return;
        }
        int n = 0;
        while (n < this.m_nVertices) {
            Point3d point3d = new Point3d(this.m_vertices[n]);
            this.m_chart.transformPoint3d(point3d);
            this.m_xVertices[n] = point3d;
            ++n;
        }
        this.m_bIsTransformed = true;
    }

    public double visibility(int n) {
        Point3d point3d = this.getFaceNormal(n);
        int n2 = this.getFace(n)[0];
        if (point3d == null) {
            return -1.0;
        }
        this.m_viewer = this.m_chart.getViewer();
        Point3d point3d2 = this.m_viewer.minus(this.m_xVertices[n2]);
        double d = point3d.x * point3d2.x + point3d.y * point3d2.y + point3d.z * point3d2.z;
        double d2 = Math.sqrt(point3d.x * point3d.x + point3d.y * point3d.y + point3d.z * point3d.z);
        double d3 = d2 == 0.0 ? -1.0 : d * 1.0 / d2;
        return d3;
    }

    protected abstract Point3d getCenter();

    protected abstract Point3d getGridLineEnd(int var1, int var2, double var3);

    protected abstract Point3d getGridLineStart(int var1, int var2, double var3);

    public abstract int getNumPtsPerFace(int var1);
}

