/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import java.io.Serializable;

public final class Matrix3d
implements Serializable {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix3d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public Matrix3d(Matrix3d matrix3d) {
        this(matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22);
    }

    public void identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void mult(Matrix3d matrix3d) {
        double d = this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20;
        double d2 = this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21;
        double d3 = this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22;
        double d4 = this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20;
        double d5 = this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21;
        double d6 = this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22;
        double d7 = this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20;
        double d8 = this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21;
        double d9 = this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public Matrix3d multBy(Matrix3d matrix3d) {
        Matrix3d matrix3d2 = new Matrix3d(this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20, this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21, this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22, this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20, this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21, this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22, this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20, this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21, this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22);
        return matrix3d2;
    }

    public void rotX(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.m01 * d2 + this.m02 * -d3;
        double d5 = this.m01 * d3 + this.m02 * d2;
        double d6 = this.m11 * d2 + this.m12 * -d3;
        double d7 = this.m11 * d3 + this.m12 * d2;
        double d8 = this.m21 * d2 + this.m22 * -d3;
        double d9 = this.m21 * d3 + this.m22 * d2;
        this.m01 = d4;
        this.m02 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public void rotY(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.m00 * d2 + this.m02 * d3;
        double d5 = this.m00 * -d3 + this.m02 * d2;
        double d6 = this.m10 * d2 + this.m12 * d3;
        double d7 = this.m10 * -d3 + this.m12 * d2;
        double d8 = this.m20 * d2 + this.m22 * d3;
        double d9 = this.m20 * -d3 + this.m22 * d2;
        this.m00 = d4;
        this.m02 = d5;
        this.m10 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m22 = d9;
    }

    public void rotZ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.m00 * d2 + this.m01 * -d3;
        double d5 = this.m00 * d3 + this.m01 * d2;
        double d6 = this.m10 * d2 + this.m11 * -d3;
        double d7 = this.m10 * d3 + this.m11 * d2;
        double d8 = this.m20 * d2 + this.m21 * -d3;
        double d9 = this.m20 * d3 + this.m21 * d2;
        this.m00 = d4;
        this.m01 = d5;
        this.m10 = d6;
        this.m11 = d7;
        this.m20 = d8;
        this.m21 = d9;
    }

    public void scale(double d, double d2, double d3) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d2;
        this.m11 *= d2;
        this.m12 *= d2;
        this.m20 *= d3;
        this.m21 *= d3;
        this.m22 *= d3;
    }

    public void scale(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
    }

    public Matrix3d transpose() {
        Matrix3d matrix3d = new Matrix3d(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return matrix3d;
    }
}

