/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.FP;

public final class SVD {
    public static final double TOL = 1.0E-5;

    private static void backsub(double[][] dArray, double[] dArray2, double[][] dArray3, int n, int n2, double[] dArray4, double[] dArray5) {
        int n3;
        double d;
        PfjAssert.pfjAssert(dArray.length == n + 1);
        PfjAssert.pfjAssert(dArray[0].length == n2 + 1);
        PfjAssert.pfjAssert(dArray2.length == n2 + 1);
        PfjAssert.pfjAssert(dArray3.length == n2 + 1);
        PfjAssert.pfjAssert(dArray3[0].length == n2 + 1);
        PfjAssert.pfjAssert(dArray4.length == n + 1);
        PfjAssert.pfjAssert(dArray5.length == n2 + 1);
        double[] dArray6 = new double[n2 + 1];
        int n4 = 1;
        while (n4 <= n2) {
            d = 0.0;
            if (dArray2[n4] != 0.0) {
                n3 = 1;
                while (n3 <= n) {
                    d += dArray[n3][n4] * dArray4[n3];
                    ++n3;
                }
                d /= dArray2[n4];
            }
            dArray6[n4] = d;
            ++n4;
        }
        n4 = 1;
        while (n4 <= n2) {
            d = 0.0;
            n3 = 1;
            while (n3 <= n2) {
                d += dArray3[n4][n3] * dArray6[n3];
                ++n3;
            }
            dArray5[n4] = d;
            ++n4;
        }
    }

    private static void decomp(double[][] dArray, int n, int n2, double[] dArray2, double[][] dArray3) throws AssertionException {
        int n3;
        double d;
        double d2;
        int n4;
        double d3;
        int n5 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        PfjAssert.pfjAssert(dArray.length == n + 1);
        PfjAssert.pfjAssert(dArray[0].length == n2 + 1);
        PfjAssert.pfjAssert(dArray2.length == n2 + 1);
        PfjAssert.pfjAssert(dArray3.length == n2 + 1);
        PfjAssert.pfjAssert(dArray3[0].length == n2 + 1);
        if (n2 < 1) {
            return;
        }
        int n6 = 0;
        double[] dArray4 = new double[n2 + 1];
        int n7 = 1;
        while (n7 <= n2) {
            n6 = n7 + 1;
            dArray4[n7] = d6 * d5;
            d6 = 0.0;
            d3 = 0.0;
            d5 = 0.0;
            if (n7 <= n) {
                n4 = n7;
                while (n4 <= n) {
                    d6 += Math.abs(dArray[n4][n7]);
                    ++n4;
                }
                if (d6 != 0.0) {
                    n4 = n7;
                    while (n4 <= n) {
                        double[] dArray5 = dArray[n4];
                        int n8 = n7;
                        dArray5[n8] = dArray5[n8] / d6;
                        d3 += dArray[n4][n7] * dArray[n4][n7];
                        ++n4;
                    }
                    d2 = dArray[n7][n7];
                    d5 = Math.sqrt(d3);
                    if (d2 >= 0.0) {
                        d5 *= (double)-1;
                    }
                    d = d2 * d5 - d3;
                    dArray[n7][n7] = d2 - d5;
                    if (n7 != n2) {
                        n3 = n6;
                        while (n3 <= n2) {
                            d3 = 0.0;
                            n4 = n7;
                            while (n4 <= n) {
                                d3 += dArray[n4][n7] * dArray[n4][n3];
                                ++n4;
                            }
                            d2 = d3 / d;
                            n4 = n7;
                            while (n4 <= n) {
                                double[] dArray6 = dArray[n4];
                                int n9 = n3;
                                dArray6[n9] = dArray6[n9] + d2 * dArray[n4][n7];
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                    n4 = n7;
                    while (n4 <= n) {
                        double[] dArray7 = dArray[n4];
                        int n10 = n7;
                        dArray7[n10] = dArray7[n10] * d6;
                        ++n4;
                    }
                }
            }
            dArray2[n7] = d6 * d5;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n7 <= n && n7 != n2) {
                n4 = n6;
                while (n4 <= n2) {
                    d6 += Math.abs(dArray[n7][n4]);
                    ++n4;
                }
                if (d6 != 0.0) {
                    n4 = n6;
                    while (n4 <= n2) {
                        double[] dArray8 = dArray[n7];
                        int n11 = n4;
                        dArray8[n11] = dArray8[n11] / d6;
                        d3 += dArray[n7][n4] * dArray[n7][n4];
                        ++n4;
                    }
                    d2 = dArray[n7][n6];
                    d5 = Math.sqrt(d3);
                    if (d2 >= 0.0) {
                        d5 *= (double)-1;
                    }
                    d = d2 * d5 - d3;
                    dArray[n7][n6] = d2 - d5;
                    n4 = n6;
                    while (n4 <= n2) {
                        dArray4[n4] = dArray[n7][n4] / d;
                        ++n4;
                    }
                    if (n7 != n) {
                        n3 = n6;
                        while (n3 <= n) {
                            d3 = 0.0;
                            n4 = n6;
                            while (n4 <= n2) {
                                d3 += dArray[n3][n4] * dArray[n7][n4];
                                ++n4;
                            }
                            n4 = n6;
                            while (n4 <= n2) {
                                double[] dArray9 = dArray[n3];
                                int n12 = n4;
                                dArray9[n12] = dArray9[n12] + d3 * dArray4[n4];
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                    n4 = n6;
                    while (n4 <= n2) {
                        double[] dArray10 = dArray[n7];
                        int n13 = n4++;
                        dArray10[n13] = dArray10[n13] * d6;
                    }
                }
            }
            d4 = Math.max(d4, Math.abs(dArray2[n7]) + Math.abs(dArray4[n7]));
            ++n7;
        }
        n7 = n2;
        while (n7 >= 1) {
            if (n7 < n2) {
                if (d5 != 0.0) {
                    n3 = n6;
                    while (n3 <= n2) {
                        dArray3[n3][n7] = dArray[n7][n3] / dArray[n7][n6] / d5;
                        ++n3;
                    }
                    n3 = n6;
                    while (n3 <= n2) {
                        d3 = 0.0;
                        n4 = n6;
                        while (n4 <= n2) {
                            d3 += dArray[n7][n4] * dArray3[n4][n3];
                            ++n4;
                        }
                        n4 = n6;
                        while (n4 <= n2) {
                            double[] dArray11 = dArray3[n4];
                            int n14 = n3;
                            dArray11[n14] = dArray11[n14] + d3 * dArray3[n4][n7];
                            ++n4;
                        }
                        ++n3;
                    }
                }
                n3 = n6;
                while (n3 <= n2) {
                    dArray3[n3][n7] = 0.0;
                    dArray3[n7][n3] = 0.0;
                    ++n3;
                }
            }
            dArray3[n7][n7] = 1.0;
            d5 = dArray4[n7];
            n6 = n7--;
        }
        n7 = n2;
        while (n7 >= 1) {
            n6 = n7 + 1;
            d5 = dArray2[n7];
            if (n7 < n2) {
                n3 = n6;
                while (n3 <= n2) {
                    dArray[n7][n3] = 0.0;
                    ++n3;
                }
            }
            if (d5 != 0.0) {
                d5 = 1.0 / d5;
                if (n7 != n2) {
                    n3 = n6;
                    while (n3 <= n2) {
                        d3 = 0.0;
                        n4 = n6;
                        while (n4 <= n) {
                            d3 += dArray[n4][n7] * dArray[n4][n3];
                            ++n4;
                        }
                        d2 = d3 / dArray[n7][n7] * d5;
                        n4 = n7;
                        while (n4 <= n) {
                            double[] dArray12 = dArray[n4];
                            int n15 = n3;
                            dArray12[n15] = dArray12[n15] + d2 * dArray[n4][n7];
                            ++n4;
                        }
                        ++n3;
                    }
                }
                n3 = n7;
                while (n3 <= n) {
                    double[] dArray13 = dArray[n3];
                    int n16 = n7;
                    dArray13[n16] = dArray13[n16] * d5;
                    ++n3;
                }
            } else {
                n3 = n7;
                while (n3 <= n) {
                    dArray[n3][n7] = 0.0;
                    ++n3;
                }
            }
            double[] dArray14 = dArray[n7];
            int n17 = n7--;
            dArray14[n17] = dArray14[n17] + 1.0;
        }
        n4 = n2;
        while (n4 >= 1) {
            int n18 = 1;
            while (n18 <= 30) {
                double d7;
                double d8;
                double d9;
                boolean bl = true;
                n6 = n4;
                while (n6 >= 1) {
                    n5 = n6 - 1;
                    if (Math.abs(dArray4[n6]) + d4 == d4) {
                        bl = false;
                        break;
                    }
                    if (Math.abs(dArray2[n5]) + d4 == d4) break;
                    --n6;
                }
                if (bl) {
                    d9 = 0.0;
                    d3 = 1.0;
                    n7 = n6;
                    while (n7 <= n4) {
                        d2 = d3 * dArray4[n7];
                        dArray4[n7] = d9 * dArray4[n7];
                        if (Math.abs(d2) + d4 == d4) break;
                        d5 = dArray2[n7];
                        dArray2[n7] = d = FP.pythag(d2, d5);
                        d = 1.0 / d;
                        d9 = d5 * d;
                        d3 = -d2 * d;
                        n3 = 1;
                        while (n3 <= n) {
                            d8 = dArray[n3][n5];
                            d7 = dArray[n3][n7];
                            dArray[n3][n5] = d8 * d9 + d7 * d3;
                            dArray[n3][n7] = d7 * d9 - d8 * d3;
                            ++n3;
                        }
                        ++n7;
                    }
                }
                d7 = dArray2[n4];
                if (n6 == n4) {
                    if (!(d7 < 0.0)) break;
                    dArray2[n4] = -d7;
                    n3 = 1;
                    while (n3 <= n2) {
                        dArray3[n3][n4] = -dArray3[n3][n4];
                        ++n3;
                    }
                    break;
                }
                if (n18 == 30) {
                    throw new AssertionException("SVD did not converge");
                }
                double d10 = dArray2[n6];
                n5 = n4 - 1;
                d8 = dArray2[n5];
                d5 = dArray4[n5];
                d = dArray4[n4];
                d2 = ((d8 - d7) * (d8 + d7) + (d5 - d) * (d5 + d)) / (2.0 * d * d8);
                d5 = FP.pythag(d2, 1.0);
                double d11 = d2 >= 0.0 ? d5 : -d5;
                d2 = ((d10 - d7) * (d10 + d7) + d * (d8 / (d2 + d11) - d)) / d10;
                d3 = 1.0;
                d9 = 1.0;
                n3 = n6;
                while (n3 <= n5) {
                    n7 = n3 + 1;
                    d5 = dArray4[n7];
                    d8 = dArray2[n7];
                    d = d3 * d5;
                    d5 = d9 * d5;
                    dArray4[n3] = d7 = FP.pythag(d2, d);
                    d9 = d2 / d7;
                    d3 = d / d7;
                    d2 = d10 * d9 + d5 * d3;
                    d5 = d5 * d9 - d10 * d3;
                    d = d8 * d3;
                    d8 *= d9;
                    int n19 = 1;
                    while (n19 <= n2) {
                        d10 = dArray3[n19][n3];
                        d7 = dArray3[n19][n7];
                        dArray3[n19][n3] = d10 * d9 + d7 * d3;
                        dArray3[n19][n7] = d7 * d9 - d10 * d3;
                        ++n19;
                    }
                    dArray2[n3] = d7 = FP.pythag(d2, d);
                    if (d7 != 0.0) {
                        d7 = 1.0 / d7;
                        d9 = d2 * d7;
                        d3 = d * d7;
                    }
                    d2 = d9 * d5 + d3 * d8;
                    d10 = d9 * d8 - d3 * d5;
                    n19 = 1;
                    while (n19 <= n) {
                        d8 = dArray[n19][n3];
                        d7 = dArray[n19][n7];
                        dArray[n19][n3] = d8 * d9 + d7 * d3;
                        dArray[n19][n7] = d7 * d9 - d8 * d3;
                        ++n19;
                    }
                    ++n3;
                }
                dArray4[n6] = 0.0;
                dArray4[n4] = d2;
                dArray2[n4] = d10;
                ++n18;
            }
            --n4;
        }
    }

    public static void fit(CurveFitIF curveFitIF, double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4, double[] dArray5) throws AssertionException {
        int n2;
        double d;
        int n3 = curveFitIF.numCoeffs();
        PfjAssert.pfjAssert(n3 > 0);
        PfjAssert.pfjAssert(dArray.length >= n + 1);
        PfjAssert.pfjAssert(dArray2.length >= n + 1);
        if (dArray3 != null) {
            PfjAssert.pfjAssert(dArray3.length >= n + 1);
        }
        PfjAssert.pfjAssert(dArray4.length == n3 + 1);
        double[] dArray6 = new double[n3 + 1];
        double[] dArray7 = new double[n + 1];
        double[] dArray8 = new double[n + 1];
        int n4 = 0;
        int n5 = 1;
        while (n5 <= n) {
            try {
                curveFitIF.eval(dArray[n5], dArray6);
                double d2 = curveFitIF.transformY(dArray2[n5]);
                if (Double.isNaN(d2)) {
                    throw new Exception();
                }
                dArray7[++n4] = dArray[n5];
                dArray8[n4] = d2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n5;
        }
        int n6 = n4;
        if (n6 < n3) {
            throw new AssertionException(String.valueOf(String.valueOf("Too few valid data points = ")) + n4);
        }
        double[] dArray9 = new double[n6 + 1];
        double[] dArray10 = new double[n6 + 1];
        n5 = 1;
        while (n5 <= n6) {
            dArray9[n5] = dArray7[n5];
            dArray10[n5] = dArray8[n5];
            ++n5;
        }
        double[] dArray11 = new double[n6 + 1];
        double[][] dArray12 = new double[n6 + 1][n3 + 1];
        double[][] dArray13 = new double[n3 + 1][n3 + 1];
        double[] dArray14 = new double[n3 + 1];
        n5 = 1;
        while (n5 <= n6) {
            curveFitIF.eval(dArray9[n5], dArray6);
            d = dArray3 == null ? 1.0 : 1.0 / dArray3[n5];
            n2 = 1;
            while (n2 <= n3) {
                dArray12[n5][n2] = dArray6[n2] * d;
                ++n2;
            }
            dArray11[n5] = dArray10[n5] * d;
            ++n5;
        }
        SVD.decomp(dArray12, n6, n3, dArray14, dArray13);
        double d3 = 0.0;
        n2 = 1;
        while (n2 <= n3) {
            if (dArray14[n2] > d3) {
                d3 = dArray14[n2];
            }
            ++n2;
        }
        double d4 = 1.0E-5 * d3;
        n2 = 1;
        while (n2 <= n3) {
            if (dArray14[n2] < d4) {
                dArray14[n2] = 0.0;
            }
            ++n2;
        }
        SVD.backsub(dArray12, dArray14, dArray13, n6, n3, dArray11, dArray4);
        dArray5[0] = 0.0;
        n5 = 1;
        while (n5 <= n6) {
            curveFitIF.eval(dArray9[n5], dArray6);
            double d5 = 0.0;
            n2 = 1;
            while (n2 <= n3) {
                d5 += dArray4[n2] * dArray6[n2];
                ++n2;
            }
            d = dArray10[n5] - d5;
            if (dArray3 != null) {
                d /= dArray3[n5];
            }
            dArray5[0] = dArray5[0] + d * d;
            ++n5;
        }
        n2 = 1;
        while (n2 <= n3) {
            dArray4[n2] = curveFitIF.invTransformCoeff(n2, dArray4[n2]);
            ++n2;
        }
    }
}

