/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.FP;

public class FitModExponential
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(FP.nonzero(d));
        double d2 = dArray[1] * Math.exp(dArray[2] / d);
        return d2;
    }

    public void eval(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(FP.nonzero(d));
        dArray[1] = 1.0;
        dArray[2] = 1.0 / d;
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double d) throws AssertionException {
        PfjAssert.pfjAssert(d > 0.0);
        return Math.log(d);
    }

    public double invTransformCoeff(int n, double d) {
        if (n == 1) {
            return Math.exp(d);
        }
        return d;
    }

    public String createEquation(String[] stringArray, boolean bl) throws AssertionException {
        PfjAssert.pfjAssert(stringArray.length >= NUM_COEFFS + 1);
        String string = stringArray[1];
        String string2 = String.valueOf(stringArray[2]) + " / x";
        return String.valueOf(String.valueOf("y = ")) + string + " * exp(" + string2 + ")";
    }
}

