/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

public final class FP {
    public static final double TOLERANCE = Math.exp(-24.0);

    public static boolean equal(double d, double d2) {
        return Math.abs(d - d2) <= TOLERANCE;
    }

    public static boolean nonzero(double d) {
        return !FP.equal(d, 0.0);
    }

    public static boolean greaterThan(double d, double d2) {
        return d - d2 > TOLERANCE;
    }

    public static boolean lessThan(double d, double d2) {
        return d - d2 < -TOLERANCE;
    }

    public static boolean between(double d, double d2, double d3) {
        return FP.greaterThan(d, d2) && FP.lessThan(d, d3);
    }

    public static double pythag(double d, double d2) {
        double d3;
        double d4;
        double d5 = Math.abs(d);
        if (d5 > (d4 = Math.abs(d2))) {
            double d6 = d4 / d5;
            d3 = d5 * Math.sqrt(1.0 + d6 * d6);
        } else if (d4 != 0.0) {
            double d7 = d5 / d4;
            d3 = d4 * Math.sqrt(1.0 + d7 * d7);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static int round(double d) {
        return (int)Math.floor(d + 0.5);
    }

    public static double sigDigits(double d, int n) {
        boolean bl;
        String string = Double.toString(d);
        if (n < 0) {
            n = 0;
        }
        int n2 = n;
        boolean bl2 = string.indexOf(".") != -1;
        boolean bl3 = bl = d < 0.0;
        if (bl2) {
            ++n2;
        }
        if (bl) {
            ++n2;
        }
        if (string.length() < n2) {
            return d;
        }
        String string2 = string.substring(n2, string.length());
        string2 = String.valueOf(String.valueOf("0.")) + string2;
        double d2 = new Double(string2);
        String string3 = "0.";
        int n3 = 1;
        while (n3 < n) {
            string3 = String.valueOf(string3) + "0";
            ++n3;
        }
        string3 = String.valueOf(string3) + "5";
        double d3 = d;
        if (d2 > 0.5) {
            d3 = bl ? d - new Double(string3) : d + new Double(string3);
        } else if (FP.equal(d2, 0.5) && (n3 = new Integer(string.substring(n2 - 1, n2)).intValue()) % 2 != 0) {
            d3 = bl ? d - new Double(string3) : d + new Double(string3);
        }
        return d3;
    }
}

