/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.dss.graph.pfj.FontCache;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.SmartText;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.ImageLoader;

public class TextStyleObj
implements Serializable {
    private static final int NEWLINE = 10;
    private static final int BLANK = 32;
    private static final int FORCE_LINEBREAK = 10;
    private static final int POSSIBLE_LINEBREAK = 32;
    private static final int FORCE_BREAK = 1;
    private static final int POSSIBLE_BREAK = 2;
    private static final int NO_SUCH_CHAR = -1;
    private static final int AUTOFIT_MIN = 200;
    private static final int AUTOFIT_MAX = 2200;
    private static final int MIN_SIZE_PTS = 0;
    private static final int MAX_SIZE_PTS = Integer.MAX_VALUE;
    private static final int MIN_SIZE_VC = 0;
    private static final int MAX_SIZE_VC = 6000;
    public static final int ALIGN_HORIZ_LEFT = 0;
    public static final int ALIGN_HORIZ_CENTER = 1;
    public static final int ALIGN_HORIZ_RIGHT = 2;
    public static final int ALIGN_HORIZ_START = 3;
    public static final int ALIGN_VERT_TOP = 0;
    public static final int ALIGN_VERT_CENTER = 1;
    public static final int ALIGN_VERT_BOTTOM = 2;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_ITALIC = 1;
    public static final int STYLE_BOLD = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_270 = 2;
    public static final int HEIGHT_AND_WIDTH_OK = 0;
    public static final int HEIGHT_LARGER = 1;
    public static final int WIDTH_LARGER = 2;
    public static final int WIDTH_AND_HEIGHT_LARGER = 3;
    public static final int LARGE_DRILL_UP_FONT_SIZE = 18;
    public static Image SMALL_DRILL_IMAGE;
    public static Image LARGE_DRILL_IMAGE;
    public boolean m_textTrunc;
    public int m_minChars;
    public boolean m_textTruncated;
    public int m_stopAtLine = -1;
    public static final String ELLIPSES = "...";
    private String m_strFontName;
    private boolean m_bUseDC;
    private int m_nFontSizeDC;
    private int m_nFontSizeVC;
    private int m_nFontStyle;
    private int m_nAngleSetting;
    private int m_nJustH;
    private int m_nJustV;
    private boolean m_bAutofit;
    private boolean m_bAdjustBox;
    private boolean m_bWordwrap;
    private boolean m_displayDrillIcon;
    private int m_imageSize;
    private Image m_image;
    private Dimension m_dimLargestTextDC;
    private int m_nTruncateCount;
    private FontCache m_fontCache;

    public TextStyleObj(FontCache fontCache, String string, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, boolean bl2, boolean bl3, boolean bl4) {
        this.m_fontCache = fontCache;
        this.m_strFontName = string;
        this.m_nFontStyle = n;
        this.m_bUseDC = bl;
        this.m_nFontSizeDC = n2;
        this.m_nFontSizeVC = n3;
        if (this.m_bUseDC) {
            this.m_nFontSizeDC = this.rangeChkFontPtSize(this.m_nFontSizeDC);
        } else {
            this.m_nFontSizeVC = this.rangeChkFontVCSize(this.m_nFontSizeVC);
        }
        this.m_nAngleSetting = n4;
        this.m_nJustH = n5;
        this.m_nJustV = n6;
        this.m_bAutofit = bl2 && !bl;
        this.m_bAdjustBox = bl3;
        this.m_bWordwrap = bl4;
        this.m_nTruncateCount = 0;
        this.m_displayDrillIcon = false;
    }

    public TextStyleObj(TextStyleObj textStyleObj) {
        this.copy(textStyleObj);
    }

    private int autofit(Graphics graphics, String string, Dimension dimension, VC vC) {
        int n;
        int n2 = n = 10;
        int n3 = 0;
        if (string != null) {
            Dimension dimension2;
            while (true) {
                dimension2 = this.getTextSizeDC(graphics, string, n2, vC, dimension, null);
                if (dimension2.width > dimension.width || dimension2.height > dimension.height) break;
                n2 += n;
                n3 += n;
            }
            do {
                int n4 = n3 + (n2 - n3) / 2;
                dimension2 = this.getTextSizeDC(graphics, string, n4, vC, dimension, null);
                if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
                    n3 = n4;
                    continue;
                }
                n2 = n4;
            } while (n3 != n2 - 1);
            this.m_nFontSizeDC = n3;
            this.m_nFontSizeVC = vC.destToVirtHeight(n3);
        }
        return n3;
    }

    private int autofit(Graphics graphics, Vector vector, Dimension dimension, VC vC) {
        int n = 0;
        n = vC.getVirtDimension().height;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            if (e != null && e.getClass().getName().equals("java.lang.String") && ((String)e).length() > 0) {
                String string = (String)e;
                int n4 = this.autofit(graphics, string, dimension, vC);
                n = Math.min(n, n4);
            }
            ++n3;
        }
        return n;
    }

    public void copy(TextStyleObj textStyleObj) {
        this.m_fontCache = textStyleObj.m_fontCache;
        this.m_strFontName = textStyleObj.m_strFontName;
        this.m_nFontStyle = textStyleObj.m_nFontStyle;
        this.m_bUseDC = textStyleObj.m_bUseDC;
        this.m_nFontSizeDC = textStyleObj.m_nFontSizeDC;
        this.m_nFontSizeVC = textStyleObj.m_nFontSizeVC;
        this.m_nAngleSetting = textStyleObj.m_nAngleSetting;
        this.m_nJustH = textStyleObj.m_nJustH;
        this.m_nJustV = textStyleObj.m_nJustV;
        this.m_bAutofit = textStyleObj.m_bAutofit;
        this.m_bAdjustBox = textStyleObj.m_bAdjustBox;
        this.m_bWordwrap = textStyleObj.m_bWordwrap;
        this.m_nTruncateCount = textStyleObj.m_nTruncateCount;
        this.m_textTrunc = textStyleObj.m_textTrunc;
        this.m_minChars = textStyleObj.m_minChars;
        this.m_textTruncated = textStyleObj.m_textTruncated;
        this.m_stopAtLine = textStyleObj.m_stopAtLine;
        this.m_displayDrillIcon = textStyleObj.m_displayDrillIcon;
    }

    public void draw(Graphics graphics, Component component, String string, Rectangle rectangle, Color color, Dimension dimension, VC vC) {
        int n = this.getFontSizeDC(vC);
        int n2 = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, n2, n);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Vector<String> vector = new Vector<String>();
        int n3 = 1;
        if (this.m_bWordwrap) {
            n3 = this.extractLinesWordWrap(string, vector, rectangle.width, fontMetrics);
        } else {
            vector.addElement(string);
        }
        Perspective perspective = (Perspective)component;
        SmartText smartText = perspective.getSmartText();
        Dimension dimension2 = new Dimension(0, 0);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Dimension dimension3 = new Dimension(rectangle2.width, rectangle2.height);
        int n4 = 0;
        while (n4 < n3) {
            Object object;
            String string2 = smartText.getDisplayString(perspective, (String)vector.elementAt(n4));
            dimension2 = this.getTextSizeDC(graphics, string2, n, vC, dimension3, dimension, false);
            Point point = this.alignTextInBox(n4, n3, fontMetrics, rectangle2, dimension2, perspective);
            if (dimension != null) {
                object = new Point(point.x + dimension.width, point.y + dimension.height);
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                graphics.drawString(string2, ((Point)object).x, ((Point)object).y);
                if ((this.m_nFontStyle & 4) != 0) {
                    int n5 = 0;
                    while (n5 < dimension2.height / 10) {
                        graphics.drawLine(((Point)object).x, ((Point)object).y + n5 + dimension2.height / 10, ((Point)object).x + dimension2.width, ((Point)object).y + n5 + dimension2.height / 10);
                        ++n5;
                    }
                }
                graphics.setColor(color2);
            }
            if (this.m_displayDrillIcon) {
                object = null;
                object = n < 18 ? SMALL_DRILL_IMAGE : LARGE_DRILL_IMAGE;
                int n6 = ((Image)object).getWidth(null);
                graphics.drawImage((Image)object, rectangle2.x, rectangle2.y + (rectangle2.height - n6) / 2, null);
                point.x += n6 + 2;
                dimension2.width -= n6 + 2;
            }
            graphics.drawString(string2, point.x, point.y);
            if ((this.m_nFontStyle & 4) != 0) {
                int n7 = 0;
                while (n7 < dimension2.height / 10) {
                    graphics.drawLine(point.x, point.y + n7 + dimension2.height / 10, point.x + dimension2.width, point.y + n7 + dimension2.height / 10);
                    ++n7;
                }
            }
            ++n4;
        }
    }

    private Point alignTextInBox(int n, int n2, FontMetrics fontMetrics, Rectangle rectangle, Dimension dimension, Perspective perspective) {
        Point point = new Point(0, 0);
        int n3 = this.m_nJustH;
        if (this.m_nJustH == 3) {
            n3 = LocaleUtils.getReadingDirectionForLocale((Locale)perspective.getLocale());
            if (n3 == 1) {
                n3 = 0;
            }
            if (n3 == 2) {
                n3 = 2;
            }
        }
        switch (n3) {
            case 0: {
                point.x = rectangle.x;
                break;
            }
            default: {
                point.x = rectangle.x + (rectangle.width - dimension.width) / 2;
                break;
            }
            case 2: {
                point.x = rectangle.x + rectangle.width - dimension.width;
            }
        }
        int n4 = (int)Math.ceil((double)fontMetrics.getDescent() / 2.0);
        switch (this.m_nJustV) {
            case 0: {
                int n5 = (n + 1) * dimension.height;
                point.y = rectangle.y + n5 - n4;
                break;
            }
            default: {
                int n6 = (n + 1) * dimension.height;
                int n7 = (rectangle.height - n2 * dimension.height) / 2;
                point.y = rectangle.y + n7 + n6 - n4;
                break;
            }
            case 2: {
                int n8 = (n2 - n - 1) * dimension.height;
                point.y = rectangle.y + rectangle.height - n8 - n4;
            }
        }
        return point;
    }

    public int formatAndAutofit(Graphics graphics, Perspective perspective, boolean bl, int n, int n2, int n3, Vector vector, Dimension dimension, VC vC) {
        int n4;
        boolean bl2 = this.getRotationAngle() != 0;
        Dimension dimension2 = bl2 ? new Dimension(vC.virtToDestHeight(dimension.height), vC.virtToDestWidth(dimension.width)) : vC.virtToDest(dimension);
        if (bl && !this.m_bUseDC) {
            n4 = this.autofit(graphics, vector, dimension2, vC);
            n3 = vC.destToVirtHeight(n4);
            if (n3 < n) {
                n3 = n;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            this.m_nFontSizeVC = n3;
            this.m_bAutofit = false;
        }
        this.m_dimLargestTextDC = new Dimension(0, 0);
        n4 = TextStyleObj.getStyleBI(this.m_nFontStyle);
        int n5 = vC.virtToDestHeight(n3);
        Font font = this.getFont(this.m_strFontName, n4, n5);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n6 = 0;
        while (n6 < vector.size()) {
            String string = (String)vector.elementAt(n6);
            if (string != null && string.length() > 0) {
                Dimension dimension3 = new Dimension(0, 0);
                Vector<String> vector2 = new Vector<String>();
                if (this.m_bWordwrap) {
                    this.extractLinesWordWrap(string, vector2, dimension2.width, fontMetrics);
                } else {
                    vector2.addElement(string);
                }
                dimension3 = this.getSizeBoxDC(vector2, fontMetrics);
                if (this.m_displayDrillIcon) {
                    Image image = null;
                    image = n5 < 18 ? SMALL_DRILL_IMAGE : LARGE_DRILL_IMAGE;
                    dimension3.width += image.getWidth(null) + 2;
                }
                this.m_dimLargestTextDC.width = Math.max(this.m_dimLargestTextDC.width, dimension3.width);
                this.m_dimLargestTextDC.height = Math.max(this.m_dimLargestTextDC.height, dimension3.height);
            }
            ++n6;
        }
        n6 = 0;
        if (this.m_dimLargestTextDC.height > dimension2.height) {
            ++n6;
        }
        if (this.m_dimLargestTextDC.width > dimension2.width) {
            n6 += 2;
        }
        dimension2.width = Math.min(dimension2.width, this.m_dimLargestTextDC.width);
        dimension2.height = Math.min(dimension2.height, this.m_dimLargestTextDC.height);
        if (bl2) {
            dimension.width = vC.destToVirtWidth(dimension2.height);
            dimension.height = vC.destToVirtHeight(dimension2.width);
        } else {
            dimension.width = vC.destToVirtWidth(dimension2.width);
            dimension.height = vC.destToVirtHeight(dimension2.height);
        }
        return n6;
    }

    public Dimension getDimLargeTextVC(VC vC) {
        Dimension dimension = null;
        if (this.m_dimLargestTextDC != null) {
            dimension = new Dimension(this.m_dimLargestTextDC);
            dimension.width = vC.destToVirtWidth(this.m_dimLargestTextDC.width);
            dimension.height = vC.destToVirtHeight(this.m_dimLargestTextDC.height);
        }
        return dimension;
    }

    public Font getFont(VC vC) {
        int n = this.getFontSizeDC(vC);
        int n2 = TextStyleObj.getStyleBI(this.m_nFontStyle);
        return this.getFont(this.m_strFontName, n2, n);
    }

    private Font getFont(String string, int n, int n2) {
        Font font = this.m_fontCache != null ? this.m_fontCache.getFont(string, n, n2) : new Font(string, n, n2);
        return font;
    }

    public int getFontSizeDC(VC vC) {
        int n = this.m_bUseDC ? this.m_nFontSizeDC : vC.virtToDestHeight(this.m_nFontSizeVC);
        n = this.rangeChkFontPtSize(n);
        return n;
    }

    public int getFontSizeVC(VC vC) {
        int n = this.m_bUseDC ? vC.destToVirtHeight(this.m_nFontSizeDC) : this.m_nFontSizeVC;
        n = this.rangeChkFontVCSize(n);
        return n;
    }

    public int getHorizAlign() {
        return this.m_nJustH;
    }

    public int getVertAlign() {
        return this.m_nJustV;
    }

    public int getRotationAngle() {
        return this.m_nAngleSetting;
    }

    public void setRotationAngle(int n) {
        this.m_nAngleSetting = n;
    }

    public void setFontStyle(int n) {
        this.m_nFontStyle = n;
    }

    public int getFontStyle() {
        return this.m_nFontStyle;
    }

    public int getNumLines(Graphics graphics, String string, int n, Dimension dimension, VC vC) {
        FontMetrics fontMetrics = this.getFontMetrics(graphics, vC);
        Vector vector = new Vector();
        int n2 = 1;
        if (this.m_bWordwrap) {
            n2 = this.extractLinesWordWrap(string, vector, n, fontMetrics);
        }
        return n2;
    }

    public FontMetrics getFontMetrics(Graphics graphics, VC vC) {
        int n = this.getFontSizeDC(vC);
        int n2 = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, n2, n);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics;
    }

    public Rectangle getTextBox(Graphics graphics, String string, Rectangle rectangle, Dimension dimension, VC vC) {
        int n = this.getFontSizeDC(vC);
        FontMetrics fontMetrics = this.getFontMetrics(graphics, vC);
        int n2 = fontMetrics.getLeading();
        Vector<String> vector = new Vector<String>();
        if (this.m_bWordwrap) {
            this.extractLinesWordWrap(string, vector, rectangle.width, fontMetrics);
        } else {
            vector.addElement(string);
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Dimension dimension2 = new Dimension(0, 0);
        Dimension dimension3 = new Dimension(rectangle2.width, rectangle2.height);
        int n3 = 0;
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            dimension2 = this.getTextSizeDC(graphics, (String)vector.elementAt(n5), n, vC, dimension3, dimension, false);
            n3 = Math.max(dimension2.width, n3);
            ++n5;
        }
        return rectangle2;
    }

    public Dimension getTextSizeDC(Graphics graphics, String string, int n, VC vC, Dimension dimension, Dimension dimension2) {
        return this.getTextSizeDC(graphics, string, n, vC, dimension, dimension2, this.m_bWordwrap);
    }

    public Dimension getTextSizeDC(Graphics graphics, String string, int n, VC vC, Dimension dimension, Dimension dimension2, boolean bl) {
        int n2 = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, n2, n);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Vector<String> vector = new Vector<String>();
        if (bl) {
            this.extractLinesWordWrap(string, vector, dimension.width, fontMetrics);
        } else {
            vector.addElement(string);
        }
        Dimension dimension3 = this.getSizeBoxDC(vector, fontMetrics);
        if (this.m_displayDrillIcon) {
            Image image = null;
            image = n < 18 ? SMALL_DRILL_IMAGE : LARGE_DRILL_IMAGE;
            dimension3.width += image.getWidth(null) + 2;
        }
        if (dimension2 != null) {
            dimension3.width = dimension3.width + dimension2.width + 1;
        }
        return dimension3;
    }

    private Dimension getSizeBoxDC(Vector vector, FontMetrics fontMetrics) {
        int n = vector.size();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = fontMetrics.stringWidth((String)vector.elementAt(n3));
            dimension.width = Math.max(dimension.width, n2);
            ++n3;
        }
        dimension.height = n * TextStyleObj.getFontHeight(fontMetrics);
        return dimension;
    }

    public static int getFontHeight(FontMetrics fontMetrics) {
        int n = fontMetrics.getHeight();
        int n2 = 85;
        n = (int)((double)(n2 * fontMetrics.getHeight()) / 100.0);
        return n;
    }

    public Dimension preDraw(Graphics graphics, String string, Rectangle rectangle, VC vC, Dimension dimension) {
        int n = this.m_bAutofit ? this.autofit(graphics, string, new Dimension(rectangle.width, rectangle.height), vC) : (this.m_bUseDC ? this.m_nFontSizeDC : vC.virtToDestHeight(this.m_nFontSizeVC));
        n = this.rangeChkFontPtSize(n);
        Dimension dimension2 = new Dimension(rectangle.width, rectangle.height);
        Dimension dimension3 = this.getTextSizeDC(graphics, string, n, vC, dimension2, dimension);
        return dimension3;
    }

    public void setHorizAlign(int n) {
        this.m_nJustH = n;
    }

    public void setVertAlign(int n) {
        this.m_nJustV = n;
    }

    private int rangeChkFontPtSize(int n) {
        if (n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    private int rangeChkFontVCSize(int n) {
        if (n > 6000) {
            n = 6000;
        }
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    protected static int getStyleBI(int n) {
        int n2 = 0;
        n2 += (n & 1) != 0 ? 2 : 0;
        return n2 += (n & 2) != 0 ? 1 : 0;
    }

    public int extractLinesWordWrap(String string, Vector vector, int n, FontMetrics fontMetrics) {
        int n2 = 0;
        vector.removeAllElements();
        int n3 = fontMetrics.charWidth(' ');
        if (string != null) {
            int n4 = 0;
            String string2 = " \t\n\r\f";
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl;
                String string4 = stringTokenizer.nextToken();
                if (string2.indexOf(string4) != -1) {
                    if (!string4.equals("\n")) continue;
                    if (this.m_textTrunc) {
                        if (!this.truncateText(vector, string3, n, fontMetrics, true)) continue;
                        return vector.size();
                    }
                    n4 = 0;
                    vector.addElement(string3);
                    string3 = "";
                    continue;
                }
                int n5 = fontMetrics.stringWidth(string4);
                boolean bl2 = bl = string3.length() == 0;
                if (!bl) {
                    n4 += n3;
                }
                if ((n4 += n5) > n) {
                    if (!bl) {
                        if (this.m_textTrunc) {
                            if (this.truncateText(vector, string3, n, fontMetrics, true)) {
                                return vector.size();
                            }
                        } else {
                            vector.addElement(string3);
                        }
                    }
                    string3 = string4;
                    n4 = n5;
                    continue;
                }
                if (!bl) {
                    string3 = String.valueOf(string3) + ' ';
                }
                string3 = String.valueOf(string3) + string4;
            }
            if (this.m_textTrunc) {
                if (this.truncateText(vector, string3, n, fontMetrics, false)) {
                    return vector.size();
                }
            } else {
                vector.addElement(string3);
            }
        }
        n2 = vector.size();
        return n2;
    }

    public boolean getWordWrap() {
        return this.m_bWordwrap;
    }

    public void setWordWrap(boolean bl) {
        this.m_bWordwrap = bl;
    }

    public void setTextTruncate(boolean bl, int n, int n2) {
        this.m_textTrunc = bl;
        this.m_stopAtLine = n;
        this.m_minChars = n2;
    }

    public void setTextTruncated(boolean bl) {
        this.m_textTruncated = bl;
    }

    public boolean isTextTruncated() {
        return this.m_textTruncated;
    }

    public static int getJavaFontStyle(int n) {
        int n2 = 0;
        n2 |= (n & 1) != 0 ? 2 : 0;
        return n2 |= (n & 2) != 0 ? 1 : 0;
    }

    public static String truncateText(String string, FontMetrics fontMetrics, int n, int n2) {
        int n3 = string.length();
        if (n3 > n) {
            int n4;
            int n5 = fontMetrics.stringWidth(string);
            float f = (float)n2 / (float)n5;
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            int n7 = (int)((double)n3 * 0.2);
            if (n7 > 2) {
                if ((double)f > 0.2) {
                    n6 = (int)((float)n3 * (f -= 0.1f));
                    stringBuffer.append(string.substring(0, n6));
                }
            } else if (n7 >= 1 && (double)f > 0.3) {
                n6 = (int)((float)n3 * (f -= 0.2f));
                stringBuffer.append(string.substring(0, n6));
            }
            int n8 = fontMetrics.stringWidth(ELLIPSES);
            if (fontMetrics.stringWidth(stringBuffer.toString()) + n8 < n2) {
                n4 = n6;
                while (n4 < string.length()) {
                    stringBuffer.append(string.charAt(n4));
                    if (fontMetrics.stringWidth(stringBuffer.toString()) + n8 > n2) {
                        n6 = n4;
                        break;
                    }
                    ++n4;
                }
            } else {
                n4 = n6 - 1;
                while (n4 >= 0) {
                    stringBuffer.deleteCharAt(n4);
                    if (fontMetrics.stringWidth(stringBuffer.toString()) + n8 < n2) {
                        n6 = n4;
                        break;
                    }
                    --n4;
                }
            }
            if (n6 < n) {
                string = "";
            } else {
                stringBuffer = new StringBuffer(string);
                String string2 = stringBuffer.substring(0, n6);
                string = String.valueOf(string2) + ELLIPSES;
                if (n6 == 0 && fontMetrics.stringWidth(string) > n2) {
                    string = "";
                }
            }
        } else {
            string = "";
        }
        return string;
    }

    private boolean truncateText(Vector vector, String string, int n, FontMetrics fontMetrics, boolean bl) {
        if (vector.size() == this.m_stopAtLine - 1 && bl) {
            string = String.valueOf(string) + ELLIPSES;
            this.m_textTruncated = true;
        }
        if (fontMetrics.stringWidth(string) <= n) {
            vector.addElement(string);
            return vector.size() == this.m_stopAtLine;
        }
        this.m_textTruncated = true;
        string = TextStyleObj.truncateText(string, fontMetrics, this.m_minChars, n);
        vector.addElement(string);
        return vector.size() == this.m_stopAtLine;
    }

    public String truncateString(String string, int n) {
        String string2 = string;
        if (string.length() > n && n > 3) {
            string2 = string.substring(0, n - 3);
            string2 = string2.concat(ELLIPSES);
        }
        return string2;
    }

    public static int calcAxisLabelGap(int n) {
        int n2 = (n - 10) * 100 / 10;
        int n3 = 10 + n2 * 50 * 10 / 26000;
        return n3;
    }

    public void setDisplayDrillIcon(boolean bl) {
        this.m_displayDrillIcon = bl;
    }

    /*
     * Loose catch block
     */
    public static Image getImageResource(Class clazz, String string) {
        int n;
        Object object;
        byte[] byArray;
        Image image;
        block14: {
            image = null;
            byArray = null;
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream != null) {
                object = new BufferedInputStream(inputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                byArray = new byte[1024];
                while ((n = ((FilterInputStream)object).read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                Object var9_10 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                break block14;
                {
                    catch (IOException iOException) {
                        Object var9_11 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (byArray != null) {
            object = Toolkit.getDefaultToolkit();
            image = ((Toolkit)object).createImage(byArray);
            int n2 = ((Toolkit)object).checkImage(image, -1, -1, null);
            n = 0;
            if ((n2 & 0x30) == 0) {
                ImageLoader imageLoader = new ImageLoader(image);
                imageLoader.start();
                n = imageLoader.waitFor() ? 1 : 0;
            } else {
                n = 1;
            }
            if (n == 0) {
                image = null;
            }
        }
        return image;
    }
}

