/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.SmartText;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.event.TDGEventManager;

public class SelList
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("ENGINE.SelList");
    public static final int SELMODE_NONE = 0;
    public static final int SELMODE_SINGLE = 1;
    public static final int SELMODE_ALLIFDATA = 2;
    public static final int SELMODE_ALL = 3;
    public static final int SELMODE_ZOOM_POINT = 4;
    public static final int SELMODE_ZOOM_RECT = 5;
    private static final int HANDLE_SIZE = 6;
    private static final int BOX_SIZE_MIN = 10;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_RESIZE = 1;
    private static final int ACTION_MOVE = 2;
    private static final int ACTION_BARRESIZE = 3;
    private static final int LEFT_TOP = 0;
    private static final int TOP = 1;
    private static final int RIGHT_TOP = 2;
    private static final int RIGHT = 3;
    private static final int RIGHT_BOTTOM = 4;
    private static final int BOTTOM = 5;
    private static final int LEFT_BOTTOM = 6;
    private static final int LEFT = 7;
    private Vector m_selList;
    private Perspective m_Perspective;
    private int m_nCurrentItem;
    private Rectangle[] m_rHandles;
    private int m_nActiveHandle;
    private Rectangle m_rOriginalPos;
    private Point m_DeltaPos;
    private int m_nAction;
    private Rectangle m_rSelBounds;
    private Vector m_MovingOriginalDelta;
    private Vector m_MovingOriginal;
    private double m_nResizeValue;
    private boolean m_bDragged;
    private int m_nResizeCoord;
    private int m_nOriginalResizeCoord;
    private int m_nOriginalResizeCoordBase;
    private int m_nScaling;
    private int m_nDirection;
    private DataItem m_item;
    private Point m_ptMouseDown;
    private boolean m_bCanSwitchDirection;
    TDGMouseState m_mouseStateDeadZone;
    private Rectangle m_rBoundParent;

    public SelList(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_selList = new Vector(10);
        this.m_nCurrentItem = 0;
        this.m_nActiveHandle = -1;
    }

    public boolean add(Graphics graphics, Point point, boolean bl, boolean bl2, int n, VC vC) {
        if (n == 0) {
            return false;
        }
        DetObj detObj = this.m_Perspective.getDetectiv().findNodeOf(point.x, point.y, vC);
        if (!(detObj.getObjectID() != 499 && detObj.getObjectID() != 500 || bl2)) {
            detObj = this.m_Perspective.getDetectiv().findNodeOf(new IdentObj(2));
        }
        if (detObj != null) {
            this.add(graphics, detObj, bl, bl2, n, vC);
            return true;
        }
        return false;
    }

    public void add(Graphics graphics, DetObj detObj, boolean bl, boolean bl2, int n, VC vC) {
        TDGEventManager tDGEventManager = this.m_Perspective.getEventManager();
        int n2 = this.m_Perspective.isColorByHeight() ? 3 : (this.m_Perspective.isColorByGroup() ? 2 : 1);
        switch (n) {
            case 0: 
            case 4: 
            case 5: {
                break;
            }
            case 1: {
                if (this.isInList(detObj)) {
                    return;
                }
                this.clear(graphics, vC);
                switch (detObj.getObjectID()) {
                    case 256: 
                    case 258: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 473: 
                    case 475: 
                    case 476: {
                        Enumeration enumeration = this.m_Perspective.getDetectiv().getList();
                        while (enumeration.hasMoreElements()) {
                            DetObj detObj2 = (DetObj)enumeration.nextElement();
                            if (!detObj2.isDetectable() || !detObj2.isHiliteable() || !detObj.isSelRelated(detObj2, n2) || detObj.getObjectID() != detObj2.getObjectID()) continue;
                            this.m_selList.addElement(detObj2);
                            this.hiliteDetObj(graphics, detObj2, vC);
                        }
                        break;
                    }
                    default: {
                        this.m_selList.addElement(detObj);
                        this.hiliteDetObj(graphics, detObj, vC);
                    }
                }
                tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3959, this.m_mouseStateDeadZone);
                break;
            }
            case 2: 
            case 3: {
                if (n == 2 && !detObj.getIdentID().isSeriesRelated()) {
                    this.clear(graphics, vC);
                    return;
                }
                if (this.isInList(detObj)) {
                    return;
                }
                if (!bl) {
                    this.clear(graphics, vC);
                }
                this.m_selList.addElement(detObj);
                this.hiliteDetObj(graphics, detObj, vC);
                if (bl2) {
                    int n3 = 0;
                    Enumeration enumeration = this.m_Perspective.getDetectiv().getList();
                    while (enumeration.hasMoreElements()) {
                        DetObj detObj3 = (DetObj)enumeration.nextElement();
                        if (detObj.equals(detObj3)) {
                            ++n3;
                            continue;
                        }
                        if (!detObj3.isDetectable() || !detObj3.isHiliteable() || !detObj.isSelRelated(detObj3, n2)) continue;
                        this.m_selList.addElement(detObj3);
                        this.hiliteDetObj(graphics, detObj3, vC);
                    }
                }
                tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3959, this.m_mouseStateDeadZone);
            }
        }
    }

    public void calc() {
        Vector vector = this.m_selList;
        this.m_selList = new Vector(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DetObj detObj = (DetObj)enumeration.nextElement();
            int n = 0;
            Enumeration enumeration2 = this.m_Perspective.getDetectiv().getList();
            while (enumeration2.hasMoreElements()) {
                DetObj detObj2 = (DetObj)enumeration2.nextElement();
                if (detObj.equals(detObj2)) {
                    this.m_selList.addElement(detObj2);
                    ++n;
                    continue;
                }
                if (!detObj2.isExceptional() && !detObj.isExceptional()) continue;
                IdentObj identObj = detObj2.getIdentID().stripExceptional();
                IdentObj identObj2 = detObj.getIdentID().stripExceptional();
                if (!identObj2.equals(identObj)) continue;
                this.m_selList.addElement(detObj2);
                ++n;
                TDGEventManager tDGEventManager = this.m_Perspective.getEventManager();
                tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3959, null);
            }
        }
    }

    public void clear(Graphics graphics, VC vC) {
        Enumeration enumeration = this.m_selList.elements();
        while (enumeration.hasMoreElements()) {
            DetObj detObj = (DetObj)enumeration.nextElement();
            this.hiliteDetObj(graphics, detObj, vC);
        }
        this.m_selList.removeAllElements();
    }

    public void saveDeadZoneMouseState(TDGMouseState tDGMouseState) {
        this.m_mouseStateDeadZone = tDGMouseState;
    }

    public void dump() {
        Enumeration enumeration = this.m_selList.elements();
        while (enumeration.hasMoreElements()) {
            DetObj detObj = (DetObj)enumeration.nextElement();
            IdentObj identObj = detObj.getIdentID();
            int n = identObj.getSeriesID();
            int n2 = identObj.getGroupID();
            LOG.info(String.valueOf(String.valueOf("o = ")) + identObj.getObjectID() + " s = " + n + " g = " + n2 + " m = " + identObj.getMiscID());
        }
    }

    private DetObj findNodeOf(int n, int n2, VC vC) {
        DetObj detObj = null;
        boolean bl = false;
        Enumeration enumeration = this.m_selList.elements();
        while (enumeration.hasMoreElements()) {
            detObj = (DetObj)enumeration.nextElement();
            if (!detObj.isPointInObj(n, n2, vC)) continue;
            bl = true;
        }
        return detObj;
    }

    public DetObj firstDetObjElement() {
        this.m_nCurrentItem = 0;
        DetObj detObj = null;
        if (this.hasMoreElements()) {
            detObj = (DetObj)this.m_selList.elementAt(this.m_nCurrentItem);
        }
        return detObj;
    }

    public IdentObj firstElement() {
        this.m_nCurrentItem = 0;
        IdentObj identObj = null;
        if (this.hasMoreElements()) {
            identObj = ((DetObj)this.m_selList.elementAt(this.m_nCurrentItem)).getIdentID();
        }
        if (identObj != null) {
            identObj = identObj.getObjectID() == 270 ? new IdentObj(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getStackID(), identObj.getMiscID()) : new IdentObj(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getStackID(), -3);
        }
        return identObj;
    }

    public boolean hasMoreElements() {
        return this.m_nCurrentItem < this.m_selList.size();
    }

    public void hilite(Graphics graphics, VC vC) {
        Enumeration enumeration = this.m_selList.elements();
        while (enumeration.hasMoreElements()) {
            DetObj detObj = (DetObj)enumeration.nextElement();
            this.hiliteDetObj(graphics, detObj, vC);
        }
    }

    private void hiliteDetObj(Graphics graphics, DetObj detObj, VC vC) {
        if (detObj.isMoveable() && this.m_Perspective.getSelectionEnableMove()) {
            this.hiliteWithHandles(graphics, detObj, vC);
        } else if (detObj.isHiliteable()) {
            detObj.hilite(graphics, vC);
        }
    }

    public void hiliteResizer(Graphics graphics, DetObj detObj, VC vC) {
        Rectangle rectangle = vC.virtToDest(detObj.getBounds());
        int n = this.m_nResizeCoord;
        if (this.m_nScaling != 1) {
            n += this.m_nOriginalResizeCoordBase;
        }
        graphics.setXORMode(Color.yellow);
        if (this.m_nDirection == 1) {
            graphics.drawLine(rectangle.x + rectangle.width, n, rectangle.x + rectangle.width + 5, n);
        } else {
            graphics.drawLine(n, rectangle.y + rectangle.height, n, rectangle.y + rectangle.height + 5);
        }
        Font font = new Font("Geneva", 0, 14);
        graphics.setFont(font);
        String string = TDGNumberFormat.toString(this.m_Perspective, 17, this.m_nResizeValue, "");
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(3, detObj.getSeriesID(), detObj.getGroupID(), -1, -3);
            string = this.m_Perspective.getNumberFormatCallBack().toString(this.m_nResizeValue);
        }
        SmartText smartText = this.m_Perspective.getSmartText();
        string = smartText.getDisplayString(this.m_Perspective, string);
        if (this.m_nDirection == 1) {
            graphics.drawString(string, rectangle.x + rectangle.width + 7, n + 4);
        } else {
            graphics.drawString(string, n + 4, rectangle.y + rectangle.height + 7);
        }
        graphics.setPaintMode();
    }

    protected void hiliteWithHandles(Graphics graphics, DetObj detObj, VC vC) {
        Rectangle rectangle = vC.virtToDest(detObj.getLooseBounds());
        graphics.setXORMode(Color.yellow);
        int n = rectangle.x - 3;
        int n2 = rectangle.x + (rectangle.width - 3) / 2;
        int n3 = rectangle.x + rectangle.width + 1 - 3 - 1;
        int n4 = rectangle.y + rectangle.height + 1 - 3 - 1;
        int n5 = rectangle.y + (rectangle.height - 6) / 2;
        int n6 = rectangle.y - 3;
        this.m_rHandles = new Rectangle[8];
        this.m_rHandles[0] = new Rectangle(n, n6, 6, 6);
        this.m_rHandles[1] = new Rectangle(n2, n6, 6, 6);
        this.m_rHandles[2] = new Rectangle(n3, n6, 6, 6);
        this.m_rHandles[3] = new Rectangle(n3, n5, 6, 6);
        this.m_rHandles[4] = new Rectangle(n3, n4, 6, 6);
        this.m_rHandles[5] = new Rectangle(n2, n4, 6, 6);
        this.m_rHandles[6] = new Rectangle(n, n4, 6, 6);
        this.m_rHandles[7] = new Rectangle(n, n5, 6, 6);
        int n7 = 0;
        while (n7 < 8) {
            graphics.fillRect(this.m_rHandles[n7].x, this.m_rHandles[n7].y, this.m_rHandles[n7].width, this.m_rHandles[n7].height);
            ++n7;
        }
        graphics.drawLine(rectangle.x + 3 + 1, rectangle.y, n2 - 3 + 1, rectangle.y);
        graphics.drawLine(n2 + 6, rectangle.y, n3 - 3 + 1, rectangle.y);
        graphics.drawLine(rectangle.x + 3 + 1, rectangle.y + rectangle.height, n2 - 3 + 1, rectangle.y + rectangle.height);
        graphics.drawLine(n2 + 6, rectangle.y + rectangle.height, n3 - 3 + 1, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, n6 + 6, rectangle.x, n5 - 3 + 1);
        graphics.drawLine(rectangle.x, n5 + 6, rectangle.x, n4 - 3 + 1);
        graphics.drawLine(rectangle.x + rectangle.width, n6 + 6, rectangle.x + rectangle.width, n5 - 3 + 1);
        graphics.drawLine(rectangle.x + rectangle.width, n5 + 6, rectangle.x + rectangle.width, n4 - 3 + 1);
        graphics.setPaintMode();
    }

    public boolean ptInsideHandles(Point point) {
        boolean bl = false;
        if (this.m_rHandles != null) {
            int n = 0;
            while (n < 8) {
                if (this.m_rHandles[n].contains(point.x, point.y)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.m_selList.size() == 0;
    }

    public int size() {
        return this.m_selList.size();
    }

    private boolean isInList(DetObj detObj) {
        DetObj detObj2 = null;
        boolean bl = false;
        Enumeration enumeration = this.m_selList.elements();
        while (enumeration.hasMoreElements()) {
            detObj2 = (DetObj)enumeration.nextElement();
            if (!detObj2.equals(detObj)) continue;
            bl = true;
        }
        return bl;
    }

    public void mouseDown(Graphics graphics, Point point, boolean bl, boolean bl2, boolean bl3, VC vC) {
        int n;
        Serializable serializable;
        int n2 = this.m_Perspective.getSelectionEnable();
        boolean bl4 = this.m_Perspective.getSelectionEnableMove();
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        this.m_nAction = 0;
        this.m_nScaling = jGraphType.getScalingMethod();
        this.m_nDirection = jGraphType.getPreferredResizeDirection();
        this.m_item = jGraphType.getPreferredResizeItem();
        this.m_ptMouseDown = new Point(point.x, point.y);
        this.m_bCanSwitchDirection = jGraphType.getCanSwitchDirection();
        if (n2 == 0) {
            return;
        }
        this.m_rBoundParent = new Rectangle(this.m_Perspective.getParent().getSize());
        if (bl4 && this.m_selList.size() == 1 && ((DetObj)(serializable = (DetObj)this.m_selList.elementAt(0))).isMoveable()) {
            n = 0;
            while (n < 8) {
                if (this.m_rHandles[n].contains(point.x, point.y)) {
                    this.m_nActiveHandle = n;
                    this.m_rOriginalPos = vC.virtToDest(((DetObj)serializable).getBounds());
                    this.m_DeltaPos = new Point(point.x - this.m_rHandles[n].x - this.m_rHandles[n].width / 2, point.y - this.m_rHandles[n].y - this.m_rHandles[n].height / 2);
                    this.m_nAction = 1;
                    return;
                }
                ++n;
            }
        }
        this.add(graphics, vC.destToVirt(point), bl, bl2, n2, vC);
        serializable = this.firstElement();
        n = ((IdentObj)serializable).getObjectID();
        int n3 = this.m_selList.size();
        if (bl3 && this.m_selList.size() == 1 && (n == 277 || n == 259 || n == 354)) {
            if (this.m_nDirection == 1) {
                this.m_nOriginalResizeCoord = this.m_nResizeCoord = vC.virtToDestY(this.m_Perspective.getDataCoord((IdentObj)serializable, this.m_item, false));
                if (this.m_nScaling != 1) {
                    this.m_nOriginalResizeCoordBase = vC.virtToDestY(this.m_Perspective.getDataCoord((IdentObj)serializable, this.m_item, true)) - vC.virtToDestY(this.m_Perspective.getDataCoord((IdentObj)serializable, this.m_item, false));
                }
            } else {
                this.m_nOriginalResizeCoord = this.m_nResizeCoord = vC.virtToDestX(this.m_Perspective.getDataCoord((IdentObj)serializable, this.m_item, false));
                if (this.m_nScaling != 1) {
                    this.m_nOriginalResizeCoordBase = vC.virtToDestX(this.m_Perspective.getDataCoord((IdentObj)serializable, this.m_item, true)) - vC.virtToDestX(this.m_Perspective.getDataCoord((IdentObj)serializable, this.m_item, false));
                }
            }
            this.hiliteResizer(graphics, this.firstDetObjElement(), vC);
            this.m_nAction = 3;
            this.m_bDragged = false;
            return;
        }
        if (bl4 && !this.m_selList.isEmpty()) {
            Rectangle rectangle;
            DetObj detObj;
            Enumeration enumeration = this.m_selList.elements();
            while (enumeration.hasMoreElements()) {
                detObj = (DetObj)enumeration.nextElement();
                rectangle = vC.virtToDest(detObj.getLooseBounds());
                if (!rectangle.contains(point.x, point.y) || !detObj.isMoveable()) continue;
                this.m_rOriginalPos = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.m_nAction = 2;
                this.m_DeltaPos = new Point(point.x - rectangle.x, point.y - rectangle.y);
                break;
            }
            if (this.m_nAction == 2) {
                this.m_rSelBounds = null;
                this.m_MovingOriginalDelta = new Vector();
                this.m_MovingOriginal = new Vector();
                enumeration = this.m_selList.elements();
                while (enumeration.hasMoreElements()) {
                    detObj = (DetObj)enumeration.nextElement();
                    if (!detObj.isMoveable()) continue;
                    rectangle = vC.virtToDest(detObj.getBounds());
                    this.m_rSelBounds = this.m_rSelBounds != null ? this.m_rSelBounds.union(rectangle) : new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.m_rOriginalPos = new Rectangle(this.m_rSelBounds.x, this.m_rSelBounds.y, this.m_rSelBounds.width, this.m_rSelBounds.height);
                this.m_DeltaPos = new Point(point.x - this.m_rSelBounds.x, point.y - this.m_rSelBounds.y);
                enumeration = this.m_selList.elements();
                while (enumeration.hasMoreElements()) {
                    detObj = (DetObj)enumeration.nextElement();
                    if (!detObj.isMoveable()) continue;
                    rectangle = vC.virtToDest(detObj.getBounds());
                    this.m_MovingOriginalDelta.addElement(new Point(rectangle.x - this.m_rSelBounds.x, rectangle.y - this.m_rSelBounds.y));
                    this.m_MovingOriginal.addElement(rectangle);
                }
            }
        }
    }

    public void mouseDragMove(Graphics graphics, Point point, VC vC) {
        IdentObj identObj = new IdentObj(1);
        Rectangle rectangle = vC.virtToDest(this.m_Perspective.getRect(identObj));
        rectangle = rectangle.intersection(this.m_rBoundParent);
        int n = point.x - this.m_DeltaPos.x;
        int n2 = point.y - this.m_DeltaPos.y;
        n = Math.max(n, rectangle.x + 1);
        n = Math.min(n + this.m_rSelBounds.width, rectangle.x + rectangle.width - 1) - this.m_rSelBounds.width;
        n2 = Math.max(n2, 1);
        n2 = Math.min(n2 + this.m_rSelBounds.height, rectangle.y + rectangle.height - 1) - this.m_rSelBounds.height;
        this.m_rSelBounds.x = n;
        this.m_rSelBounds.y = n2;
        int n3 = 0;
        Enumeration enumeration = this.m_selList.elements();
        while (enumeration.hasMoreElements()) {
            DetObj detObj = (DetObj)enumeration.nextElement();
            if (!detObj.isMoveable()) continue;
            Rectangle rectangle2 = detObj.getBounds();
            Rectangle rectangle3 = vC.virtToDest(rectangle2);
            this.hiliteWithHandles(graphics, detObj, vC);
            rectangle3.x = n + ((Point)this.m_MovingOriginalDelta.elementAt((int)n3)).x;
            rectangle3.y = n2 + ((Point)this.m_MovingOriginalDelta.elementAt((int)n3)).y;
            Rectangle rectangle4 = vC.destToVirt(rectangle3);
            rectangle4.width = rectangle2.width;
            rectangle4.height = rectangle2.height;
            detObj.setBounds(rectangle4);
            this.hiliteWithHandles(graphics, detObj, vC);
            ++n3;
        }
    }

    public void mouseDragResize(Graphics graphics, Point point, VC vC) {
        int n;
        DetObj detObj = (DetObj)this.m_selList.elementAt(0);
        Rectangle rectangle = detObj.getBounds();
        Rectangle rectangle2 = vC.virtToDest(rectangle);
        IdentObj identObj = new IdentObj(1);
        Rectangle rectangle3 = vC.virtToDest(this.m_Perspective.getRect(identObj));
        rectangle3 = rectangle3.intersection(this.m_rBoundParent);
        this.hiliteWithHandles(graphics, detObj, vC);
        if (this.m_nActiveHandle == 7 || this.m_nActiveHandle == 0 || this.m_nActiveHandle == 6) {
            n = point.x - rectangle2.x - this.m_DeltaPos.x;
            n = Math.max(rectangle2.x + n, rectangle3.x + 1) - rectangle2.x;
            n = Math.min(rectangle2.width - 10, n);
            n = vC.destToVirtWidth(n);
            rectangle.x += n;
            rectangle.width -= n;
        } else if (this.m_nActiveHandle == 3 || this.m_nActiveHandle == 2 || this.m_nActiveHandle == 4) {
            n = point.x - rectangle2.x - this.m_DeltaPos.x;
            n = Math.min(rectangle2.x + n, rectangle3.x + rectangle3.width - 1) - rectangle2.x;
            n = Math.max(10, n);
            rectangle.width = n = vC.destToVirtWidth(n);
        }
        if (this.m_nActiveHandle == 1 || this.m_nActiveHandle == 0 || this.m_nActiveHandle == 2) {
            n = point.y - rectangle2.y - this.m_DeltaPos.y;
            n = Math.max(rectangle2.y + n, rectangle3.y + 1) - rectangle2.y;
            n = Math.min(rectangle2.height - 10, n);
            n = vC.destToVirtHeight(n);
            rectangle.height -= n;
        } else if (this.m_nActiveHandle == 5 || this.m_nActiveHandle == 6 || this.m_nActiveHandle == 4) {
            n = point.y - rectangle2.y - this.m_DeltaPos.y;
            n = Math.min(rectangle2.y + n, rectangle3.y + rectangle3.height - 1) - rectangle2.y;
            n = Math.max(10, n);
            n = vC.destToVirtHeight(n);
            rectangle.y -= n - rectangle.height;
            rectangle.height = n;
        }
        detObj.setBounds(rectangle);
        this.hiliteWithHandles(graphics, detObj, vC);
    }

    public void mouseDragRiserResize(Graphics graphics, Point point, VC vC) {
        this.hiliteResizer(graphics, this.firstDetObjElement(), vC);
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        IdentObj identObj = this.firstElement();
        int n = Math.abs(point.x - this.m_ptMouseDown.x);
        int n2 = Math.abs(point.y - this.m_ptMouseDown.y);
        if (this.m_bCanSwitchDirection) {
            if (n2 > n) {
                if (this.m_nDirection == 0) {
                    this.m_nDirection = 1;
                    this.m_item = jGraphType.getDataFormat().getDataItem(1);
                    this.m_nOriginalResizeCoord = this.m_nResizeCoord = vC.virtToDestY(this.m_Perspective.getDataCoord(identObj, this.m_item, false));
                    if (this.m_nScaling != 1) {
                        this.m_nOriginalResizeCoordBase = vC.virtToDestY(this.m_Perspective.getDataCoord(identObj, this.m_item, true)) - vC.virtToDestY(this.m_Perspective.getDataCoord(identObj, this.m_item, false));
                    }
                }
            } else if (this.m_nDirection == 1) {
                this.m_nDirection = 0;
                this.m_item = jGraphType.getDataFormat().getDataItem(1);
                this.m_nOriginalResizeCoord = this.m_nResizeCoord = vC.virtToDestX(this.m_Perspective.getDataCoord(identObj, this.m_item, false));
                if (this.m_nScaling != 1) {
                    this.m_nOriginalResizeCoordBase = vC.virtToDestX(this.m_Perspective.getDataCoord(identObj, this.m_item, true)) - vC.virtToDestX(this.m_Perspective.getDataCoord(identObj, this.m_item, false));
                }
            }
        }
        Rectangle rectangle = vC.virtToDest(this.m_Perspective.getFrameRect(true));
        rectangle = rectangle.intersection(this.m_rBoundParent);
        if (this.m_nDirection == 1) {
            if (point.y < rectangle.y) {
                point.y = rectangle.y;
            } else if (point.y > rectangle.y + rectangle.height) {
                point.y = rectangle.y + rectangle.height - 1;
            }
        } else if (point.x < rectangle.x) {
            point.x = rectangle.x;
        } else if (point.x > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width - 1;
        }
        Rectangle rectangle2 = vC.virtToDest(this.firstDetObjElement().getBounds());
        int n3 = vC.virtToDestWidth(1000);
        if (this.m_nDirection == 1) {
            this.m_nResizeCoord = point.x < rectangle2.x - n3 || point.x > rectangle2.x + rectangle2.width + n3 ? this.m_nOriginalResizeCoord : (this.m_nScaling == 1 ? point.y : point.y - this.m_nOriginalResizeCoordBase);
            this.m_nResizeValue = this.m_Perspective.getDataFromCoord(this.firstElement(), this.m_item, vC.destToVirtY(this.m_nResizeCoord));
        } else {
            this.m_nResizeCoord = point.y < rectangle2.y - n3 || point.y > rectangle2.y + rectangle2.height + n3 ? this.m_nOriginalResizeCoord : (this.m_nScaling == 1 ? point.x : point.x - this.m_nOriginalResizeCoordBase);
            this.m_nResizeValue = this.m_Perspective.getDataFromCoord(this.firstElement(), this.m_item, vC.destToVirtX(this.m_nResizeCoord));
        }
        this.hiliteResizer(graphics, this.firstDetObjElement(), vC);
        this.m_bDragged = true;
    }

    public void mouseDrag(Graphics graphics, Point point, VC vC) {
        if (this.m_nAction == 1) {
            this.mouseDragResize(graphics, point, vC);
        } else if (this.m_nAction == 2) {
            this.mouseDragMove(graphics, point, vC);
        } else if (this.m_nAction == 3) {
            this.mouseDragRiserResize(graphics, point, vC);
        }
    }

    public void cancelMoveDrag(Graphics graphics, VC vC) {
        if (this.m_nAction == 1) {
            DetObj detObj = (DetObj)this.m_selList.elementAt(0);
            this.hiliteWithHandles(graphics, detObj, vC);
            Rectangle rectangle = vC.destToVirt(this.m_rOriginalPos);
            detObj.setBounds(rectangle);
            this.hiliteWithHandles(graphics, detObj, vC);
        } else if (this.m_nAction == 2) {
            int n = 0;
            Enumeration enumeration = this.m_selList.elements();
            while (enumeration.hasMoreElements()) {
                DetObj detObj = (DetObj)enumeration.nextElement();
                if (!detObj.isMoveable()) continue;
                Rectangle rectangle = detObj.getBounds();
                Rectangle rectangle2 = vC.virtToDest(rectangle);
                this.hiliteWithHandles(graphics, detObj, vC);
                Rectangle rectangle3 = vC.destToVirt((Rectangle)this.m_MovingOriginal.elementAt(n));
                detObj.setBounds(rectangle3);
                this.hiliteWithHandles(graphics, detObj, vC);
                ++n;
            }
        } else if (this.m_nAction == 3) {
            this.hiliteResizer(graphics, this.firstDetObjElement(), vC);
            this.m_bDragged = false;
        }
        this.m_nAction = 0;
    }

    public void mouseUp(Graphics graphics, VC vC) {
        if (this.m_nAction == 1) {
            DetObj detObj = (DetObj)this.m_selList.elementAt(0);
            Rectangle rectangle = vC.virtToDest(detObj.getBounds());
            if (!rectangle.equals(this.m_rOriginalPos)) {
                this.m_Perspective.setRect(detObj.getIdentID(), detObj.getBounds());
                if (detObj.getIdentID().getObjectID() == 12) {
                    this.m_Perspective.getEventManager().notifyPerspectiveListener((Object)this.m_Perspective, 4001, 0);
                }
            }
        } else if (this.m_nAction == 2) {
            DetObj detObj = (DetObj)this.m_selList.elementAt(0);
            Rectangle rectangle = vC.virtToDest(detObj.getBounds());
            if (!rectangle.equals(this.m_rOriginalPos)) {
                Enumeration enumeration = this.m_selList.elements();
                while (enumeration.hasMoreElements()) {
                    detObj = (DetObj)enumeration.nextElement();
                    if (!detObj.isMoveable()) continue;
                    this.m_Perspective.setRect(detObj.getIdentID(), detObj.getBounds());
                    if (detObj.getIdentID().getObjectID() != 12) continue;
                    this.m_Perspective.getEventManager().notifyPerspectiveListener((Object)this.m_Perspective, 4001, 0);
                }
            }
        } else if (this.m_nAction == 3) {
            this.hiliteResizer(graphics, this.firstDetObjElement(), vC);
            if (this.m_bDragged) {
                this.m_Perspective.useWorkDataStorage();
                this.m_Perspective.setDataValue(this.firstElement(), this.m_item, this.m_nResizeValue);
            }
        }
        this.m_nAction = 0;
    }

    public DetObj nextDetObjElement() {
        Object var1_1 = null;
        ++this.m_nCurrentItem;
        if (this.hasMoreElements()) {
            return (DetObj)this.m_selList.elementAt(this.m_nCurrentItem);
        }
        return null;
    }

    public IdentObj nextElement() {
        IdentObj identObj = null;
        ++this.m_nCurrentItem;
        if (this.hasMoreElements()) {
            identObj = ((DetObj)this.m_selList.elementAt(this.m_nCurrentItem)).getIdentID();
            identObj = new IdentObj(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getStackID(), -3);
            return identObj;
        }
        return null;
    }

    public void setFirstElement(IdentObj identObj) {
        IdentObj identObj2;
        if (this.hasMoreElements() && (identObj2 = ((DetObj)this.m_selList.elementAt(0)).getIdentIDRef()) != null) {
            identObj2.copy(identObj);
        }
    }

    public DetObj testMouseDown(Point point, VC vC) {
        int n = this.m_Perspective.getSelectionEnable();
        if (n == 0) {
            return null;
        }
        Point point2 = vC.destToVirt(point);
        DetObj detObj = this.m_Perspective.getDetectiv().findNodeOf(point2.x, point2.y, vC);
        return detObj;
    }

    public int getResizeCursor(Point point) {
        DetObj detObj;
        int n = 0;
        int n2 = this.m_Perspective.getSelectionEnable();
        boolean bl = this.m_Perspective.getSelectionEnableMove();
        if (n2 != 0 && bl && this.m_selList.size() == 1 && (detObj = (DetObj)this.m_selList.elementAt(0)).isMoveable()) {
            int n3 = 0;
            boolean bl2 = false;
            while (n3 < 8 && !bl2) {
                if (this.m_rHandles[n3].contains(point.x, point.y)) {
                    bl2 = true;
                    continue;
                }
                ++n3;
            }
            switch (n3) {
                default: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = 6;
                    break;
                }
                case 1: {
                    n = 8;
                    break;
                }
                case 2: {
                    n = 7;
                    break;
                }
                case 3: {
                    n = 11;
                    break;
                }
                case 4: {
                    n = 5;
                    break;
                }
                case 5: {
                    n = 9;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                case 7: {
                    n = 10;
                }
            }
        }
        return n;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    private void handleIEJavascriptFunction(String string) {
        int n = string.indexOf(":");
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n > n2 || n2 > n3) {
            return;
        }
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(n2 + 1, n3);
        String[] stringArray = this.getJSArguments(string3);
    }

    private String[] getJSArguments(String string) {
        String[] stringArray;
        if (string == null || string.length() == 0) {
            return null;
        }
        Vector<String[]> vector = new Vector<String[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            vector.addElement(stringArray);
        }
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

