/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;

public class Polyline
implements Serializable {
    public int m_npoints;
    public int[] m_xpoints = new int[4];
    public int[] m_ypoints = new int[4];
    public int m_nThickness;
    public Polygon m_polygon;

    public Polyline(int[] nArray, int[] nArray2, int n, int n2) throws AssertionException {
        PfjAssert.pfjAssert(n >= 2);
        PfjAssert.pfjAssert(nArray.length >= n);
        PfjAssert.pfjAssert(nArray2.length >= n);
        PfjAssert.pfjAssert(n2 > 0);
        this.m_npoints = n;
        this.m_xpoints = new int[n];
        this.m_ypoints = new int[n];
        System.arraycopy(nArray, 0, this.m_xpoints, 0, n);
        System.arraycopy(nArray2, 0, this.m_ypoints, 0, n);
        this.m_nThickness = n2;
        int n3 = this.m_nThickness / 2;
        this.m_polygon = new Polygon();
        int n4 = 0;
        while (n4 < this.m_npoints) {
            this.m_polygon.addPoint(this.m_xpoints[n4], this.m_ypoints[n4] + n3);
            ++n4;
        }
        n4 = this.m_npoints - 1;
        while (n4 >= 0) {
            this.m_polygon.addPoint(this.m_xpoints[n4], this.m_ypoints[n4] - n3);
            --n4;
        }
        this.m_polygon.addPoint(this.m_xpoints[0], this.m_ypoints[0] + n3);
    }

    public void translate(int n, int n2) {
        this.m_polygon.translate(n, n2);
    }

    public Rectangle getBounds() {
        return this.m_polygon.getBounds();
    }
}

