/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import oracle.dss.graph.pfj.draw.ImageLoader;
import oracle.dss.graph.pfj.draw.OctreeNode;

class OctreeQuantizer {
    private static final int _MAX_COLORS = 255;
    private int _colors;
    private OctreeNode[] _listHead;
    private OctreeNode[] _listEnd;
    private int _maxDepth = 8;
    private OctreeNode _root = new OctreeNode(this);

    public OctreeQuantizer(Image image) {
        this();
        ImageLoader imageLoader = new ImageLoader(image);
        imageLoader.start();
        if (!imageLoader.waitFor()) {
            throw new IllegalArgumentException("Problem loading...");
        }
        int n = image.getWidth(imageLoader);
        int n2 = image.getHeight(imageLoader);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image.getSource(), 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalArgumentException("While grabbing pixels:");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf("Error while fetching image. grabbed ")) + nArray.length + " pixel values of the " + n + " x " + n2 + " image.");
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            this.addColor(nArray[n3]);
            ++n3;
        }
    }

    public static void mapColors(int[] nArray) {
        OctreeQuantizer octreeQuantizer = new OctreeQuantizer();
        int n = 0;
        while (n < nArray.length) {
            octreeQuantizer.addColor(nArray[n]);
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            nArray[n] = octreeQuantizer.mapColor(nArray[n]);
            ++n;
        }
    }

    public void addColor(int n) {
        this._root.addColor(n);
    }

    public int mapColor(int n) {
        return this._root.mapColor(n);
    }

    OctreeNode _getListHead(int n) {
        return this._listHead[n];
    }

    int _getMaxDepth() {
        return this._maxDepth;
    }

    void _incColors() {
        if (++this._colors > 255) {
            this._reduce();
        }
    }

    void _setListHead(int n, OctreeNode octreeNode) {
        this._listHead[n] = octreeNode;
        this._listEnd[n] = octreeNode;
    }

    void _setListEnd(int n, OctreeNode octreeNode) {
        this._listEnd[n]._setNext(octreeNode);
        this._listEnd[n] = octreeNode;
    }

    private OctreeQuantizer() {
        this._listHead = new OctreeNode[8];
        this._listEnd = new OctreeNode[8];
    }

    private OctreeNode _pickNode() {
        int n = this._maxDepth - 2;
        while (n >= 0) {
            OctreeNode octreeNode = this._getListHead(n);
            OctreeNode octreeNode2 = null;
            OctreeNode octreeNode3 = null;
            OctreeNode octreeNode4 = null;
            while (octreeNode != null) {
                if (octreeNode._getChildren() > 1 && (octreeNode3 == null || octreeNode._getChildren() < octreeNode3._getChildren())) {
                    octreeNode3 = octreeNode;
                    octreeNode4 = octreeNode2;
                }
                octreeNode2 = octreeNode;
                octreeNode = octreeNode._getNext();
            }
            if (octreeNode3 != null) {
                if (octreeNode4 == null) {
                    this._listHead[n] = octreeNode3._getNext();
                } else {
                    OctreeNode octreeNode5 = octreeNode3._getNext();
                    if (octreeNode5 == null) {
                        this._listEnd[n] = octreeNode4;
                    }
                    octreeNode4._setNext(octreeNode5);
                }
                return octreeNode3;
            }
            --this._maxDepth;
            --n;
        }
        return null;
    }

    private void _reduce() {
        OctreeNode octreeNode = this._pickNode();
        octreeNode._setMaxLevel(octreeNode._getLevel());
        octreeNode._computeColor();
        this._colors -= octreeNode._getChildren() - 1;
        octreeNode._setChildren(0);
    }
}

