/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import oracle.dss.graph.pfj.draw.GifEncoderHashitem;
import oracle.dss.graph.pfj.draw.ImageEncoder;
import oracle.dss.graph.pfj.draw.IntHashtable;

public class GifEncoder
extends ImageEncoder {
    private boolean interlace;
    int width;
    int height;
    int[][] rgbPixels;
    IntHashtable colorHash;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass;
    static final int EOF = -1;
    int rl_pixel;
    int rl_basecode;
    int rl_count;
    int rl_table_pixel;
    int rl_table_max;
    boolean just_cleared;
    int out_bits;
    int out_bits_init;
    int out_count;
    int out_bump;
    int out_bump_init;
    int out_clear;
    int out_clear_init;
    int max_ocodes;
    int code_clear;
    int code_eof;
    int obuf;
    int obits;
    byte[] oblock = new byte[256];
    int oblen;
    OutputStream imageStream;
    boolean VERBOSE;
    static final int BITS = 12;

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        super(imageProducer, outputStream);
    }

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream, boolean bl) throws IOException {
        super(imageProducer, outputStream);
        this.interlace = bl;
    }

    public GifEncoder(Image image, OutputStream outputStream) throws IOException {
        super(image, outputStream);
    }

    public GifEncoder(Image image, OutputStream outputStream, boolean bl) throws IOException {
        super(image, outputStream);
        this.interlace = bl;
    }

    void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    void encodeDone() throws IOException {
        Object object;
        int n;
        int n2 = -1;
        int n3 = -1;
        this.colorHash = new IntHashtable();
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.height) {
            n = n5 * this.width;
            int n6 = 0;
            while (n6 < this.width) {
                boolean bl;
                int n7 = this.rgbPixels[n5][n6];
                boolean bl2 = bl = n7 >>> 24 < 128;
                if (bl) {
                    if (n2 < 0) {
                        n2 = n4;
                        n3 = n7;
                    } else if (n7 != n3) {
                        this.rgbPixels[n5][n6] = n7 = n3;
                    }
                }
                if ((object = (GifEncoderHashitem)this.colorHash.get(n7)) == null) {
                    if (n4 >= 256) {
                        throw new IOException("too many colors for a GIF");
                    }
                    object = new GifEncoderHashitem(n7, 1, n4, bl);
                    ++n4;
                    this.colorHash.put(n7, object);
                } else {
                    ++((GifEncoderHashitem)object).count;
                }
                ++n6;
            }
            ++n5;
        }
        n5 = n4 <= 2 ? 1 : (n4 <= 4 ? 2 : (n4 <= 16 ? 4 : 8));
        n = 1 << n5;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        object = this.colorHash.elements();
        while (object.hasMoreElements()) {
            GifEncoderHashitem gifEncoderHashitem = (GifEncoderHashitem)object.nextElement();
            byArray[gifEncoderHashitem.index] = (byte)(gifEncoderHashitem.rgb >> 16 & 0xFF);
            byArray2[gifEncoderHashitem.index] = (byte)(gifEncoderHashitem.rgb >> 8 & 0xFF);
            byArray3[gifEncoderHashitem.index] = (byte)(gifEncoderHashitem.rgb & 0xFF);
        }
        this.GIFEncode(this.out, this.width, this.height, this.interlace, (byte)0, n2, n5, byArray, byArray2, byArray3);
    }

    void encodePixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        int n7 = 0;
        while (n7 < n4) {
            System.arraycopy(nArray, n7 * n6 + n5, this.rgbPixels[n2 + n7], n, n3);
            ++n7;
        }
    }

    void encodeStart(int n, int n2) throws IOException {
        this.width = n;
        this.height = n2;
        this.rgbPixels = new int[n2][n];
    }

    byte GetPixel(int n, int n2) throws IOException {
        GifEncoderHashitem gifEncoderHashitem = (GifEncoderHashitem)this.colorHash.get(this.rgbPixels[n2][n]);
        if (gifEncoderHashitem == null) {
            throw new IOException("color not found");
        }
        return (byte)gifEncoderHashitem.index;
    }

    void GIFEncode(OutputStream outputStream, int n, int n2, boolean bl, byte by, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this.Width = n;
        this.Height = n2;
        this.Interlace = bl;
        int n5 = 1 << n4;
        int n6 = 0;
        int n7 = 0;
        this.CountDown = n * n2;
        this.Pass = 0;
        int n8 = n4 <= 1 ? 2 : n4;
        this.curx = 0;
        this.cury = 0;
        this.Putbyte((byte)71, outputStream);
        this.Putbyte((byte)73, outputStream);
        this.Putbyte((byte)70, outputStream);
        this.Putbyte((byte)56, outputStream);
        this.Putbyte((byte)57, outputStream);
        this.Putbyte((byte)97, outputStream);
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        byte by2 = -128;
        by2 = (byte)(by2 | 0x70);
        by2 = (byte)(by2 | (byte)(n4 - 1));
        this.Putbyte(by2, outputStream);
        this.Putbyte(by, outputStream);
        this.Putbyte((byte)0, outputStream);
        int n9 = 0;
        while (n9 < n5) {
            this.Putbyte(byArray[n9], outputStream);
            this.Putbyte(byArray2[n9], outputStream);
            this.Putbyte(byArray3[n9], outputStream);
            ++n9;
        }
        if (n3 != -1) {
            this.Putbyte((byte)33, outputStream);
            this.Putbyte((byte)-7, outputStream);
            this.Putbyte((byte)4, outputStream);
            this.Putbyte((byte)1, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)n3, outputStream);
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)44, outputStream);
        this.Putword(n7, outputStream);
        this.Putword(n6, outputStream);
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        if (bl) {
            this.Putbyte((byte)64, outputStream);
        } else {
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)n8, outputStream);
        this.compress(n8 + 1, outputStream);
        this.Putbyte((byte)0, outputStream);
        this.Putbyte((byte)59, outputStream);
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte by = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return by & 0xFF;
    }

    void Putbyte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    void Putword(int n, OutputStream outputStream) throws IOException {
        this.Putbyte((byte)(n & 0xFF), outputStream);
        this.Putbyte((byte)(n >> 8 & 0xFF), outputStream);
    }

    void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    void write_block() {
        try {
            this.Putbyte((byte)(this.oblen & 0xFF), this.imageStream);
            this.imageStream.write(this.oblock, 0, this.oblen);
            this.oblen = 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void block_out(byte by) {
        this.oblock[this.oblen++] = by;
        if (this.oblen >= 255) {
            this.write_block();
        }
    }

    void block_flush() {
        if (this.oblen > 0) {
            this.write_block();
        }
    }

    void output(int n) {
        this.obuf |= n << this.obits;
        this.obits += this.out_bits;
        while (this.obits >= 8) {
            this.block_out((byte)(this.obuf & 0xFF));
            this.obuf >>= 8;
            this.obits -= 8;
        }
    }

    void output_flush() {
        if (this.obits > 0) {
            this.block_out((byte)this.obuf);
        }
        this.block_flush();
    }

    void did_clear() {
        this.out_bits = this.out_bits_init;
        this.out_bump = this.out_bump_init;
        this.out_clear = this.out_clear_init;
        this.out_count = 0;
        this.rl_table_max = 0;
        this.just_cleared = true;
    }

    void output_plain(int n) {
        this.just_cleared = false;
        this.output(n);
        ++this.out_count;
        if (this.out_count >= this.out_bump) {
            ++this.out_bits;
            this.out_bump += 1 << this.out_bits - 1;
        }
        if (this.out_count >= this.out_clear) {
            this.output(this.code_clear);
            this.did_clear();
        }
    }

    int isqrt(int n) {
        if (n < 2) {
            return n;
        }
        int n2 = n;
        int n3 = 1;
        while (n2 != 0) {
            n2 >>= 2;
            n3 <<= 1;
        }
        while ((n2 = (n / n3 + n3) / 2) != n3 && n2 != n3 + 1) {
            n3 = n2;
        }
        return n3;
    }

    int compute_triangle_count(int n, int n2) {
        int n3 = 0;
        int n4 = n2 * (n2 + 1) / 2;
        while (n >= n4) {
            n3 += n2;
            n -= n4;
        }
        if (n > 0) {
            int n5 = this.isqrt(n);
            while (n5 * (n5 + 1) >= 2 * n) {
                --n5;
            }
            while (n5 * (n5 + 1) < 2 * n) {
                ++n5;
            }
            n3 += n5;
        }
        return n3;
    }

    void max_out_clear() {
        this.out_clear = this.max_ocodes;
    }

    void reset_out_clear() {
        this.out_clear = this.out_clear_init;
        if (this.out_count >= this.out_clear) {
            this.output(this.code_clear);
            this.did_clear();
        }
    }

    void rl_flush_fromclear(int n) {
        this.max_out_clear();
        this.rl_table_pixel = this.rl_pixel;
        int n2 = 1;
        while (n > 0) {
            if (n2 == 1) {
                this.rl_table_max = 1;
                this.output_plain(this.rl_pixel);
                --n;
            } else if (n >= n2) {
                this.rl_table_max = n2;
                this.output_plain(this.rl_basecode + n2 - 2);
                n -= n2;
            } else if (n == 1) {
                ++this.rl_table_max;
                this.output_plain(this.rl_pixel);
                n = 0;
            } else {
                ++this.rl_table_max;
                this.output_plain(this.rl_basecode + n - 2);
                n = 0;
            }
            if (this.out_count == 0) {
                n2 = 1;
                continue;
            }
            ++n2;
        }
        this.reset_out_clear();
    }

    /*
     * Unable to fully structure code
     */
    void rl_flush_clearorrep(int var1_1) {
        block1: {
            var2_2 = 1 + this.compute_triangle_count(var1_1, this.max_ocodes);
            if (var2_2 >= var1_1) ** GOTO lbl9
            this.output(this.code_clear);
            this.did_clear();
            this.rl_flush_fromclear(var1_1);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.output_plain(this.rl_pixel);
                --var1_1;
lbl9:
                // 2 sources

                ** while (var1_1 > 0)
            }
        }
    }

    void rl_flush_withtable(int n) {
        int n2;
        int n3 = n / this.rl_table_max;
        int n4 = n % this.rl_table_max;
        int n5 = n2 = n4 != 0 ? 1 : 0;
        if (this.out_count + n3 + n2 > this.max_ocodes) {
            n3 = this.max_ocodes - this.out_count;
            n4 = n - n3 * this.rl_table_max;
            n2 = 1 + this.compute_triangle_count(n4, this.max_ocodes);
        }
        if (1 + this.compute_triangle_count(n, this.max_ocodes) < n3 + n2) {
            this.output(this.code_clear);
            this.did_clear();
            this.rl_flush_fromclear(n);
            return;
        }
        this.max_out_clear();
        while (n3 > 0) {
            this.output_plain(this.rl_basecode + this.rl_table_max - 2);
            --n3;
        }
        if (n4 != 0) {
            if (this.just_cleared) {
                this.rl_flush_fromclear(n4);
            } else if (n4 == 1) {
                this.output_plain(this.rl_pixel);
            } else {
                this.output_plain(this.rl_basecode + n4 - 2);
            }
        }
        this.reset_out_clear();
    }

    void rl_flush() {
        if (this.VERBOSE) {
            System.err.println(String.valueOf(String.valueOf("rl_flush [ ")) + this.rl_count + " " + this.rl_pixel + "\n");
        }
        if (this.rl_count == 1) {
            this.output_plain(this.rl_pixel);
            this.rl_count = 0;
            if (this.VERBOSE) {
                System.err.println("rl_flush ]\n");
            }
            return;
        }
        if (this.just_cleared) {
            this.rl_flush_fromclear(this.rl_count);
        } else if (this.rl_table_max < 2 || this.rl_table_pixel != this.rl_pixel) {
            this.rl_flush_clearorrep(this.rl_count);
        } else {
            this.rl_flush_withtable(this.rl_count);
        }
        if (this.VERBOSE) {
            System.err.println("rl_flush ]\n");
        }
        this.rl_count = 0;
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        this.obuf = 0;
        this.obits = 0;
        this.oblen = 0;
        this.imageStream = outputStream;
        this.code_clear = 1 << n - 1;
        this.code_eof = this.code_clear + 1;
        this.rl_basecode = this.code_eof + 1;
        this.out_bump_init = (1 << n - 1) - 1;
        this.out_clear_init = n <= 3 ? 9 : this.out_bump_init - 1;
        this.out_bits_init = n;
        this.max_ocodes = 4096 - ((1 << this.out_bits_init - 1) + 3);
        this.did_clear();
        this.output(this.code_clear);
        this.rl_count = 0;
        while (true) {
            int n2 = this.GIFNextPixel();
            if (this.rl_count > 0 && n2 != this.rl_pixel) {
                this.rl_flush();
            }
            if (n2 == -1) break;
            if (this.rl_pixel == n2) {
                ++this.rl_count;
                continue;
            }
            this.rl_pixel = n2;
            this.rl_count = 1;
        }
        this.output(this.code_eof);
        this.output_flush();
    }
}

