/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public abstract class FillSfxObj
extends FillObj {
    public Image createOvalMask(Component component, Rectangle rectangle) {
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(new Color(0, 0, 0));
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(new Color(255, 255, 255));
        graphics.fillOval(0, 0, rectangle.width, rectangle.height);
        graphics.dispose();
        return image;
    }

    protected Image createPolygonMask(Component component, Polygon polygon) {
        Perspective perspective = (Perspective)component;
        Rectangle rectangle = polygon.getBounds();
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(new Color(0, 0, 0));
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(new Color(255, 255, 255));
        int[] nArray = new int[polygon.npoints];
        int[] nArray2 = new int[polygon.npoints];
        int n = 0;
        while (n < polygon.npoints) {
            nArray[n] = polygon.xpoints[n] - rectangle.x;
            nArray2[n] = polygon.ypoints[n] - rectangle.y;
            ++n;
        }
        graphics.fillPolygon(nArray, nArray2, polygon.npoints);
        graphics.dispose();
        return image;
    }

    protected Image createAreaMask(Component component, Area area) {
        Perspective perspective = (Perspective)component;
        Rectangle rectangle = area.getBounds();
        BufferedImage bufferedImage = (BufferedImage)perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.setColor(new Color(255, 255, 255));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle.x, -rectangle.y);
        area = area.createTransformedArea(affineTransform);
        graphics2D.fill(area);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected Image createArc2DMask(Component component, Arc2D arc2D) {
        Perspective perspective = (Perspective)component;
        Rectangle rectangle = arc2D.getBounds2D().getBounds();
        BufferedImage bufferedImage = (BufferedImage)perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.setColor(new Color(255, 255, 255));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle.x, -rectangle.y);
        Shape shape = affineTransform.createTransformedShape(arc2D);
        graphics2D.fill(shape);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected Image createGeneralPathMask(Component component, GeneralPath generalPath) {
        Perspective perspective = (Perspective)component;
        Rectangle rectangle = generalPath.getBounds();
        BufferedImage bufferedImage = (BufferedImage)perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.setColor(new Color(255, 255, 255));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle.x, -rectangle.y);
        generalPath.transform(affineTransform);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        affineTransform = new AffineTransform();
        affineTransform.translate(rectangle.x, rectangle.y);
        generalPath.transform(affineTransform);
        return bufferedImage;
    }

    public Image createTextMask(Component component, String string, Rectangle rectangle, TextStyleObj textStyleObj, VC vC) {
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        return image;
    }

    private void fillClip(Graphics graphics, Component component, Image image, Image image2, Rectangle rectangle) {
        this.applyFilter(graphics, component, image, image2, rectangle, rectangle, null);
    }

    public void fillOval(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Perspective perspective = (Perspective)component;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image.getGraphics();
        this.fillSfxRect(graphics2, component, 0, 0, rectangle.width, rectangle.height);
        graphics2.dispose();
        this.applyFilter(graphics, component, image, this.createOvalMask(component, rectangle), rectangle, rectangle, null);
        image.flush();
    }

    public void fillPolygon(Graphics graphics, Component component, Polygon polygon) {
        this.fillPolygon(graphics, component, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(Graphics graphics, Component component, GeneralPath generalPath) {
        Rectangle rectangle = generalPath.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image.getGraphics();
        this.fillSfxRect(graphics2, component, 0, 0, rectangle.width, rectangle.height);
        graphics2.dispose();
        this.applyFilter(graphics, component, image, this.createGeneralPathMask(component, generalPath), rectangle, rectangle, null);
        image.flush();
    }

    public void fillPolygon(Graphics graphics, Component component, Area area) {
        Rectangle rectangle = area.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image.getGraphics();
        this.fillSfxRect(graphics2, component, 0, 0, rectangle.width, rectangle.height);
        graphics2.dispose();
        this.applyFilter(graphics, component, image, this.createAreaMask(component, area), rectangle, rectangle, null);
        image.flush();
    }

    public void fillPolygon(Graphics graphics, Component component, Arc2D arc2D) {
        Rectangle rectangle = arc2D.getBounds2D().getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image.getGraphics();
        this.fillSfxRect(graphics2, component, 0, 0, rectangle.width, rectangle.height);
        graphics2.dispose();
        this.applyFilter(graphics, component, image, this.createArc2DMask(component, arc2D), rectangle, rectangle, null);
        image.flush();
    }

    public void fillPolygon(Graphics graphics, Component component, int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        Rectangle rectangle = polygon.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image.getGraphics();
        this.fillSfxRect(graphics2, component, 0, 0, rectangle.width, rectangle.height);
        graphics2.dispose();
        this.applyFilter(graphics, component, image, this.createPolygonMask(component, polygon), rectangle, rectangle, null);
        image.flush();
    }

    public void fillRect(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(n3, n4);
        Graphics graphics2 = image.getGraphics();
        this.fillSfxRect(graphics2, component, 0, 0, n3, n4);
        graphics2.dispose();
        graphics.drawImage(image, n, n2, null);
        image.flush();
    }

    public void fillShadedPolygon(Graphics graphics, Component component, int[] nArray, int[] nArray2, int n, int n2) {
        this.fillPolygon(graphics, component, nArray, nArray2, n);
    }

    public abstract void copy(FillObj var1);

    protected abstract void fillSfxRect(Graphics var1, Component var2, int var3, int var4, int var5, int var6);
}

