/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.RotateImageFilter;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public abstract class FillObj
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("DRAW.FillObj");
    public static final int FILL_COLOR = 1;
    public static final int FILL_GRADIENT = 2;
    public static final int FILL_TEXTURE = 3;

    public void fillOval(Graphics graphics, Component component, Rectangle rectangle) {
        this.fillOval(graphics, component, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Color getColor() {
        return Color.white;
    }

    public void fillPolygon(Graphics graphics, Component component, Polygon polygon) {
        this.fillPolygon(graphics, component, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void fillPolygon(Graphics var1, Component var2, Area var3);

    public abstract void fillPolygon(Graphics var1, Component var2, Arc2D var3);

    public abstract void fillPolygon(Graphics var1, Component var2, GeneralPath var3);

    public void fillRect(Graphics graphics, Component component, Rectangle rectangle) {
        this.fillRect(graphics, component, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected boolean waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            while (!mediaTracker.checkID(0, true)) {
                mediaTracker.waitForAll();
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.warn("FillObj.waitForImage: InterruptedException caught");
        }
        catch (Throwable throwable) {
            LOG.error("FillObj.waitForImage: unexpected exception caught: ", throwable);
        }
        try {
            if (mediaTracker.isErrorAny()) {
                throw new AWTException(String.valueOf(String.valueOf("error with image ")) + image.toString());
            }
        }
        catch (AWTException aWTException) {
            System.err.println(String.valueOf(String.valueOf("Error with image ")) + image.toString());
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected int[] extractPixels(Component component, Image image, Rectangle rectangle) {
        int[] nArray = new int[rectangle.width * rectangle.height];
        this.waitForImage(component, image);
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, rectangle.width, rectangle.height, nArray, 0, rectangle.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            LOG.warn("extractPixels was interrupted waiting for pixels!");
            int[] nArray2 = null;
            return nArray2;
        }
        catch (Throwable throwable) {
            LOG.error("FillObj.extractPixels: unexpected error grabbing pixels: ", throwable);
            int[] nArray3 = null;
            return nArray3;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            LOG.warn("image fetch aborted or errored");
            return null;
        }
        return nArray;
    }

    protected void applyFilter(Graphics graphics, Component component, Image image, Image image2, Rectangle rectangle, Rectangle rectangle2, TextStyleObj textStyleObj) {
        int[] nArray = this.extractPixels(component, image, rectangle);
        int[] nArray2 = this.extractPixels(component, image2, rectangle);
        int n = 0;
        while (n < rectangle.height) {
            int n2 = 0;
            while (n2 < rectangle.width) {
                nArray[n * rectangle.width + n2] = nArray[n * rectangle.width + n2] & 0xFFFFFF;
                if ((nArray2[n * rectangle.width + n2] & 0xFFFFFF) != 0) {
                    nArray[n * rectangle.width + n2] = nArray[n * rectangle.width + n2] | 0xFF000000;
                }
                ++n2;
            }
            ++n;
        }
        image2.flush();
        Image image3 = component.createImage(new MemoryImageSource(rectangle.width, rectangle.height, nArray, 0, rectangle.width));
        Point point = new Point(rectangle2.x, rectangle2.y);
        graphics.drawImage(image3, point.x, point.y, null);
        image3.flush();
    }

    public void fillText(Graphics graphics, Component component, String string, Rectangle rectangle, Rectangle rectangle2, Color color, Dimension dimension, TextStyleObj textStyleObj, VC vC, Color color2, int n, boolean bl) {
        boolean bl2 = textStyleObj.getRotationAngle() != 0;
        Rectangle rectangle3 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        if (bl2) {
            int n2 = rectangle3.width;
            rectangle3.width = rectangle3.height;
            rectangle3.height = n2;
        }
        Dimension dimension2 = textStyleObj.preDraw(graphics, string, rectangle3, vC, dimension);
        rectangle3.width = Math.min(rectangle3.width, dimension2.width);
        rectangle3.height = Math.min(rectangle3.height, dimension2.height);
        if (rectangle3.width <= 1 || rectangle3.height <= 1) {
            return;
        }
        Perspective perspective = (Perspective)component;
        Image image = perspective.createOffscreenImage(rectangle3.width, rectangle3.height);
        Graphics graphics2 = image.getGraphics();
        Color color3 = Color.black;
        graphics2.setColor(color3);
        graphics2.fillRect(0, 0, rectangle3.width, rectangle3.height);
        graphics2.setColor(Color.white);
        textStyleObj.draw(graphics2, component, string, rectangle3, null, dimension, vC);
        graphics2.dispose();
        if (bl2) {
            image = component.createImage(new FilteredImageSource(image.getSource(), new RotateImageFilter(textStyleObj.getRotationAngle())));
        }
        Rectangle rectangle4 = bl2 ? new Rectangle(0, 0, rectangle3.height, rectangle3.width) : new Rectangle(0, 0, rectangle3.width, rectangle3.height);
        Image image2 = perspective.createOffscreenImage(rectangle4.width, rectangle4.height);
        graphics2 = image2.getGraphics();
        this.fillRect(graphics2, component, 0, 0, rectangle4.width, rectangle4.height);
        graphics2.dispose();
        try {
            this.applyFilter(graphics, component, image2, image, rectangle4, rectangle, textStyleObj);
        }
        catch (Throwable throwable) {
            LOG.error("FillObj.fillText: unexpected exception during applyFilter: ", throwable);
        }
    }

    public abstract void copy(FillObj var1);

    public abstract void fillOval(Graphics var1, Component var2, int var3, int var4, int var5, int var6);

    public abstract void fillPolygon(Graphics var1, Component var2, int[] var3, int[] var4, int var5);

    public abstract void fillRect(Graphics var1, Component var2, int var3, int var4, int var5, int var6);

    public abstract void fillShadedPolygon(Graphics var1, Component var2, int[] var3, int[] var4, int var5, int var6);
}

