/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.print.PrinterGraphics;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.ColorPinStripeObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.FillSfxObj;

public class FillGradientObj
extends FillSfxObj {
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int DOWN = 3;
    public static final int UP = 4;
    public static final int DOWN_LEFT = 5;
    public static final int UP_LEFT = 6;
    public static final int DOWN_RIGHT = 7;
    public static final int UP_RIGHT = 8;
    public static final int RADIAL = 9;
    public static final int RADIAL_TOPLEFT = 10;
    public static final int RADIAL_TOPRIGHT = 11;
    public static final int RADIAL_BOTTOMLEFT = 12;
    public static final int RADIAL_BOTTOMRIGHT = 13;
    public static final int RECTANGULAR = 14;
    private static final int GRADIENT_MAX = 14;
    private int m_nDirection;
    private ColorPinStripeObj m_ColorStripe = new ColorPinStripeObj();
    private Perspective m_Perspective;
    private double m_pos1 = -1.0;
    private double m_pos2 = -1.0;
    private double m_pos3 = -1.0;
    private Color m_leftColor1;
    private Color m_rightColor1;
    private Color m_leftColor2;
    private Color m_rightColor2;
    private Color m_leftColor3;
    private Color m_rightColor3;
    private int m_numPins;

    public FillGradientObj() {
        this.m_nDirection = 3;
    }

    public FillGradientObj(Perspective perspective, int n) {
        this.m_nDirection = n;
        this.m_Perspective = perspective;
    }

    public void copy(FillObj fillObj) {
        this.m_nDirection = ((FillGradientObj)fillObj).m_nDirection;
        this.m_ColorStripe.copy(((FillGradientObj)fillObj).m_ColorStripe);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof FillGradientObj) {
            FillGradientObj fillGradientObj = (FillGradientObj)object;
            bl = this.m_nDirection == fillGradientObj.m_nDirection && this.m_ColorStripe.equals(fillGradientObj.m_ColorStripe);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean is2DTech(Graphics graphics) {
        boolean bl = false;
        if (graphics instanceof PrinterGraphics) {
            if (this.m_Perspective.isSFXPrintingSmooth()) {
                bl = true;
            }
        } else if (graphics instanceof Graphics2D) {
            bl = true;
        }
        if (bl) {
            bl = false;
            if (this.m_nDirection >= 1 && this.m_nDirection <= 8) {
                if (this.m_numPins == 2) {
                    if (this.m_leftColor1.equals(this.m_rightColor1) && this.m_leftColor2.equals(this.m_rightColor2) && this.m_pos1 == 0.0 && this.m_pos2 == 1.0) {
                        bl = true;
                    }
                } else if (this.m_numPins == 3 && this.m_leftColor1.equals(this.m_rightColor1) && this.m_leftColor2.equals(this.m_rightColor2) && this.m_leftColor3.equals(this.m_rightColor3) && this.m_leftColor1.equals(this.m_leftColor3) && this.m_pos1 == 0.0 && this.m_pos2 == 0.5 && this.m_pos3 == 1.0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void fillPolygon(Graphics graphics, Component component, Area area) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, area, false);
        } else {
            super.fillPolygon(graphics, component, area);
        }
    }

    public void fillPolygon(Graphics graphics, Component component, Arc2D arc2D) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, arc2D, false);
        } else {
            super.fillPolygon(graphics, component, arc2D);
        }
    }

    public void fillPolygon(Graphics graphics, Component component, Polygon polygon) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, polygon, false);
        } else {
            super.fillPolygon(graphics, component, polygon);
        }
    }

    public void fillPolygon(Graphics graphics, Component component, GeneralPath generalPath) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, generalPath, false);
        } else {
            super.fillPolygon(graphics, component, generalPath);
        }
    }

    public void fillRect(Graphics graphics, Component component, Rectangle rectangle) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, rectangle, false);
        } else {
            super.fillRect(graphics, component, rectangle);
        }
    }

    public void fillOval(Graphics graphics, Component component, Rectangle rectangle) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, rectangle, true);
        } else {
            super.fillOval(graphics, component, rectangle);
        }
    }

    public void fill(Graphics2D graphics2D, Component component, Shape shape, boolean bl) {
        Rectangle rectangle = shape instanceof Arc2D ? shape.getBounds2D().getBounds() : shape.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        boolean bl2 = false;
        Color color = this.m_leftColor1;
        Color color2 = this.m_leftColor2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.m_numPins == 2) {
            switch (this.m_nDirection) {
                case 2: {
                    color = this.m_leftColor2;
                    color2 = this.m_leftColor1;
                }
                case 1: {
                    n = rectangle.x;
                    n3 = rectangle.y;
                    n2 = rectangle.x + rectangle.width;
                    n4 = rectangle.y;
                    break;
                }
                case 4: {
                    color = this.m_leftColor2;
                    color2 = this.m_leftColor1;
                }
                case 3: {
                    n = rectangle.x;
                    n3 = rectangle.y;
                    n2 = rectangle.x;
                    n4 = rectangle.y + rectangle.height;
                    break;
                }
                case 7: {
                    n = rectangle.x;
                    n3 = rectangle.y;
                    n2 = rectangle.x + rectangle.width;
                    n4 = rectangle.y + rectangle.height;
                    break;
                }
                case 5: {
                    n = rectangle.x + rectangle.width;
                    n3 = rectangle.y;
                    n2 = rectangle.x;
                    n4 = rectangle.y + rectangle.height;
                    break;
                }
                case 6: {
                    n = rectangle.x + rectangle.width;
                    n3 = rectangle.y + rectangle.height;
                    n2 = rectangle.x;
                    n4 = rectangle.y;
                    break;
                }
                case 8: {
                    n = rectangle.x;
                    n3 = rectangle.y + rectangle.height;
                    n2 = rectangle.x + rectangle.width;
                    n4 = rectangle.y;
                }
            }
        } else if (this.m_numPins == 3) {
            bl2 = true;
            switch (this.m_nDirection) {
                case 1: 
                case 2: {
                    n = rectangle.x;
                    n3 = rectangle.y;
                    n2 = rectangle.x + rectangle.width / 2;
                    n4 = rectangle.y;
                    break;
                }
                case 3: 
                case 4: {
                    n = rectangle.x;
                    n3 = rectangle.y;
                    n2 = rectangle.x;
                    n4 = rectangle.y + rectangle.height / 2;
                    break;
                }
                case 7: {
                    n = rectangle.x;
                    n3 = rectangle.y;
                    n2 = rectangle.x + rectangle.width / 2;
                    n4 = rectangle.y + rectangle.height / 2;
                    break;
                }
                case 5: {
                    n = rectangle.x + rectangle.width / 2;
                    n3 = rectangle.y;
                    n2 = rectangle.x;
                    n4 = rectangle.y + rectangle.height / 2;
                    break;
                }
                case 6: {
                    n = rectangle.x + rectangle.width;
                    n3 = rectangle.y + rectangle.height;
                    n2 = rectangle.x + rectangle.width / 2;
                    n4 = rectangle.y + rectangle.height / 2;
                    break;
                }
                case 8: {
                    n = rectangle.x;
                    n3 = rectangle.y + rectangle.height;
                    n2 = rectangle.x + rectangle.width / 2;
                    n4 = rectangle.y + rectangle.height / 2;
                }
            }
        }
        GradientPaint gradientPaint = new GradientPaint(n, n3, color, n2, n4, color2, bl2);
        graphics2D.setPaint(gradientPaint);
        if (bl) {
            Rectangle rectangle2 = (Rectangle)shape;
            graphics2D.fillOval(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } else {
            graphics2D.fill(shape);
        }
    }

    private void downGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        ColorObj colorObj = new ColorObj();
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = n2;
        while (n7 < n6) {
            this.m_ColorStripe.getColorAt((double)(n7 - n2) / (double)n4, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.drawLine(n, n7, n5, n7);
            ++n7;
        }
    }

    private void downLeftGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = n4 * n4 / n3 + n3;
        double d2 = n3 * n3 / n4 + n4;
        int n5 = (int)Math.max(d, d2);
        ColorObj colorObj = new ColorObj();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        int n6 = 0;
        while (n6 < n5) {
            double d3 = (double)n6 / (double)n5;
            this.m_ColorStripe.getColorAt(d3, colorObj);
            graphics2D.setColor(colorObj.getColor());
            nArray[0] = (int)((double)n3 - d3 * d) + n;
            nArray2[0] = n2;
            nArray[1] = n + n3;
            nArray2[1] = (int)(d3 * d2) + n2;
            nArray[2] = nArray[1] - 5;
            nArray2[2] = nArray2[1] + 5;
            nArray[3] = nArray[0] - 5;
            nArray2[3] = nArray2[0] + 5;
            graphics2D.drawPolygon(nArray, nArray2, 4);
            ++n6;
        }
    }

    private void downRightGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = n4 * n4 / n3 + n3;
        double d2 = n3 * n3 / n4 + n4;
        int n5 = (int)Math.max(d, d2);
        ColorObj colorObj = new ColorObj();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        int n6 = 0;
        while (n6 < n5) {
            double d3 = (double)n6 / (double)n5;
            this.m_ColorStripe.getColorAt(d3, colorObj);
            graphics2D.setColor(colorObj.getColor());
            nArray[0] = (int)(d3 * d) + n;
            nArray2[0] = n2;
            nArray[1] = n;
            nArray2[1] = (int)(d3 * d2) + n2;
            nArray[2] = nArray[1] - 5;
            nArray2[2] = nArray2[1] - 5;
            nArray[3] = nArray[0] - 5;
            nArray2[3] = nArray2[0] - 5;
            graphics2D.drawPolygon(nArray, nArray2, 4);
            ++n6;
        }
    }

    public void fillSfxRect(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        switch (this.m_nDirection) {
            case 1: {
                this.rightGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 2: {
                this.leftGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 3: {
                this.downGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 4: {
                this.upGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 9: {
                this.radialGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 5: {
                this.downLeftGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 6: {
                this.upLeftGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 7: {
                this.downRightGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 8: {
                this.upRightGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 10: {
                this.radialTopLeftGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 11: {
                this.radialTopRightGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 12: {
                this.radialBottomLeftGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 13: {
                this.radialBottomRightGradient(graphics, n, n2, n3, n4);
                break;
            }
            case 14: {
                this.rectangularGradient(graphics, n, n2, n3, n4);
            }
        }
    }

    public void insertPin(double d, ColorObj colorObj, ColorObj colorObj2) {
        this.m_ColorStripe.insertPin(d, colorObj, colorObj2);
        if (this.m_pos1 == (double)-1) {
            this.m_pos1 = d;
            this.m_leftColor1 = colorObj.getColor();
            this.m_rightColor1 = colorObj2.getColor();
        } else if (this.m_pos2 == (double)-1) {
            this.m_pos2 = d;
            this.m_leftColor2 = colorObj.getColor();
            this.m_rightColor2 = colorObj2.getColor();
        } else if (this.m_pos3 == (double)-1) {
            this.m_pos3 = d;
            this.m_leftColor3 = colorObj.getColor();
            this.m_rightColor3 = colorObj2.getColor();
        }
        ++this.m_numPins;
    }

    private void leftGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        ColorObj colorObj = new ColorObj();
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = n5 - 1;
        while (n7 >= n) {
            this.m_ColorStripe.getColorAt(1.0 - (double)(n7 - n) / (double)n3, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.drawLine(n7, n2, n7, n6);
            --n7;
        }
    }

    private void radialBottomLeftGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 3 * n3;
        int n6 = 3 * n4;
        int n7 = -n5 / 2 + n;
        int n8 = -n6 / 2 + n2;
        int n9 = Math.max(n5, n6) / 2;
        ColorObj colorObj = new ColorObj();
        int n10 = n9 - 1;
        while (n10 >= 0) {
            double d = (double)n10 / (double)n9;
            this.m_ColorStripe.getColorAt(d, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.fillOval((int)((double)n7 + (1.0 - d) * (double)n5 / (double)2), (int)((double)n8 + (1.0 - d) * (double)n6 / (double)2 + (double)n4), (int)((double)n5 * d), (int)((double)n6 * d));
            --n10;
        }
    }

    private void radialBottomRightGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 3 * n3;
        int n6 = 3 * n4;
        int n7 = -n5 / 2 + n;
        int n8 = -n6 / 2 + n2;
        int n9 = Math.max(n5, n6) / 2;
        ColorObj colorObj = new ColorObj();
        int n10 = n9 - 1;
        while (n10 >= 0) {
            double d = (double)n10 / (double)n9;
            this.m_ColorStripe.getColorAt(d, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.fillOval((int)((double)n7 + (1.0 - d) * (double)n5 / (double)2 + (double)n3), (int)((double)n8 + (1.0 - d) * (double)n6 / (double)2 + (double)n4), (int)((double)n5 * d), (int)((double)n6 * d));
            --n10;
        }
    }

    private void radialGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = -n3 / 4 + n;
        int n7 = -n4 / 4 + n2;
        int n8 = n3 + n3 / 2;
        int n9 = n4 + n4 / 2;
        int n10 = n5 = Math.max(n8, n9) / 2;
        while (n10 >= 0) {
            ColorObj colorObj = new ColorObj();
            double d = (double)n10 / (double)n5;
            this.m_ColorStripe.getColorAt(d, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.fillOval((int)((double)(n6 + n8 / 2) - d * (double)n8 / (double)2), (int)((double)(n7 + n9 / 2) - d * (double)n9 / (double)2), (int)((double)2 * (d * (double)n8 / (double)2)), (int)((double)2 * (d * (double)n9 / (double)2)));
            --n10;
        }
    }

    private void radialTopLeftGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 3 * n3;
        int n6 = 3 * n4;
        int n7 = -n5 / 2 + n;
        int n8 = -n6 / 2 + n2;
        int n9 = Math.max(n5, n6) / 2;
        ColorObj colorObj = new ColorObj();
        int n10 = n9 - 1;
        while (n10 >= 0) {
            double d = (double)n10 / (double)n9;
            this.m_ColorStripe.getColorAt(d, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.fillOval((int)((double)n7 + (1.0 - d) * (double)n5 / (double)2), (int)((double)n8 + (1.0 - d) * (double)n6 / (double)2), (int)((double)n5 * d), (int)((double)n6 * d));
            --n10;
        }
    }

    private void radialTopRightGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 3 * n3;
        int n6 = 3 * n4;
        int n7 = -n5 / 2 + n;
        int n8 = -n6 / 2 + n2;
        int n9 = Math.max(n5, n6) / 2;
        ColorObj colorObj = new ColorObj();
        int n10 = n9 - 1;
        while (n10 >= 0) {
            double d = (double)n10 / (double)n9;
            this.m_ColorStripe.getColorAt(d, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.fillOval((int)((double)n7 + (1.0 - d) * (double)n5 / (double)2 + (double)n3), (int)((double)n8 + (1.0 - d) * (double)n6 / (double)2), (int)((double)n5 * d), (int)((double)n6 * d));
            --n10;
        }
    }

    private void rightGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        ColorObj colorObj = new ColorObj();
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = n;
        while (n7 < n5) {
            this.m_ColorStripe.getColorAt((double)(n7 - n) / (double)n3, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.drawLine(n7, n2, n7, n6);
            ++n7;
        }
    }

    public void setDirection(int n) {
        if (n < 1 || n > 14) {
            throw new AssertionException(1, 14, n);
        }
        this.m_nDirection = n;
    }

    private void upGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        ColorObj colorObj = new ColorObj();
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = n6 - 1;
        while (n7 >= n2) {
            this.m_ColorStripe.getColorAt(1.0 - (double)(n7 - n2) / (double)n4, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.drawLine(n, n7, n5, n7);
            --n7;
        }
    }

    private void upRightGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = n4 * n4 / n3 + n3;
        double d2 = n3 * n3 / n4 + n4;
        int n5 = (int)Math.max(d, d2);
        ColorObj colorObj = new ColorObj();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        int n6 = n5 - 1;
        while (n6 >= 0) {
            double d3 = (double)n6 / (double)n5;
            this.m_ColorStripe.getColorAt(1.0 - d3, colorObj);
            graphics2D.setColor(colorObj.getColor());
            nArray[0] = (int)((double)n3 - d3 * d) + n;
            nArray2[0] = n2;
            nArray[1] = n + n3;
            nArray2[1] = (int)(d3 * d2) + n2;
            nArray[2] = nArray[1] - 5;
            nArray2[2] = nArray2[1] + 5;
            nArray[3] = nArray[0] - 5;
            nArray2[3] = nArray2[0] + 5;
            graphics2D.drawPolygon(nArray, nArray2, 4);
            --n6;
        }
    }

    private void upLeftGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = n4 * n4 / n3 + n3;
        double d2 = n3 * n3 / n4 + n4;
        int n5 = (int)Math.max(d, d2);
        ColorObj colorObj = new ColorObj();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        int n6 = n5 - 1;
        while (n6 >= 0) {
            double d3 = (double)n6 / (double)n5;
            this.m_ColorStripe.getColorAt(1.0 - d3, colorObj);
            graphics2D.setColor(colorObj.getColor());
            nArray[0] = (int)(d3 * d) + n;
            nArray2[0] = n2;
            nArray[1] = n;
            nArray2[1] = (int)(d3 * d2) + n2;
            nArray[2] = nArray[1] + 5;
            nArray2[2] = nArray2[1] + 5;
            nArray[3] = nArray[0] + 5;
            nArray2[3] = nArray2[0] + 5;
            graphics2D.drawPolygon(nArray, nArray2, 4);
            --n6;
        }
    }

    private void rectangularGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = -n3 / 4 + n;
        int n6 = -n4 / 4 + n2;
        int n7 = n3 + n3 / 2;
        int n8 = n4 + n4 / 2;
        int n9 = Math.max(n7, n8) / 2;
        int n10 = n9 - 1;
        while (n10 >= 0) {
            ColorObj colorObj = new ColorObj();
            double d = (double)n10 / (double)n9;
            this.m_ColorStripe.getColorAt(d, colorObj);
            graphics.setColor(colorObj.getColor());
            graphics.fillRect((int)((double)(n5 + n7 / 2) - d * (double)n7 / (double)2), (int)((double)(n6 + n8 / 2) - d * (double)n8 / (double)2), (int)((double)2 * (d * (double)n7 / (double)2)), (int)((double)2 * (d * (double)n8 / (double)2)));
            --n10;
        }
    }

    public Color getColorAt(double d) {
        ColorObj colorObj = new ColorObj();
        this.m_ColorStripe.getColorAt(d, colorObj);
        return colorObj.getColor();
    }
}

