/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.PixelGrabber;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class FillColorObj
extends FillObj {
    private ColorObj m_ColorFill;

    public FillColorObj() {
        this.m_ColorFill = new ColorObj();
    }

    public FillColorObj(Color color) {
        this.m_ColorFill = new ColorObj(color);
    }

    public void copy(FillObj fillObj) {
        this.m_ColorFill.copy(((FillColorObj)fillObj).m_ColorFill);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof FillColorObj) {
            FillColorObj fillColorObj = (FillColorObj)object;
            bl = this.m_ColorFill.equals(fillColorObj.m_ColorFill);
        } else {
            bl = false;
        }
        return bl;
    }

    public void fillOval(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        graphics.setColor(this.m_ColorFill.getColor());
        graphics.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(Graphics graphics, Component component, Polygon polygon) {
        graphics.setColor(this.m_ColorFill.getColor());
        graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(Graphics graphics, Component component, GeneralPath generalPath) {
        graphics.setColor(this.m_ColorFill.getColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(generalPath);
    }

    public void fillPolygon(Graphics graphics, Component component, Area area) {
        graphics.setColor(this.m_ColorFill.getColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(area);
    }

    public void fillPolygon(Graphics graphics, Component component, Arc2D arc2D) {
        graphics.setColor(this.m_ColorFill.getColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(arc2D);
    }

    public void fillPolygon(Graphics graphics, Component component, int[] nArray, int[] nArray2, int n) {
        graphics.setColor(this.m_ColorFill.getColor());
        graphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillRect(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        graphics.setColor(this.m_ColorFill.getColor());
        graphics.fillRect(n, n2, n3, n4);
    }

    public void fillShadedPolygon(Graphics graphics, Component component, int[] nArray, int[] nArray2, int n, int n2) {
        ColorObj colorObj = new ColorObj(this.m_ColorFill);
        colorObj.shadeColor(n2);
        graphics.setColor(colorObj.getColor());
        graphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillText(Graphics graphics, Component component, String string, Rectangle rectangle, Rectangle rectangle2, Color color, Dimension dimension, TextStyleObj textStyleObj, VC vC, Color color2, int n, boolean bl) {
        graphics.setColor(this.m_ColorFill.getColor());
        if (textStyleObj.getRotationAngle() == 0) {
            textStyleObj.draw(graphics, component, string, rectangle2, color, dimension, vC);
        } else if (n == 2) {
            super.fillText(graphics, component, string, rectangle, rectangle2, color, dimension, textStyleObj, vC, color2, n, bl);
        } else {
            this.fillTextRotated(graphics, component, string, rectangle2, color, dimension, textStyleObj, vC, color2, n, bl);
        }
    }

    public void fillTextRotated(Graphics graphics, Component component, String string, Rectangle rectangle, Color color, Dimension dimension, TextStyleObj textStyleObj, VC vC, Color color2, int n, boolean bl) {
        Object object;
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.height, rectangle.width);
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (textStyleObj != null && textStyleObj.getWordWrap()) {
            object = textStyleObj.preDraw(graphics, string, rectangle2, vC, dimension);
            rectangle2.width = Math.max(rectangle2.width, ((Dimension)object).width);
            rectangle2.height = Math.max(rectangle2.height, ((Dimension)object).height);
        }
        if (rectangle2.width <= 1 || rectangle2.height <= 1) {
            return;
        }
        rectangle3.height = rectangle2.width;
        rectangle3.width = rectangle2.height;
        object = (Graphics2D)graphics;
        AffineTransform affineTransform = ((Graphics2D)object).getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        int n2 = rectangle3.width;
        int n3 = rectangle3.height;
        int n4 = rectangle3.width;
        rectangle3.width = rectangle3.height;
        rectangle3.height = n4;
        rectangle3.y = rectangle3.y + n3 / 2 - n2 / 2;
        rectangle3.x = rectangle3.x - n3 / 2 + n2 / 2;
        if (textStyleObj.getRotationAngle() == 2) {
            affineTransform2.rotate(Math.toRadians(90.0), rectangle3.x + rectangle3.width / 2, rectangle3.y + rectangle3.height / 2);
        } else if (textStyleObj.getRotationAngle() == 1) {
            affineTransform2.rotate(Math.toRadians(270.0), rectangle3.x + rectangle3.width / 2, rectangle3.y + rectangle3.height / 2);
        }
        ((Graphics2D)object).transform(affineTransform2);
        textStyleObj.draw((Graphics)object, component, string, rectangle3, color, dimension, vC);
        ((Graphics2D)object).setTransform(affineTransform);
    }

    private void drawImageJDKPatch(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interrupted waiting for pixels in drawImageJDKPatch!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("Image fetch aborted or errored in drawImageJDKPatch!");
            return;
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = n + n6;
                int n8 = n2 + n5;
                int n9 = nArray[n5 * n3 + n6];
                int n10 = n9 >> 24 & 0xFF;
                int n11 = n9 >> 16 & 0xFF;
                int n12 = n9 >> 8 & 0xFF;
                int n13 = n9 & 0xFF;
                Color color = graphics.getColor();
                graphics.setColor(new Color(n11, n12, n13));
                graphics.drawLine(n7, n8, n7, n8);
                graphics.setColor(color);
                ++n6;
            }
            ++n5;
        }
    }

    public Color getColor() {
        return this.m_ColorFill.getColor();
    }

    public void setColor(int n, int n2, int n3, int n4) {
        this.m_ColorFill = new ColorObj(n, n2, n3, n4);
    }
}

