/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PrinterGraphics;
import oracle.bali.ewt.print.PrinterGraphics2DProxy;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class DetOval
extends DetObj {
    Rectangle m_rBounds;
    boolean m_bNoFill;
    boolean m_bDrawCircular;
    boolean m_bDestCoords;
    Rectangle m_rDestBounds;
    Polygon m_polygon;
    boolean m_bClip;
    int m_nReferenceLineWidth;
    int m_nUnitWidth;

    public DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, null, false, true, false, false);
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, rectangle, bl, bl2, false, false);
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, rectangle, bl, bl2, bl3, true);
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n5, int n6) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, rectangle, bl, bl2, bl3, true, n5, n6);
    }

    private DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n5, int n6) {
        super(detectiv, identObj, blackBoxIF, rectangle, bl, bl2);
        this.m_rBounds = new Rectangle(n, n2, n3, n4);
        this.m_bNoFill = bl3;
        this.m_bDrawCircular = bl4;
        this.m_nReferenceLineWidth = n5;
        this.m_nUnitWidth = n6;
    }

    private DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(detectiv, identObj, blackBoxIF, rectangle, bl, bl2);
        this.m_rBounds = new Rectangle(n, n2, n3, n4);
        this.m_bNoFill = bl3;
        this.m_bDrawCircular = bl4;
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, boolean bl) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, null, true, true, false, bl);
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, boolean bl, boolean bl2) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, null, bl, bl2, false, false);
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, int n, int n2, BlackBoxIF blackBoxIF, Rectangle rectangle) {
        this(detectiv, identObj, 0, 0, n, n2, blackBoxIF, rectangle, false, true, false, false);
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, Rectangle rectangle, BlackBoxIF blackBoxIF, Rectangle rectangle2) {
        this(detectiv, identObj, rectangle.x, rectangle.y, rectangle.width, rectangle.height, blackBoxIF, rectangle2, false, true, false, false);
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, Rectangle rectangle, BlackBoxIF blackBoxIF, boolean bl, Polygon polygon) {
        super(detectiv, identObj, blackBoxIF, null, false, true);
        this.m_bDestCoords = bl;
        this.m_rDestBounds = rectangle;
        this.m_polygon = polygon;
        this.m_bNoFill = false;
        this.m_bDrawCircular = false;
    }

    public DetOval(Detectiv detectiv, IdentObj identObj, Rectangle rectangle, BlackBoxIF blackBoxIF, boolean bl, Polygon polygon, Rectangle rectangle2) {
        super(detectiv, identObj, blackBoxIF, rectangle2, false, true);
        this.m_bDestCoords = bl;
        this.m_rDestBounds = rectangle;
        this.m_polygon = polygon;
        this.m_bNoFill = false;
        this.m_bDrawCircular = false;
        this.m_bClip = rectangle2 != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DetOval)) {
            return false;
        }
        DetOval detOval = (DetOval)object;
        return this.m_id.equals(detOval.m_id);
    }

    public Rectangle getBounds() {
        Rectangle rectangle = null;
        rectangle = this.m_bDestCoords ? (this.m_rDestBounds != null ? this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds) : this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_polygon.getBounds())) : this.m_rBounds;
        if (this.m_bClip && rectangle != null) {
            rectangle = rectangle.intersection(this.m_clipRect);
        }
        return rectangle;
    }

    public Rectangle getBounds(VC vC) {
        Rectangle rectangle = null;
        if (this.m_bDrawCircular) {
            Rectangle rectangle2 = vC.virtToDest(new Rectangle(this.m_rBounds.x, this.m_rBounds.y, this.m_rBounds.width, this.m_rBounds.height));
            int n = Math.min(rectangle2.width, rectangle2.height);
            rectangle2.x += (rectangle2.width - n) / 2;
            rectangle2.y += (rectangle2.height - n) / 2;
            rectangle2.width = rectangle2.height = n;
            rectangle = vC.destToVirt(rectangle2);
        } else {
            rectangle = this.m_bDestCoords ? (this.m_rDestBounds != null ? vC.destToVirt(this.m_rDestBounds) : vC.destToVirt(this.m_polygon.getBounds())) : this.m_rBounds;
        }
        if (this.m_bClip && rectangle != null) {
            rectangle = rectangle.intersection(this.m_clipRect);
        }
        return rectangle;
    }

    public void hilite(Graphics graphics, VC vC) {
        Object object;
        Shape shape = null;
        if (this.m_bClip) {
            object = vC.virtToDest(this.m_clipRect);
            shape = graphics.getClip();
            graphics.setClip((Shape)object);
        }
        if (this.m_bDestCoords && this.m_polygon != null && (this.m_rDestBounds == null || this.m_rDestBounds.height < 26)) {
            graphics.setXORMode(Color.yellow);
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setStroke(new BasicStroke(1.0f, 1, 1));
            ((Graphics)object).drawPolygon(this.m_polygon);
            graphics.setPaintMode();
            if (shape != null) {
                graphics.setClip(shape);
            }
            return;
        }
        object = this.m_bDestCoords && this.m_rDestBounds != null ? this.m_rDestBounds : vC.virtToDest(this.getBounds(vC));
        graphics.setXORMode(Color.yellow);
        graphics.drawOval(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        graphics.setPaintMode();
        if (this.m_bClip) {
            graphics.setClip(shape);
        }
    }

    public boolean isPointInObj(int n, int n2, VC vC) {
        int n3 = vC.destToVirtHeight(5);
        int n4 = vC.destToVirtWidth(5);
        Rectangle rectangle = this.getBounds(vC);
        if (this.m_bNoFill) {
            rectangle.grow(n4 / 2, n3 / 2);
            if (!this.isPointInOval(n, n2, rectangle, vC)) {
                return false;
            }
            rectangle.grow(-n4, -n3);
            return !this.isPointInOval(n, n2, rectangle, vC);
        }
        return this.isPointInOval(n, n2, rectangle, vC);
    }

    public boolean isPointInObj(Point point, VC vC) {
        return this.isPointInObj(point.x, point.y, vC);
    }

    private boolean isPointInOval(int n, int n2, Rectangle rectangle, VC vC) {
        boolean bl;
        if (!this.m_bDetectable) {
            return false;
        }
        if (this.m_bClip && !this.m_clipRect.contains(n, n2)) {
            return false;
        }
        if (!this.m_bDestCoords) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            bl = !rectangle.contains(n, n2) ? false : (d6 = (double)n - (d5 = (double)rectangle.x + (double)rectangle.width / 2.0)) * d6 / ((d4 = (double)rectangle.width / 2.0) * d4) + (d3 = (double)n2 - (d2 = (double)rectangle.y + (double)rectangle.height / 2.0)) * d3 / ((d = (double)rectangle.height / 2.0) * d) <= 1.0;
        } else if (this.m_rDestBounds != null && !this.m_rDestBounds.contains(vC.virtToDestX(n), vC.virtToDestY(n2))) {
            bl = false;
        } else if (this.m_polygon != null) {
            bl = this.m_polygon.contains(vC.virtToDestX(n), vC.virtToDestY(n2));
        } else {
            rectangle = this.m_rDestBounds != null ? this.m_rDestBounds : this.m_polygon.getBounds();
            double d = (double)rectangle.width / 2.0;
            double d7 = (double)rectangle.height / 2.0;
            double d8 = (double)rectangle.x + (double)rectangle.width / 2.0;
            double d9 = (double)rectangle.y + (double)rectangle.height / 2.0;
            double d10 = (double)vC.virtToDestX(n) - d8;
            double d11 = (double)vC.virtToDestY(n2) - d9;
            bl = d10 * d10 / (d * d) + d11 * d11 / (d7 * d7) <= 1.0;
        }
        return bl;
    }

    public void paintIt(Graphics graphics, VC vC) {
        Shape shape = null;
        if (this.m_bClip) {
            Rectangle rectangle = vC.virtToDest(this.m_clipRect);
            shape = graphics.getClip();
            if (shape == null) {
                graphics.setClip(rectangle);
            }
        }
        if (this.m_bDestCoords) {
            if (!(graphics instanceof PrinterGraphics) && this.m_rDestBounds != null && this.m_rDestBounds.height > 25) {
                this.m_blackBox.paint(graphics, this.m_rDestBounds, true, this.m_bNoFill);
            } else if (graphics instanceof PrinterGraphics && !(graphics instanceof PrinterGraphics2DProxy) && this.m_rDestBounds != null) {
                this.m_blackBox.paint(graphics, this.m_rDestBounds, true, this.m_bNoFill);
            } else if (this.m_polygon != null) {
                this.m_blackBox.paint(graphics, this.m_polygon);
            }
        } else if (this.getReferenceObject()) {
            this.m_blackBox.paint(graphics, vC.virtToDest(this.getBounds(vC)), true, this.m_bNoFill, this.m_nReferenceLineWidth);
        } else {
            this.m_blackBox.paint(graphics, vC.virtToDest(this.getBounds(vC)), true, this.m_bNoFill);
        }
        if (this.m_bClip) {
            graphics.setClip(shape);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.m_rBounds = rectangle;
    }

    public Polygon getShape(VC vC) {
        Polygon polygon = null;
        polygon = this.m_polygon != null ? vC.destToVirt(this.m_polygon) : (this.m_rDestBounds != null ? (this.m_bClip ? this.rectToPoly(this.m_clipRect.intersection(vC.destToVirt(this.m_rDestBounds))) : this.rectToPoly(vC.destToVirt(this.m_rDestBounds))) : (this.m_bClip ? this.rectToPoly(this.m_clipRect.intersection(this.m_rBounds)) : this.rectToPoly(this.m_rBounds)));
        return polygon;
    }
}

