/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public abstract class DetObj
implements Serializable {
    protected static final int SLOP_THICKNESS = 5;
    protected IdentObj m_id;
    protected BlackBoxIF m_blackBox;
    protected boolean m_bDetectable;
    protected boolean m_bHiliteable;
    private boolean m_bMoveable;
    private double m_nData;
    protected String m_szRefLabel;
    protected Rectangle m_clipRect;
    protected Detectiv m_Detectiv;
    private boolean m_bReferenceObj;

    protected DetObj(Detectiv detectiv, IdentObj identObj, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2) {
        this(detectiv, identObj, blackBoxIF, rectangle, bl, bl2, true);
    }

    protected DetObj(Detectiv detectiv, IdentObj identObj, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        IdentObj identObj2;
        this.m_id = identObj;
        this.m_blackBox = blackBoxIF;
        this.m_clipRect = rectangle;
        this.m_bMoveable = bl;
        this.m_bDetectable = bl2;
        this.m_bHiliteable = bl3;
        this.m_Detectiv = detectiv;
        this.m_bReferenceObj = false;
        if (this.m_Detectiv.m_bExceptionalFlag && identObj.canBeExceptional() && this.m_Detectiv.isExceptionalAllowed() && (identObj2 = this.m_Detectiv.getExceptionalID(identObj)) != null) {
            int n = ObjClassID.addExceptionalOffset(0);
            this.m_id = new IdentObj(n, identObj.getSeriesID(), identObj.getGroupID());
            this.m_blackBox = new BlackBoxObj(this.m_Detectiv.getPerspective(), identObj2);
            n = ObjClassID.addExceptionalOffset(identObj.getObjectID());
            this.m_id = new IdentObj(n, identObj.getSeriesID(), identObj.getGroupID());
            this.m_id.setMiscID(identObj.getMiscID());
        }
        this.m_Detectiv.insertDetNode(this);
    }

    public BlackBoxIF getBlackBox() {
        return this.m_blackBox;
    }

    public int getGroupID() {
        return this.m_id.m_groupID;
    }

    public IdentObj getIdentID() {
        return new IdentObj(this.m_id);
    }

    public IdentObj getIdentIDRef() {
        return this.m_id;
    }

    public Rectangle getLooseBounds() {
        return this.getBounds();
    }

    public int getObjectID() {
        return this.m_id.m_objectID;
    }

    public int getSeriesID() {
        return this.m_id.m_seriesID;
    }

    public boolean idMatchExactly(IdentObj identObj) {
        return this.m_id.equals(identObj);
    }

    public boolean isDetectable() {
        return this.m_bDetectable;
    }

    public boolean isExceptional() {
        return this.m_id.isExceptional();
    }

    public boolean isHiliteable() {
        return this.m_bHiliteable;
    }

    public boolean isMoveable() {
        return this.m_bMoveable;
    }

    public boolean isSelRelated(DetObj detObj, int n) {
        boolean bl = false;
        if (n == 3) {
            if (this.getIdentID().isColorByHeightRelated()) {
                if (detObj.getIdentID().isColorByHeightRelated()) {
                    bl = this.m_blackBox.equals(detObj.m_blackBox);
                }
            } else {
                bl = this.getObjectID() == detObj.getObjectID() && detObj.isDetectable();
            }
        } else if (this.getIdentID().isSeriesRelated()) {
            if (detObj.getIdentID().isSeriesRelated()) {
                bl = n == 2 ? this.getGroupID() == detObj.getGroupID() : this.getSeriesID() == detObj.getSeriesID();
            }
        } else {
            bl = this.getIdentID().isGroupRelated() ? detObj.getIdentID().isGroupRelated() && this.getGroupID() == detObj.getGroupID() : this.getObjectID() == detObj.getObjectID() && detObj.isDetectable();
        }
        return bl;
    }

    public void paint(Graphics graphics, VC vC) {
        this.paintIt(graphics, vC);
    }

    public String toString() {
        return this.m_id.toString();
    }

    public Polygon rectToPoly(Rectangle rectangle) {
        int[] nArray = new int[]{rectangle.x, rectangle.x + rectangle.width, rectangle.x + rectangle.width, rectangle.x};
        int[] nArray2 = new int[]{rectangle.y, rectangle.y, rectangle.y + rectangle.height, rectangle.y + rectangle.height};
        return new Polygon(nArray, nArray2, 4);
    }

    public void setReferenceData(double d) {
        this.m_nData = d;
    }

    public void setReferenceLabel(String string) {
        this.m_szRefLabel = string;
    }

    public double getReferenceData() {
        return this.m_nData;
    }

    public String getReferenceLabel() {
        return this.m_szRefLabel;
    }

    public boolean IsReferenceObject() {
        return this.m_bReferenceObj;
    }

    public void setReferenceObject() {
        this.m_bReferenceObj = true;
    }

    public boolean getReferenceObject() {
        return this.m_bReferenceObj;
    }

    public abstract Rectangle getBounds();

    public abstract void hilite(Graphics var1, VC var2);

    public abstract boolean isPointInObj(int var1, int var2, VC var3);

    public abstract boolean isPointInObj(Point var1, VC var2);

    public abstract void paintIt(Graphics var1, VC var2);

    public abstract void setBounds(Rectangle var1);

    public abstract Polygon getShape(VC var1);
}

