/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;

public class ColorObj
implements Serializable {
    static final int HSB_HUE = 0;
    static final int HSB_SATURATION = 1;
    static final int HSB_BRIGHTNESS = 2;
    private double m_fRed;
    private double m_fGreen;
    private double m_fBlue;
    private double m_fAlpha;

    public ColorObj() {
        this.m_fAlpha = 1.0;
        this.m_fBlue = 1.0;
        this.m_fGreen = 1.0;
        this.m_fRed = 1.0;
    }

    public ColorObj(double d, double d2, double d3, double d4) {
        this.setColor(d, d2, d3, d4);
    }

    public ColorObj(int n, int n2, int n3, int n4) {
        this.setColor(n, n2, n3, n4);
    }

    public ColorObj(Color color) {
        this.setColor(color);
    }

    public ColorObj(ColorObj colorObj) {
        this.m_fRed = colorObj.m_fRed;
        this.m_fGreen = colorObj.m_fGreen;
        this.m_fBlue = colorObj.m_fBlue;
        this.m_fAlpha = colorObj.m_fAlpha;
    }

    public void copy(ColorObj colorObj) {
        this.m_fRed = colorObj.m_fRed;
        this.m_fGreen = colorObj.m_fGreen;
        this.m_fBlue = colorObj.m_fBlue;
        this.m_fAlpha = colorObj.m_fAlpha;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorObj)) {
            return false;
        }
        ColorObj colorObj = (ColorObj)object;
        boolean bl = this.m_fRed == colorObj.m_fRed && this.m_fGreen == colorObj.m_fGreen && this.m_fBlue == colorObj.m_fBlue && this.m_fAlpha == colorObj.m_fAlpha;
        return bl;
    }

    public double getAlpha() {
        return this.m_fAlpha;
    }

    public double getBlue() {
        return this.m_fBlue;
    }

    public Color getColor() {
        Color color = new Color((float)this.m_fRed, (float)this.m_fGreen, (float)this.m_fBlue, (float)this.m_fAlpha);
        return color;
    }

    public double getGreen() {
        return this.m_fGreen;
    }

    public double getRed() {
        return this.m_fRed;
    }

    public void setAlpha(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        this.m_fAlpha = d;
    }

    public void setBlue(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        this.m_fBlue = d;
    }

    public void setColor(double d, double d2, double d3, double d4) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new AssertionException(0.0, 1.0, d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new AssertionException(0.0, 1.0, d3);
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new AssertionException(0.0, 1.0, d4);
        }
        this.m_fRed = d;
        this.m_fGreen = d2;
        this.m_fBlue = d3;
        this.m_fAlpha = d4;
    }

    public void setColor(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 255) {
            throw new AssertionException(0, 255, n);
        }
        if (n2 < 0 || n2 > 255) {
            throw new AssertionException(0, 255, n2);
        }
        if (n3 < 0 || n3 > 255) {
            throw new AssertionException(0, 255, n3);
        }
        if (n4 < 0 || n4 > 255) {
            throw new AssertionException(0, 255, n4);
        }
        this.m_fRed = 1.0 * (double)n / 255.0;
        this.m_fGreen = 1.0 * (double)n2 / 255.0;
        this.m_fBlue = 1.0 * (double)n3 / 255.0;
        this.m_fAlpha = 1.0 * (double)n4 / 255.0;
    }

    public void setColor(Color color) {
        this.m_fRed = 1.0 * (double)color.getRed() / 255.0;
        this.m_fGreen = 1.0 * (double)color.getGreen() / 255.0;
        this.m_fBlue = 1.0 * (double)color.getBlue() / 255.0;
        this.m_fAlpha = 1.0 * (double)color.getAlpha() / 255.0;
    }

    public void setGreen(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        this.m_fGreen = d;
    }

    public void setRed(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new AssertionException(0.0, 1.0, d);
        }
        this.m_fRed = d;
    }

    public void shadeColor(int n) {
        if (n < 0 || n > 100) {
            throw new AssertionException(0, 100, n);
        }
        Color color = this.getColor();
        this.m_fAlpha = (double)color.getAlpha() / 255.0;
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[2] = fArray[2] * (float)n / (float)100;
        color = new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
        this.m_fRed = 1.0 * (double)color.getRed() / 255.0;
        this.m_fGreen = 1.0 * (double)color.getGreen() / 255.0;
        this.m_fBlue = 1.0 * (double)color.getBlue() / 255.0;
    }
}

