/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.OrdinalAxisFragment;

public class ZoomState
implements Serializable {
    public static final ZoomState UNZOOMED = new ZoomState();
    protected boolean m_bZoomed = false;
    protected AxisDescriptor m_AxisDescriptor;
    protected double m_fMin_X1;
    protected double m_fMax_X1;
    protected double m_fMin_Y1;
    protected double m_fMax_Y1;
    protected double m_fMin_Y2;
    protected double m_fMax_Y2;
    protected int m_nViewGroups;
    protected int m_nGroupOffset;
    protected int m_nViewSeries;
    protected int m_nSeriesOffset;

    public void ChartFrame(double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, int n3, int n4, AxisDescriptor axisDescriptor) {
        this.m_bZoomed = true;
        this.m_AxisDescriptor = axisDescriptor;
        this.m_fMin_X1 = d;
        this.m_fMax_X1 = d2;
        this.m_fMin_Y1 = d3;
        this.m_fMax_Y1 = d4;
        this.m_fMin_Y2 = d5;
        this.m_fMax_Y2 = d6;
        this.m_nViewGroups = n;
        this.m_nGroupOffset = n2;
        this.m_nViewSeries = n3;
        this.m_nSeriesOffset = n4;
    }

    public OrdinalAxisFragment getOrdinalAxisFragment(int n) {
        OrdinalAxisFragment ordinalAxisFragment = null;
        if (!this.m_bZoomed) {
            throw new AssertionException("UNZOOMED can't respond to getOrdinalAxisFragment");
        }
        switch (n) {
            case 5: {
                if (!this.m_AxisDescriptor.hasO1()) break;
                ordinalAxisFragment = new OrdinalAxisFragment(this.m_nViewGroups, this.m_nGroupOffset);
                break;
            }
            case 6: {
                if (!this.m_AxisDescriptor.hasO2()) break;
                ordinalAxisFragment = new OrdinalAxisFragment(this.m_nViewSeries, this.m_nSeriesOffset);
                break;
            }
            default: {
                throw new AssertionException(String.valueOf(String.valueOf("ZoomState.getOrdinalAxisFragment: Unknown axis ID = ")) + n);
            }
        }
        return ordinalAxisFragment;
    }

    public MinMaxObj getScaleMinMax(int n) {
        MinMaxObj minMaxObj = null;
        if (!this.m_bZoomed) {
            throw new AssertionException("UNZOOMED can't respond to getScaleMin");
        }
        switch (n) {
            case 7: {
                if (!this.m_AxisDescriptor.hasX1()) break;
                minMaxObj = new MinMaxObj(this.m_fMin_X1, this.m_fMax_X1);
                break;
            }
            case 0: {
                if (!this.m_AxisDescriptor.hasY1()) break;
                minMaxObj = new MinMaxObj(this.m_fMin_Y1, this.m_fMax_Y1);
                break;
            }
            case 1: {
                if (!this.m_AxisDescriptor.hasY2()) break;
                minMaxObj = new MinMaxObj(this.m_fMin_Y2, this.m_fMax_Y2);
                break;
            }
            default: {
                throw new AssertionException(String.valueOf(String.valueOf("ZoomState.getScaleMin: Unknown axis ID = ")) + n);
            }
        }
        if (minMaxObj != null) {
            minMaxObj.setDataDerived(false);
        }
        return minMaxObj;
    }

    public boolean isZoomed() {
        return this.m_bZoomed;
    }

    public String toString() {
        if (this.m_bZoomed) {
            return String.valueOf(String.valueOf("[X1: (")) + this.m_fMin_X1 + ", " + this.m_fMax_X1 + "), Y1: (" + this.m_fMin_Y1 + ", " + this.m_fMax_Y1 + ")]";
        }
        return "UNZOOMED state";
    }
}

