/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.Vector;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.TDGNestedLabel;

public class TDGTestNestedGroupLabels
implements TDGNestedLabel {
    protected Perspective m_Perspective;
    protected String[][] m_Labels = new String[][]{{"Q1", "Q2", "Q3", "Q4"}, {"1997", "1998", "1999"}};
    protected boolean[][] m_raShown;
    protected int[] m_raShownPerLevel;
    protected int[][] m_raGrouping;

    public TDGTestNestedGroupLabels(Perspective perspective) {
        this.m_Perspective = perspective;
        this.calc();
    }

    public void calc() {
        int n;
        int n2 = this.getNumLevels();
        int n3 = this.getNumLabelsAvailOnLevel(0);
        int n4 = this.m_Perspective.getEffectiveViewableGroups();
        int n5 = this.m_Perspective.getEffectiveGroupOffset();
        int n6 = this.m_Labels[0].length;
        this.m_raShown = new boolean[n2][n3];
        this.m_raShownPerLevel = new int[this.getNumLevels()];
        this.m_raGrouping = new int[n2 - 1][n3];
        int n7 = 0;
        while (n7 < n3) {
            if (n7 >= n5 && n7 < n5 + n4) {
                this.m_raShown[0][n7] = true;
                n = n7 / n6;
                this.m_raShown[1][n] = true;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n2) {
            n = 0;
            while (n < n3) {
                if (this.m_raShown[n7][n]) {
                    int n8 = n7;
                    this.m_raShownPerLevel[n8] = this.m_raShownPerLevel[n8] + 1;
                }
                ++n;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n2 - 1) {
            n = 0;
            while (n < n3) {
                int n9;
                int n10 = n9 = n / n6 * n6;
                while (n10 < n9 + n6) {
                    if (this.m_raShown[n7][n10]) {
                        int[] nArray = this.m_raGrouping[n7];
                        int n11 = n;
                        nArray[n11] = nArray[n11] + 1;
                    }
                    ++n10;
                }
                ++n;
            }
            ++n7;
        }
    }

    public int getNumLevels() {
        return this.m_Labels.length;
    }

    public int getNumLabelsOnLevel(int n) {
        PfjAssert.pfjAssert(n >= 0 && n < this.m_Labels.length);
        this.calc();
        int n2 = this.m_raShownPerLevel[n];
        return n2;
    }

    protected int getNumLabelsAvailOnLevel(int n) {
        PfjAssert.pfjAssert(n >= 0 && n < this.m_Labels.length);
        int n2 = 1;
        int n3 = n;
        while (n3 < this.getNumLevels()) {
            int n4 = this.m_Labels[n3].length;
            n2 *= n4;
            ++n3;
        }
        return n2;
    }

    public Vector getAllLabels(int n) {
        PfjAssert.pfjAssert(n >= 0 && n < this.m_Labels.length);
        this.calc();
        int n2 = this.getNumLabelsOnLevel(n);
        Vector<String> vector = new Vector<String>(n2);
        int n3 = 0;
        while (n3 < n2) {
            String string = this.getLabel(n3, n);
            if (string != null) {
                vector.addElement(string);
            }
            ++n3;
        }
        return vector;
    }

    public String getLabel(int n, int n2) {
        PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_Labels.length);
        PfjAssert.pfjAssert(n >= 0);
        this.calc();
        int n3 = -1;
        int n4 = this.getNumLabelsAvailOnLevel(0);
        int n5 = 0;
        while (n5 < n4) {
            if (this.m_raShown[n2][n5]) {
                ++n3;
            }
            if (n3 == n) break;
            ++n5;
        }
        PfjAssert.pfjAssert(n3 >= 0);
        if (n3 < 0) {
            return null;
        }
        int n6 = n5 % this.m_Labels[n2].length;
        String string = this.m_Labels[n2][n6];
        return string;
    }

    public int getLabelGrouping(int n, int n2) {
        PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_Labels.length);
        PfjAssert.pfjAssert(n >= 0);
        this.calc();
        int n3 = this.m_raGrouping[n2][n];
        return n3;
    }

    public int getParentIndex(int n, int n2) {
        return -1;
    }
}

