/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import oracle.dss.graph.pfj.Perspective;

public class TDGNumberFormat {
    private static final int DEFAULT_MAXNUMDECIMALS = 5;
    public static final int FORMAT_USE_PATTERN = -1;
    public static final int FORMAT_GENERAL = 0;
    public static final int FORMAT_INTEGER = 1;
    public static final int FORMAT_PERCENT = 2;
    public static final int FORMAT_PERCENT_1 = 3;
    public static final int FORMAT_PERCENT_2 = 4;
    public static final int FORMAT_CURRENCY_GENERAL = 5;
    public static final int FORMAT_CURRENCY_INT = 6;
    public static final int FORMAT_K = 7;
    public static final int FORMAT_CURRENCY_K = 8;
    public static final int FORMAT_M = 9;
    public static final int FORMAT_CURRENCY_M = 10;
    public static final int FORMAT_B = 11;
    public static final int FORMAT_CURRENCY_B = 12;
    public static final int FORMAT_T = 13;
    public static final int FORMAT_CURRENCY_T = 14;
    public static final int FORMAT_NUMERIC = 15;
    public static final int FORMAT_NUMERIC_2 = 16;
    public static final int FORMAT_CURRENCY = 17;
    public static final int FORMAT_DATE_SHORT = 18;
    public static final int FORMAT_DATE_MEDIUM = 19;
    public static final int FORMAT_DATE_LONG = 20;
    public static final int FORMAT_DATE_FULL = 21;
    public static final int FORMAT_PARETO_PERCENT = 23;
    public static final int GENERAL = 0;
    public static final int CURRENCY = 1;
    public static final int PERCENT = 2;

    public static String toString(Perspective perspective, int n, double d, String string) {
        String string2;
        if ((n == 0 || n == 15 || n == 16) && (d > 1.0E15 || d < -1.0E15)) {
            string2 = Double.toString(d);
        } else if (n == 23) {
            string2 = Double.toString(d);
        } else {
            switch (n) {
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    string2 = TDGNumberFormat.dateFormatting(perspective, n, d);
                    break;
                }
                default: {
                    string2 = TDGNumberFormat.decimalFormatting(perspective, n, d, string);
                }
            }
        }
        return string2;
    }

    private static String dateFormatting(Perspective perspective, int n, double d) {
        int n2;
        Double d2 = new Double(d);
        long l = d2.longValue();
        Date date = new Date(l);
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
            case 20: {
                n2 = 1;
                break;
            }
            case 21: {
                n2 = 0;
            }
        }
        DateFormat dateFormat = DateFormat.getDateInstance(n2, perspective.m_Locale);
        Locale locale = perspective.m_Locale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            if (perspective.m_Locale != null) {
                dateFormat.setCalendar(new GregorianCalendar(perspective.m_Locale));
            } else {
                dateFormat.setCalendar(new GregorianCalendar());
            }
        }
        String string = dateFormat.format(date);
        return string;
    }

    private static String decimalFormatting(Perspective perspective, int n, double d, String string) {
        DecimalFormat decimalFormat = TDGNumberFormat.isPercentFormat(n) ? (DecimalFormat)NumberFormat.getPercentInstance(perspective.m_Locale) : (TDGNumberFormat.isCurrencyFormat(n) ? (DecimalFormat)NumberFormat.getCurrencyInstance(perspective.m_Locale) : (DecimalFormat)NumberFormat.getInstance(perspective.m_Locale));
        if (n == -1) {
            decimalFormat.applyLocalizedPattern(string);
        } else {
            if (n == 3) {
                decimalFormat.setMinimumFractionDigits(1);
                decimalFormat.setMaximumFractionDigits(1);
            } else if (n == 4 || n == 5 || n == 16) {
                decimalFormat.setMinimumFractionDigits(2);
                decimalFormat.setMaximumFractionDigits(2);
            } else if (n == 0) {
                decimalFormat.setMinimumFractionDigits(0);
                decimalFormat.setMaximumFractionDigits(5);
            } else if (n != 17) {
                decimalFormat.setMaximumFractionDigits(0);
            }
            if (n == 1) {
                decimalFormat.setGroupingUsed(false);
            }
            String string2 = "";
            if (n == 0 || n == 5 || n == 6 || n == 15 || n == 16) {
                string2 = TDGNumberFormat.calcPrefix(d);
            } else if (n == 7 || n == 8) {
                string2 = "K";
            } else if (n == 9 || n == 10) {
                string2 = "M";
            } else if (n == 11 || n == 12) {
                string2 = "B";
            } else if (n == 13 || n == 14) {
                string2 = "T";
            }
            if (!string2.equals("")) {
                if (string2.equals("K")) {
                    d /= 1000.0;
                } else if (string2.equals("M")) {
                    d /= 1000000.0;
                } else if (string2.equals("B")) {
                    d /= 1.0E9;
                } else if (string2.equals("T")) {
                    d /= 1.0E12;
                }
                decimalFormat.setPositiveSuffix(String.valueOf(string2) + decimalFormat.getPositiveSuffix());
                decimalFormat.setNegativeSuffix(String.valueOf(string2) + decimalFormat.getNegativeSuffix());
            }
        }
        if (d < 1.0 && d > -1.0 && n == 1) {
            d = Math.floor(d + 0.5);
        }
        return decimalFormat.format(d);
    }

    private static String calcPrefix(double d) {
        String string = "";
        if (d >= 1.0E12 && d < 1.0E15 || d <= -1.0E12 && d > -1.0E15) {
            string = "T";
        } else if (d >= 1.0E9 && d < 1.0E12 || d <= -1.0E9 && d > -1.0E12) {
            string = "B";
        } else if (d >= 1000000.0 && d < 1.0E9 || d <= -1000000.0 && d > -1.0E9) {
            string = "M";
        } else if (d >= 1000.0 && d < 1000000.0 || d <= -1000.0 && d > -1000000.0) {
            string = "K";
        }
        return string;
    }

    static boolean isPercentFormat(int n) {
        return n == 2 || n == 3 || n == 4;
    }

    static boolean isCurrencyFormat(int n) {
        return n == 5 || n == 17 || n == 6 || n == 8 || n == 10 || n == 12 || n == 14;
    }
}

