/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.Perspective;

public class SeriesEnumerator {
    static final boolean FORWARD = true;
    static final boolean REVERSE = false;
    int[] m_seriesArray;
    int m_index;

    SeriesEnumerator(Perspective perspective, Access access, boolean bl) {
        DataRange dataRange = access.getViewableDataRangeSG(perspective);
        int n = dataRange.getRowStart();
        int n2 = dataRange.getRowStop();
        int n3 = n2 - n + 1;
        int n4 = 0;
        this.m_index = 0;
        if (n3 < 0) {
            this.m_seriesArray = new int[0];
            return;
        }
        this.m_seriesArray = new int[n3];
        if (bl) {
            int n5 = 0;
            int n6 = n;
            while (n6 <= n2) {
                if (!perspective.getIgnoreSeries(n6)) {
                    this.m_seriesArray[n5++] = n6;
                    ++n4;
                }
                ++n6;
            }
            if (n4 < n3) {
                int[] nArray = new int[n4];
                System.arraycopy(this.m_seriesArray, 0, nArray, 0, n4);
                this.m_seriesArray = nArray;
            }
        } else {
            int n7 = n3 - 1;
            int n8 = n;
            while (n8 <= n2) {
                if (!perspective.getIgnoreSeries(n8)) {
                    this.m_seriesArray[n7--] = n8;
                    ++n4;
                }
                ++n8;
            }
            if (n4 < n3) {
                n8 = n3 - n4;
                int[] nArray = new int[n4];
                System.arraycopy(this.m_seriesArray, n8, nArray, 0, n4);
                this.m_seriesArray = nArray;
            }
        }
    }

    public int getAbsoluteSeries(int n) {
        return this.seriesAt(n);
    }

    public int getFirstSeries() {
        return this.seriesAt(0);
    }

    public int getLastSeries() {
        return this.seriesAt(this.m_seriesArray.length - 1);
    }

    public int getNumSeries() {
        return this.m_seriesArray.length;
    }

    public int getRelativeSeries(int n) {
        int n2 = 0;
        while (n2 < this.m_seriesArray.length) {
            if (this.m_seriesArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean hasMoreElements() {
        return this.m_index < this.m_seriesArray.length;
    }

    public int nextSeries() {
        return this.m_seriesArray[this.m_index++];
    }

    public int seriesAt(int n) {
        try {
            int n2 = this.m_seriesArray[n];
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n3 = -1;
            return n3;
        }
    }

    public int peekAtNextSeries() {
        return this.seriesAt(this.m_index);
    }

    public int peekAtSeriesAfter(int n) {
        int n2 = this.getRelativeSeries(n);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.seriesAt(n2 + 1);
        }
        return n3;
    }

    public int peekAtSeriesBefore(int n) {
        int n2 = this.getRelativeSeries(n);
        int n3 = -1;
        if (n2 >= 1) {
            n3 = this.seriesAt(n2 - 1);
        }
        return n3;
    }

    public void reset() {
        this.m_index = 0;
    }
}

