/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.AxisObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.NumberFormatCallBack;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.event.TDGErrorManager;
import oracle.dss.graph.pfj.math.FP;

public abstract class RelativeAxisObj
extends AxisObj {
    private static final double AUTOMINMAX_ADJUST = 1.05;
    private static final int MAX_NUMBER_OF_GRIDS = 100;
    static final int BUBBLE_DEST_BUFFER = 2;
    private static final int BUBBLE_VIRT_BUFFER = 100;
    public static final int SERIES_SIDE_BY_SIDE = 0;
    public static final int ONE_SERIES_PER_GROUP = 1;
    public static final int CENTERED_ON_GROUP = 2;
    public static final int TWO_SERIES_PER_GROUP = 3;
    public static final int CONNECTED_SERIES = 4;
    public static final int CONNECTED_GROUPS = 5;
    public static final int DATA_TOUCH_BORDER = 6;
    public static final int GROUP_3D = 7;
    public static final int SERIES_3D = 8;
    public static final int CIRCULAR = 9;
    public static final int ONE_SERIES_PER_GROUPS = 10;
    protected boolean m_bNumericAxis;
    protected MinMaxObj m_objMinMax;
    protected double m_fScaleMin;
    protected double m_fScaleMax;
    protected double m_fScaleStep;
    protected double m_fMinAutoScaleStep;
    protected double m_fMinorStep;
    protected double m_fValToRelCoord;
    protected boolean m_bLogScale;
    protected double m_fLogScaleBase;
    protected boolean m_bAutoMax;
    protected boolean m_bAutoMin;
    protected boolean m_bAutoStep;
    private double m_nSpaceBetGroups;
    private double m_nLeftPosFirstGroup;
    private double m_nSpaceBetSeries;
    private double m_nOffsetBetGroupPosAndFirstSeries;
    private double m_fRiserWidth;
    int[] m_nSeriesTypes;
    int m_nBaseRiserType;
    boolean m_bIsComboChart;
    private int m_nNumLabels;
    double[] m_nParetoSeriesMaximums;
    double[] m_nParetoSeriesMinimums;
    double m_Y2DefaultScaleStep;
    private String m_NonZeroBaselineLabel;
    AxisTemplate m_AxisTempID;
    protected double m_fBaseMax;
    protected double m_fBaseMin;
    protected boolean m_bNonZeroBaseline;
    protected int m_numberOfSteps;
    protected int m_requiredSteps;
    private double m_minBubbleVal;
    private double m_maxBubbleVal;
    private int m_minBubbleSize;
    private int m_maxBubbleSize;

    protected RelativeAxisObj(Perspective perspective, Access access, AxisTemplate axisTemplate, int n, boolean bl) {
        this(perspective, access, axisTemplate, n, bl, 0, 100);
        this.m_bNumericAxis = false;
    }

    protected RelativeAxisObj(Perspective perspective, Access access, AxisTemplate axisTemplate, int n, boolean bl, int n2, int n3) {
        super(perspective, access, axisTemplate, bl, n2, n3);
        this.m_nParetoSeriesMaximums = new double[this.m_numSeries];
        this.m_nParetoSeriesMinimums = new double[this.m_numSeries];
        this.m_Y2DefaultScaleStep = 10.0;
        this.m_bNumericAxis = false;
        this.m_AxisTempID = axisTemplate;
        if (n < 0 || n > 10) {
            throw new AssertionException("RelativeAxisObj Constructor: Invalid parameter passed for OrdinalAxisType");
        }
        this.m_nOrdinalAxisType = n;
        this.m_nNumLabels = 0;
    }

    protected RelativeAxisObj(Perspective perspective, Access access, AxisTemplate axisTemplate, MinMaxObj minMaxObj, boolean bl, int n, int n2) {
        super(perspective, access, axisTemplate, bl, n, n2);
        this.m_nParetoSeriesMaximums = new double[this.m_numSeries];
        this.m_nParetoSeriesMinimums = new double[this.m_numSeries];
        this.m_Y2DefaultScaleStep = 10.0;
        this.m_bNumericAxis = true;
        this.m_objMinMax = minMaxObj;
        this.m_nNumLabels = 0;
    }

    public void copyScaleParams() {
        this.m_bLogScale = this.m_Perspective.getLogScale(this.m_template.getAxis());
        this.m_fLogScaleBase = this.m_Perspective.getLogScaleBase(this.m_template.getAxis());
        if (this.m_fLogScaleBase < 2.0) {
            this.m_fLogScaleBase = 2.0;
        }
        if (this.m_fLogScaleBase > 100.0) {
            this.m_fLogScaleBase = 100.0;
        }
        this.m_bAutoMax = this.m_Perspective.getScaleMaxAuto(this.m_template.getAxis());
        this.m_bAutoMin = this.m_Perspective.getScaleMinAuto(this.m_template.getAxis());
        this.m_bAutoStep = this.m_Perspective.getGridStepAuto(this.m_template.getMajor());
        if (this.m_gt.isParetoType()) {
            this.m_fScaleMax = this.getParetoSeriesMaximum(this.m_Perspective.getDisplayParetoSeries());
            this.m_bAutoMax = false;
            this.m_bAutoMin = true;
            this.m_fScaleMin = 0.0;
        } else {
            this.m_fScaleMax = this.m_bAutoMax ? this.m_objMinMax.getAdjMax() : this.m_Perspective.getScaleMax(this.m_template.getAxis());
            double d = this.m_fScaleMin = this.m_bAutoMin ? this.m_objMinMax.getAdjMin() : this.m_Perspective.getScaleMin(this.m_template.getAxis());
            if (this.m_bNonZeroBaseline && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter()) {
                double d2 = this.m_Perspective.getNonZeroBaselineValue(this.m_template.getAxis());
                this.m_fBaseMax = this.m_fScaleMax;
                this.m_fBaseMin = this.m_fScaleMin;
                if (!(d2 <= 0.0) || !this.isLogScale()) {
                    if (d2 >= this.m_fScaleMax && this.m_bAutoMax) {
                        this.m_fScaleMax = d2;
                    } else if (d2 <= this.m_fScaleMin && this.m_bAutoMin) {
                        this.m_fScaleMin = d2;
                    }
                }
            }
        }
        this.m_fScaleStep = this.m_Perspective.getGridStep(this.m_template.getMajor());
        this.m_fMinAutoScaleStep = this.m_Perspective.getMinAutoGridStep(this.m_template.getMajor());
    }

    public void calc_init() {
        this.initSeriesTypes();
        this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(this.m_template.getAxis());
        if (this.m_bNumericAxis) {
            this.copyScaleParams();
            if (!this.m_objMinMax.isValid() && !this.m_gt.isParetoType()) {
                this.m_fScaleMin = 0.0;
                this.m_fScaleMax = 1.0;
                return;
            }
            this.calcNumericScale();
            this.calcMinorStep();
            this._updateValToRelCoord();
        } else {
            this.calcOrdinalScale();
        }
        this.calcNumLabels();
    }

    public void calc() {
        if (this.m_Perspective.getAxesPreviewMode() && !this.m_bNumericAxis) {
            return;
        }
        this.calc_init();
        if (this.m_Perspective.getAxesPreviewMode()) {
            return;
        }
        super.calc();
    }

    protected void calcAutoMinMax() {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        double d3;
        int n6 = 0;
        double d4 = this.m_fScaleMin;
        double d5 = this.m_fScaleMax;
        if (FP.equal(d5, 0.0) && FP.equal(d4, 0.0)) {
            d5 = 1.0;
        } else if (FP.equal(d5 - d4, 0.0)) {
            d5 *= 1.1;
            d4 /= 1.1;
        } else if (FP.lessThan(d5 - d4, 0.0)) {
            d5 = Math.max(d4, d5);
            d4 = Math.min(d4, d5);
        }
        double d6 = d5 - d4;
        double d7 = Math.log(d6) / Math.log(10.0);
        double d8 = 0.0;
        double d9 = this.m_bLogScale ? this.m_fLogScaleBase : 10.0;
        d8 = FP.equal(d7 - (double)FP.round(d7), 0.0) ? Math.pow(d9, d7 - 2.0) : Math.pow(d9, Math.floor(d7) - 1.0);
        int n7 = (int)(d6 / d8) - 1;
        n6 = n7 >= 9 && n7 <= 16 ? 2 : (n7 >= 17 && n7 <= 29 ? 4 : (n7 >= 30 && n7 <= 44 ? 5 : (n7 >= 45 && n7 <= 79 ? 10 : (n7 >= 80 && n7 <= 99 ? 20 : (n7 > 100 ? (d8 > 0.0 ? (int)d6 / 100 / (int)d8 : (int)d6 / 100 / 64) : 1)))));
        if (this.m_fAxisLengthRel < 1.0) {
            d3 = n6;
            d3 /= this.m_fAxisLengthRel;
            while (d3 >= 20.0) {
                d3 /= (double)10;
                d8 *= (double)10;
            }
            n6 = d3 < 20.0 && d3 > 10.0 ? 20 : (d3 > 5.0 ? 10 : (d3 > 4.0 ? 5 : (d3 > 2.0 ? 4 : 2)));
        }
        double d10 = (double)n6 * d8;
        d3 = Math.floor(this.m_fScaleMin / d10) * d10;
        if (FP.greaterThan(d10, 0.0)) {
            while (FP.greaterThan(d3, this.m_fScaleMax)) {
                d3 -= d10;
            }
        }
        double d11 = d3;
        if (FP.greaterThan(d10, 0.0)) {
            while (FP.lessThan(d11, d5)) {
                d11 += d10;
            }
        }
        if (this.m_bAutoMin) {
            this.m_fScaleMin = d3;
        }
        if (this.m_bAutoMax) {
            this.m_fScaleMax = d11;
        }
        if (this.m_gt.isBubble() && this.getAxisObjID() != 8 && (this.m_bAutoMin || this.m_bAutoMax)) {
            this._calcMinMaxBubblesOnAxis();
            n5 = 2;
            n4 = 100;
            n3 = 0;
            n3 = this.isVertical() ? this.m_Perspective.m_VC.destToVirtHeight(n5) : this.m_Perspective.m_VC.destToVirtWidth(n5);
            if (n3 > n4) {
                n4 = n3;
            }
            n2 = this.m_minBubbleSize + 2 * n4;
            n = this.m_maxBubbleSize + 2 * n4;
            int n8 = (int)this.getValueCoord(this.m_minBubbleVal);
            int n9 = (int)this.getValueCoord(this.m_maxBubbleVal);
            int n10 = n8 - n2 / 2;
            int n11 = n9 + n / 2;
            double d12 = this.getValueFromCoord(n10);
            double d13 = this.getValueFromCoord(n11);
            boolean bl = this.m_bAutoMin && d12 < this.m_fScaleMin;
            boolean bl2 = this.m_bAutoMax && d13 > this.m_fScaleMax;
            boolean bl3 = false;
            boolean bl4 = false;
            int n12 = 0;
            int n13 = 10;
            double d14 = this.m_fScaleMin;
            double d15 = this.m_fScaleMax;
            double d16 = d15 - d14;
            while ((bl || bl2) && n12 < n13) {
                int n14;
                if (bl) {
                    n14 = (int)Math.ceil((this.m_fScaleMin - d12) / d10);
                    if ((double)n14 * d10 + (d14 - this.m_fScaleMin) > d16) {
                        this.m_fScaleMin = d14 - d16;
                        bl = false;
                        bl3 = true;
                    } else {
                        this.m_fScaleMin -= (double)n14 * d10;
                    }
                    if (!bl4) {
                        bl2 = true;
                    }
                    this._updateValToRelCoord();
                    n8 = (int)this.getValueCoord(this.m_minBubbleVal);
                    n9 = (int)this.getValueCoord(this.m_maxBubbleVal);
                    n10 = n8 - n2 / 2;
                    n11 = n9 + n / 2;
                    d12 = this.getValueFromCoord(n10);
                    d13 = this.getValueFromCoord(n11);
                    bl = bl && this.m_bAutoMin && d12 < this.m_fScaleMin;
                    boolean bl5 = bl2 = bl2 && this.m_bAutoMax && d13 > this.m_fScaleMax;
                }
                if (bl2) {
                    n14 = (int)Math.ceil((d13 - this.m_fScaleMax) / d10);
                    if ((double)n14 * d10 + (this.m_fScaleMax - d15) > d16) {
                        this.m_fScaleMax = d15 + d16;
                        bl2 = false;
                        bl4 = true;
                    } else {
                        this.m_fScaleMax += (double)n14 * d10;
                    }
                    if (!bl3) {
                        bl = true;
                    }
                    this._updateValToRelCoord();
                    n8 = (int)this.getValueCoord(this.m_minBubbleVal);
                    n9 = (int)this.getValueCoord(this.m_maxBubbleVal);
                    n10 = n8 - n2 / 2;
                    n11 = n9 + n / 2;
                    d12 = this.getValueFromCoord(n10);
                    d13 = this.getValueFromCoord(n11);
                    bl = bl && this.m_bAutoMin && d12 < this.m_fScaleMin;
                    bl2 = bl2 && this.m_bAutoMax && d13 > this.m_fScaleMax;
                }
                ++n12;
            }
        }
        this.m_numberOfSteps = (int)Math.round((this.m_fScaleMax - this.m_fScaleMin) / d10);
        if (!(!this.m_bAutoStep || this.m_bAutoMax && this.m_bAutoMin || FP.equal(this.m_fScaleMin + d10 * (double)this.m_numberOfSteps, this.m_fScaleMax))) {
            double d17 = this.m_fScaleMax - this.m_fScaleMin;
            if (n6 == 20) {
                n6 = 15;
            }
            n3 = n6;
            while (n3 > 0) {
                double d18 = (double)n3 * d8;
                double d19 = (int)Math.ceil(d17 / d18);
                if (d19 > (double)100) break;
                double d20 = this.m_fScaleMin + d18 * d19;
                boolean bl = FP.equal(d20, this.m_fScaleMax);
                if (bl) {
                    if (!this.m_bNonZeroBaseline && this.m_fScaleMin < 0.0 && this.m_fScaleMax > 0.0) {
                        d2 = this.m_fScaleMin / d18;
                        d = Math.round(this.m_fScaleMin / d18);
                        if (FP.equal(d2, d)) {
                            d10 = d18;
                            n6 = n3;
                            break;
                        }
                        bl = false;
                    } else {
                        d10 = d18;
                        n6 = n3;
                        break;
                    }
                }
                --n3;
            }
        }
        if (this.m_bAutoStep) {
            if (this.m_fMinAutoScaleStep != 0.0) {
                this.m_fScaleStep = d10 > this.m_fMinAutoScaleStep ? (!FP.equal(d10 % this.m_fMinAutoScaleStep, 0.0) ? d10 - d10 % this.m_fMinAutoScaleStep : d10) : (d10 < this.m_fMinAutoScaleStep && this.m_fMinAutoScaleStep <= this.m_fScaleMax - this.m_fScaleMin ? this.m_fMinAutoScaleStep : d10);
                if (this.m_bAutoMin && this.m_fScaleMin > 0.0) {
                    this.m_fScaleMin -= this.m_fScaleMin % this.m_fMinAutoScaleStep;
                }
                if (this.m_bAutoMax && this.m_fScaleMax > 0.0 && this.m_fScaleMax % this.m_fMinAutoScaleStep != 0.0) {
                    this.m_fScaleMax = this.m_fScaleMax - this.m_fScaleMax % this.m_fMinAutoScaleStep + this.m_fMinAutoScaleStep;
                }
                if (this.m_bAutoMin && this.m_fScaleMin < 0.0 && this.m_fScaleMin % this.m_fMinAutoScaleStep != 0.0) {
                    this.m_fScaleMin = this.m_fScaleMin - this.m_fScaleMin % this.m_fMinAutoScaleStep - this.m_fMinAutoScaleStep;
                }
                if (this.m_bAutoMax && this.m_fScaleMax < 0.0) {
                    this.m_fScaleMax -= this.m_fScaleMax % this.m_fMinAutoScaleStep;
                }
                if (d10 < this.m_fMinAutoScaleStep && this.m_fMinAutoScaleStep <= this.m_fScaleMax - this.m_fScaleMin) {
                    this.m_fScaleStep = this.m_fMinAutoScaleStep;
                }
            } else {
                this.m_fScaleStep = d10;
            }
        }
        this.m_numberOfSteps = (int)Math.round((this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep);
        if (!this.m_gt.isDualY() || this.m_gt.isParetoType() || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
            return;
        }
        n5 = 0;
        if (this.m_template == AxisTemplate.Y2_AXIS) {
            n5 = this.m_Perspective.getY2MustIncludeZero() ? 1 : 0;
        } else if (this.m_template == AxisTemplate.Y1_AXIS) {
            n5 = this.m_Perspective.getY1MustIncludeZero() ? 1 : 0;
        }
        n4 = 0;
        if (this.m_requiredSteps != 0 && (this.m_numberOfSteps >= this.m_requiredSteps && this.m_numberOfSteps % this.m_requiredSteps != 0 || this.m_requiredSteps >= this.m_numberOfSteps && this.m_requiredSteps % this.m_numberOfSteps != 0)) {
            if (this.m_bAutoStep) {
                double d21 = (this.m_fScaleMax - this.m_fScaleMin) / (double)this.m_requiredSteps;
                if (this.m_fMinAutoScaleStep != 0.0 && (d21 < this.m_fMinAutoScaleStep || !FP.equal(d21 % this.m_fMinAutoScaleStep, 0.0))) {
                    n4 = 1;
                }
                if (n4 == 0) {
                    double d22;
                    double d23 = Math.ceil(d21 / d8);
                    double d24 = this.m_fScaleStep;
                    double d25 = this.m_fScaleMax;
                    d2 = this.m_fScaleMin;
                    if (this.m_bAutoMax && this.m_fScaleMax != 0.0) {
                        this.m_fScaleStep = d23 * d8;
                        this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
                    } else if (this.m_bAutoMin && this.m_fScaleMin != 0.0) {
                        this.m_fScaleStep = d23 * d8;
                        this.m_fScaleMin = this.m_fScaleMax - this.m_fScaleStep * (double)this.m_requiredSteps;
                    } else {
                        this.m_fScaleStep = d21;
                    }
                    if (!this.m_bNonZeroBaseline && this.m_fScaleMin < 0.0 && this.m_fScaleMax > 0.0 && !FP.equal(d = this.m_fScaleMin / this.m_fScaleStep, d22 = (double)Math.round(this.m_fScaleMin / this.m_fScaleStep))) {
                        n4 = 1;
                        this.m_fScaleStep = d24;
                        this.m_fScaleMax = d25;
                        this.m_fScaleMin = d2;
                    }
                }
            }
            if (n4 != 0 || !this.m_bAutoStep) {
                if (this.m_numberOfSteps > this.m_requiredSteps) {
                    int n15 = 2;
                    while (this.m_numberOfSteps >= this.m_requiredSteps) {
                        this.m_requiredSteps *= n15++;
                    }
                }
                if (this.m_requiredSteps > 100) {
                    return;
                }
                if (this.m_bAutoMax && this.m_bAutoMin) {
                    if (n5 != 0 && this.m_fScaleMin == 0.0) {
                        this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
                    } else {
                        int n16 = this.m_requiredSteps - this.m_numberOfSteps;
                        n2 = n16 / 2;
                        n = n2 + n16 % 2;
                        this.m_fScaleMax += this.m_fScaleStep * (double)n;
                        this.m_fScaleMin -= this.m_fScaleStep * (double)n2;
                    }
                } else if (this.m_bAutoMax) {
                    this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
                } else if (this.m_bAutoMin) {
                    this.m_fScaleMin = this.m_fScaleMax - this.m_fScaleStep * (double)this.m_requiredSteps;
                }
            }
        }
    }

    private void calcLogScale() {
        int n;
        double d = Math.log(this.m_fScaleMin) / Math.log(this.m_fLogScaleBase);
        this.m_fScaleMin = Math.floor(d);
        d = Math.log(this.m_fScaleMax) / Math.log(this.m_fLogScaleBase);
        this.m_fScaleMax = Math.ceil(d);
        if (this.m_gt.isBubble() && this.getAxisObjID() != 8 && (this.m_bAutoMin || this.m_bAutoMax)) {
            this._calcMinMaxBubblesOnAxis();
            n = 2;
            int n2 = 100;
            int n3 = 0;
            n3 = this.isVertical() ? this.m_Perspective.m_VC.destToVirtHeight(n) : this.m_Perspective.m_VC.destToVirtWidth(n);
            if (n3 > n2) {
                n2 = n3;
            }
            int n4 = this.m_minBubbleSize + 2 * n2;
            int n5 = this.m_maxBubbleSize + 2 * n2;
            int n6 = (int)this.getValueCoord(this.m_minBubbleVal);
            int n7 = (int)this.getValueCoord(this.m_maxBubbleVal);
            int n8 = n6 - n4 / 2;
            int n9 = n7 + n5 / 2;
            double d2 = this.getValueFromCoord(n8);
            double d3 = this.getValueFromCoord(n9);
            boolean bl = this.m_bAutoMin && d2 < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
            boolean bl2 = this.m_bAutoMax && d3 > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
            boolean bl3 = false;
            boolean bl4 = false;
            int n10 = 0;
            int n11 = 10;
            double d4 = this.m_fScaleMin;
            double d5 = this.m_fScaleMax;
            double d6 = d5 - d4;
            while ((bl || bl2) && n10 < n11) {
                double d7;
                if (bl) {
                    d = Math.log(this.getValueFromCoord(n8)) / Math.log(this.m_fLogScaleBase);
                    d7 = Math.floor(d);
                    if (d7 < d4 - d6) {
                        this.m_fScaleMin = d4 - d6;
                        bl = false;
                        bl3 = true;
                    } else {
                        this.m_fScaleMin = d7;
                    }
                    if (!bl4) {
                        bl2 = true;
                    }
                    this._updateValToRelCoord();
                    n6 = (int)this.getValueCoord(this.m_minBubbleVal);
                    n7 = (int)this.getValueCoord(this.m_maxBubbleVal);
                    n8 = n6 - n4 / 2;
                    n9 = n7 + n5 / 2;
                    d2 = this.getValueFromCoord(n8);
                    d3 = this.getValueFromCoord(n9);
                    bl = bl && this.m_bAutoMin && d2 < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
                    boolean bl5 = bl2 = bl2 && this.m_bAutoMax && d3 > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
                }
                if (bl2) {
                    d = Math.log(this.getValueFromCoord(n9)) / Math.log(this.m_fLogScaleBase);
                    d7 = Math.ceil(d);
                    if (d7 > d5 + d6) {
                        this.m_fScaleMax = d5 + d6;
                        bl2 = false;
                        bl4 = true;
                    } else {
                        this.m_fScaleMax = d7;
                    }
                    if (!bl3) {
                        bl = true;
                    }
                    this._updateValToRelCoord();
                    n6 = (int)this.getValueCoord(this.m_minBubbleVal);
                    n7 = (int)this.getValueCoord(this.m_maxBubbleVal);
                    n8 = n6 - n4 / 2;
                    n9 = n7 + n5 / 2;
                    d2 = this.getValueFromCoord(n8);
                    d3 = this.getValueFromCoord(n9);
                    bl = bl && this.m_bAutoMin && d2 < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
                    bl2 = bl2 && this.m_bAutoMax && d3 > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
                }
                ++n10;
            }
        }
        this.m_fScaleStep = 1.0;
        this.m_fMinorStep = 0.1;
        if (!this.m_gt.isDualY() || this.m_gt.isParetoType() || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
            return;
        }
        this.m_numberOfSteps = (int)(this.m_fScaleMax - this.m_fScaleMin);
        this.m_fScaleStep = 1.0;
        if (this.m_requiredSteps != 0 && (this.m_numberOfSteps >= this.m_requiredSteps && this.m_numberOfSteps % this.m_requiredSteps != 0 || this.m_requiredSteps >= this.m_numberOfSteps && this.m_requiredSteps % this.m_numberOfSteps != 0)) {
            if (this.m_bAutoMin) {
                if (this.m_numberOfSteps > this.m_requiredSteps) {
                    n = 2;
                    while (this.m_numberOfSteps >= this.m_requiredSteps) {
                        this.m_requiredSteps *= n++;
                    }
                }
                this.m_fScaleMin = this.m_fScaleMax - this.m_fScaleStep * (double)this.m_requiredSteps;
            } else if (this.m_bAutoMax) {
                if (this.m_numberOfSteps > this.m_requiredSteps) {
                    n = 2;
                    while (this.m_numberOfSteps >= this.m_requiredSteps) {
                        this.m_requiredSteps *= n++;
                    }
                }
                this.m_fScaleMax = this.m_fScaleMin + this.m_fScaleStep * (double)this.m_requiredSteps;
            }
        }
    }

    protected void calcOrdinalScale() {
        this.calcOrdinalScaleGroupSpacing();
        this.calcOrdinalScaleRiserSpacing();
    }

    protected void calcOrdinalScaleRiserSpacing() {
        switch (this.m_nOrdinalAxisType) {
            case 0: {
                this.calcOrdinalScaleRiserSpacingSideBySide();
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / (double)100;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = (this.m_nSpaceBetGroups - this.m_fRiserWidth) / 2.0;
                break;
            }
            case 3: {
                double d = this.m_nSpaceBetGroups / (double)2;
                double d2 = d * (double)this.m_Perspective.getRiserWidth() / 100.0;
                double d3 = this.m_nSpaceBetGroups - (double)2 * d2;
                double d4 = d3 * (double)this.m_Perspective.getRiserBarGroupSpacing() / (double)100;
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / (double)100 / (double)2;
                this.m_nSpaceBetSeries = d2 + d4;
                this.m_nOffsetBetGroupPosAndFirstSeries = (this.m_nSpaceBetGroups - (double)2 * d2 - d4) / (double)2;
                break;
            }
            case 10: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / (double)100;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = this.m_nSpaceBetGroups / (double)2;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = this.m_nSpaceBetGroups / (double)2;
            }
        }
    }

    protected void calcOrdinalScaleRiserSpacingSideBySide() {
        int n = this.getComboAdjustedNumSeries();
        int n2 = this.m_numSeries;
        this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / (double)100 / (double)n;
        double d = this.m_nSpaceBetGroups / (double)n;
        double d2 = d * (double)this.m_Perspective.getRiserWidth() / 100.0;
        double d3 = this.m_numSeries > 1 ? (n == 1 ? 0.2 : (this.m_nSpaceBetGroups - d2) / (double)(n - 1) - d2) : this.m_nSpaceBetGroups - d2;
        double d4 = d3 * (double)this.m_Perspective.getRiserBarGroupSpacing() / (double)100;
        this.m_nSpaceBetSeries = d2 + d4;
        this.m_nOffsetBetGroupPosAndFirstSeries = this.m_numSeries > 1 ? (this.m_nSeriesTypes == null ? (this.m_nSpaceBetGroups - (double)n * d2 - (double)(n - 1) * d4) / (double)2 : (this.m_nSpaceBetGroups - (double)n * d2 - (double)(n - 1) * d4) / (double)2) : (this.m_nSpaceBetGroups - d2) / (double)2;
        this.m_numSeries = n2;
    }

    protected int getComboAdjustedNumSeries() {
        int n = this.m_numSeries;
        if (this.m_numSeries > 1 && this.m_nSeriesTypes != null) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.m_numSeries) {
                if (this.m_nSeriesTypes[n3] != this.m_nBaseRiserType) {
                    ++n2;
                }
                ++n3;
            }
            n = this.m_numSeries - n2;
        }
        return n;
    }

    protected void calcOrdinalScaleGroupSpacing() {
        if (this.isO1WithNestedLabels()) {
            int n = this.isO1WithNestedLabels() && this.m_cbO1Labels != null ? this.m_cbO1Labels.getNumLabelsOnLevel(0) : this.m_nNumLabels;
            if (this.m_nOrdinalAxisType == 6) {
                if (n > 1) {
                    this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)(n - 1);
                    this.m_nLeftPosFirstGroup = -this.m_nSpaceBetGroups / (double)2;
                } else {
                    this.m_nSpaceBetGroups = 0.5;
                    this.m_nLeftPosFirstGroup = 0.5;
                }
            } else {
                this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)n;
                this.m_nLeftPosFirstGroup = 0.0;
            }
        } else if (this.m_nOrdinalAxisType == 6) {
            if (this.m_numGroups > 1) {
                this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)(this.m_numGroups - 1);
                this.m_nLeftPosFirstGroup = -this.m_nSpaceBetGroups / (double)2;
            } else {
                this.m_nSpaceBetGroups = 0.5;
                this.m_nLeftPosFirstGroup = 0.5;
            }
        } else if (this.useSeriesLabels()) {
            this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)this.m_numSeries;
            this.m_nLeftPosFirstGroup = 0.0;
        } else {
            this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)this.m_numGroups;
            this.m_nLeftPosFirstGroup = 0.0;
        }
    }

    protected double getBaseRelCoord() {
        if (this.m_bLogScale) {
            return this.getValueRelCoord(Math.pow(this.m_fLogScaleBase, this.m_fScaleMin));
        }
        return this.getValueRelCoord(this.m_fScaleMin);
    }

    public double getCenterRelCoord(int n) {
        if (!this.m_bNumericAxis) {
            double d;
            if (this.isO1WithNestedLabels() && this.m_cbO1Labels != null && this.m_nNestingLevel != 0) {
                int n2 = this.m_cbO1Labels.getParentIndex(n, this.m_nNestingLevel);
                d = this.m_nLeftPosFirstGroup + (double)n2 * this.m_nSpaceBetGroups;
                if (this.m_nOrdinalAxisType == 6) {
                    d = this.m_nLeftPosFirstGroup + (double)n2 * this.m_nSpaceBetGroups + this.m_nSpaceBetGroups / (double)2;
                }
            } else {
                d = this.m_nLeftPosFirstGroup + (double)n * this.m_nSpaceBetGroups + this.m_nSpaceBetGroups / (double)2;
            }
            if (this.m_bAscending) {
                return this.m_fAxisPositionRel + d;
            }
            return this.m_fAxisPositionRel + this.m_fAxisLengthRel - d;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public double getCenterRelCoord(double d) {
        int n = (int)d;
        double d2 = this.getCenterRelCoord(n);
        return d2;
    }

    protected int getGroupAboveRelCoord(double d) {
        if (!this.m_bNumericAxis) {
            int n;
            if (this.isAscending()) {
                double d2 = (d - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / (double)2) / this.m_nSpaceBetGroups;
                n = (int)Math.ceil(d2 - this.m_nSpaceBetGroups * 1.0E-4);
            } else {
                double d3 = (1.0 - d - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / (double)2) / this.m_nSpaceBetGroups;
                n = (int)Math.floor(d3 + this.m_nSpaceBetGroups * 1.0E-4);
            }
            if (n < 0) {
                n = 0;
            } else if (n >= this.m_numTotalGroups) {
                n = this.m_numTotalGroups - 1;
            }
            return n;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    protected int getGroupBelowRelCoord(double d) {
        if (!this.m_bNumericAxis) {
            int n;
            if (this.isAscending()) {
                double d2 = (d - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / (double)2) / this.m_nSpaceBetGroups;
                n = (int)Math.floor(d2 + this.m_nSpaceBetGroups * 1.0E-4);
            } else {
                double d3 = (1.0 - d - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / (double)2) / this.m_nSpaceBetGroups;
                n = (int)Math.ceil(d3 - this.m_nSpaceBetGroups * 1.0E-4);
            }
            if (n < 0) {
                n = 0;
            } else if (n >= this.m_numTotalGroups) {
                n = this.m_numTotalGroups - 1;
            }
            return n;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    protected double getHighRelCoord(int n, int n2) {
        if (!this.m_bNumericAxis) {
            return this.getLowRelCoord(n, n2) + this.m_fRiserWidth;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public double getIntervalStart(int n) {
        if (this.m_bNumericAxis) {
            return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fScaleStep * (double)n) : this.m_fScaleMin + this.m_fScaleStep * (double)n;
        }
        throw new AssertionException("Numeric Axis method call on ordinal axis");
    }

    public double getIntervalStop(int n) {
        if (this.m_bNumericAxis) {
            return this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fScaleStep * (double)(n + 1)) : this.m_fScaleMin + this.m_fScaleStep * (double)(n + 1);
        }
        throw new AssertionException("Numeric Axis method call on ordinal axis");
    }

    protected double getLabelRelPos(int n) {
        if (this.m_bNumericAxis) {
            return this.getMajorGridPos(n);
        }
        return this.getCenterRelCoord(n);
    }

    protected double getLowRelCoord(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = this.getLowRelCoord(n, n2);
        return d3;
    }

    protected void initSeriesTypes() {
        this.m_nSeriesTypes = this.m_Perspective.getSeriesTypes();
        this.m_nBaseRiserType = this.m_Perspective.getBaseRiserType();
        this.m_bIsComboChart = false;
        int n = 0;
        while (n < this.m_Perspective.getNumTotalSeries()) {
            if (this.m_nSeriesTypes[n] != this.m_nBaseRiserType) {
                this.m_bIsComboChart = true;
            }
            ++n;
        }
    }

    protected double getLowRelCoord(int n, int n2) {
        if (this.m_bNumericAxis) {
            throw new AssertionException("Ordinal Axis method call on numerical axis");
        }
        int n3 = this.m_Perspective.getGraphType();
        double d = n3 >= 41 && n3 <= 47 || n3 >= 31 && n3 <= 35 ? (double)n2 * this.m_nSpaceBetGroups : (double)n2 * this.m_nSpaceBetGroups + this.m_nOffsetBetGroupPosAndFirstSeries;
        double d2 = 0.0;
        PfjAssert.pfjAssert(this.m_nSeriesTypes != null);
        boolean bl = false;
        if (this.m_gt.getIntegerGraphType() == 20 || this.m_gt.getIntegerGraphType() == 27) {
            bl = true;
        }
        if (this.m_nSeriesTypes[n] == this.m_nBaseRiserType || bl) {
            d2 = this.adjustLowRelForComboCharts(d, n, n2);
            if (this.m_nOrdinalAxisType == 2) {
                d2 -= this.m_fRiserWidth / (double)2;
            }
            d2 = this.m_bAscending ? this.m_fAxisPositionRel + d2 : this.m_fAxisPositionRel + this.m_fAxisLengthRel - d2 - this.m_fRiserWidth;
        } else {
            JGraphType jGraphType = this.m_Perspective.getJGraphType();
            d2 = this.getCenterRelCoord(n2) - this.m_fRiserWidth / (double)2;
            if (this.m_nOrdinalAxisType == 2) {
                d2 -= this.m_fRiserWidth / (double)2;
            }
        }
        return d2;
    }

    protected double adjustLowRelForComboCharts(double d, int n, int n2) {
        double d2 = d;
        if (this.m_bIsComboChart && this.m_nSeriesTypes != null) {
            int n3 = 0;
            while (n3 < n) {
                if (this.m_nSeriesTypes[n3] == this.m_nBaseRiserType || this.m_gt.getIntegerGraphType() == 20 || this.m_gt.getIntegerGraphType() == 27) {
                    d2 += this.m_nSpaceBetSeries;
                }
                ++n3;
            }
        } else {
            d2 = d + (double)n * this.m_nSpaceBetSeries;
        }
        return d2;
    }

    protected double getMajorGridPos(int n) {
        if (this.m_bNumericAxis) {
            return this.getValueRelCoord(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + this.m_fScaleStep * (double)n) : this.m_fScaleMin + this.m_fScaleStep * (double)n);
        }
        if (this.m_nOrdinalAxisType == 6 || this.m_nOrdinalAxisType == 9) {
            return this.getCenterRelCoord(n);
        }
        double d = this.getCenterRelCoord(n - 1);
        double d2 = 0.0;
        d2 = this.m_nOrdinalAxisType == 2 ? this.m_nSpaceBetGroups : this.m_nSpaceBetGroups / (double)2;
        d = this.m_bAscending ? (d += d2) : (d -= d2);
        return d;
    }

    protected double getMinorGridPos(int n, int n2) {
        if (this.m_bNumericAxis) {
            double d = this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)n) * (double)(n2 + 2) : this.m_fScaleMin + this.m_fScaleStep * (double)n + this.m_fMinorStep * (double)(n2 + 1);
            return this.getValueRelCoord(d);
        }
        double d = this.m_nSpaceBetGroups / (double)(this.getNumMinorGrids() + 1);
        return this.getMajorGridPos(n) + d * (double)(n2 + 1);
    }

    Vector getNumericLabels() {
        Vector<String> vector;
        block11: {
            PfjAssert.pfjAssert(this.m_bNumericAxis);
            vector = null;
            boolean bl = false;
            if (!this.m_bNumericAxis) break block11;
            vector = new Vector<String>(this.getNumLabels());
            IdentObj identObj = new IdentObj(this.m_template.getLabel());
            int n = this.m_Perspective.getTextFormatPreset(identObj);
            String string = this.m_Perspective.getTextFormatPattern(identObj);
            if (n == 0 && this.m_gt.isPercent()) {
                n = 2;
            }
            if (this.isY2Axis() && this.m_gt.isParetoType()) {
                n = 23;
                int n2 = 0;
                while (n2 < this.getNumLabels()) {
                    String string2 = TDGNumberFormat.toString(this.m_Perspective, n, MathExt.sigdigits((double)n2 * this.m_Y2DefaultScaleStep, 10), string);
                    if (this.m_Perspective.isNumberFormatCallBack()) {
                        NumberFormatCallBack numberFormatCallBack = this.m_Perspective.getNumberFormatCallBack();
                        numberFormatCallBack.setAxisMin(this.getMinValue());
                        numberFormatCallBack.setAxisMax(this.getMaxValue());
                        numberFormatCallBack.setAxisStep(this.getStepValue());
                        int n3 = this.m_template.getAxisObjID();
                        numberFormatCallBack.setState(0, -3, -3, n3, n2);
                        double d = Double.parseDouble(string2) / (double)100;
                        string2 = numberFormatCallBack.toString(d);
                    }
                    vector.addElement(string2);
                    ++n2;
                }
            } else {
                int n4 = 0;
                while (n4 < this.getNumLabels()) {
                    String string3;
                    if (this.m_Perspective.isNumberFormatCallBack()) {
                        this.m_Perspective.getNumberFormatCallBack().setAxisMin(this.getMinValue());
                        this.m_Perspective.getNumberFormatCallBack().setAxisMax(this.getMaxValue());
                        this.m_Perspective.getNumberFormatCallBack().setAxisStep(this.getStepValue());
                        int n5 = this.m_template.getAxisObjID();
                        this.m_Perspective.getNumberFormatCallBack().setState(0, -3, -3, n5, n4);
                        string3 = this.m_Perspective.getNumberFormatCallBack().toString(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)n4 * this.m_fScaleStep) : this.m_fScaleMin + (double)n4 * this.m_fScaleStep);
                    } else {
                        if (this.m_bNonZeroBaseline && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter()) {
                            double d = this.m_Perspective.getNonZeroBaselineValue(this.m_template.getAxis());
                            double d2 = MathExt.sigdigits(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)n4 * this.m_fScaleStep) : this.m_fScaleMin + (double)n4 * this.m_fScaleStep, 10);
                            if (d2 == d) {
                                bl = true;
                            }
                            if (d2 > d && !bl) {
                                string3 = TDGNumberFormat.toString(this.m_Perspective, n, MathExt.sigdigits(d, 10), string);
                                this.m_NonZeroBaselineLabel = new String(string3);
                                bl = true;
                            }
                        }
                        string3 = TDGNumberFormat.toString(this.m_Perspective, n, MathExt.sigdigits(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)n4 * this.m_fScaleStep) : this.m_fScaleMin + (double)n4 * this.m_fScaleStep, 10), string);
                    }
                    vector.addElement(string3);
                    ++n4;
                }
            }
        }
        return vector;
    }

    Vector getNumericLabelsAsDouble() {
        PfjAssert.pfjAssert(this.m_bNumericAxis);
        if (this.m_bNumericAxis) {
            Vector<Double> vector = new Vector<Double>(this.getNumLabels());
            int n = 0;
            while (n < this.getNumLabels()) {
                double d = this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin + (double)n * this.m_fScaleStep) : this.m_fScaleMin + (double)n * this.m_fScaleStep;
                Double d2 = new Double(d);
                vector.addElement(d2);
                ++n;
            }
            return vector;
        }
        return null;
    }

    public int getNumIntervals() {
        if (this.m_bNumericAxis) {
            double d = (this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep;
            double d2 = Math.rint(d);
            int n = FP.equal(d, d2) ? (int)(d2 + 1.0) : (int)(d + 1.0);
            return n;
        }
        throw new AssertionException("Numeric Axis method call on ordinal axis");
    }

    private void calcNumLabels() {
        double d;
        double d2;
        this.m_nNumLabels = this.m_bNumericAxis ? (this.isY2Axis() && this.m_gt.isParetoType() ? (int)((double)100 / this.m_Y2DefaultScaleStep) + 1 : (FP.equal(d2 = (this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep, d = Math.rint(d2)) ? (int)(d + 1.0) : (int)(d2 + 1.0))) : (!this.useSeriesLabels() ? this.m_numGroups : this.m_numSeries);
    }

    protected int getNumLabels() {
        int n = this.isO1WithNestedLabels() && this.m_cbO1Labels != null ? this.m_cbO1Labels.getNumLabelsOnLevel(this.m_nNestingLevel) : this.m_nNumLabels;
        return n;
    }

    protected int getNumMajorGrids() {
        if (!this.m_bNumericAxis && this.m_nOrdinalAxisType == 0) {
            return this.getNumLabels() + 1;
        }
        return this.getNumLabels();
    }

    protected int getNumMinorGrids() {
        int n;
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return 8;
            }
            n = (int)Math.max(Math.floor(this.m_fScaleStep / this.m_fMinorStep), 0.0);
            if (FP.equal(this.m_fMinorStep * (double)n, this.m_fScaleStep)) {
                --n;
            }
        } else {
            n = this.m_Perspective.getGridCount(this.m_template.getMinor());
        }
        return n;
    }

    protected double getValueFromRelCoord(double d) {
        if (this.m_bNumericAxis) {
            double d2 = this.m_bAscending ? (d - this.m_fAxisPositionRel) / this.m_fValToRelCoord + this.m_fScaleMin : (this.m_fAxisPositionRel + this.m_fAxisLengthRel - d) / this.m_fValToRelCoord + this.m_fScaleMin;
            if (this.m_bLogScale) {
                d2 = Math.pow(this.m_fLogScaleBase, d2);
            }
            return d2;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getValueRelCoord(double d) {
        if (!this.m_gt.isBLAType() && !this.m_bLogScale) {
            if (d < this.m_fScaleMin) {
                d = this.m_fScaleMin;
            }
            if (d > this.m_fScaleMax) {
                d = this.m_fScaleMax;
            }
        }
        if (this.m_bLogScale) {
            d = d == 0.0 ? this.m_fScaleMin : Math.log(d) / Math.log(this.m_fLogScaleBase);
        }
        double d2 = d - this.m_fScaleMin;
        if (this.m_fScaleMax - this.m_fScaleMin <= 0.0) {
            d2 = 1.0;
        }
        double d3 = this.m_bAscending ? this.m_fAxisPositionRel + d2 * this.m_fValToRelCoord : this.m_fAxisPositionRel + this.m_fAxisLengthRel - d2 * this.m_fValToRelCoord;
        if (!this.m_gt.isBLAType()) {
            d3 = Math.min(d3, 1.0);
            if (this.pinCoordToMinScale()) {
                d3 = Math.max(d3, 0.0);
            }
        }
        return d3;
    }

    public boolean hasNegData() {
        if (this.m_bNumericAxis) {
            return this.m_fScaleMin < 0.0;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public boolean isNumericAxis() {
        return this.m_bNumericAxis;
    }

    protected boolean isZeroInRange() {
        if (this.m_bNumericAxis) {
            return !(this.m_fScaleMin > 0.0) && !(this.m_fScaleMax < 0.0);
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    private void _updateValToRelCoord() {
        this.m_fValToRelCoord = this.m_fScaleMax - this.m_fScaleMin <= 0.0 ? this.m_fAxisLengthRel : this.m_fAxisLengthRel / (this.m_fScaleMax - this.m_fScaleMin);
    }

    private void _calcBubbleSizes() {
        this._updateValToRelCoord();
        JChart_Base jChart_Base = this.m_Perspective.getGraphObject();
        JChart_2D_Scat jChart_2D_Scat = null;
        if (jChart_Base instanceof JChart_2D_Scat) {
            jChart_2D_Scat = (JChart_2D_Scat)jChart_Base;
        }
        if (jChart_2D_Scat != null && this.getAxisObjID() == 8) {
            jChart_2D_Scat.calcBubbleSizes(this.m_fScaleMin, this.m_fScaleMax);
        }
    }

    private void _calcMinMaxBubblesOnAxis() {
        this._updateValToRelCoord();
        JChart_Base jChart_Base = this.m_Perspective.getGraphObject();
        JChart_2D_Scat jChart_2D_Scat = null;
        if (jChart_Base instanceof JChart_2D_Scat) {
            jChart_2D_Scat = (JChart_2D_Scat)jChart_Base;
        }
        if (jChart_2D_Scat != null && (this.getAxisObjID() == 0 || this.getAxisObjID() == 1 || this.getAxisObjID() == 7) && (this.m_bAutoMax || this.m_bAutoMin)) {
            SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
            int n = 0;
            int n2 = 0;
            double d = this.m_fScaleMin;
            double d2 = this.m_fScaleMax;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (this.m_bLogScale) {
                n5 = (int)this.getValueCoord(Math.pow(this.m_fLogScaleBase, d));
                n6 = (int)this.getValueCoord(Math.pow(this.m_fLogScaleBase, d2));
            } else {
                n5 = (int)this.getValueCoord(d);
                n6 = (int)this.getValueCoord(d2);
            }
            while (seriesEnumerator.hasMoreElements()) {
                n = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_numTotalSeries);
                int n7 = 0;
                if (this.getAxisObjID() == 7) {
                    n7 = 7;
                } else if (this.m_gt.isDualY()) {
                    n7 = this.m_Perspective.getAxisAssignment(n);
                }
                if (n7 != this.getAxisObjID()) continue;
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_numTotalGroups);
                    int n8 = 0;
                    double d3 = 0.0;
                    try {
                        switch (n7) {
                            case 0: 
                            case 1: {
                                d3 = jChart_2D_Scat.getXYZ_YValue(n, n2);
                                n8 = jChart_2D_Scat.getBubbleSizeY(n, n2);
                                break;
                            }
                            case 7: {
                                d3 = jChart_2D_Scat.getXYZ_XValue(n, n2);
                                n8 = jChart_2D_Scat.getBubbleSizeX(n, n2);
                            }
                        }
                    }
                    catch (AssertionException assertionException) {
                        continue;
                    }
                    if (this.m_bLogScale && d3 <= 0.0) continue;
                    int n9 = (int)this.getValueCoord(d3);
                    if (n9 + n8 / 2 > n5 + n3 / 2) {
                        d = d3;
                        n5 = n9;
                        n3 = n8;
                    }
                    if (n9 - n8 / 2 >= n6 - n4 / 2) continue;
                    d2 = d3;
                    n6 = n9;
                    n4 = n8;
                }
            }
            this.m_minBubbleVal = d2;
            this.m_maxBubbleVal = d;
            this.m_minBubbleSize = n4;
            this.m_maxBubbleSize = n3;
        }
    }

    protected void calcNumericScale() {
        if (this.m_gt.isBubble() && this.getAxisObjID() == 8) {
            this._calcBubbleSizes();
        }
        boolean bl = false;
        if (this.isY2Axis() && this.m_gt.isParetoType()) {
            this.m_fScaleMin = 0.0;
            if (this.m_bAutoStep) {
                this.m_Y2DefaultScaleStep = 10.0;
                this.m_Perspective.putToLookNoCalc(new IdentObj(2000), Attr.ParetoY2MajorGridStep, new Double(10.0));
            } else {
                this.m_Y2DefaultScaleStep = this.m_Perspective.getParetoY2MajorGridStep();
            }
            this.m_fScaleMax = this.getParetoSeriesMaximum(this.m_Perspective.getDisplayParetoSeries());
            if (this.m_bAutoStep && this.m_Y2DefaultScaleStep < this.m_fMinAutoScaleStep && this.m_fMinAutoScaleStep <= (double)100) {
                this.m_Y2DefaultScaleStep = this.m_fMinAutoScaleStep;
            }
            if (this.m_bAutoStep && this.m_fMinAutoScaleStep != 0.0 && this.m_Y2DefaultScaleStep > this.m_fMinAutoScaleStep && !FP.equal(this.m_Y2DefaultScaleStep % this.m_fMinAutoScaleStep, 0.0)) {
                this.m_Y2DefaultScaleStep -= this.m_Y2DefaultScaleStep % this.m_fMinAutoScaleStep;
            }
            this.m_fScaleStep = (this.m_fScaleMax - this.m_fScaleMin) / 10.0;
            this.m_fScaleStep = (this.m_fScaleMax - this.m_fScaleMin) / (100.0 / this.m_Y2DefaultScaleStep);
            this.m_bAutoStep = false;
        }
        if (this.m_gt.isPercent()) {
            this.m_bAutoStep = false;
            this.m_bAutoMin = false;
            this.m_bAutoMax = false;
            this.m_fScaleMax = this.m_objMinMax.getAdjMax() > 0.0 ? 1.0 : 0.0;
            this.m_fScaleMin = this.m_objMinMax.getAdjMin() < 0.0 ? -1.0 : 0.0;
            this.m_fScaleStep = 0.2;
            this.m_bLogScale = false;
        }
        if (this.m_fScaleMin > this.m_fScaleMax) {
            double d = this.m_fScaleMin;
            this.m_fScaleMin = this.m_fScaleMax;
            this.m_fScaleMax = d;
            this.m_bAscending = !this.m_bAscending;
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3959, "Warning: Scale minimum larger that scale maximum, axis automatically inverted", null);
            }
            bl = true;
        }
        if (this.m_fScaleStep < 0.0 && !this.m_bAutoStep) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3960, "Warning: Negative axis step, step set to automatic", null);
            }
            this.m_bAutoStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        } else if (this.m_fScaleStep > this.m_fScaleMax - this.m_fScaleMin && this.m_fScaleMax != this.m_fScaleMin && !this.m_bAutoStep) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3961, "Warning: Step larger than range, step set to automatic", null);
            }
            this.m_bAutoStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        } else if (this.m_fScaleStep * (double)100 < this.m_fScaleMax - this.m_fScaleMin && !this.m_bAutoStep) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3962, "Warning: Step too small (too many labels/grids), step set to automatic", null);
            }
            this.m_bAutoStep = true;
            this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
        }
        if (this.m_bLogScale) {
            if (this.m_fScaleMin <= 0.0) {
                this.m_bLogScale = false;
                this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
                TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
                if (!this.m_Perspective.getAxesPreviewMode()) {
                    tDGErrorManager.notifyErrorListener(this, 3963, "Warning: Negative or null minimum scale invalid for a logarithmic scale: set to linear scales", null);
                }
            }
            if (this.m_fScaleMax <= 0.0) {
                this.m_bLogScale = false;
                this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
                TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
                if (!this.m_Perspective.getAxesPreviewMode()) {
                    tDGErrorManager.notifyErrorListener(this, 3964, "Warning: Negative or null maximum scale invalid for a logarithmic scale: set to linear scales", null);
                }
            }
            if (this.m_bLogScale) {
                this.calcLogScale();
                this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), true);
                this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fScaleStep);
                return;
            }
        }
        if (FP.equal(this.m_fScaleMin, 0.0) && FP.equal(this.m_fScaleMax, 0.0)) {
            this.m_bAutoMax = false;
            this.m_bAutoMin = false;
            this.m_bAutoStep = false;
            this.m_fScaleMax = 1.0;
            this.m_fScaleMin = 0.0;
            this.m_fScaleStep = 0.2;
            this.m_Perspective.setLogScale(this.m_template.getAxis(), false);
            this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fScaleStep);
            this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
            this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3965, "Warning: scale minimum and maximum are both 0, scaling from 0 to 1", null);
            }
        }
        if (FP.equal(this.m_fScaleMin, this.m_fScaleMax) && !this.m_bAutoMax && !this.m_bAutoMin) {
            this.m_bAutoMax = true;
            this.m_bAutoMin = true;
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3965, "Warning: scale minimum and maximum are equal, set to automatic", null);
            }
            bl = true;
        }
        if (this.m_objMinMax.isDataDerived()) {
            double d = (Math.abs(this.m_fScaleMin) + Math.abs(this.m_fScaleMax)) / (double)2;
            double d2 = Math.abs(this.m_fScaleMax - this.m_fScaleMin);
            double d3 = 1.05;
            if (d != 0.0 && d2 != 0.0 && d2 < 0.5 * d) {
                d3 = 1.0 + 0.1 * d2 / d;
            }
            if (this.m_bAutoMin) {
                this.m_fScaleMin = this.m_fScaleMin < 0.0 ? (this.m_fScaleMin *= d3) : (this.m_fScaleMin /= d3);
            }
            if (this.m_bAutoMax) {
                this.m_fScaleMax = this.m_fScaleMax < 0.0 ? (this.m_fScaleMax /= d3) : (this.m_fScaleMax *= d3);
            }
        }
        if (this.m_bAutoMax || this.m_bAutoMin || this.m_bAutoStep) {
            this.calcAutoMinMax();
        } else {
            this.m_numberOfSteps = (int)Math.round((this.m_fScaleMax - this.m_fScaleMin) / this.m_fScaleStep);
        }
        if (!this.m_gt.isPercent()) {
            this.m_Perspective.setGridStep(this.m_template.getMajor(), this.m_fScaleStep);
            if (bl || this.m_bAutoMax || this.m_bAutoMin || this.m_bAutoStep) {
                if (bl) {
                    this.m_Perspective.setScaleMaxAuto(this.m_template.getAxis(), this.m_bAutoMax);
                    this.m_Perspective.setScaleMinAuto(this.m_template.getAxis(), this.m_bAutoMin);
                    this.m_Perspective.setGridStepAuto(this.m_template.getMajor(), this.m_bAutoStep);
                }
                this.m_Perspective.setAxisDescending(this.m_template.getAxis(), !this.m_bAscending);
                if (this.isY2Axis() && this.m_gt.isParetoType()) {
                    this.m_Perspective.setScaleMax(this.m_template.getAxis(), 100.0);
                    this.m_Perspective.setScaleMin(this.m_template.getAxis(), 0.0);
                } else if (!(this.m_gt.isParetoType() || this.m_bNonZeroBaseline && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter())) {
                    this.m_Perspective.setScaleMax(this.m_template.getAxis(), this.m_fScaleMax);
                    this.m_Perspective.setScaleMin(this.m_template.getAxis(), this.m_fScaleMin);
                }
            }
        }
    }

    protected boolean isLogScale() {
        return this.m_bLogScale;
    }

    private void calcMinorStep() {
        boolean bl = this.m_Perspective.getGridStepAuto(this.m_template.getMinor());
        boolean bl2 = false;
        this.m_fMinorStep = bl ? this.m_fScaleStep / (double)2 : this.m_Perspective.getGridStep(this.m_template.getMinor());
        if (this.m_fMinorStep < 0.0 && !this.m_bAutoStep) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3966, "Warning: Negative axis minor step, minor step set to automatic", null);
            }
            this.m_fMinorStep = this.m_fScaleStep / (double)2;
            bl = true;
            bl2 = true;
        } else if (this.m_fMinorStep >= this.m_fScaleStep) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3967, "Warning: Minor step larger than range, minor step set to automatic", null);
            }
            this.m_fMinorStep = this.m_fScaleStep / (double)2;
            bl = true;
            bl2 = true;
        } else if (this.m_fMinorStep * (double)100 < this.m_fScaleStep) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            if (!this.m_Perspective.getAxesPreviewMode()) {
                tDGErrorManager.notifyErrorListener(this, 3968, "Warning: Minor step too small (too many minor grids), minor step set to automatic", null);
            }
            this.m_fMinorStep = this.m_fScaleStep / (double)2;
            bl = true;
            bl2 = true;
        }
        if (bl2 || this.m_bLogScale) {
            this.m_Perspective.setGridStepAuto(this.m_template.getMinor(), true);
            this.m_Perspective.setGridStep(this.m_template.getMinor(), this.m_fMinorStep);
        }
    }

    protected double getMinCoord() {
        if (this.m_bNumericAxis) {
            return this.getValueCoord(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMin) : this.m_fScaleMin);
        }
        throw new AssertionException("This method should be called only for numeric axis");
    }

    protected double getMaxCoord() {
        if (this.m_bNumericAxis) {
            return this.getValueCoord(this.m_bLogScale ? Math.pow(this.m_fLogScaleBase, this.m_fScaleMax) : this.m_fScaleMax);
        }
        throw new RuntimeException("This method should be called only for numeric axis");
    }

    public double getMinValue() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fScaleMin);
            }
            return this.m_fScaleMin;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getBaseMax() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fBaseMax);
            }
            return this.m_fBaseMax;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getBaseMin() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fBaseMin);
            }
            return this.m_fBaseMin;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getMaxValue() {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
            }
            return this.m_fScaleMax;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public double getStepValue() {
        if (this.m_bNumericAxis) {
            return this.m_fScaleStep;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    public boolean isValueOffscale(double d) {
        if (this.m_bNumericAxis) {
            if (this.m_bLogScale) {
                return d < Math.pow(this.m_fLogScaleBase, this.m_fScaleMin) || d > Math.pow(this.m_fLogScaleBase, this.m_fScaleMax);
            }
            return d < this.m_fScaleMin || d > this.m_fScaleMax;
        }
        throw new AssertionException("Numerical Axis method call on ordinal axis");
    }

    protected boolean pinCoordToMinScale() {
        return true;
    }

    protected boolean useSeriesLabels() {
        if (this.m_bNumericAxis) {
            throw new AssertionException("Numerical Axis method call on ordinal axis");
        }
        boolean bl = this.m_nOrdinalAxisType == 8 || this.m_nOrdinalAxisType == 4;
        return bl;
    }

    protected abstract double getBaseCoord();

    protected abstract boolean isPolarAxis();

    public abstract void calcAxisBody();

    protected abstract void adjustLabelPos(int var1, int var2, Vector var3);

    protected abstract int getTitleJustVert(IdentObj var1, int var2);

    protected abstract int getTitleJustHoriz(IdentObj var1, int var2);

    protected abstract double getCenterCoord(int var1);

    protected abstract int getGroupAboveCoord(int var1);

    protected abstract int getGroupBelowCoord(int var1);

    protected abstract double getHighCoord(int var1, int var2);

    protected abstract double getLowCoord(int var1, int var2);

    protected abstract double getValueCoord(double var1);

    protected abstract double getValueFromCoord(int var1);

    public void setParetoSeriesMaximum(int n, double d) {
        this.m_nParetoSeriesMaximums[n] = d;
    }

    public double getParetoSeriesMaximum(int n) {
        return this.m_nParetoSeriesMaximums[n];
    }

    public void setParetoSeriesMinimum(int n, double d) {
        this.m_nParetoSeriesMinimums[n] = d;
    }

    public double getParetoSeriesMinimum(int n) {
        return this.m_nParetoSeriesMinimums[n];
    }

    public String getNonZeroBaselineLabel() {
        return this.m_NonZeroBaselineLabel;
    }
}

