/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Polygon;
import oracle.dss.graph.pfj.Cubic;

public class NatCubic {
    static final int STEPS = 12;

    private NatCubic() {
    }

    static Cubic[] calcNaturalCubic(int n, int[] nArray) {
        float[] fArray = new float[n + 1];
        float[] fArray2 = new float[n + 1];
        float[] fArray3 = new float[n + 1];
        fArray[0] = 0.5f;
        int n2 = 1;
        while (n2 < n) {
            fArray[n2] = 1.0f / ((float)4 - fArray[n2 - 1]);
            ++n2;
        }
        fArray[n] = 1.0f / ((float)2 - fArray[n - 1]);
        fArray2[0] = (float)(3 * (nArray[1] - nArray[0])) * fArray[0];
        n2 = 1;
        while (n2 < n) {
            fArray2[n2] = ((float)(3 * (nArray[n2 + 1] - nArray[n2 - 1])) - fArray2[n2 - 1]) * fArray[n2];
            ++n2;
        }
        fArray2[n] = ((float)(3 * (nArray[n] - nArray[n - 1])) - fArray2[n - 1]) * fArray[n];
        fArray3[n] = fArray2[n];
        n2 = n - 1;
        while (n2 >= 0) {
            fArray3[n2] = fArray2[n2] - fArray[n2] * fArray3[n2 + 1];
            --n2;
        }
        Cubic[] cubicArray = new Cubic[n];
        n2 = 0;
        while (n2 < n) {
            cubicArray[n2] = new Cubic(nArray[n2], fArray3[n2], (float)(3 * (nArray[n2 + 1] - nArray[n2])) - (float)2 * fArray3[n2] - fArray3[n2 + 1], (float)(2 * (nArray[n2] - nArray[n2 + 1])) + fArray3[n2] + fArray3[n2 + 1]);
            ++n2;
        }
        return cubicArray;
    }

    public static Polygon interpolate(Polygon polygon) {
        Polygon polygon2 = new Polygon();
        if (polygon.npoints >= 2) {
            Cubic[] cubicArray = NatCubic.calcNaturalCubic(polygon.npoints - 1, polygon.xpoints);
            Cubic[] cubicArray2 = NatCubic.calcNaturalCubic(polygon.npoints - 1, polygon.ypoints);
            polygon2.addPoint(Math.round(cubicArray[0].eval(0.0f)), Math.round(cubicArray2[0].eval(0.0f)));
            int n = 0;
            while (n < cubicArray.length) {
                int n2 = 1;
                while (n2 <= 12) {
                    float f = (float)n2 / 12.0f;
                    polygon2.addPoint(Math.round(cubicArray[n].eval(f)), Math.round(cubicArray2[n].eval(f)));
                    ++n2;
                }
                ++n;
            }
        }
        return polygon2;
    }
}

