/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;

public class NYDescriptor
implements Serializable {
    public static final boolean[] usageValuesTwoY = new boolean[]{true, true};
    public static final boolean[] usageValuesThreeY = new boolean[]{true, true, true};
    public static final boolean[] usageValuesFourY = new boolean[]{true, true, true, true};
    public static final boolean[] usageValuesFiveY = new boolean[]{true, true, true, true, true};
    protected final boolean[] m_bUsageValues;
    protected final float[] m_fStartValues;
    protected final float[] m_fSizeValues;

    public NYDescriptor(boolean[] blArray) throws IllegalArgumentException {
        if (blArray == null) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed with null values");
        }
        if (blArray.length == 0 || !blArray[0]) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed without valid Y1 values");
        }
        this.m_bUsageValues = new boolean[blArray.length];
        this.m_fStartValues = new float[blArray.length];
        this.m_fSizeValues = new float[blArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                ++n;
            }
            ++n2;
        }
        float f = 1.0f;
        int n3 = 0;
        int n4 = 0;
        while (n4 < blArray.length) {
            this.m_bUsageValues[n4] = blArray[n4];
            if (!blArray[n4]) {
                this.m_fStartValues[n4] = 0.0f;
                this.m_fSizeValues[n4] = 0.0f;
            } else {
                float f2;
                this.m_fSizeValues[n4] = f2 = f / (float)(n - n3);
                this.m_fStartValues[n4] = 1.0f - f;
                f -= f2;
                ++n3;
            }
            ++n4;
        }
    }

    public NYDescriptor(boolean[] blArray, float[] fArray, float[] fArray2) throws IllegalArgumentException {
        if (blArray == null || fArray == null || fArray2 == null) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed with null arguments");
        }
        int n = Math.min(Math.min(blArray.length, fArray.length), fArray2.length);
        if (n == 0 || !blArray[0] || fArray2[0] <= 0.0f) {
            throw new IllegalArgumentException("NYDescriptor cannot be constructed with empty arrays or invalid Y1 values");
        }
        this.m_bUsageValues = new boolean[n];
        this.m_fStartValues = new float[n];
        this.m_fSizeValues = new float[n];
        int n2 = 0;
        while (n2 < n) {
            if (fArray[n2] < 0.0f || fArray[n2] > 1.0f || fArray2[n2] < 0.0f || fArray2[n2] > 1.0f) {
                throw new IllegalArgumentException("start and size values must be between 0 and 1");
            }
            if (this.m_bUsageValues[n2] && fArray2[n2] == 0.0f) {
                throw new IllegalArgumentException("size must be positive if the axis is in use");
            }
            this.m_bUsageValues[n2] = blArray[n2];
            this.m_fStartValues[n2] = fArray[n2];
            this.m_fSizeValues[n2] = fArray2[n2];
            ++n2;
        }
    }

    public boolean hasYAxis(int n) {
        return n < this.m_bUsageValues.length && this.m_bUsageValues[n];
    }

    public float getOffset(int n) {
        if (n < this.m_fStartValues.length) {
            return this.m_fStartValues[n];
        }
        return 0.0f;
    }

    public float getSize(int n) {
        if (n < this.m_fSizeValues.length) {
            return this.m_fSizeValues[n];
        }
        return 0.0f;
    }

    public String toString() {
        return super.toString();
    }
}

