/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Polygon;
import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataStorage;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.NatCubic;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.SeriesEnumerator;

public class MissingData {
    public static final int MISSINGDATA_SKIP = 0;
    public static final int MISSINGDATA_ZERO = 1;
    public static final int MISSINGDATA_INTERPOLATE = 2;
    Perspective m_Perspective;
    Access m_Access;
    JChart_Base m_Chart;
    DataStorage m_DataStorage;

    public MissingData(JChart_Base jChart_Base, Perspective perspective, Access access, DataStorage dataStorage) {
        this.m_Perspective = perspective;
        this.m_Access = access;
        this.m_Chart = jChart_Base;
        this.m_DataStorage = dataStorage;
    }

    public void calcMissingData(SeriesEnumerator seriesEnumerator, boolean bl) {
        int n = this.m_Perspective.getFillMissingData();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.calcMissingDataZero(seriesEnumerator, bl);
                break;
            }
            case 2: {
                this.calcMissingDataInterpolated(seriesEnumerator, bl);
            }
        }
    }

    private void calcMissingDataZero(SeriesEnumerator seriesEnumerator, boolean bl) {
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n2 = groupsEnumerator.nextGroup();
                boolean bl2 = this.shouldFillInMissingData(bl, n, n2);
                if (!bl2) continue;
                this.m_Chart.setDataAsDouble(n, n2, DataItem.DI_GENERAL, 0.0);
                this.m_DataStorage.setFillMissingData(n, n2, true);
            }
        }
    }

    private void calcMissingDataInterpolated(SeriesEnumerator seriesEnumerator, boolean bl) {
        Polygon polygon = null;
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            Vector vector = this.getMissingDataGroupIndices(bl, n, polygon = new Polygon());
            if (vector.size() < 1) continue;
            Polygon polygon2 = NatCubic.interpolate(polygon);
            this.setMissingDataForSeries(n, vector, polygon2);
        }
    }

    Vector getMissingDataGroupIndices(boolean bl, int n, Polygon polygon) {
        Vector<Integer> vector = new Vector<Integer>();
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            Serializable serializable;
            int n2 = groupsEnumerator.nextGroup();
            boolean bl2 = this.shouldFillInMissingData(bl, n, n2);
            if (bl2) {
                serializable = new Integer(n2);
                vector.addElement((Integer)serializable);
                continue;
            }
            serializable = this.m_Chart.getDataValue(n, n2, DataItem.DI_GENERAL);
            double d = ((DatumObj)serializable).m_fValue;
            polygon.addPoint(n2, (int)d);
        }
        return vector;
    }

    private boolean shouldFillInMissingData(boolean bl, int n, int n2) {
        boolean bl2 = false;
        DatumObj datumObj = this.m_Chart.getDataValue(n, n2, DataItem.DI_GENERAL);
        double d = datumObj.m_fValue;
        if (bl) {
            if (!datumObj.m_bOK) {
                bl2 = true;
            }
        } else {
            boolean bl3 = this.m_DataStorage.isMissingDataFilledIn(n, n2);
            if (bl3) {
                bl2 = true;
            }
        }
        return bl2;
    }

    private void setMissingDataForSeries(int n, Vector vector, Polygon polygon) {
        int n2 = 0;
        while (n2 < vector.size()) {
            Integer n3 = (Integer)vector.elementAt(n2);
            int n4 = n3;
            double d = this.getAverageInterpolatedValue(n4, polygon);
            this.m_Chart.setDataAsDouble(n, n4, DataItem.DI_GENERAL, d);
            this.m_DataStorage.setFillMissingData(n, n4, true);
            ++n2;
        }
    }

    private double getAverageInterpolatedValue(int n, Polygon polygon) {
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        int n4 = 0;
        while (n4 < polygon.npoints - 1) {
            if (n == polygon.xpoints[n4]) {
                n2 += polygon.ypoints[n4];
                ++n3;
            }
            ++n4;
        }
        if (n3 != 0) {
            d = n2 / n3;
        }
        return d;
    }
}

