/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;

public class MinMaxObj
implements Serializable {
    public static final double DEFAULT_MIN = Double.MAX_VALUE;
    public static final double DEFAULT_MAX = -1.7976931348623157E308;
    double m_rawMin;
    double m_rawMax;
    double m_adjMin;
    double m_adjMax;
    boolean m_bDataDerived;

    public MinMaxObj() {
        this(false, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public MinMaxObj(double d, double d2) {
        this(false, d, d2);
    }

    public MinMaxObj(boolean bl) {
        this(bl, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public MinMaxObj(boolean bl, double d, double d2) {
        this.m_rawMin = d;
        this.m_rawMax = d2;
        if (bl) {
            this.m_adjMin = Math.min(0.0, d);
            this.m_adjMax = Math.max(0.0, d2);
        } else {
            this.m_adjMin = d;
            this.m_adjMax = d2;
        }
        this.m_bDataDerived = true;
    }

    public double getAdjMax() {
        return this.m_adjMax;
    }

    public double getAdjMin() {
        return this.m_adjMin;
    }

    public double getRawMax() {
        return this.m_rawMax;
    }

    public double getRawMin() {
        return this.m_rawMin;
    }

    public boolean isDataDerived() {
        return this.m_bDataDerived;
    }

    public boolean isValid() {
        return this.m_rawMin != Double.MAX_VALUE && this.m_rawMax != -1.7976931348623157E308;
    }

    void setDataDerived(boolean bl) {
        this.m_bDataDerived = bl;
    }

    public void testRawValue(double d) {
        if (d < this.m_rawMin) {
            this.m_rawMin = d;
        }
        if (d > this.m_rawMax) {
            this.m_rawMax = d;
        }
        if (d < this.m_adjMin) {
            this.m_adjMin = d;
        }
        if (d > this.m_adjMax) {
            this.m_adjMax = d;
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf("[raw: (")) + this.m_rawMin + ", " + this.m_rawMax + ")  adj: (" + this.m_adjMin + ", " + this.m_adjMax + ")]";
    }
}

