/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.QSortPoly;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetImage;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class MarkerObj {
    protected IdentObj m_id;
    protected MarkerTemplate m_template;
    protected Point m_center;
    protected int m_markerSizeX;
    protected int m_markerSizeY;
    protected BlackBoxIF m_bb;
    protected Rectangle m_rClip;
    protected Detectiv m_Detectiv;
    protected Perspective m_Perspective;
    protected String m_szRefLabel;
    protected double m_nData;
    protected boolean m_threed;
    protected boolean m_bHiliteable = true;
    protected int m_nXDepth;
    protected int m_nYDepth;
    protected int m_nDepthAngle;

    public MarkerObj(Detectiv detectiv, IdentObj identObj, MarkerTemplate markerTemplate, Point point, int n, int n2, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl) {
        this(detectiv, identObj, markerTemplate, point, n, n2, blackBoxIF, rectangle, bl, false, 0, 0, 0);
    }

    public MarkerObj(Detectiv detectiv, IdentObj identObj, MarkerTemplate markerTemplate, Point point, int n, int n2, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, int n3, int n4, int n5) {
        this(detectiv, identObj, markerTemplate, point, n, n2, blackBoxIF, rectangle, bl, bl2, n3, n4, n5, true);
    }

    public MarkerObj(Detectiv detectiv, IdentObj identObj, MarkerTemplate markerTemplate, Point point, int n, int n2, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, int n3, int n4, int n5, boolean bl3) {
        this.m_threed = bl2;
        this.m_nXDepth = n3;
        this.m_nYDepth = n4;
        this.m_nDepthAngle = n5;
        this.m_bHiliteable = bl3;
        if (point == null) {
            point = new Point(0, 0);
        }
        if (markerTemplate == MarkerTemplateArray.PRESET_BUBBLE) {
            if (n < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, n);
            }
            if (n2 < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, n2);
            }
        } else {
            if (n < 0 || bl && n > 100) {
                throw new AssertionException(0, 100, n);
            }
            if (n2 < 0 || bl && n2 > 100) {
                throw new AssertionException(0, 100, n2);
            }
        }
        this.m_id = identObj;
        this.m_template = markerTemplate;
        this.m_center = point;
        this.m_markerSizeX = n;
        this.m_markerSizeY = n2;
        this.m_bb = blackBoxIF;
        this.m_rClip = rectangle;
        this.m_Detectiv = detectiv;
        this.m_Perspective = this.m_Detectiv.getPerspective();
        this.calc();
    }

    public MarkerObj(Detectiv detectiv, IdentObj identObj, MarkerTemplate markerTemplate, Point point, int n, int n2, BlackBoxIF blackBoxIF) {
        this(detectiv, identObj, markerTemplate, point, n, n2, blackBoxIF, null, true);
    }

    public void calc() {
        switch (this.m_template.m_markerType) {
            case 0: {
                break;
            }
            case 1: {
                this.calcRect();
                break;
            }
            case 2: {
                this.calcOval();
                break;
            }
            case 9: {
                this.calcBubble();
                break;
            }
            case 4: 
            case 10: {
                this.calcLine();
                break;
            }
            case 3: {
                this.calcDiamond();
                break;
            }
            case 5: {
                this.calcPlus();
                break;
            }
            case 6: {
                this.calcTriangleDn();
                break;
            }
            case 7: {
                this.calcTriangleUp();
                break;
            }
            case 8: {
                this.calcDrillUp();
                break;
            }
            default: {
                throw new AssertionException(String.valueOf(String.valueOf("MarkerObj - unknown markerType = ")) + this.m_template.m_markerType);
            }
        }
    }

    public void calcBubble() {
        int n;
        int n2;
        Polygon polygon = new Polygon();
        VC vC = this.m_Perspective.getVC();
        int n3 = vC.virtToDestWidth(this.m_markerSizeX);
        if (n3 < (n2 = vC.virtToDestHeight(this.m_markerSizeY))) {
            n3 = n2;
        }
        if (n3 < (n = 3)) {
            n3 = n;
        }
        n2 = n3;
        this._calcOval(n2, n3, polygon, vC);
    }

    public void calcOval() {
        int n;
        Polygon polygon = new Polygon();
        VC vC = this.m_Perspective.getVC();
        int n2 = vC.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (n2 < (n = vC.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            n2 = n;
        }
        if (!this.m_Perspective.getJGraphType().isBubble()) {
            if (n2 < 5) {
                n2 = 5;
            }
            if (n2 % 2 == 0) {
                ++n2;
            }
        } else if (n2 < 3) {
            n2 = 3;
        }
        n = n2;
        this._calcOval(n, n2, polygon, vC);
    }

    private void _calcOval(int n, int n2, Polygon polygon, VC vC) {
        boolean bl;
        int n3;
        int n4;
        int n5 = vC.virtToDestX(this.m_center.x);
        int n6 = vC.virtToDestY(this.m_center.y);
        int n7 = n5 - n / 2;
        int n8 = n6 - n / 2;
        Rectangle rectangle = new Rectangle(n7, n8, n2 - 1, n - 1);
        switch (n) {
            case 3: {
                polygon.addPoint(n7 + 1, n8);
                polygon.addPoint(n7 + 2, n8 + 1);
                polygon.addPoint(n7 + 1, n8 + 2);
                polygon.addPoint(n7, n8 + 1);
                polygon.addPoint(n7 + 1, n8);
                break;
            }
            case 4: {
                polygon.addPoint(n7 + 1, n8);
                polygon.addPoint(n7 + 2, n8);
                polygon.addPoint(n7 + 3, n8 + 1);
                polygon.addPoint(n7 + 3, n8 + 2);
                polygon.addPoint(n7 + 2, n8 + 3);
                polygon.addPoint(n7 + 1, n8 + 3);
                polygon.addPoint(n7, n8 + 2);
                polygon.addPoint(n7, n8 + 1);
                polygon.addPoint(n7 + 1, n8);
                break;
            }
            case 5: {
                polygon.addPoint(n7 + 1, n8);
                polygon.addPoint(n7 + 3, n8);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 4, n8 + 3);
                polygon.addPoint(n7 + 3, n8 + 4);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7, n8 + 3);
                polygon.addPoint(n7, n8 + 1);
                polygon.addPoint(n7 + 1, n8);
                break;
            }
            case 6: {
                polygon.addPoint(n7 + 2, n8);
                polygon.addPoint(n7 + 3, n8);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 5, n8 + 2);
                polygon.addPoint(n7 + 5, n8 + 3);
                polygon.addPoint(n7 + 4, n8 + 4);
                polygon.addPoint(n7 + 3, n8 + 5);
                polygon.addPoint(n7 + 2, n8 + 5);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7, n8 + 3);
                polygon.addPoint(n7, n8 + 2);
                polygon.addPoint(n7 + 1, n8 + 1);
                polygon.addPoint(n7 + 2, n8);
                break;
            }
            case 7: {
                polygon.addPoint(n7 + 2, n8);
                polygon.addPoint(n7 + 4, n8);
                polygon.addPoint(n7 + 5, n8 + 1);
                polygon.addPoint(n7 + 6, n8 + 2);
                polygon.addPoint(n7 + 6, n8 + 4);
                polygon.addPoint(n7 + 5, n8 + 5);
                polygon.addPoint(n7 + 4, n8 + 6);
                polygon.addPoint(n7 + 2, n8 + 6);
                polygon.addPoint(n7 + 1, n8 + 5);
                polygon.addPoint(n7, n8 + 4);
                polygon.addPoint(n7, n8 + 2);
                polygon.addPoint(n7 + 1, n8 + 1);
                polygon.addPoint(n7 + 2, n8);
                break;
            }
            case 8: {
                polygon.addPoint(n7 + 3, n8);
                polygon.addPoint(n7 + 4, n8);
                polygon.addPoint(n7 + 5, n8 + 1);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 6, n8 + 2);
                polygon.addPoint(n7 + 7, n8 + 3);
                polygon.addPoint(n7 + 7, n8 + 4);
                polygon.addPoint(n7 + 6, n8 + 5);
                polygon.addPoint(n7 + 6, n8 + 6);
                polygon.addPoint(n7 + 5, n8 + 6);
                polygon.addPoint(n7 + 4, n8 + 7);
                polygon.addPoint(n7 + 3, n8 + 7);
                polygon.addPoint(n7 + 2, n8 + 6);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7 + 1, n8 + 5);
                polygon.addPoint(n7, n8 + 4);
                polygon.addPoint(n7, n8 + 3);
                polygon.addPoint(n7 + 1, n8 + 2);
                polygon.addPoint(n7 + 1, n8 + 1);
                polygon.addPoint(n7 + 2, n8 + 1);
                polygon.addPoint(n7 + 3, n8);
                break;
            }
            case 9: {
                polygon.addPoint(n7 + 3, n8);
                polygon.addPoint(n7 + 5, n8);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 7, n8 + 2);
                polygon.addPoint(n7 + 8, n8 + 3);
                polygon.addPoint(n7 + 8, n8 + 5);
                polygon.addPoint(n7 + 7, n8 + 6);
                polygon.addPoint(n7 + 7, n8 + 7);
                polygon.addPoint(n7 + 6, n8 + 7);
                polygon.addPoint(n7 + 5, n8 + 8);
                polygon.addPoint(n7 + 3, n8 + 8);
                polygon.addPoint(n7 + 2, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7, n8 + 5);
                polygon.addPoint(n7, n8 + 3);
                polygon.addPoint(n7 + 1, n8 + 2);
                polygon.addPoint(n7 + 1, n8 + 1);
                polygon.addPoint(n7 + 2, n8 + 1);
                polygon.addPoint(n7 + 3, n8);
                break;
            }
            case 10: {
                polygon.addPoint(n7 + 4, n8);
                polygon.addPoint(n7 + 5, n8);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 8, n8 + 2);
                polygon.addPoint(n7 + 8, n8 + 3);
                polygon.addPoint(n7 + 9, n8 + 4);
                polygon.addPoint(n7 + 9, n8 + 5);
                polygon.addPoint(n7 + 8, n8 + 6);
                polygon.addPoint(n7 + 8, n8 + 7);
                polygon.addPoint(n7 + 7, n8 + 8);
                polygon.addPoint(n7 + 6, n8 + 8);
                polygon.addPoint(n7 + 5, n8 + 9);
                polygon.addPoint(n7 + 4, n8 + 9);
                polygon.addPoint(n7 + 3, n8 + 8);
                polygon.addPoint(n7 + 2, n8 + 8);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7, n8 + 5);
                polygon.addPoint(n7, n8 + 4);
                polygon.addPoint(n7 + 1, n8 + 3);
                polygon.addPoint(n7 + 1, n8 + 2);
                polygon.addPoint(n7 + 2, n8 + 1);
                polygon.addPoint(n7 + 3, n8 + 1);
                polygon.addPoint(n7 + 4, n8);
                break;
            }
            case 11: {
                polygon.addPoint(n7 + 4, n8);
                polygon.addPoint(n7 + 6, n8);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 8, n8 + 1);
                polygon.addPoint(n7 + 9, n8 + 2);
                polygon.addPoint(n7 + 9, n8 + 3);
                polygon.addPoint(n7 + 10, n8 + 4);
                polygon.addPoint(n7 + 10, n8 + 6);
                polygon.addPoint(n7 + 9, n8 + 7);
                polygon.addPoint(n7 + 9, n8 + 8);
                polygon.addPoint(n7 + 8, n8 + 9);
                polygon.addPoint(n7 + 7, n8 + 9);
                polygon.addPoint(n7 + 6, n8 + 10);
                polygon.addPoint(n7 + 4, n8 + 10);
                polygon.addPoint(n7 + 3, n8 + 9);
                polygon.addPoint(n7 + 2, n8 + 9);
                polygon.addPoint(n7 + 1, n8 + 8);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7, n8 + 6);
                polygon.addPoint(n7, n8 + 4);
                polygon.addPoint(n7 + 1, n8 + 3);
                polygon.addPoint(n7 + 1, n8 + 2);
                polygon.addPoint(n7 + 2, n8 + 1);
                polygon.addPoint(n7 + 3, n8 + 1);
                polygon.addPoint(n7 + 4, n8);
                break;
            }
            case 12: {
                polygon.addPoint(n7 + 5, n8);
                polygon.addPoint(n7 + 6, n8);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 9, n8 + 1);
                polygon.addPoint(n7 + 10, n8 + 2);
                polygon.addPoint(n7 + 10, n8 + 4);
                polygon.addPoint(n7 + 11, n8 + 5);
                polygon.addPoint(n7 + 11, n8 + 6);
                polygon.addPoint(n7 + 10, n8 + 7);
                polygon.addPoint(n7 + 10, n8 + 9);
                polygon.addPoint(n7 + 9, n8 + 10);
                polygon.addPoint(n7 + 7, n8 + 10);
                polygon.addPoint(n7 + 6, n8 + 11);
                polygon.addPoint(n7 + 5, n8 + 11);
                polygon.addPoint(n7 + 4, n8 + 10);
                polygon.addPoint(n7 + 2, n8 + 10);
                polygon.addPoint(n7 + 1, n8 + 9);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7, n8 + 6);
                polygon.addPoint(n7, n8 + 5);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7 + 1, n8 + 2);
                polygon.addPoint(n7 + 2, n8 + 1);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 5, n8);
                break;
            }
            case 13: {
                polygon.addPoint(n7 + 5, n8);
                polygon.addPoint(n7 + 7, n8);
                polygon.addPoint(n7 + 8, n8 + 1);
                polygon.addPoint(n7 + 9, n8 + 1);
                polygon.addPoint(n7 + 10, n8 + 2);
                polygon.addPoint(n7 + 11, n8 + 3);
                polygon.addPoint(n7 + 11, n8 + 4);
                polygon.addPoint(n7 + 12, n8 + 5);
                polygon.addPoint(n7 + 12, n8 + 7);
                polygon.addPoint(n7 + 11, n8 + 8);
                polygon.addPoint(n7 + 11, n8 + 9);
                polygon.addPoint(n7 + 10, n8 + 10);
                polygon.addPoint(n7 + 9, n8 + 11);
                polygon.addPoint(n7 + 8, n8 + 11);
                polygon.addPoint(n7 + 7, n8 + 12);
                polygon.addPoint(n7 + 5, n8 + 12);
                polygon.addPoint(n7 + 4, n8 + 11);
                polygon.addPoint(n7 + 3, n8 + 11);
                polygon.addPoint(n7 + 2, n8 + 10);
                polygon.addPoint(n7 + 1, n8 + 9);
                polygon.addPoint(n7 + 1, n8 + 8);
                polygon.addPoint(n7, n8 + 7);
                polygon.addPoint(n7, n8 + 5);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7 + 1, n8 + 3);
                polygon.addPoint(n7 + 2, n8 + 2);
                polygon.addPoint(n7 + 3, n8 + 1);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 5, n8);
                break;
            }
            case 14: {
                polygon.addPoint(n7 + 4, n8);
                polygon.addPoint(n7 + 9, n8);
                polygon.addPoint(n7 + 10, n8 + 1);
                polygon.addPoint(n7 + 11, n8 + 2);
                polygon.addPoint(n7 + 12, n8 + 3);
                polygon.addPoint(n7 + 12, n8 + 4);
                polygon.addPoint(n7 + 13, n8 + 5);
                polygon.addPoint(n7 + 13, n8 + 8);
                polygon.addPoint(n7 + 12, n8 + 9);
                polygon.addPoint(n7 + 12, n8 + 10);
                polygon.addPoint(n7 + 11, n8 + 11);
                polygon.addPoint(n7 + 10, n8 + 12);
                polygon.addPoint(n7 + 9, n8 + 13);
                polygon.addPoint(n7 + 4, n8 + 13);
                polygon.addPoint(n7 + 3, n8 + 12);
                polygon.addPoint(n7 + 2, n8 + 11);
                polygon.addPoint(n7 + 1, n8 + 10);
                polygon.addPoint(n7, n8 + 9);
                polygon.addPoint(n7, n8 + 4);
                polygon.addPoint(n7 + 1, n8 + 3);
                polygon.addPoint(n7 + 2, n8 + 2);
                polygon.addPoint(n7 + 3, n8 + 1);
                polygon.addPoint(n7 + 4, n8);
                break;
            }
            case 15: {
                polygon.addPoint(n7 + 5, n8);
                polygon.addPoint(n7 + 9, n8);
                polygon.addPoint(n7 + 10, n8 + 1);
                polygon.addPoint(n7 + 11, n8 + 1);
                polygon.addPoint(n7 + 12, n8 + 2);
                polygon.addPoint(n7 + 13, n8 + 3);
                polygon.addPoint(n7 + 13, n8 + 4);
                polygon.addPoint(n7 + 14, n8 + 5);
                polygon.addPoint(n7 + 14, n8 + 9);
                polygon.addPoint(n7 + 13, n8 + 10);
                polygon.addPoint(n7 + 13, n8 + 11);
                polygon.addPoint(n7 + 12, n8 + 12);
                polygon.addPoint(n7 + 11, n8 + 13);
                polygon.addPoint(n7 + 10, n8 + 13);
                polygon.addPoint(n7 + 9, n8 + 14);
                polygon.addPoint(n7 + 5, n8 + 14);
                polygon.addPoint(n7 + 4, n8 + 13);
                polygon.addPoint(n7 + 3, n8 + 13);
                polygon.addPoint(n7 + 2, n8 + 12);
                polygon.addPoint(n7 + 1, n8 + 11);
                polygon.addPoint(n7 + 1, n8 + 10);
                polygon.addPoint(n7, n8 + 9);
                polygon.addPoint(n7, n8 + 5);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7 + 1, n8 + 3);
                polygon.addPoint(n7 + 2, n8 + 2);
                polygon.addPoint(n7 + 3, n8 + 1);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 5, n8);
                break;
            }
            case 16: {
                polygon.addPoint(n7 + 5, n8);
                polygon.addPoint(n7 + 10, n8);
                polygon.addPoint(n7 + 11, n8 + 1);
                polygon.addPoint(n7 + 12, n8 + 2);
                polygon.addPoint(n7 + 13, n8 + 2);
                polygon.addPoint(n7 + 13, n8 + 3);
                polygon.addPoint(n7 + 14, n8 + 4);
                polygon.addPoint(n7 + 15, n8 + 5);
                polygon.addPoint(n7 + 15, n8 + 10);
                polygon.addPoint(n7 + 14, n8 + 11);
                polygon.addPoint(n7 + 13, n8 + 12);
                polygon.addPoint(n7 + 13, n8 + 13);
                polygon.addPoint(n7 + 12, n8 + 13);
                polygon.addPoint(n7 + 11, n8 + 14);
                polygon.addPoint(n7 + 10, n8 + 15);
                polygon.addPoint(n7 + 5, n8 + 15);
                polygon.addPoint(n7 + 4, n8 + 14);
                polygon.addPoint(n7 + 3, n8 + 13);
                polygon.addPoint(n7 + 2, n8 + 13);
                polygon.addPoint(n7 + 2, n8 + 12);
                polygon.addPoint(n7 + 1, n8 + 11);
                polygon.addPoint(n7, n8 + 10);
                polygon.addPoint(n7, n8 + 5);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7 + 2, n8 + 3);
                polygon.addPoint(n7 + 2, n8 + 2);
                polygon.addPoint(n7 + 3, n8 + 2);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 5, n8);
                break;
            }
            case 17: {
                polygon.addPoint(n7 + 6, n8);
                polygon.addPoint(n7 + 10, n8);
                polygon.addPoint(n7 + 11, n8 + 1);
                polygon.addPoint(n7 + 12, n8 + 1);
                polygon.addPoint(n7 + 13, n8 + 2);
                polygon.addPoint(n7 + 14, n8 + 3);
                polygon.addPoint(n7 + 15, n8 + 4);
                polygon.addPoint(n7 + 15, n8 + 5);
                polygon.addPoint(n7 + 16, n8 + 6);
                polygon.addPoint(n7 + 16, n8 + 10);
                polygon.addPoint(n7 + 15, n8 + 11);
                polygon.addPoint(n7 + 15, n8 + 12);
                polygon.addPoint(n7 + 14, n8 + 13);
                polygon.addPoint(n7 + 13, n8 + 14);
                polygon.addPoint(n7 + 12, n8 + 15);
                polygon.addPoint(n7 + 11, n8 + 15);
                polygon.addPoint(n7 + 10, n8 + 16);
                polygon.addPoint(n7 + 6, n8 + 16);
                polygon.addPoint(n7 + 5, n8 + 15);
                polygon.addPoint(n7 + 4, n8 + 15);
                polygon.addPoint(n7 + 3, n8 + 14);
                polygon.addPoint(n7 + 2, n8 + 13);
                polygon.addPoint(n7 + 1, n8 + 12);
                polygon.addPoint(n7 + 1, n8 + 11);
                polygon.addPoint(n7, n8 + 10);
                polygon.addPoint(n7, n8 + 6);
                polygon.addPoint(n7 + 1, n8 + 5);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7 + 2, n8 + 3);
                polygon.addPoint(n7 + 3, n8 + 2);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 5, n8 + 1);
                polygon.addPoint(n7 + 6, n8);
                break;
            }
            case 18: {
                polygon.addPoint(n7 + 7, n8);
                polygon.addPoint(n7 + 10, n8);
                polygon.addPoint(n7 + 11, n8 + 1);
                polygon.addPoint(n7 + 13, n8 + 1);
                polygon.addPoint(n7 + 14, n8 + 2);
                polygon.addPoint(n7 + 15, n8 + 3);
                polygon.addPoint(n7 + 16, n8 + 4);
                polygon.addPoint(n7 + 16, n8 + 6);
                polygon.addPoint(n7 + 17, n8 + 7);
                polygon.addPoint(n7 + 17, n8 + 10);
                polygon.addPoint(n7 + 16, n8 + 11);
                polygon.addPoint(n7 + 16, n8 + 13);
                polygon.addPoint(n7 + 15, n8 + 14);
                polygon.addPoint(n7 + 14, n8 + 15);
                polygon.addPoint(n7 + 13, n8 + 16);
                polygon.addPoint(n7 + 11, n8 + 16);
                polygon.addPoint(n7 + 10, n8 + 17);
                polygon.addPoint(n7 + 7, n8 + 17);
                polygon.addPoint(n7 + 6, n8 + 16);
                polygon.addPoint(n7 + 4, n8 + 16);
                polygon.addPoint(n7 + 3, n8 + 15);
                polygon.addPoint(n7 + 2, n8 + 14);
                polygon.addPoint(n7 + 1, n8 + 13);
                polygon.addPoint(n7 + 1, n8 + 11);
                polygon.addPoint(n7, n8 + 10);
                polygon.addPoint(n7, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7 + 1, n8 + 4);
                polygon.addPoint(n7 + 2, n8 + 3);
                polygon.addPoint(n7 + 3, n8 + 2);
                polygon.addPoint(n7 + 4, n8 + 1);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 7, n8);
                break;
            }
            case 19: {
                polygon.addPoint(n7 + 7, n8);
                polygon.addPoint(n7 + 11, n8);
                polygon.addPoint(n7 + 12, n8 + 1);
                polygon.addPoint(n7 + 13, n8 + 1);
                polygon.addPoint(n7 + 14, n8 + 2);
                polygon.addPoint(n7 + 15, n8 + 2);
                polygon.addPoint(n7 + 16, n8 + 3);
                polygon.addPoint(n7 + 16, n8 + 4);
                polygon.addPoint(n7 + 17, n8 + 5);
                polygon.addPoint(n7 + 17, n8 + 6);
                polygon.addPoint(n7 + 18, n8 + 7);
                polygon.addPoint(n7 + 18, n8 + 11);
                polygon.addPoint(n7 + 17, n8 + 12);
                polygon.addPoint(n7 + 17, n8 + 13);
                polygon.addPoint(n7 + 16, n8 + 14);
                polygon.addPoint(n7 + 16, n8 + 15);
                polygon.addPoint(n7 + 15, n8 + 16);
                polygon.addPoint(n7 + 14, n8 + 16);
                polygon.addPoint(n7 + 13, n8 + 17);
                polygon.addPoint(n7 + 12, n8 + 17);
                polygon.addPoint(n7 + 11, n8 + 18);
                polygon.addPoint(n7 + 7, n8 + 18);
                polygon.addPoint(n7 + 6, n8 + 17);
                polygon.addPoint(n7 + 5, n8 + 17);
                polygon.addPoint(n7 + 4, n8 + 16);
                polygon.addPoint(n7 + 3, n8 + 16);
                polygon.addPoint(n7 + 2, n8 + 15);
                polygon.addPoint(n7 + 2, n8 + 14);
                polygon.addPoint(n7 + 1, n8 + 13);
                polygon.addPoint(n7 + 1, n8 + 12);
                polygon.addPoint(n7, n8 + 11);
                polygon.addPoint(n7, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7 + 1, n8 + 5);
                polygon.addPoint(n7 + 2, n8 + 4);
                polygon.addPoint(n7 + 2, n8 + 3);
                polygon.addPoint(n7 + 3, n8 + 2);
                polygon.addPoint(n7 + 4, n8 + 2);
                polygon.addPoint(n7 + 5, n8 + 1);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 7, n8);
                break;
            }
            case 20: {
                polygon.addPoint(n7 + 8, n8);
                polygon.addPoint(n7 + 11, n8);
                polygon.addPoint(n7 + 12, n8 + 1);
                polygon.addPoint(n7 + 14, n8 + 1);
                polygon.addPoint(n7 + 15, n8 + 2);
                polygon.addPoint(n7 + 16, n8 + 3);
                polygon.addPoint(n7 + 17, n8 + 4);
                polygon.addPoint(n7 + 18, n8 + 5);
                polygon.addPoint(n7 + 18, n8 + 7);
                polygon.addPoint(n7 + 19, n8 + 8);
                polygon.addPoint(n7 + 19, n8 + 11);
                polygon.addPoint(n7 + 18, n8 + 12);
                polygon.addPoint(n7 + 18, n8 + 14);
                polygon.addPoint(n7 + 17, n8 + 15);
                polygon.addPoint(n7 + 16, n8 + 16);
                polygon.addPoint(n7 + 15, n8 + 17);
                polygon.addPoint(n7 + 14, n8 + 18);
                polygon.addPoint(n7 + 12, n8 + 18);
                polygon.addPoint(n7 + 11, n8 + 19);
                polygon.addPoint(n7 + 8, n8 + 19);
                polygon.addPoint(n7 + 7, n8 + 18);
                polygon.addPoint(n7 + 5, n8 + 18);
                polygon.addPoint(n7 + 4, n8 + 17);
                polygon.addPoint(n7 + 3, n8 + 16);
                polygon.addPoint(n7 + 2, n8 + 15);
                polygon.addPoint(n7 + 1, n8 + 14);
                polygon.addPoint(n7 + 1, n8 + 12);
                polygon.addPoint(n7, n8 + 11);
                polygon.addPoint(n7, n8 + 8);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 5);
                polygon.addPoint(n7 + 2, n8 + 4);
                polygon.addPoint(n7 + 3, n8 + 3);
                polygon.addPoint(n7 + 4, n8 + 2);
                polygon.addPoint(n7 + 5, n8 + 1);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 8, n8);
                break;
            }
            case 21: {
                polygon.addPoint(n7 + 8, n8);
                polygon.addPoint(n7 + 12, n8);
                polygon.addPoint(n7 + 13, n8 + 1);
                polygon.addPoint(n7 + 14, n8 + 1);
                polygon.addPoint(n7 + 15, n8 + 2);
                polygon.addPoint(n7 + 16, n8 + 2);
                polygon.addPoint(n7 + 17, n8 + 3);
                polygon.addPoint(n7 + 18, n8 + 4);
                polygon.addPoint(n7 + 18, n8 + 5);
                polygon.addPoint(n7 + 19, n8 + 6);
                polygon.addPoint(n7 + 19, n8 + 7);
                polygon.addPoint(n7 + 20, n8 + 8);
                polygon.addPoint(n7 + 20, n8 + 12);
                polygon.addPoint(n7 + 19, n8 + 13);
                polygon.addPoint(n7 + 19, n8 + 14);
                polygon.addPoint(n7 + 18, n8 + 15);
                polygon.addPoint(n7 + 18, n8 + 16);
                polygon.addPoint(n7 + 17, n8 + 17);
                polygon.addPoint(n7 + 16, n8 + 18);
                polygon.addPoint(n7 + 15, n8 + 18);
                polygon.addPoint(n7 + 14, n8 + 19);
                polygon.addPoint(n7 + 13, n8 + 19);
                polygon.addPoint(n7 + 12, n8 + 20);
                polygon.addPoint(n7 + 8, n8 + 20);
                polygon.addPoint(n7 + 7, n8 + 19);
                polygon.addPoint(n7 + 6, n8 + 19);
                polygon.addPoint(n7 + 5, n8 + 18);
                polygon.addPoint(n7 + 4, n8 + 18);
                polygon.addPoint(n7 + 3, n8 + 17);
                polygon.addPoint(n7 + 2, n8 + 16);
                polygon.addPoint(n7 + 2, n8 + 15);
                polygon.addPoint(n7 + 1, n8 + 14);
                polygon.addPoint(n7 + 1, n8 + 13);
                polygon.addPoint(n7, n8 + 12);
                polygon.addPoint(n7, n8 + 8);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7 + 2, n8 + 5);
                polygon.addPoint(n7 + 2, n8 + 4);
                polygon.addPoint(n7 + 3, n8 + 3);
                polygon.addPoint(n7 + 4, n8 + 2);
                polygon.addPoint(n7 + 5, n8 + 2);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 8, n8);
                break;
            }
            case 22: {
                polygon.addPoint(n7 + 8, n8);
                polygon.addPoint(n7 + 13, n8);
                polygon.addPoint(n7 + 14, n8 + 1);
                polygon.addPoint(n7 + 15, n8 + 1);
                polygon.addPoint(n7 + 16, n8 + 2);
                polygon.addPoint(n7 + 17, n8 + 2);
                polygon.addPoint(n7 + 18, n8 + 3);
                polygon.addPoint(n7 + 19, n8 + 4);
                polygon.addPoint(n7 + 19, n8 + 5);
                polygon.addPoint(n7 + 20, n8 + 6);
                polygon.addPoint(n7 + 20, n8 + 8);
                polygon.addPoint(n7 + 21, n8 + 9);
                polygon.addPoint(n7 + 21, n8 + 12);
                polygon.addPoint(n7 + 20, n8 + 13);
                polygon.addPoint(n7 + 20, n8 + 15);
                polygon.addPoint(n7 + 19, n8 + 16);
                polygon.addPoint(n7 + 19, n8 + 17);
                polygon.addPoint(n7 + 18, n8 + 18);
                polygon.addPoint(n7 + 17, n8 + 19);
                polygon.addPoint(n7 + 16, n8 + 19);
                polygon.addPoint(n7 + 15, n8 + 20);
                polygon.addPoint(n7 + 13, n8 + 20);
                polygon.addPoint(n7 + 12, n8 + 21);
                polygon.addPoint(n7 + 9, n8 + 21);
                polygon.addPoint(n7 + 8, n8 + 20);
                polygon.addPoint(n7 + 6, n8 + 20);
                polygon.addPoint(n7 + 5, n8 + 19);
                polygon.addPoint(n7 + 4, n8 + 19);
                polygon.addPoint(n7 + 3, n8 + 18);
                polygon.addPoint(n7 + 2, n8 + 17);
                polygon.addPoint(n7 + 2, n8 + 16);
                polygon.addPoint(n7 + 1, n8 + 15);
                polygon.addPoint(n7 + 1, n8 + 14);
                polygon.addPoint(n7, n8 + 13);
                polygon.addPoint(n7, n8 + 8);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7 + 2, n8 + 5);
                polygon.addPoint(n7 + 2, n8 + 4);
                polygon.addPoint(n7 + 3, n8 + 3);
                polygon.addPoint(n7 + 4, n8 + 2);
                polygon.addPoint(n7 + 5, n8 + 2);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 8, n8);
                break;
            }
            case 23: {
                polygon.addPoint(n7 + 9, n8);
                polygon.addPoint(n7 + 13, n8);
                polygon.addPoint(n7 + 14, n8 + 1);
                polygon.addPoint(n7 + 16, n8 + 1);
                polygon.addPoint(n7 + 17, n8 + 2);
                polygon.addPoint(n7 + 18, n8 + 3);
                polygon.addPoint(n7 + 19, n8 + 3);
                polygon.addPoint(n7 + 19, n8 + 4);
                polygon.addPoint(n7 + 20, n8 + 5);
                polygon.addPoint(n7 + 21, n8 + 6);
                polygon.addPoint(n7 + 21, n8 + 8);
                polygon.addPoint(n7 + 22, n8 + 9);
                polygon.addPoint(n7 + 22, n8 + 13);
                polygon.addPoint(n7 + 21, n8 + 14);
                polygon.addPoint(n7 + 21, n8 + 16);
                polygon.addPoint(n7 + 20, n8 + 17);
                polygon.addPoint(n7 + 19, n8 + 18);
                polygon.addPoint(n7 + 19, n8 + 19);
                polygon.addPoint(n7 + 18, n8 + 19);
                polygon.addPoint(n7 + 17, n8 + 20);
                polygon.addPoint(n7 + 16, n8 + 21);
                polygon.addPoint(n7 + 14, n8 + 21);
                polygon.addPoint(n7 + 13, n8 + 22);
                polygon.addPoint(n7 + 9, n8 + 22);
                polygon.addPoint(n7 + 8, n8 + 21);
                polygon.addPoint(n7 + 6, n8 + 21);
                polygon.addPoint(n7 + 5, n8 + 20);
                polygon.addPoint(n7 + 4, n8 + 19);
                polygon.addPoint(n7 + 3, n8 + 19);
                polygon.addPoint(n7 + 3, n8 + 18);
                polygon.addPoint(n7 + 2, n8 + 17);
                polygon.addPoint(n7 + 1, n8 + 16);
                polygon.addPoint(n7 + 1, n8 + 14);
                polygon.addPoint(n7, n8 + 13);
                polygon.addPoint(n7, n8 + 9);
                polygon.addPoint(n7 + 1, n8 + 8);
                polygon.addPoint(n7 + 1, n8 + 6);
                polygon.addPoint(n7 + 2, n8 + 5);
                polygon.addPoint(n7 + 3, n8 + 4);
                polygon.addPoint(n7 + 3, n8 + 3);
                polygon.addPoint(n7 + 4, n8 + 3);
                polygon.addPoint(n7 + 5, n8 + 2);
                polygon.addPoint(n7 + 6, n8 + 1);
                polygon.addPoint(n7 + 8, n8 + 1);
                polygon.addPoint(n7 + 9, n8);
                break;
            }
            case 24: {
                polygon.addPoint(n7 + 10, n8);
                polygon.addPoint(n7 + 13, n8);
                polygon.addPoint(n7 + 14, n8 + 1);
                polygon.addPoint(n7 + 16, n8 + 1);
                polygon.addPoint(n7 + 17, n8 + 2);
                polygon.addPoint(n7 + 18, n8 + 2);
                polygon.addPoint(n7 + 19, n8 + 3);
                polygon.addPoint(n7 + 20, n8 + 4);
                polygon.addPoint(n7 + 21, n8 + 5);
                polygon.addPoint(n7 + 21, n8 + 6);
                polygon.addPoint(n7 + 22, n8 + 7);
                polygon.addPoint(n7 + 22, n8 + 8);
                polygon.addPoint(n7 + 23, n8 + 9);
                polygon.addPoint(n7 + 23, n8 + 14);
                polygon.addPoint(n7 + 22, n8 + 15);
                polygon.addPoint(n7 + 22, n8 + 16);
                polygon.addPoint(n7 + 21, n8 + 17);
                polygon.addPoint(n7 + 21, n8 + 18);
                polygon.addPoint(n7 + 20, n8 + 19);
                polygon.addPoint(n7 + 19, n8 + 20);
                polygon.addPoint(n7 + 18, n8 + 21);
                polygon.addPoint(n7 + 17, n8 + 21);
                polygon.addPoint(n7 + 16, n8 + 22);
                polygon.addPoint(n7 + 14, n8 + 22);
                polygon.addPoint(n7 + 13, n8 + 23);
                polygon.addPoint(n7 + 10, n8 + 23);
                polygon.addPoint(n7 + 9, n8 + 22);
                polygon.addPoint(n7 + 7, n8 + 22);
                polygon.addPoint(n7 + 6, n8 + 21);
                polygon.addPoint(n7 + 5, n8 + 21);
                polygon.addPoint(n7 + 4, n8 + 20);
                polygon.addPoint(n7 + 3, n8 + 19);
                polygon.addPoint(n7 + 2, n8 + 18);
                polygon.addPoint(n7 + 2, n8 + 17);
                polygon.addPoint(n7 + 1, n8 + 16);
                polygon.addPoint(n7 + 1, n8 + 15);
                polygon.addPoint(n7, n8 + 14);
                polygon.addPoint(n7, n8 + 9);
                polygon.addPoint(n7 + 1, n8 + 8);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 2, n8 + 6);
                polygon.addPoint(n7 + 2, n8 + 5);
                polygon.addPoint(n7 + 3, n8 + 4);
                polygon.addPoint(n7 + 4, n8 + 3);
                polygon.addPoint(n7 + 5, n8 + 2);
                polygon.addPoint(n7 + 6, n8 + 2);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 9, n8 + 1);
                polygon.addPoint(n7 + 10, n8);
                break;
            }
            case 25: {
                polygon.addPoint(n7 + 10, n8);
                polygon.addPoint(n7 + 14, n8);
                polygon.addPoint(n7 + 15, n8 + 1);
                polygon.addPoint(n7 + 17, n8 + 1);
                polygon.addPoint(n7 + 18, n8 + 2);
                polygon.addPoint(n7 + 19, n8 + 2);
                polygon.addPoint(n7 + 20, n8 + 3);
                polygon.addPoint(n7 + 21, n8 + 4);
                polygon.addPoint(n7 + 22, n8 + 5);
                polygon.addPoint(n7 + 22, n8 + 6);
                polygon.addPoint(n7 + 23, n8 + 7);
                polygon.addPoint(n7 + 23, n8 + 9);
                polygon.addPoint(n7 + 24, n8 + 10);
                polygon.addPoint(n7 + 24, n8 + 14);
                polygon.addPoint(n7 + 23, n8 + 15);
                polygon.addPoint(n7 + 23, n8 + 17);
                polygon.addPoint(n7 + 22, n8 + 18);
                polygon.addPoint(n7 + 22, n8 + 19);
                polygon.addPoint(n7 + 21, n8 + 20);
                polygon.addPoint(n7 + 20, n8 + 21);
                polygon.addPoint(n7 + 19, n8 + 22);
                polygon.addPoint(n7 + 18, n8 + 22);
                polygon.addPoint(n7 + 17, n8 + 23);
                polygon.addPoint(n7 + 15, n8 + 23);
                polygon.addPoint(n7 + 14, n8 + 24);
                polygon.addPoint(n7 + 10, n8 + 24);
                polygon.addPoint(n7 + 9, n8 + 23);
                polygon.addPoint(n7 + 7, n8 + 23);
                polygon.addPoint(n7 + 6, n8 + 22);
                polygon.addPoint(n7 + 5, n8 + 22);
                polygon.addPoint(n7 + 4, n8 + 21);
                polygon.addPoint(n7 + 3, n8 + 20);
                polygon.addPoint(n7 + 2, n8 + 19);
                polygon.addPoint(n7 + 2, n8 + 18);
                polygon.addPoint(n7 + 1, n8 + 17);
                polygon.addPoint(n7 + 1, n8 + 15);
                polygon.addPoint(n7, n8 + 14);
                polygon.addPoint(n7, n8 + 10);
                polygon.addPoint(n7 + 1, n8 + 9);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 2, n8 + 6);
                polygon.addPoint(n7 + 2, n8 + 5);
                polygon.addPoint(n7 + 3, n8 + 4);
                polygon.addPoint(n7 + 4, n8 + 3);
                polygon.addPoint(n7 + 5, n8 + 2);
                polygon.addPoint(n7 + 6, n8 + 2);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 9, n8 + 1);
                polygon.addPoint(n7 + 10, n8);
                break;
            }
            case 26: {
                polygon.addPoint(n7 + 11, n8);
                polygon.addPoint(n7 + 14, n8);
                polygon.addPoint(n7 + 15, n8 + 1);
                polygon.addPoint(n7 + 18, n8 + 1);
                polygon.addPoint(n7 + 19, n8 + 2);
                polygon.addPoint(n7 + 20, n8 + 3);
                polygon.addPoint(n7 + 21, n8 + 3);
                polygon.addPoint(n7 + 22, n8 + 4);
                polygon.addPoint(n7 + 22, n8 + 5);
                polygon.addPoint(n7 + 23, n8 + 6);
                polygon.addPoint(n7 + 24, n8 + 7);
                polygon.addPoint(n7 + 24, n8 + 10);
                polygon.addPoint(n7 + 25, n8 + 11);
                polygon.addPoint(n7 + 25, n8 + 14);
                polygon.addPoint(n7 + 24, n8 + 15);
                polygon.addPoint(n7 + 24, n8 + 18);
                polygon.addPoint(n7 + 23, n8 + 19);
                polygon.addPoint(n7 + 22, n8 + 20);
                polygon.addPoint(n7 + 22, n8 + 21);
                polygon.addPoint(n7 + 21, n8 + 22);
                polygon.addPoint(n7 + 20, n8 + 22);
                polygon.addPoint(n7 + 19, n8 + 23);
                polygon.addPoint(n7 + 18, n8 + 24);
                polygon.addPoint(n7 + 15, n8 + 24);
                polygon.addPoint(n7 + 14, n8 + 25);
                polygon.addPoint(n7 + 11, n8 + 25);
                polygon.addPoint(n7 + 10, n8 + 24);
                polygon.addPoint(n7 + 7, n8 + 24);
                polygon.addPoint(n7 + 6, n8 + 23);
                polygon.addPoint(n7 + 5, n8 + 22);
                polygon.addPoint(n7 + 4, n8 + 22);
                polygon.addPoint(n7 + 3, n8 + 21);
                polygon.addPoint(n7 + 3, n8 + 20);
                polygon.addPoint(n7 + 2, n8 + 19);
                polygon.addPoint(n7 + 1, n8 + 18);
                polygon.addPoint(n7 + 1, n8 + 15);
                polygon.addPoint(n7, n8 + 14);
                polygon.addPoint(n7, n8 + 11);
                polygon.addPoint(n7 + 1, n8 + 10);
                polygon.addPoint(n7 + 1, n8 + 7);
                polygon.addPoint(n7 + 2, n8 + 6);
                polygon.addPoint(n7 + 3, n8 + 5);
                polygon.addPoint(n7 + 3, n8 + 4);
                polygon.addPoint(n7 + 4, n8 + 3);
                polygon.addPoint(n7 + 5, n8 + 3);
                polygon.addPoint(n7 + 6, n8 + 2);
                polygon.addPoint(n7 + 7, n8 + 1);
                polygon.addPoint(n7 + 10, n8 + 1);
                polygon.addPoint(n7 + 11, n8);
                break;
            }
            default: {
                polygon = new Polygon();
                int n9 = 260;
                int n10 = 0;
                while (n10 < 36) {
                    n4 = (int)((double)(n / 2) * Math.cos((double)n9 * (Math.PI / 180)));
                    n3 = (int)((double)(n / 2) * Math.sin((double)n9 * (Math.PI / 180)));
                    if (n9 == 360) {
                        n9 = 0;
                    }
                    n9 += 10;
                    polygon.addPoint(n4 + n5, n3 + n6);
                    ++n10;
                }
                break block0;
            }
        }
        if (!this.m_threed) {
            new DetOval(this.m_Detectiv, this.m_id, rectangle, this.m_bb, true, polygon, this.m_rClip);
            return;
        }
        this.m_nXDepth = (int)((double)this.m_nXDepth / 2.5);
        this.m_nYDepth = (int)((double)this.m_nYDepth / 2.5);
        Polygon polygon2 = new Polygon();
        n4 = 0;
        while (n4 < polygon.npoints) {
            polygon2.addPoint(polygon.xpoints[n4] + vC.virtToDestWidth(this.m_nXDepth), polygon.ypoints[n4] - vC.virtToDestHeight(this.m_nYDepth));
            ++n4;
        }
        n4 = 0;
        n3 = 0;
        double d = 0.0;
        double d2 = 20000.0;
        double d3 = 0.0;
        double d4 = 30000.0;
        double d5 = (double)n5 + vC.virtToDestWidth((double)this.m_nXDepth);
        double d6 = (double)n6 - vC.virtToDestHeight((double)this.m_nYDepth);
        double d7 = 100.0;
        int n11 = 0;
        while (n11 < polygon.npoints) {
            if (this.m_nDepthAngle < 90 && polygon.ypoints[n11] <= n6 && polygon.xpoints[n11] <= n5 || this.m_nDepthAngle >= 90 && polygon.ypoints[n11] <= n6 && polygon.xpoints[n11] >= n5) {
                double d8 = Point2D.distance(n5, n6, polygon.xpoints[n11], polygon.ypoints[n11]);
                double d9 = Point2D.distance(d5, d6, polygon.xpoints[n11], polygon.ypoints[n11]);
                if (Math.abs(1.0 - d9 / d8) <= d7) {
                    d7 = Math.abs(1.0 - d9 / d8);
                    n4 = n11;
                }
            }
            ++n11;
        }
        d = 0.0;
        double d10 = polygon.xpoints[n4];
        double d11 = polygon.ypoints[n4];
        int n12 = 0;
        while (n12 < polygon.npoints) {
            double d12 = polygon.xpoints[n12];
            double d13 = polygon.ypoints[n12];
            double d14 = Point2D.distance(d10, d11, d12, d13);
            if (d14 >= d) {
                n3 = n12;
                d = d14;
            }
            ++n12;
        }
        Polygon polygon3 = new Polygon();
        if (this.m_nDepthAngle <= 90) {
            int n13 = n3;
            bl = false;
            while (!bl) {
                if (n13 == n4) {
                    bl = true;
                }
                polygon3.addPoint(polygon2.xpoints[n13], polygon2.ypoints[n13]);
                if (--n13 != -1) continue;
                n13 = polygon2.npoints - 1;
            }
            bl = false;
            n13 = n4;
            while (!bl) {
                if (n13 == n3) {
                    bl = true;
                }
                polygon3.addPoint(polygon.xpoints[n13], polygon.ypoints[n13]);
                if (++n13 != polygon.npoints) continue;
                n13 = 0;
            }
            polygon3.addPoint(polygon2.xpoints[n3], polygon2.ypoints[n3]);
        }
        if (this.m_nDepthAngle > 90) {
            int n14 = n3;
            bl = false;
            while (!bl) {
                if (n14 == n4) {
                    bl = true;
                }
                polygon3.addPoint(polygon2.xpoints[n14], polygon2.ypoints[n14]);
                if (++n14 != polygon2.npoints) continue;
                n14 = 0;
            }
            bl = false;
            n14 = n4;
            while (!bl) {
                if (n14 == n3) {
                    bl = true;
                }
                polygon3.addPoint(polygon.xpoints[n14], polygon.ypoints[n14]);
                if (--n14 != -1) continue;
                n14 = polygon.npoints - 1;
            }
        }
        new DetOval(this.m_Detectiv, this.m_id, null, this.m_bb, true, polygon3, this.m_rClip);
        IdentObj identObj = new IdentObj(this.m_id);
        identObj.setMiscID(1);
        new DetOval(this.m_Detectiv, identObj, null, this.m_bb, true, polygon, this.m_rClip);
    }

    public void calcTriangleUp() {
        int n;
        Polygon polygon = new Polygon();
        VC vC = this.m_Perspective.getVC();
        int n2 = vC.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (n2 < (n = vC.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            n2 = n;
        }
        if (n2 < 5) {
            n2 = 5;
        }
        if (n2 % 2 == 0) {
            ++n2;
        }
        n = n2;
        int n3 = vC.virtToDestX(this.m_center.x);
        int n4 = vC.virtToDestY(this.m_center.y);
        polygon.addPoint(n3, n4 - n / 2);
        polygon.addPoint(n3 + n2 / 2, n4 + n / 2);
        polygon.addPoint(n3 - n2 / 2, n4 + n / 2);
        polygon.addPoint(n3, n4 - n / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, polygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(polygon, vC);
        }
    }

    public void calcTriangleDn() {
        int n;
        Polygon polygon = new Polygon();
        VC vC = this.m_Perspective.getVC();
        int n2 = vC.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (n2 < (n = vC.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            n2 = n;
        }
        if (n2 < 5) {
            n2 = 5;
        }
        if (n2 % 2 == 0) {
            ++n2;
        }
        n = n2;
        int n3 = vC.virtToDestX(this.m_center.x);
        int n4 = vC.virtToDestY(this.m_center.y);
        polygon.addPoint(n3, n4 + n / 2);
        polygon.addPoint(n3 + n2 / 2, n4 - n / 2);
        polygon.addPoint(n3 - n / 2, n4 - n / 2);
        polygon.addPoint(n3, n4 + n / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, polygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(polygon, vC);
        }
    }

    public void calcDiamond() {
        int n;
        Polygon polygon = new Polygon();
        VC vC = this.m_Perspective.getVC();
        int n2 = vC.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (n2 < (n = vC.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            n2 = n;
        }
        if (n2 < 5) {
            n2 = 5;
        }
        if (n2 % 2 == 0) {
            ++n2;
        }
        n = n2;
        int n3 = vC.virtToDestX(this.m_center.x);
        int n4 = vC.virtToDestY(this.m_center.y);
        polygon.addPoint(n3 + n2 / 2, n4);
        polygon.addPoint(n3, n4 - n / 2);
        polygon.addPoint(n3 - n2 / 2, n4);
        polygon.addPoint(n3, n4 + n / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, polygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(polygon, vC);
        }
    }

    public void threedPolygons(Polygon polygon, VC vC) {
        Polygon polygon2;
        int n;
        Vector<Polygon> vector = new Vector<Polygon>();
        this.m_nXDepth /= 3;
        this.m_nYDepth /= 3;
        int n2 = 0;
        while (n2 < polygon.npoints) {
            n = (n2 + 1) % polygon.npoints;
            polygon2 = new Polygon();
            polygon2.addPoint(polygon.xpoints[n2], polygon.ypoints[n2]);
            polygon2.addPoint(polygon.xpoints[n], polygon.ypoints[n]);
            polygon2.addPoint(polygon.xpoints[n] + vC.virtToDestWidth(this.m_nXDepth), polygon.ypoints[n] - vC.virtToDestHeight(this.m_nYDepth));
            polygon2.addPoint(polygon.xpoints[n2] + vC.virtToDestWidth(this.m_nXDepth), polygon.ypoints[n2] - vC.virtToDestHeight(this.m_nYDepth));
            vector.addElement(polygon2);
            ++n2;
        }
        n2 = this.m_nDepthAngle > 90 ? 1 : 0;
        QSortPoly.quickSortPoly(vector, 0, vector.size() - 1, n2);
        vector.addElement(polygon);
        n = 0;
        while (n < vector.size()) {
            polygon2 = (Polygon)vector.elementAt(n);
            IdentObj identObj = new IdentObj(this.m_id);
            identObj.setMiscID(n);
            new DetPolygon(this.m_Detectiv, identObj, polygon2, this.m_bb, this.m_bHiliteable);
            ++n;
        }
    }

    public void calcPlus() {
        int n;
        Polygon polygon = new Polygon();
        VC vC = this.m_Perspective.getVC();
        int n2 = vC.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (n2 < (n = vC.virtToDestHeight(this.m_template.m_rect.height * this.m_markerSizeY / 100))) {
            n2 = n;
        }
        if (n2 < 5) {
            n2 = 5;
        }
        if (n2 % 2 == 0) {
            ++n2;
        }
        n = n2;
        int n3 = vC.virtToDestX(this.m_center.x);
        int n4 = vC.virtToDestY(this.m_center.y);
        int n5 = 1;
        boolean bl = false;
        while (!bl) {
            if (n2 >= (n5 += 2) * 3 + 2) continue;
            bl = true;
            n5 -= 2;
        }
        int n6 = (n5 + 1) / 2;
        polygon.addPoint(n3 - n6, n4 - n / 2);
        polygon.addPoint(n3 + n6, n4 - n / 2);
        polygon.addPoint(n3 + n6, n4 - n6);
        polygon.addPoint(n3 + n / 2, n4 - n6);
        polygon.addPoint(n3 + n / 2, n4 + n6);
        polygon.addPoint(n3 + n6, n4 + n6);
        polygon.addPoint(n3 + n6, n4 + n / 2);
        polygon.addPoint(n3 - n6, n4 + n / 2);
        polygon.addPoint(n3 - n6, n4 + n6);
        polygon.addPoint(n3 - n / 2, n4 + n6);
        polygon.addPoint(n3 - n / 2, n4 - n6);
        polygon.addPoint(n3 - n6, n4 - n6);
        polygon.addPoint(n3 - n6, n4 - n / 2);
        if (!this.m_threed) {
            new DetPolygon(this.m_Detectiv, this.m_id, polygon, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            this.threedPolygons(polygon, vC);
        }
    }

    public void calcRect() {
        VC vC = this.m_Perspective.getVC();
        int n = vC.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        if (n < 5) {
            n = 5;
        }
        if (n % 2 == 0) {
            ++n;
        }
        int n2 = n;
        int n3 = vC.virtToDestX(this.m_center.x);
        int n4 = vC.virtToDestY(this.m_center.y);
        Rectangle rectangle = new Rectangle(n3 - n / 2, n4 - n2 / 2, n - 1, n2 - 1);
        if (!this.m_threed) {
            new DetRect(this.m_Detectiv, this.m_id, rectangle, this.m_bb, this.m_bHiliteable);
        }
        if (this.m_threed) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n3 - n / 2, n4 - n2 / 2);
            polygon.addPoint(n3 + n / 2, n4 - n2 / 2);
            polygon.addPoint(n3 + n / 2, n4 + n2 / 2);
            polygon.addPoint(n3 - n / 2, n4 + n2 / 2);
            this.threedPolygons(polygon, vC);
        }
    }

    public void calcLine() {
        int n = this.m_template.getLineStyle();
        VC vC = this.m_Perspective.getVC();
        int n2 = vC.virtToDestWidth(this.m_template.m_rect.width * this.m_markerSizeX / 100);
        int n3 = vC.virtToDestX(this.m_center.x);
        int n4 = vC.virtToDestY(this.m_center.y);
        n3 = vC.destToVirtX(n3 - n2 / 2);
        new DetLine(this.m_Detectiv, this.m_id, n3, this.m_center.y, n3 + vC.destToVirtWidth(n2 - 1), this.m_center.y, this.m_bb, null, 2, n);
    }

    public void calcDrillUp() {
        VC vC = this.m_Perspective.getVC();
        int n = vC.virtToDestX(this.m_center.x);
        int n2 = vC.virtToDestY(this.m_center.y);
        Rectangle rectangle = new Rectangle(n - this.m_markerSizeX / 2, n2 - this.m_markerSizeY / 2, this.m_markerSizeX, this.m_markerSizeY);
        new DetImage(this.m_Detectiv, this.m_id, this.m_bb, this.m_rClip, false, rectangle);
    }

    public Point getCenter() {
        return this.m_center;
    }

    public int getMarkerType() {
        return this.m_template.m_markerType;
    }

    public Dimension getSize() {
        return new Dimension(this.m_template.m_rect.width * this.m_markerSizeX / 100, this.m_template.m_rect.height * this.m_markerSizeY / 100);
    }

    public void setReferenceLabel(String string) {
        this.m_szRefLabel = string;
    }

    public double getReferenceData() {
        return this.m_nData;
    }

    public String getReferenceLabel() {
        return this.m_szRefLabel;
    }
}

