/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataStorage;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.MissingData;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.SmartChartBase;
import oracle.dss.graph.pfj.data.TDGPreScaleIF;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.event.TDGErrorManager;
import oracle.dss.graph.pfj.event.TDGEventManager;

public abstract class JChart_Base
implements Serializable {
    public static final int CM_AUTOMATIC = 0;
    public static final int CM_SERIES = 1;
    public static final int CM_GROUP = 2;
    public static final int CM_HEIGHT = 3;
    public static final int LARGE_DATASET = 899;
    public static final int SCROLLER_THICKNESS = 8;
    public static final int SCROLLER_THICKNESS_HORZ = 12;
    public static final int MIN_GRADIENT_WIDTH = 3;
    public static final int MIN_GRADIENT_HEIGHT = 3;
    public static final int MIN_GRADIENT_MARKER_SIZE = 8;
    public static final int MIN_GRADIENT_SLICE_SIZE = 10;
    Perspective m_Perspective;
    Access m_Access;
    JGraphType m_gt;
    LegendObj m_Legend;
    Detectiv m_Detectiv;
    int m_nTotalSeries;
    int m_nTotalGroups;
    int m_nSeries;
    int m_nGroups;
    boolean m_bAbsolute;
    boolean m_bStacked;
    boolean m_bWantRiserBorder;
    boolean m_bSmallDataSet;
    protected boolean m_bColorAutoshadeRisers;
    int m_nEffColorMode;
    int m_nSeriesLooping;
    IdentObj m_idColorByHeight;
    boolean[] m_bSeriesHasSFX;
    boolean m_bDisplayOffScaleY1;
    boolean m_bDisplayOffScaleY2;
    boolean m_bDisplayOffScaleY3;
    boolean m_bDisplayOffScaleY4;
    boolean m_bDisplayOffScaleY5;
    int m_nFillMissingData;
    boolean m_autoGradient;
    boolean m_smallMarker;
    SeriesEnumerator m_sEnumForward;
    SeriesEnumerator m_sEnumReverse;
    GroupsEnumerator m_gEnumForward;
    GroupsEnumerator m_gEnumReverse;
    MissingData m_missData;
    SimpleBlackBoxObj[] m_sbb;
    SmartChartBase m_SmartChart;
    boolean m_bFoundNullData;
    boolean m_positiveVal;
    boolean m_negativeVal;
    boolean m_zeroVal;
    boolean m_nullVal;
    boolean m_positiveValY1;
    boolean m_negativeValY1;
    boolean m_zeroValY1;
    boolean m_nullValY1;
    boolean m_positiveValY2;
    boolean m_negativeValY2;
    boolean m_zeroValY2;
    boolean m_nullValY2;
    boolean m_positiveValX1;
    boolean m_negativeValX1;
    boolean m_zeroValX1;
    boolean m_nullValX1;
    boolean m_dualY;
    boolean m_XY;
    boolean m_dualYX;

    public BlackBoxIF assignSeriesColor(int n, int n2) {
        Serializable serializable;
        try {
            if ((this.m_autoGradient && this.m_smallMarker || !this.m_bColorAutoshadeRisers && this.m_nEffColorMode == 1 && !this.m_bSeriesHasSFX[n]) && (serializable = this.m_sbb[n % this.m_nSeriesLooping]) != null) {
                Serializable serializable2 = serializable;
                return serializable2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = this.assignSeriesIdent(n, n2);
        return this.assignSeriesColor((IdentObj)serializable);
    }

    public BlackBoxIF assignSeriesColor(int n) {
        IdentObj identObj;
        try {
            SimpleBlackBoxObj simpleBlackBoxObj;
            if (!this.m_bColorAutoshadeRisers && this.m_nEffColorMode == 1 && !this.m_bSeriesHasSFX[n] && (simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj = new IdentObj(-3, n % this.m_nSeriesLooping), this.m_bWantRiserBorder)) != null) {
                SimpleBlackBoxObj simpleBlackBoxObj2 = simpleBlackBoxObj;
                return simpleBlackBoxObj2;
            }
        }
        catch (Exception exception) {
            System.out.println("exception in chartbase");
        }
        identObj = this.assignSeriesIdent(n, 0);
        return this.assignSeriesColor(identObj);
    }

    public BlackBoxIF assignSeriesColor(IdentObj identObj) {
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        return blackBoxObj;
    }

    public IdentObj assignSeriesIdent(int n, int n2) {
        boolean bl = this.m_Perspective.getReverseSeries();
        int n3 = this.m_Perspective.isColorByGroup() ? n2 : n;
        IdentObj identObj = new IdentObj(-3, n3 %= this.m_nSeriesLooping);
        return identObj;
    }

    public void calc() {
        this.m_positiveVal = false;
        this.m_negativeVal = false;
        this.m_zeroVal = false;
        this.m_nullVal = false;
        this.copyParams();
        this.calcAllMissingData();
        this.m_SmartChart = new SmartChartBase();
        this.m_SmartChart.init(this.m_Perspective);
        this.m_bFoundNullData = false;
    }

    private void calcAllMissingData() {
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        if (this.m_nFillMissingData != 0 && jGraphType.isBLAType()) {
            boolean bl = false;
            if (this.m_missData == null) {
                bl = true;
            }
            SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
            this.m_missData = new MissingData(this, this.m_Perspective, this.m_Access, this.m_Perspective.m_DataStorage);
            this.m_missData.calcMissingData(seriesEnumerator, bl);
        }
    }

    public void calcLegend() {
        if (this.m_Legend != null) {
            this.m_Legend.calc();
        }
    }

    protected void copyParams() {
        IdentObj identObj;
        this.m_Detectiv = this.m_Perspective.getDetectiv();
        this.m_nSeries = this.m_Access.getNumNonIgnoredSeries();
        this.m_nGroups = this.m_Access.getNumGroups();
        this.m_bSmallDataSet = this.m_nSeries * this.m_nGroups < 899;
        this.m_nTotalSeries = this.m_Access.getNumTotalSeries();
        this.m_nTotalGroups = this.m_Access.getNumTotalGroups();
        this.m_bAbsolute = this.m_gt.isScalingAbs();
        this.m_bStacked = this.m_gt.isScalingStacked();
        this.m_nEffColorMode = this.m_Perspective.getEffectiveColorMode();
        this.m_bColorAutoshadeRisers = this.m_Perspective.getAutoshading() && this.m_bSmallDataSet;
        this.m_bDisplayOffScaleY1 = this.m_Perspective.getDisplayOffScale(2004);
        this.m_bDisplayOffScaleY2 = this.m_Perspective.getDisplayOffScale(2005);
        this.m_bDisplayOffScaleY3 = this.m_Perspective.getDisplayOffScale(2012);
        this.m_bDisplayOffScaleY4 = this.m_Perspective.getDisplayOffScale(2013);
        this.m_bDisplayOffScaleY5 = this.m_Perspective.getDisplayOffScale(2014);
        this.m_nFillMissingData = this.m_Perspective.getFillMissingData();
        switch (this.m_Perspective.getRiserBorderMode()) {
            case 0: {
                this.m_bWantRiserBorder = this.m_bSmallDataSet;
                break;
            }
            case 1: {
                this.m_bWantRiserBorder = false;
                break;
            }
            case 2: {
                this.m_bWantRiserBorder = true;
                break;
            }
            default: {
                throw new AssertionException("RiserBorderMode", 0, 2, this.m_Perspective.getRiserBorderMode());
            }
        }
        this.m_idColorByHeight = this.m_Perspective.getColorByHeight();
        this.m_Perspective.setFillType(this.m_idColorByHeight, 2);
        this.m_bSeriesHasSFX = new boolean[this.m_nTotalSeries];
        int n = 0;
        while (n < this.m_nTotalSeries) {
            identObj = this.m_Perspective.getSeries(n);
            this.m_bSeriesHasSFX[n] = this.m_Perspective.getFillType(identObj) != 1 || this.m_Perspective.getShadowDisplay(identObj);
            ++n;
        }
        this.m_sEnumForward = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_sEnumReverse = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        this.m_gEnumForward = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_gEnumReverse = new GroupsEnumerator(this.m_Perspective, this.m_Access, false);
        this.m_nSeriesLooping = this.m_Perspective.getSeriesLooping();
        this.m_sbb = new SimpleBlackBoxObj[this.m_nSeriesLooping];
        n = 0;
        while (n < this.m_nSeriesLooping) {
            identObj = new IdentObj(-3, n);
            this.m_sbb[n] = new SimpleBlackBoxObj(this.m_Perspective, identObj, this.m_bWantRiserBorder);
            ++n;
        }
        this.m_autoGradient = this.m_Perspective.getSeriesGradientEffect(0) == 2;
    }

    public void createLegend() {
        this.m_Legend = new LegendObj(this.m_Perspective, this.m_Access, this, false);
    }

    public MinMaxObj findPreScaledLimits(int n, int n2, boolean bl) {
        TDGPreScaleIF tDGPreScaleIF = this.m_Perspective.getPreScaleCallback();
        MinMaxObj minMaxObj = null;
        try {
            if (tDGPreScaleIF != null) {
                double d = tDGPreScaleIF.getScaleMinimum(n, n2);
                double d2 = tDGPreScaleIF.getScaleMaximum(n, n2);
                minMaxObj = new MinMaxObj(bl, d, d2);
                minMaxObj.setDataDerived(false);
            }
        }
        catch (Exception exception) {
            minMaxObj = null;
        }
        return minMaxObj;
    }

    protected BlackBoxIF getBlackBox(IdentObj identObj) {
        int n = identObj.getSeriesID();
        int n2 = identObj.getGroupID();
        BlackBoxIF blackBoxIF = n != -3 ? this.assignSeriesColor(n, n2) : new BlackBoxObj(this.m_Perspective, identObj);
        return blackBoxIF;
    }

    public BlackBoxIF getBlackBox(IdentObj identObj, double d) {
        PfjAssert.pfjAssert(d >= 0.0 && d <= 1.0);
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, this.m_idColorByHeight);
        BlackBoxIF blackBoxIF = this.getBlackBox(identObj);
        blackBoxIF.setFillColor(blackBoxObj.getGradientColorAt(d));
        return blackBoxIF;
    }

    public DatumObj getDataValue(int n, int n2) {
        return this.getDataValue(n, n2, DataItem.DI_GENERAL, false);
    }

    public DatumObj getDataValue(int n, int n2, DataItem dataItem) {
        return this.getDataValue(n, n2, dataItem, false);
    }

    public DatumObj getDataValue(int n, int n2, DataItem dataItem, boolean bl) {
        double d;
        boolean bl2 = true;
        try {
            d = this.m_Access.getDataAsDouble(n, n2, dataItem, bl);
            if (this.m_nFillMissingData != 0 && this.m_Access.m_DataStorage.isMissingDataFilledIn(n, n2)) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            this.m_nullVal = true;
            d = 0.0;
            bl2 = false;
        }
        DatumObj datumObj = new DatumObj(d, bl2);
        return datumObj;
    }

    public String getStringDataValue(int n, int n2, DataItem dataItem, boolean bl) {
        String string = "";
        try {
            string = this.m_Access.getDataAsString(n, n2, dataItem);
        }
        catch (AssertionException assertionException) {
            // empty catch block
        }
        return string;
    }

    public String getStringDataValue(int n, int n2, DataItem dataItem) {
        return this.getStringDataValue(n, n2, dataItem, false);
    }

    public void setDataAsDouble(int n, int n2, DataItem dataItem, double d, boolean bl) {
        this.m_Access.setDataAsDouble(n, n2, dataItem, d, bl);
    }

    public void setDataAsDouble(int n, int n2, DataItem dataItem, double d) {
        this.setDataAsDouble(n, n2, dataItem, d, false);
    }

    public void setDataAsString(int n, int n2, DataItem dataItem, String string, boolean bl) {
        this.m_Access.setDataAsString(n, n2, dataItem, string, bl);
    }

    public void setDataAsString(int n, int n2, DataItem dataItem, String string) {
        this.setDataAsString(n, n2, dataItem, string, false);
    }

    public Point2D getDataValuesXY(int n, int n2) throws AssertionException {
        DatumObj datumObj = this.getDataValue(n, n2);
        if (!datumObj.m_bOK) {
            throw new AssertionException();
        }
        return new Point2D.Double(n2, datumObj.m_fValue);
    }

    protected Point getVCPositionsXY(int n, double d, double d2) throws AssertionException {
        throw new AssertionException(String.valueOf(String.valueOf("getVCPositionsXY not implemented for chart type ")) + this.m_gt.getChartName());
    }

    public Detectiv getDetectiv() {
        return this.m_Detectiv;
    }

    public double getAutoLowerSplitValue(IdentObj identObj) {
        return Double.NaN;
    }

    public double getAutoHigherSplitValue(IdentObj identObj) {
        return Double.NaN;
    }

    public double getQuantizedDataValue(int n, int n2) {
        return this.getQuantizedDataValue(n, n2, DataItem.DI_GENERAL);
    }

    public double getQuantizedDataValue(int n, int n2, DataItem dataItem) {
        throw new AssertionException(String.valueOf(String.valueOf("Data quantization by the spectral legend not supported by chart type ")) + this.m_gt.getChartName());
    }

    public GroupsEnumerator getResetGroupsEnumerator() {
        GroupsEnumerator groupsEnumerator = this.m_gEnumForward;
        PfjAssert.pfjAssert(groupsEnumerator != null);
        groupsEnumerator.reset();
        return groupsEnumerator;
    }

    public GroupsEnumerator getResetGroupsEnumerator(boolean bl) {
        GroupsEnumerator groupsEnumerator = bl ? this.m_gEnumForward : this.m_gEnumReverse;
        PfjAssert.pfjAssert(groupsEnumerator != null);
        groupsEnumerator.reset();
        return groupsEnumerator;
    }

    public SeriesEnumerator getResetSeriesEnumerator() {
        SeriesEnumerator seriesEnumerator = this.m_sEnumForward;
        PfjAssert.pfjAssert(seriesEnumerator != null);
        seriesEnumerator.reset();
        return seriesEnumerator;
    }

    public SeriesEnumerator getResetSeriesEnumerator(boolean bl) {
        SeriesEnumerator seriesEnumerator = bl ? this.m_sEnumForward : this.m_sEnumReverse;
        PfjAssert.pfjAssert(seriesEnumerator != null);
        seriesEnumerator.reset();
        return seriesEnumerator;
    }

    public void init(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
        this.updateAccess();
        this.m_Legend = null;
    }

    public boolean isIgnoredOffScale(RelativeAxisObj relativeAxisObj, double d) {
        boolean bl = relativeAxisObj.isValueOffscale(d);
        return bl && !this.allowDisplayOffScale(relativeAxisObj);
    }

    public boolean allowDisplayOffScale(RelativeAxisObj relativeAxisObj) {
        boolean bl;
        if (this.m_gt.isScatter() || this.m_gt.isBubble()) {
            bl = false;
        } else {
            int n = relativeAxisObj.getAxisObjID();
            switch (n) {
                case 0: {
                    bl = this.m_bDisplayOffScaleY1;
                    break;
                }
                case 1: {
                    bl = this.m_bDisplayOffScaleY2;
                    break;
                }
                case 2: {
                    bl = this.m_bDisplayOffScaleY3;
                    break;
                }
                case 3: {
                    bl = this.m_bDisplayOffScaleY4;
                    break;
                }
                case 4: {
                    bl = this.m_bDisplayOffScaleY5;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public boolean isBadValueInLogscale(RelativeAxisObj relativeAxisObj, double d) {
        boolean bl = d <= 0.0;
        boolean bl2 = relativeAxisObj.isLogScale();
        return bl && bl2;
    }

    public boolean isBadValueInLogscale(int n, double d) {
        boolean bl;
        boolean bl2 = d <= 0.0;
        switch (n) {
            case 7: {
                bl = this.m_Perspective.getX1LogScale();
                break;
            }
            case 0: {
                bl = this.m_Perspective.getY1LogScale();
                break;
            }
            case 1: {
                bl = this.m_Perspective.getY2LogScale();
                break;
            }
            case 2: {
                bl = this.m_Perspective.getY3LogScale();
                break;
            }
            case 3: {
                bl = this.m_Perspective.getY4LogScale();
                break;
            }
            case 4: {
                bl = this.m_Perspective.getY5LogScale();
                break;
            }
            case 8: {
                bl = false;
                break;
            }
            default: {
                TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
                tDGErrorManager.notifyErrorListener(this, 3972, String.valueOf(String.valueOf("isBadValueInLogscale: axis = ")) + n + ". bIsLog = true.", null);
                bl = true;
            }
        }
        return bl2 && bl;
    }

    public boolean isGroupScrollerPresent() {
        return false;
    }

    public boolean isSeriesScrollerPresent() {
        return false;
    }

    public boolean optimizeData() {
        return false;
    }

    public void reloadOriginalData() {
    }

    public void releaseReferences() {
        this.m_Access.releaseReferences();
        if (this.m_Legend != null) {
            this.m_Legend.releaseReferences();
        }
        int n = 0;
        while (n < this.m_nSeriesLooping) {
            this.m_sbb[n].releaseReferences();
            ++n;
        }
        this.m_Perspective = null;
    }

    public void updateAccess() {
        this.m_Access = new Access(this.m_Perspective, this.m_Perspective.m_DataStorage, this.m_Perspective.m_DataRange, this.m_gt.getDataFormat());
        this.m_nSeries = this.m_Access.getNumNonIgnoredSeries();
        this.m_nGroups = this.m_Access.getNumGroups();
    }

    public void updateDataSet(DataStorage dataStorage) {
    }

    public boolean wantLegend() {
        boolean bl = !this.m_Perspective.isColorByGroup();
        return bl;
    }

    protected BlackBoxIF getMissingDataBlackBox(int n, int n2) {
        boolean bl;
        SimpleBlackBoxObj simpleBlackBoxObj = null;
        if (this.m_nFillMissingData != 0 && (bl = this.m_Access.m_DataStorage.isMissingDataFilledIn(n, n2))) {
            IdentObj identObj = this.m_Perspective.getSeries(n);
            simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj, this.m_bWantRiserBorder);
            simpleBlackBoxObj.setTransparentFillColor(true);
        }
        return simpleBlackBoxObj;
    }

    protected void fireInapropriateDataEvent() {
        int n = 0;
        boolean bl = false;
        if (!(this.m_dualY || this.m_XY || this.m_dualYX)) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeVal;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroVal;
            this.m_nullVal = this.m_nullValY1 || this.m_nullVal;
            this.m_positiveVal = this.m_positiveValY1 || this.m_positiveVal;
        } else if (this.m_XY && !this.m_positiveValY1 && this.m_positiveValX1) {
            bl = true;
            this.m_negativeVal = this.m_negativeValY1;
            this.m_zeroVal = this.m_zeroValY1;
            this.m_nullVal = this.m_nullValY1;
            this.m_positiveVal = this.m_positiveValY1;
        } else if (this.m_XY && this.m_positiveValY1 && !this.m_positiveValX1) {
            bl = true;
            this.m_negativeVal = this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValX1;
            this.m_nullVal = this.m_nullValX1;
            this.m_positiveVal = this.m_positiveValX1;
        } else if (this.m_XY) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroValX1;
            this.m_nullVal = this.m_nullValY1 || this.m_nullValX1;
            this.m_positiveVal = this.m_positiveValY1 || this.m_positiveValX1;
        } else if (this.m_dualY && !this.m_positiveValY1 && this.m_positiveValY2) {
            bl = true;
            this.m_negativeVal = this.m_negativeValY1;
            this.m_zeroVal = this.m_zeroValY1;
            this.m_nullVal = this.m_nullValY1;
            this.m_positiveVal = this.m_positiveValY1;
        } else if (this.m_dualY && this.m_positiveValY1 && !this.m_positiveValY2) {
            bl = true;
            this.m_negativeVal = this.m_negativeValY2;
            this.m_zeroVal = this.m_zeroValY2;
            this.m_nullVal = this.m_nullValY2;
            this.m_positiveVal = this.m_positiveValY2;
        } else if (this.m_dualY) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeValY2;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroValY2;
            this.m_nullVal = this.m_nullValY1 || this.m_nullValY2;
            this.m_positiveVal = this.m_positiveValY1 || this.m_positiveValY2;
        } else if (this.m_dualYX && !this.m_positiveValY1 && this.m_positiveValY2 && this.m_positiveValX1) {
            bl = true;
            this.m_negativeVal = this.m_negativeValY1;
            this.m_zeroVal = this.m_zeroValY1;
            this.m_nullVal = this.m_nullValY1;
            this.m_positiveVal = this.m_positiveValY1;
        } else if (this.m_dualYX && this.m_positiveValY1 && !this.m_positiveValY2 && this.m_positiveValX1) {
            bl = true;
            this.m_negativeVal = this.m_negativeValY2;
            this.m_zeroVal = this.m_zeroValY2;
            this.m_nullVal = this.m_nullValY2;
            this.m_positiveVal = this.m_positiveValY2;
        } else if (this.m_dualYX && this.m_positiveValY1 && this.m_positiveValY2 && !this.m_positiveValX1) {
            bl = true;
            this.m_negativeVal = this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValX1;
            this.m_nullVal = this.m_nullValX1;
            this.m_positiveVal = this.m_positiveValX1;
        } else if (this.m_dualYX) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeValY2 || this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroValY2 || this.m_zeroValX1;
            this.m_nullVal = this.m_nullValY1 || this.m_nullValY2 || this.m_nullValX1;
            boolean bl2 = this.m_positiveVal = this.m_positiveValY1 || this.m_positiveValY2 || this.m_positiveValX1;
        }
        if (this.m_negativeVal) {
            n |= 2;
        }
        if (this.m_zeroVal) {
            n |= 1;
        }
        if (this.m_nullVal) {
            n |= 4;
        }
        TDGEventManager tDGEventManager = this.m_Perspective.getEventManager();
        if (!bl) {
            if (n == 4) {
                if (this.m_positiveVal) {
                    tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3995, n);
                } else {
                    tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3993, n);
                }
            } else if (n != 0) {
                if (this.m_positiveVal) {
                    tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3994, n);
                } else {
                    tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3992, n);
                }
            }
        } else if (n == 4) {
            tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3997, n);
        } else if (n != 0) {
            tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3996, n);
        }
    }

    public boolean isSingleSeriesOnly() {
        return false;
    }

    public abstract void calcDataScrollers();
}

