/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis3DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_3D_Surf;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.QSortAlgorithm;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.event.TDGErrorManager;
import oracle.dss.graph.pfj.model3d.Matrix3d;
import oracle.dss.graph.pfj.model3d.Matrix4d;
import oracle.dss.graph.pfj.model3d.Model3DCubeWall;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Model3DModRectSolid;
import oracle.dss.graph.pfj.model3d.Model3DOctagonSolid;
import oracle.dss.graph.pfj.model3d.Model3DRectPyramid;
import oracle.dss.graph.pfj.model3d.Model3DRectSolid;
import oracle.dss.graph.pfj.model3d.Model3DRibbonGroupSolid;
import oracle.dss.graph.pfj.model3d.Model3DRibbonSeriesSolid;
import oracle.dss.graph.pfj.model3d.Point3d;

public class JChart_3D
extends JChart_Base {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    public static final int CHANGED_ALL = 0;
    public static final int CHANGED_COLOR = 1;
    public static final int CHANGED_CUBE = 2;
    public static final int CHANGED_GRID = 3;
    public static final int CHANGED_RISER = 4;
    public static final int CHANGED_SCALE = 5;
    public static final int CHANGED_VIEW = 6;
    public static final double LIGHTSOURCE_FACTOR = 0.01;
    public static final int LIGHTSOURCE_OFFSET = 0;
    public static final int SIZE_FACTOR = 200;
    public static final int SIZE_OFFSET = 2000;
    public static final int WALL_FACTOR = 20;
    public static final int WALL_OFFSET = 100;
    public static final int TRANS_FACTOR = 200;
    public static final int TRANS_OFFSET = -10000;
    public static final int VIEW_XY_FACTOR = 100;
    public static final int VIEW_XY_OFFSET = -5000;
    public static final int VIEW_Z_FACTOR = 500;
    public static final int VIEW_Z_OFFSET = 0;
    public static final int PAN_FACTOR = 300;
    public static final int PAN_OFFSET = -15000;
    public static final double ZOOM_BASE = 1.028113827;
    public static final double ZOOM_MULT = 0.25;
    public static final double ZOOM_MIN = 0.25;
    public static final double ZOOM_MAX = 4.0;
    public static final double FOCUS_BASE = 1.011778466;
    public static final double FOCUS_MULT = 0.556837407;
    public static final int INTERP_LARGE_DATASETS = 0;
    public static final int INTERP_ISOMETRIC = 1;
    public static final int INTERP_NEVER = 2;
    static final int WIREPOINTS = 17;
    static final int CONNECTIONS = 21;
    static final int[][] m_Connect = new int[][]{{0, 1}, {0, 2}, {0, 3}, {7, 3}, {1, 7}, {1, 8}, {3, 9}, {9, 2}, {2, 8}, {10, 11}, {11, 12}, {12, 13}, {13, 10}, {10, 14}, {11, 15}, {13, 16}, {14, 15}, {16, 14}, {9, 16}, {15, 8}, {12, 7}};
    Point3d[] m_wirePts3D;
    Point[] m_wirePts2D;
    boolean m_bAlreadyDrawn;
    protected boolean m_bChangedColor;
    protected boolean m_bChangedCube;
    protected boolean m_bChangedGrid;
    protected boolean m_bChangedRiser;
    protected boolean m_bChangedScale;
    protected boolean m_bChangedView;
    protected boolean m_bNoWireframeYet;
    protected boolean m_bSafeAngle;
    protected boolean m_bCanUseSimpleVis;
    protected boolean m_bColorAutoshading;
    public double m_fColorLightSourceX;
    public double m_fColorLightSourceY;
    public double m_fColorLightSourceZ;
    protected boolean m_bCubeDisplay3DFloor;
    protected boolean m_bCubeDisplay3DLeftWall;
    protected boolean m_bCubeDisplay3DRightWall;
    protected double m_fCubeSizeX;
    protected double m_fCubeSizeY;
    protected double m_fCubeSizeZ;
    protected double m_fCubeWallThickX;
    protected double m_fCubeWallThickY;
    protected double m_fCubeWallThickZ;
    protected boolean m_bGrid3DFloorDisplayX;
    protected boolean m_bGrid3DFloorDisplayZ;
    protected boolean m_bGrid3DLeftWallDisplayY;
    protected boolean m_bGrid3DLeftWallDisplayZ;
    protected boolean m_bGrid3DRightWallDisplayX;
    protected boolean m_bGrid3DRightWallDisplayY;
    protected boolean m_bGrid3DRiserDisplayX;
    protected boolean m_bGrid3DRiserDisplayY;
    protected boolean m_bGrid3DRiserDisplayZ;
    protected int m_nRiser3DThicknessY;
    protected boolean m_bRiserScaleFromZero;
    protected boolean m_bRiserSquareRisers;
    protected boolean m_bDataTextDisplay;
    protected boolean m_bScaleY1AxisAscending;
    protected boolean m_bScaleMustIncludeZero;
    protected boolean m_bScaleO1LabelDisplay;
    protected boolean m_bScaleO2LabelDisplay;
    protected boolean m_bScaleY1LabelDisplay;
    protected boolean m_bY1LogScale;
    protected double m_fViewTranslationX;
    protected double m_fViewTranslationY;
    protected double m_fViewTranslationZ;
    protected double m_fViewPanX;
    protected double m_fViewPanY;
    protected double m_fViewZoomFactor;
    protected double m_fViewFocusFactor;
    protected double m_fViewViewerX;
    protected double m_fViewViewerY;
    protected double m_fViewViewerZ;
    protected boolean m_bViewRawViewerZ;
    protected boolean m_bViewForceIsometric;
    protected Matrix3d m_rotationMatrix;
    protected Axis3DObj m_O1Axis;
    protected Axis3DObj m_O2Axis;
    protected Axis3DObj m_Y1Axis;
    protected Vector m_objectList;
    protected Model3DCubeWall m_Floor;
    protected Model3DCubeWall m_LWall;
    protected Model3DCubeWall m_RWall;
    protected Model3DRectSolid m_wholeCube;
    protected Matrix4d m_matrix;
    int[][] m_numYCoords;
    boolean[][] m_dataOK;
    double[][] m_rawValues;
    String[][] m_DataLabel;

    public void calc() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        super.calc();
        if (this.m_bChangedView) {
            this.createMatrix();
        }
        if (this.m_bNoWireframeYet) {
            this.createWireframe();
        }
        if (this.m_bChangedCube || this.m_bChangedScale) {
            this.createAxes3D();
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (this.m_O1Axis != null) {
                this.m_O1Axis.calc();
            }
            if (this.m_O2Axis != null) {
                this.m_O2Axis.calc();
            }
            this.calcDataAbsolute();
        }
        if (this.m_bChangedCube) {
            this.defineCube();
        }
        if (this.m_bChangedCube || this.m_bChangedView) {
            this.setDrawOrder();
        }
        if (this.m_bSafeAngle) {
            this.m_Floor.preDisplay();
            this.m_LWall.preDisplay();
            this.m_RWall.preDisplay();
            switch (this.m_Perspective.getCubeRiserInterpolation()) {
                case 0: {
                    bl = !this.m_bSmallDataSet;
                    break;
                }
                case 1: {
                    bl = this.m_bViewForceIsometric;
                    break;
                }
            }
            if (bl) {
                if (this.m_bChangedRiser || this.m_bChangedScale) {
                    this.defineFast3DMatrixObjects();
                }
            } else if (this.m_bChangedRiser || this.m_bChangedScale) {
                this.define3DMatrixObjects();
            }
            this.m_RWall.postDisplay();
            this.m_LWall.postDisplay();
            this.m_Floor.postDisplay();
        } else {
            if (this.m_bChangedRiser || this.m_bChangedScale) {
                this.define3DMatrixObjects();
            }
            if (this.m_bChangedRiser || this.m_bChangedView) {
                this.sort3DObjects();
            }
            this.displayAll3DObjects();
        }
        this.calculateAxisTitlePosition();
        while (true) {
            if (n < 1) {
                this.m_Perspective.setMinimumAxisTextSizeVC(16000);
                n2 = this.m_Perspective.getAxisTextAutofitMode();
                this.m_Perspective.setAxisTextAutofitMode(0);
                if (n2 != 0) {
                    this.m_Perspective.setTestLabelCalc(true);
                } else {
                    this.m_Perspective.setTestLabelCalc(false);
                }
            }
            if (this.m_O1Axis != null && this.m_bScaleO1LabelDisplay) {
                this.m_O1Axis.calcLabels();
                if (n < 1 && this.m_O1Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_O1Axis.getAxisTextLabelSizeVC());
                }
            }
            if (this.m_O2Axis != null && this.m_bScaleO2LabelDisplay) {
                this.m_O2Axis.calcLabels();
                if (n < 1 && this.m_O2Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_O2Axis.getAxisTextLabelSizeVC());
                }
            }
            if (this.m_Y1Axis != null && this.m_bScaleY1LabelDisplay) {
                this.m_Y1Axis.calcLabels();
                if (n < 1 && this.m_Y1Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_Y1Axis.getAxisTextLabelSizeVC());
                }
            }
            if (n < 1) {
                this.m_Perspective.setAxisTextAutofitMode(n2);
                this.m_Perspective.setTestLabelCalc(false);
            }
            if (this.m_Perspective.getAxisTextAutofitMode() == 0 || n == 1) break;
            ++n;
        }
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcGrids();
        }
        if (this.m_O2Axis != null) {
            this.m_O2Axis.calcGrids();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcGrids();
        }
        this.fireInapropriateDataEvent();
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        Axis3DObj axis3DObj = this.m_Y1Axis;
        double d = 0.0;
        boolean bl = false;
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_rawValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n2 = groupsEnumerator.nextGroup();
                this.m_dataOK[n][n2] = true;
                DatumObj datumObj = this.getDataValue(n, n2, DataItem.DI_GENERAL);
                d = datumObj.m_fValue;
                if (!datumObj.m_bOK) {
                    this.m_dataOK[n][n2] = false;
                }
                if (this.m_bY1LogScale && d <= 0.0) {
                    if (d == 0.0 && datumObj.m_bOK) {
                        this.m_zeroVal = true;
                    } else if (d < 0.0) {
                        this.m_negativeVal = true;
                    }
                    bl = true;
                    this.m_dataOK[n][n2] = false;
                    d = 0.0;
                } else {
                    this.m_positiveVal = true;
                }
                if (this.isIgnoredOffScale(axis3DObj, d)) {
                    this.m_dataOK[n][n2] = false;
                    d = 0.0;
                }
                this.m_rawValues[n][n2] = d;
                this.m_numYCoords[n][n2] = (int)axis3DObj.getValueCoord(d);
            }
        }
    }

    public void calcDataScrollers() {
    }

    protected int calcSeriesPerPixel() {
        Point3d point3d = new Point3d(this.m_fCubeWallThickX, this.m_fCubeWallThickY, this.m_fCubeSizeZ);
        Point3d point3d2 = new Point3d(this.m_fCubeSizeX - this.m_fCubeWallThickX, this.m_fCubeWallThickY, this.m_fCubeSizeZ);
        this.transformPoint3d(point3d);
        this.transformPoint3d(point3d2);
        Point point = this.projectPoint3d(point3d);
        Point point2 = this.projectPoint3d(point3d2);
        int n = this.m_Perspective.m_VC.virtToDestWidth(point2.x - point.x);
        int n2 = this.m_nSeries / n;
        if (n2 < 1) {
            n2 = 1;
        }
        return n2;
    }

    private Point3d centerGraph(Matrix4d matrix4d) {
        double d = matrix4d.m30;
        double d2 = matrix4d.m31;
        double d3 = matrix4d.m32;
        matrix4d.translate(-d, -d2, -d3);
        return new Point3d(d, d2, d3);
    }

    public void changed() {
        this.changed(0);
    }

    public void changed(int n) {
        switch (n) {
            case 0: {
                this.m_bChangedColor = true;
                this.m_bChangedCube = true;
                this.m_bChangedGrid = true;
                this.m_bChangedRiser = true;
                this.m_bChangedScale = true;
                this.m_bChangedView = true;
                break;
            }
            case 1: {
                this.m_bChangedColor = true;
                break;
            }
            case 2: {
                this.m_bChangedCube = true;
                break;
            }
            case 3: {
                this.m_bChangedGrid = true;
                break;
            }
            case 4: {
                this.m_bChangedRiser = true;
                break;
            }
            case 5: {
                this.m_bChangedScale = true;
                break;
            }
            case 6: {
                this.m_bChangedView = true;
                break;
            }
            default: {
                throw new AssertionException(0, 6, n);
            }
        }
    }

    public void clearWireframe() {
        this.m_bAlreadyDrawn = false;
    }

    public void copyParams() {
        super.copyParams();
        this.copyColorParams();
        this.copyCubeParams();
        this.copyGridParams();
        this.copyRiserParams();
        this.copyScaleParams();
        this.copyViewParams();
    }

    public void copyColorParams() {
        this.m_bColorAutoshading = this.m_Perspective.getAutoshading();
        this.m_fColorLightSourceX = this.denormalize(this.m_Perspective.getCubeLightSourceX(), 0.0, 100.0, 0.01, 0.0);
        this.m_fColorLightSourceY = this.denormalize(this.m_Perspective.getCubeLightSourceY(), 0.0, 100.0, 0.01, 0.0);
        this.m_fColorLightSourceZ = this.denormalize(this.m_Perspective.getCubeLightSourceZ(), 0.0, 100.0, 0.01, 0.0);
    }

    public void copyCubeParams() {
        this.m_bCubeDisplay3DFloor = this.m_Perspective.getDisplay3DFloor();
        this.m_bCubeDisplay3DLeftWall = this.m_Perspective.getDisplay3DLeftWall();
        this.m_bCubeDisplay3DRightWall = this.m_Perspective.getDisplay3DRightWall();
        this.m_fCubeWallThickX = this.denormalize(this.m_Perspective.getCubeWallThickX(), 0.0, 100.0, 20.0, 100.0);
        this.m_fCubeWallThickY = this.denormalize(this.m_Perspective.getCubeWallThickY(), 0.0, 100.0, 20.0, 100.0);
        this.m_fCubeWallThickZ = this.denormalize(this.m_Perspective.getCubeWallThickZ(), 0.0, 100.0, 20.0, 100.0);
        this.m_fCubeSizeX = this.denormalize(this.m_Perspective.getCubeSizeX(), 0.0, 100.0, 200.0, 2000.0);
        this.m_fCubeSizeY = this.denormalize(this.m_Perspective.getCubeSizeY(), 0.0, 100.0, 200.0, 2000.0);
        this.m_fCubeSizeZ = this.denormalize(this.m_Perspective.getCubeSizeZ(), 0.0, 100.0, 200.0, 2000.0);
    }

    public void copyGridParams() {
        this.m_bGrid3DFloorDisplayX = this.m_Perspective.getGrid3DFloorDisplayX();
        this.m_bGrid3DFloorDisplayZ = this.m_Perspective.getGrid3DFloorDisplayZ();
        this.m_bGrid3DLeftWallDisplayY = this.m_Perspective.getGrid3DLeftWallDisplayY();
        this.m_bGrid3DLeftWallDisplayZ = this.m_Perspective.getGrid3DLeftWallDisplayZ();
        this.m_bGrid3DRightWallDisplayX = this.m_Perspective.getGrid3DRightWallDisplayX();
        this.m_bGrid3DRightWallDisplayY = this.m_Perspective.getGrid3DRightWallDisplayY();
        this.m_bGrid3DRiserDisplayX = this.m_Perspective.getGrid3DRiserDisplayX();
        this.m_bGrid3DRiserDisplayY = this.m_Perspective.getGrid3DRiserDisplayY();
        this.m_bGrid3DRiserDisplayZ = this.m_Perspective.getGrid3DRiserDisplayZ();
    }

    public void copyRiserParams() {
        this.m_nRiser3DThicknessY = this.m_Perspective.getRiser3DThicknessY();
        this.m_bRiserScaleFromZero = this.m_Perspective.getScaleFromZero() && (this.m_gt.is3DRiser() || this.m_gt.is3DSurface() || this.m_gt.equals(5));
        this.m_bRiserSquareRisers = this.m_Perspective.getCubeSquareRisers() && (this.m_gt.is3DFloating() || this.m_gt.is3DRiser());
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
    }

    public void copyScaleParams() {
        this.m_bScaleY1AxisAscending = true;
        this.m_bScaleMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        this.m_bScaleO1LabelDisplay = this.m_Perspective.getO1LabelDisplay();
        this.m_bScaleO2LabelDisplay = this.m_Perspective.getO2LabelDisplay();
        this.m_bScaleY1LabelDisplay = this.m_Perspective.getY1LabelDisplay();
        this.m_bY1LogScale = this.m_Perspective.getY1LogScale();
    }

    public void copyViewParams() {
        this.m_fViewTranslationX = this.denormalize(this.m_Perspective.getCubeTranslationX(), 0.0, 100.0, 200.0, -10000.0);
        this.m_fViewTranslationY = this.denormalize(this.m_Perspective.getCubeTranslationY(), 0.0, 100.0, 200.0, -10000.0);
        this.m_fViewTranslationZ = this.denormalize(this.m_Perspective.getCubeTranslationZ(), 0.0, 100.0, 200.0, -10000.0);
        this.m_fViewViewerX = this.denormalize(this.m_Perspective.getCubeViewerX(), 0.0, 100.0, 100.0, -5000.0);
        this.m_fViewViewerY = this.denormalize(this.m_Perspective.getCubeViewerY(), 0.0, 100.0, 100.0, -5000.0);
        this.m_fViewViewerZ = this.denormalize(this.m_Perspective.getCubeViewerZ(), 0.0, 100.0, 500.0, 0.0);
        this.m_bViewRawViewerZ = true;
        this.m_fViewPanX = this.denormalize(this.m_Perspective.getCubePanX(), 0.0, 100.0, 300.0, -15000.0);
        this.m_fViewPanY = this.denormalize(this.m_Perspective.getCubePanY(), 0.0, 100.0, 300.0, -15000.0);
        this.m_fViewZoomFactor = this.denormalizeGeom(this.m_Perspective.getCubeZoomFactor(), 0.0, 100.0, 1.028113827, 0.25);
        this.m_fViewFocusFactor = this.denormalizeGeom(this.m_Perspective.getCubeFocusFactor(), 0.0, 100.0, 1.011778466, 0.556837407);
        this.m_bViewForceIsometric = this.m_Perspective.getCubeIsometricProjection();
        this.m_rotationMatrix = this.m_Perspective.getCubeRotationMatrix();
    }

    private void createAxes3D() {
        int n = 2;
        int n2 = 1;
        int n3 = 0;
        int n4 = 100;
        boolean bl = !this.m_gt.is3DSurface();
        this.m_O1Axis = new Axis3DObj(this, this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, this.m_gt.is3DConnectSeries() ? 5 : 7, n, bl, (int)this.m_fCubeWallThickZ, (int)(this.m_fCubeSizeZ - this.m_fCubeWallThickZ));
        this.m_O2Axis = new Axis3DObj(this, this.m_Perspective, this.m_Access, AxisTemplate.O2_AXIS, this.m_gt.is3DConnectGroups() ? 4 : 8, n, true, (int)this.m_fCubeWallThickX, (int)(this.m_fCubeSizeX - this.m_fCubeWallThickX));
        MinMaxObj minMaxObj = this.findLimits(0, n2, this.m_bScaleMustIncludeZero);
        this.m_Y1Axis = new Axis3DObj(this, this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj, n, this.m_bScaleY1AxisAscending, n3, n4, (int)this.m_fCubeWallThickY, (int)(this.m_fCubeSizeY - this.m_fCubeWallThickY));
    }

    public void createMatrix() {
        this.m_matrix = new Matrix4d();
        this.m_matrix.rotate(this.m_rotationMatrix);
        this.m_matrix.scale(this.m_fViewZoomFactor);
        this.m_matrix.translate(this.m_fViewTranslationX, this.m_fViewTranslationY, this.m_fViewTranslationZ);
    }

    public void createWireframe() {
        this.m_wirePts3D = new Point3d[17];
        this.m_wirePts2D = new Point[17];
        int n = 0;
        while (n < 17) {
            this.m_wirePts3D[n] = new Point3d();
            this.m_wirePts2D[n] = new Point(0, 0);
            ++n;
        }
        this.setWireframePoints();
        this.m_bNoWireframeYet = false;
    }

    public void defineCube() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
        boolean[][] blArray = new boolean[2][3];
        blArray[0][0] = false;
        blArray[0][1] = false;
        blArray[0][2] = false;
        if (this.m_bViewRawViewerZ) {
            double d = this.getMinCubeViewerZ();
            this.m_fViewViewerZ += d;
            this.m_bViewRawViewerZ = false;
        }
        IdentObj identObj = new IdentObj(-3);
        blArray[1][0] = false;
        blArray[1][1] = false;
        blArray[1][2] = false;
        this.m_wholeCube = new Model3DRectSolid(this, identObj, null, point3d, point3d2, blArray, false, false);
        this.m_bSafeAngle = this.m_gt.is3DSurface() ? false : this.m_wholeCube.visibility(0) >= 0.0 && this.m_wholeCube.visibility(2) >= 0.0 && this.m_wholeCube.visibility(4) >= 0.0;
        this.m_bCanUseSimpleVis = this.m_bSafeAngle && !this.m_bColorAutoshadeRisers;
        point3d2.y = this.m_fCubeWallThickY;
        identObj = new IdentObj(514);
        blArray[1][0] = this.m_bGrid3DFloorDisplayX;
        blArray[1][1] = false;
        blArray[1][2] = this.m_bGrid3DFloorDisplayZ;
        this.m_Floor = new Model3DCubeWall(this, identObj, null, point3d, point3d2, blArray, this.m_bColorAutoshading);
        this.m_Floor.calcGrids();
        point3d.y = this.m_fCubeWallThickY;
        point3d2.x = this.m_fCubeWallThickX;
        point3d2.y = this.m_fCubeSizeY - this.m_fCubeWallThickY;
        identObj = new IdentObj(515);
        blArray[1][0] = false;
        blArray[1][1] = this.m_bGrid3DLeftWallDisplayY;
        blArray[1][2] = this.m_bGrid3DLeftWallDisplayZ;
        this.m_LWall = new Model3DCubeWall(this, identObj, null, point3d, point3d2, blArray, this.m_bColorAutoshading);
        this.m_LWall.calcGrids();
        point3d.x = this.m_fCubeWallThickX;
        point3d2.x = this.m_fCubeSizeX - this.m_fCubeWallThickX;
        point3d2.z = this.m_fCubeWallThickZ;
        identObj = new IdentObj(516);
        blArray[1][0] = this.m_bGrid3DRightWallDisplayX;
        blArray[1][1] = this.m_bGrid3DRightWallDisplayY;
        blArray[1][2] = false;
        this.m_RWall = new Model3DCubeWall(this, identObj, null, point3d, point3d2, blArray, this.m_bColorAutoshading);
        this.m_RWall.calcGrids();
    }

    public void define3DMatrixObjects() {
        double d;
        double d2;
        double d3;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator(false);
        BlackBoxIF blackBoxIF = null;
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        this.m_objectList = !this.m_bSafeAngle ? new Vector(this.m_nSeries * this.m_nGroups) : null;
        point3d.y = this.m_bRiserScaleFromZero ? this.m_Y1Axis.getValueCoord(0.0) : this.m_Y1Axis.getBaseCoord();
        boolean[][] blArray = new boolean[2][3];
        blArray[0][0] = false;
        blArray[0][1] = false;
        blArray[0][2] = false;
        blArray[1][0] = this.m_bGrid3DRiserDisplayX;
        blArray[1][1] = this.m_bGrid3DRiserDisplayY;
        blArray[1][2] = this.m_bGrid3DRiserDisplayZ;
        double d4 = d3 = this.m_O2Axis.getHighCoord(0, 0) - this.m_O2Axis.getLowCoord(0, 0);
        double d5 = d2 = this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0);
        double d6 = d = d3 < d2 ? d3 : d2;
        if (this.m_bRiserSquareRisers) {
            d3 = d2 = d;
        }
        while (seriesEnumerator.hasMoreElements()) {
            int n;
            int n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            if (this.m_nEffColorMode == 1) {
                blackBoxIF = this.assignSeriesColor(n2, 0);
            }
            PfjAssert.pfjAssert((n = seriesEnumerator.getRelativeSeries(n2)) >= 0 && n < this.m_nSeries);
            point3d.x = this.m_O2Axis.getLowCoord(0, n);
            point3d2.x = d3;
            if (this.m_bRiserSquareRisers && d4 != d) {
                point3d.x += (d4 - d) / (double)2;
            }
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                BlackBoxIF blackBoxIF2;
                int n3 = groupsEnumerator.nextGroup();
                int n4 = groupsEnumerator.getRelativeGroup(n3);
                if (!this.m_dataOK[n2][n3]) continue;
                point3d.z = this.m_O1Axis.getLowCoord(0, n4);
                point3d2.z = d2;
                if (this.m_bRiserSquareRisers && d5 != d) {
                    point3d.z += (d5 - d) / (double)2;
                }
                point3d2.y = (double)this.m_numYCoords[n2][n3] - point3d.y;
                IdentObj identObj = new IdentObj(517, n2, n3);
                if (this.m_nEffColorMode != 1) {
                    blackBoxIF = this.assignSeriesColor(n2, n3);
                }
                if ((blackBoxIF2 = this.getMissingDataBlackBox(n2, n3)) == null) {
                    blackBoxIF2 = blackBoxIF;
                }
                this.defineRiserObject(seriesEnumerator, groupsEnumerator, identObj, blackBoxIF2, point3d, point3d2, blArray);
            }
        }
    }

    public void defineFast3DMatrixObjects() {
        double d;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator(false);
        int n = seriesEnumerator.getFirstSeries();
        int n2 = seriesEnumerator.getLastSeries();
        int n3 = groupsEnumerator.getFirstGroup();
        int n4 = groupsEnumerator.getLastGroup();
        double d2 = this.m_Y1Axis.getMinValue();
        double d3 = this.m_Y1Axis.getMaxValue();
        double d4 = this.m_Y1Axis.getMinCoord();
        double d5 = this.m_Y1Axis.getMaxCoord();
        double d6 = this.m_O2Axis.getHighCoord(0, 0) - this.m_O2Axis.getLowCoord(0, 0);
        double d7 = this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0);
        double d8 = d6;
        double d9 = d7;
        double d10 = d = d6 < d7 ? d6 : d7;
        if (this.m_bRiserSquareRisers) {
            d6 = d7 = d;
        }
        Point3d point3d = new Point3d(d6, d5 - d4, d7);
        double d11 = this.m_O2Axis.getLowCoord(0, n);
        double d12 = this.m_O2Axis.getLowCoord(0, n2);
        double d13 = this.m_O1Axis.getLowCoord(0, n4);
        double d14 = this.m_O1Axis.getLowCoord(0, n3);
        if (this.m_bRiserSquareRisers && d8 != d) {
            d11 += (d8 - d) / (double)2;
            d12 += (d8 - d) / (double)2;
        }
        if (this.m_bRiserSquareRisers && d9 != d) {
            d13 += (d9 - d) / (double)2;
            d14 += (d9 - d) / (double)2;
        }
        Point3d point3d2 = new Point3d(d11, d4, d13);
        Point3d point3d3 = new Point3d(d12, d4, d13);
        Point3d point3d4 = new Point3d(d11, d4, d14);
        Point3d point3d5 = new Point3d(d12, d4, d14);
        IdentObj identObj = new IdentObj(517, n, n4);
        Model3DRectSolid model3DRectSolid = new Model3DRectSolid(this, identObj, null, point3d2, point3d, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        identObj = new IdentObj(517, n2, n4);
        Model3DRectSolid model3DRectSolid2 = new Model3DRectSolid(this, identObj, null, point3d3, point3d, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        identObj = new IdentObj(517, n, n3);
        Model3DRectSolid model3DRectSolid3 = new Model3DRectSolid(this, identObj, null, point3d4, point3d, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        identObj = new IdentObj(517, n2, n3);
        Model3DRectSolid model3DRectSolid4 = new Model3DRectSolid(this, identObj, null, point3d5, point3d, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        model3DRectSolid.transformVertices();
        model3DRectSolid2.transformVertices();
        model3DRectSolid3.transformVertices();
        model3DRectSolid4.transformVertices();
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        double[] dArray3 = new double[8];
        double[] dArray4 = new double[8];
        double[] dArray5 = new double[8];
        double[] dArray6 = new double[8];
        double[] dArray7 = new double[8];
        double[] dArray8 = new double[8];
        model3DRectSolid.projectVerticesInDouble(dArray, dArray2);
        model3DRectSolid2.projectVerticesInDouble(dArray3, dArray4);
        model3DRectSolid3.projectVerticesInDouble(dArray5, dArray6);
        model3DRectSolid4.projectVerticesInDouble(dArray7, dArray8);
        BlackBoxIF blackBoxIF = null;
        double[] dArray9 = new double[8];
        double[] dArray10 = new double[8];
        double[] dArray11 = new double[8];
        double[] dArray12 = new double[8];
        double[] dArray13 = new double[8];
        double[] dArray14 = new double[8];
        double[] dArray15 = new double[8];
        double[] dArray16 = new double[8];
        double[] dArray17 = new double[8];
        double[] dArray18 = new double[8];
        int n5 = 0;
        while (n5 < this.m_nSeries) {
            int n6 = seriesEnumerator.seriesAt(n5);
            PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalSeries);
            if (this.m_nEffColorMode == 1) {
                blackBoxIF = this.assignSeriesColor(n6, 0);
            }
            int n7 = 0;
            while (n7 < 8) {
                dArray9[n7] = dArray[n7] + (double)n5 * (dArray3[n7] - dArray[n7]) / (double)(this.m_nSeries - 1);
                dArray10[n7] = dArray2[n7] + (double)n5 * (dArray4[n7] - dArray2[n7]) / (double)(this.m_nSeries - 1);
                dArray11[n7] = dArray5[n7] + (double)n5 * (dArray7[n7] - dArray5[n7]) / (double)(this.m_nSeries - 1);
                dArray12[n7] = dArray6[n7] + (double)n5 * (dArray8[n7] - dArray6[n7]) / (double)(this.m_nSeries - 1);
                dArray13[n7] = (dArray11[n7] - dArray9[n7]) / (double)(this.m_nGroups - 1);
                dArray14[n7] = (dArray12[n7] - dArray10[n7]) / (double)(this.m_nGroups - 1);
                ++n7;
            }
            int n8 = 0;
            while (n8 < this.m_nGroups) {
                int n9 = groupsEnumerator.groupAt(n8);
                PfjAssert.pfjAssert(n9 >= 0 && n9 < this.m_nTotalGroups);
                if (this.m_dataOK[n6][n9]) {
                    BlackBoxIF blackBoxIF2;
                    n7 = 0;
                    while (n7 < 8) {
                        dArray15[n7] = dArray9[n7] + (double)n8 * dArray13[n7];
                        dArray16[n7] = dArray10[n7] + (double)n8 * dArray14[n7];
                        dArray17[n7] = dArray15[n7];
                        dArray18[n7] = dArray16[n7];
                        ++n7;
                    }
                    double d15 = this.m_rawValues[n6][n9];
                    double d16 = d2;
                    double d17 = d15;
                    double d18 = (d17 - d2) / (d3 - d2);
                    dArray17[2] = dArray17[1] + d18 * (dArray17[2] - dArray17[1]);
                    dArray18[2] = dArray18[1] + d18 * (dArray18[2] - dArray18[1]);
                    dArray17[3] = dArray17[0] + d18 * (dArray17[3] - dArray17[0]);
                    dArray18[3] = dArray18[0] + d18 * (dArray18[3] - dArray18[0]);
                    dArray17[6] = dArray17[5] + d18 * (dArray17[6] - dArray17[5]);
                    dArray18[6] = dArray18[5] + d18 * (dArray18[6] - dArray18[5]);
                    dArray17[7] = dArray17[4] + d18 * (dArray17[7] - dArray17[4]);
                    dArray18[7] = dArray18[4] + d18 * (dArray18[7] - dArray18[4]);
                    identObj = new IdentObj(517, n6, n9);
                    if (this.m_nEffColorMode != 1) {
                        blackBoxIF = this.assignSeriesColor(n6, n9);
                    }
                    if ((blackBoxIF2 = this.getMissingDataBlackBox(n6, n9)) == null) {
                        blackBoxIF2 = blackBoxIF;
                    }
                    this.drawRiser(identObj, blackBoxIF2, dArray17, dArray18);
                }
                ++n8;
            }
            ++n5;
        }
    }

    public Model3DFlatFace defineRiserObject(SeriesEnumerator seriesEnumerator, GroupsEnumerator groupsEnumerator, IdentObj identObj, BlackBoxIF blackBoxIF, Point3d point3d, Point3d point3d2, boolean[][] blArray) {
        Model3DFlatFace model3DFlatFace = null;
        Point3d point3d3 = new Point3d(point3d);
        Point3d point3d4 = new Point3d(point3d2);
        double d = 0.0;
        int n = identObj.getSeriesID();
        int n2 = identObj.getGroupID();
        boolean bl = false;
        double d2 = this.m_numYCoords[n][n2];
        double d3 = 0.0;
        if (point3d4.y < 0.0) {
            bl = true;
            point3d3.y += point3d4.y;
            point3d4.y = -point3d4.y;
        }
        if (this.m_gt.is3DRaisedOrigin()) {
            double d4 = point3d3.y;
            d = this.m_gt.is3DConnectSeries() ? point3d4.x * (double)this.m_nRiser3DThicknessY / (double)100 : (this.m_gt.is3DConnectGroups() ? point3d4.z * (double)this.m_nRiser3DThicknessY / (double)100 : Math.max(point3d4.x, point3d4.z) * (double)this.m_nRiser3DThicknessY / (double)100);
            if (this.m_gt.is3DFloating()) {
                point3d3.y = bl ? (point3d3.y -= d / (double)2) : point3d3.y + point3d4.y - d / (double)2;
                point3d4.y = d;
                if (point3d3.y < this.m_fCubeWallThickY) {
                    point3d4.y -= this.m_fCubeWallThickY - point3d3.y;
                    point3d3.y = this.m_fCubeWallThickY;
                }
            } else {
                point3d3.y = point3d3.y + point3d4.y - d;
                if (point3d3.y < this.m_fCubeWallThickY && !this.m_gt.is3DRibbonType()) {
                    point3d3.y = this.m_fCubeWallThickY;
                }
                point3d4.y = point3d4.y + d4 - point3d3.y;
            }
        }
        if (this.m_gt.equals(0)) {
            model3DFlatFace = new Model3DRectSolid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        } else if (this.m_gt.equals(1)) {
            model3DFlatFace = new Model3DRectPyramid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers, bl);
        } else if (this.m_gt.equals(2)) {
            model3DFlatFace = new Model3DOctagonSolid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers);
        } else if (this.m_gt.equals(4)) {
            model3DFlatFace = new Model3DRectSolid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        } else if (this.m_gt.equals(5)) {
            model3DFlatFace = new Model3DRectPyramid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers, bl);
        } else if (this.m_gt.equals(6)) {
            int n3;
            if (groupsEnumerator.hasMoreElements() && this.m_dataOK[n][n3 = groupsEnumerator.peekAtNextGroup()] && (!this.m_bCubeDisplay3DFloor || d2 >= this.m_fCubeWallThickY || (double)this.m_numYCoords[n][n3] >= this.m_fCubeWallThickY)) {
                model3DFlatFace = new Model3DModRectSolid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers);
                double d5 = this.m_numYCoords[n][n3];
                boolean bl2 = this.m_O1Axis.isDescending();
                if (bl2) {
                    ((Model3DModRectSolid)model3DFlatFace).modBackFace(d5, point3d3.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
                } else {
                    ((Model3DModRectSolid)model3DFlatFace).modFrontFace(d5, point3d3.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
                }
            }
        } else if (this.m_gt.equals(7)) {
            if (groupsEnumerator.hasMoreElements()) {
                int n4 = groupsEnumerator.peekAtNextGroup();
                if (n4 == -1 || !this.m_dataOK[n][n4]) {
                    return null;
                }
                d3 = d2;
                d2 = this.m_numYCoords[n][n4];
                if (!this.m_bCubeDisplay3DFloor || d2 >= this.m_fCubeWallThickY || d3 >= this.m_fCubeWallThickY) {
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    double d14;
                    double d15;
                    int n5;
                    int n6;
                    if (!this.m_bCubeDisplay3DFloor) {
                        n6 = 0;
                        n5 = 0;
                    } else {
                        n5 = d2 - point3d4.y >= this.m_fCubeWallThickY ? 0 : (d2 >= this.m_fCubeWallThickY ? 1 : 2);
                        n6 = d3 - point3d4.y >= this.m_fCubeWallThickY ? 0 : (d3 >= this.m_fCubeWallThickY ? 1 : 2);
                    }
                    if (n5 == 0) {
                        d15 = d2 - point3d4.y;
                        d14 = d2;
                        d13 = 1.0;
                        d12 = 1.0;
                    } else if (n5 == 1) {
                        d15 = this.m_fCubeWallThickY;
                        d14 = d2;
                        d13 = 1.0;
                        d12 = 1.0;
                    } else if (n5 == 2) {
                        d15 = this.m_fCubeWallThickY;
                        d14 = this.m_fCubeWallThickY;
                        d12 = (d3 - this.m_fCubeWallThickY) / (d3 - d2);
                        d13 = n6 == 0 ? (d3 - point3d4.y - this.m_fCubeWallThickY) / (d3 - d2) : d12;
                    } else {
                        throw new AssertionException(String.valueOf(String.valueOf("oops, unknown nClipFront = ")) + n5);
                    }
                    if (n6 == 0) {
                        d11 = d3 - point3d4.y;
                        d10 = d3;
                        d9 = 0.0;
                        d8 = 0.0;
                    } else if (n6 == 1) {
                        d11 = this.m_fCubeWallThickY;
                        d10 = d3;
                        d9 = 0.0;
                        d8 = 0.0;
                    } else if (n6 == 2) {
                        d11 = this.m_fCubeWallThickY;
                        d10 = this.m_fCubeWallThickY;
                        d8 = (this.m_fCubeWallThickY - d3) / (d2 - d3);
                        d9 = n5 == 0 ? (this.m_fCubeWallThickY - (d3 - point3d4.y)) / (d2 - d3) : d8;
                    } else {
                        throw new AssertionException(String.valueOf(String.valueOf("oops, unknown nClipBack = ")) + n6);
                    }
                    if (n5 == 0 && n6 == 1) {
                        d7 = this.m_fCubeWallThickY;
                        d6 = (this.m_fCubeWallThickY - (d3 - point3d4.y)) / (d2 - d3);
                    } else if (n5 == 1 && n6 == 0) {
                        d7 = this.m_fCubeWallThickY;
                        d6 = (d3 - point3d4.y - this.m_fCubeWallThickY) / (d3 - d2);
                    } else {
                        d7 = d11;
                        d6 = d9;
                    }
                    Point3d[] point3dArray = new Point3d[]{new Point3d(point3d3.x, d15, point3d3.z + d13 * point3d4.z), new Point3d(point3d3.x + point3d4.x, d15, point3d3.z + d13 * point3d4.z), new Point3d(point3d3.x, d14, point3d3.z + d12 * point3d4.z), new Point3d(point3d3.x + point3d4.x, d14, point3d3.z + d12 * point3d4.z), new Point3d(point3d3.x, d7, point3d3.z + d6 * point3d4.z), new Point3d(point3d3.x + point3d4.x, d7, point3d3.z + d6 * point3d4.z), new Point3d(point3d3.x, d11, point3d3.z + d9 * point3d4.z), new Point3d(point3d3.x + point3d4.x, d11, point3d3.z + d9 * point3d4.z), new Point3d(point3d3.x, d10, point3d3.z + d8 * point3d4.z), new Point3d(point3d3.x + point3d4.x, d10, point3d3.z + d8 * point3d4.z)};
                    model3DFlatFace = new Model3DRibbonSeriesSolid(this, identObj, blackBoxIF, point3d3, point3d4, point3dArray, blArray, this.m_bColorAutoshadeRisers);
                }
            }
        } else if (this.m_gt.equals(9)) {
            int n7;
            if (seriesEnumerator.hasMoreElements() && this.m_dataOK[n7 = seriesEnumerator.peekAtNextSeries()][n2] && (!this.m_bCubeDisplay3DFloor || d2 >= this.m_fCubeWallThickY || (double)this.m_numYCoords[n7][n2] >= this.m_fCubeWallThickY)) {
                model3DFlatFace = new Model3DModRectSolid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers);
                double d16 = this.m_numYCoords[n7][n2];
                ((Model3DModRectSolid)model3DFlatFace).modRightFace(d16, point3d3.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
            }
        } else if (this.m_gt.equals(10)) {
            if (seriesEnumerator.hasMoreElements()) {
                int n8 = seriesEnumerator.peekAtNextSeries();
                if (n8 == -1 || !this.m_dataOK[n8][n2]) {
                    return null;
                }
                d3 = this.m_numYCoords[n8][n2];
                if (!this.m_bCubeDisplay3DFloor || d2 >= this.m_fCubeWallThickY || d3 >= this.m_fCubeWallThickY) {
                    double d17;
                    double d18;
                    double d19;
                    double d20;
                    double d21;
                    double d22;
                    double d23;
                    double d24;
                    double d25;
                    double d26;
                    int n9;
                    int n10;
                    if (!this.m_bCubeDisplay3DFloor) {
                        n10 = 0;
                        n9 = 0;
                    } else {
                        n10 = d2 - point3d4.y >= this.m_fCubeWallThickY ? 0 : (d2 >= this.m_fCubeWallThickY ? 1 : 2);
                        n9 = d3 - point3d4.y >= this.m_fCubeWallThickY ? 0 : (d3 >= this.m_fCubeWallThickY ? 1 : 2);
                    }
                    if (n10 == 0) {
                        d26 = d2 - point3d4.y;
                        d25 = d2;
                        d24 = 0.0;
                        d23 = 0.0;
                    } else if (n10 == 1) {
                        d26 = this.m_fCubeWallThickY;
                        d25 = d2;
                        d24 = 0.0;
                        d23 = 0.0;
                    } else if (n10 == 2) {
                        d26 = this.m_fCubeWallThickY;
                        d25 = this.m_fCubeWallThickY;
                        d23 = (this.m_fCubeWallThickY - d2) / (d3 - d2);
                        d24 = n9 == 0 ? (this.m_fCubeWallThickY - (d2 - point3d4.y)) / (d3 - d2) : d23;
                    } else {
                        throw new AssertionException(String.valueOf(String.valueOf("oops, unknown nClipBack = ")) + n10);
                    }
                    if (n9 == 0) {
                        d22 = d3 - point3d4.y;
                        d21 = d3;
                        d20 = 1.0;
                        d19 = 1.0;
                    } else if (n9 == 1) {
                        d22 = this.m_fCubeWallThickY;
                        d21 = d3;
                        d20 = 1.0;
                        d19 = 1.0;
                    } else if (n9 == 2) {
                        d22 = this.m_fCubeWallThickY;
                        d21 = this.m_fCubeWallThickY;
                        d19 = (d2 - this.m_fCubeWallThickY) / (d2 - d3);
                        d20 = n10 == 0 ? (d2 - point3d4.y - this.m_fCubeWallThickY) / (d2 - d3) : d19;
                    } else {
                        throw new AssertionException(String.valueOf(String.valueOf("oops, unknown nClipFront = ")) + n9);
                    }
                    if (n9 == 0 && n10 == 1) {
                        d18 = this.m_fCubeWallThickY;
                        d17 = (this.m_fCubeWallThickY - (d3 - point3d4.y)) / (d2 - d3);
                        d17 = 1.0 - d17;
                    } else if (n9 == 1 && n10 == 0) {
                        d18 = this.m_fCubeWallThickY;
                        d17 = (d3 - point3d4.y - this.m_fCubeWallThickY) / (d3 - d2);
                        d17 = 1.0 - d17;
                    } else {
                        d18 = d22;
                        d17 = d20;
                    }
                    Point3d[] point3dArray = new Point3d[]{new Point3d(point3d3.x + d24 * point3d4.x, d26, point3d3.z), new Point3d(point3d3.x + d24 * point3d4.x, d26, point3d3.z + point3d4.z), new Point3d(point3d3.x + d23 * point3d4.x, d25, point3d3.z), new Point3d(point3d3.x + d23 * point3d4.x, d25, point3d3.z + point3d4.z), new Point3d(point3d3.x + d17 * point3d4.x, d18, point3d3.z), new Point3d(point3d3.x + d17 * point3d4.x, d18, point3d3.z + point3d4.z), new Point3d(point3d3.x + d20 * point3d4.x, d22, point3d3.z), new Point3d(point3d3.x + d20 * point3d4.x, d22, point3d3.z + point3d4.z), new Point3d(point3d3.x + d19 * point3d4.x, d21, point3d3.z), new Point3d(point3d3.x + d19 * point3d4.x, d21, point3d3.z + point3d4.z)};
                    model3DFlatFace = new Model3DRibbonGroupSolid(this, identObj, blackBoxIF, point3d3, point3d4, point3dArray, blArray, this.m_bColorAutoshadeRisers);
                }
            }
        } else {
            model3DFlatFace = new Model3DRectSolid(this, identObj, blackBoxIF, point3d3, point3d4, blArray, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        }
        if (model3DFlatFace != null) {
            model3DFlatFace.calcGrids();
        }
        if (model3DFlatFace != null) {
            if (this.m_bSafeAngle) {
                model3DFlatFace.display();
            } else {
                this.m_objectList.addElement(model3DFlatFace);
            }
        }
        return model3DFlatFace;
    }

    protected double denormalize(double d, double d2, double d3, double d4, double d5) {
        if (d < d2) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to minimum (" + d2 + ")", null);
            d = d2;
        } else if (d > d3) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to maximum (" + d3 + ")", null);
            d = d3;
        }
        double d6 = d5 + d4 * d;
        return d6;
    }

    protected double denormalizeGeom(double d, double d2, double d3, double d4, double d5) {
        if (d < d2) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to minimum (" + d2 + ")", null);
            d = d2;
        } else if (d > d3) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to maximum (" + d3 + ")", null);
            d = d3;
        }
        double d6 = Math.pow(d4, d) * d5;
        return d6;
    }

    public void displayAll3DObjects() {
        PfjAssert.pfjAssert(!this.m_bSafeAngle && this.m_objectList != null);
        this.m_Floor.preDisplay();
        this.m_LWall.preDisplay();
        this.m_RWall.preDisplay();
        int n = this.m_objectList.size();
        int n2 = 0;
        while (n2 < n) {
            Model3DFlatFace model3DFlatFace = (Model3DFlatFace)this.m_objectList.elementAt(n2);
            model3DFlatFace.display();
            ++n2;
        }
        this.m_RWall.postDisplay();
        this.m_LWall.postDisplay();
        this.m_Floor.postDisplay();
    }

    public void drawRiser(IdentObj identObj, BlackBoxIF blackBoxIF, double[] dArray, double[] dArray2) {
        Polygon polygon = new Polygon();
        int n = (int)dArray[0];
        int n2 = (int)dArray2[0];
        int n3 = (int)dArray[1];
        int n4 = (int)dArray2[1];
        int n5 = (int)dArray[2];
        int n6 = (int)dArray2[2];
        int n7 = (int)dArray[3];
        int n8 = (int)dArray2[3];
        int n9 = (int)dArray[6];
        int n10 = (int)dArray2[6];
        polygon.addPoint(n, n2);
        polygon.addPoint(n3, n4);
        polygon.addPoint(n5, n6);
        polygon.addPoint(n7, n8);
        polygon.addPoint(n, n2);
        new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, null, 1.0, true);
        polygon = new Polygon();
        polygon.addPoint(n7, n8);
        polygon.addPoint(n5, n6);
        polygon.addPoint(n9, n10);
        polygon.addPoint((int)dArray[7], (int)dArray2[7]);
        polygon.addPoint(n7, n8);
        IdentObj identObj2 = new IdentObj(identObj);
        identObj2.incrMiscID(2);
        new DetPolygon(this.m_Detectiv, identObj2, polygon, blackBoxIF, null, 1.0, true);
        polygon = new Polygon();
        polygon.addPoint(n3, n4);
        polygon.addPoint((int)dArray[5], (int)dArray2[5]);
        polygon.addPoint(n9, n10);
        polygon.addPoint(n5, n6);
        polygon.addPoint(n3, n4);
        identObj2 = new IdentObj(identObj);
        identObj2.incrMiscID(4);
        new DetPolygon(this.m_Detectiv, identObj2, polygon, blackBoxIF, null, 1.0, true);
    }

    public void drawWireframe() {
        int n;
        Point3d point3d = new Point3d();
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        if (this.m_bAlreadyDrawn) {
            graphics.setXORMode(Color.yellow);
            n = 0;
            while (n < 21) {
                this.drawWireframeLine(graphics, this.m_wirePts2D[m_Connect[n][0]], this.m_wirePts2D[m_Connect[n][1]]);
                ++n;
            }
            graphics.setPaintMode();
        }
        double d = this.getMinCubeViewerZ();
        if (this.m_bViewRawViewerZ) {
            this.m_fViewViewerZ += d;
            this.m_bViewRawViewerZ = false;
        }
        this.setWireframePoints();
        n = 0;
        while (n < 17) {
            point3d.copy(this.m_wirePts3D[n]);
            this.transformPoint3d(point3d);
            this.m_wirePts2D[n] = this.projectPoint3d(point3d);
            ++n;
        }
        graphics.setXORMode(Color.yellow);
        n = 0;
        while (n < 21) {
            this.drawWireframeLine(graphics, this.m_wirePts2D[m_Connect[n][0]], this.m_wirePts2D[m_Connect[n][1]]);
            ++n;
        }
        graphics.setPaintMode();
        graphics.dispose();
        this.m_bAlreadyDrawn = true;
    }

    public void drawWireframeLine(Graphics graphics, Point point, Point point2) {
        Point point3 = new Point(point.x, point.y);
        Point point4 = new Point(point2.x, point2.y);
        point3 = this.m_Perspective.m_VC.virtToDest(point3);
        point4 = this.m_Perspective.m_VC.virtToDest(point4);
        graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
    }

    protected MinMaxObj findLimits(int n, int n2, boolean bl) {
        MinMaxObj minMaxObj = this.findPreScaledLimits(n, n2, bl);
        if (minMaxObj != null) {
            return minMaxObj;
        }
        minMaxObj = new MinMaxObj(bl);
        if (n2 == 1) {
            int n3 = 0;
            while (n3 < this.m_nTotalSeries) {
                int n4 = 0;
                while (n4 < this.m_nTotalGroups) {
                    DatumObj datumObj = this.getDataValue(n3, n4, DataItem.DI_GENERAL);
                    double d = datumObj.m_fValue;
                    if (!(!datumObj.m_bOK || this.m_bY1LogScale && d <= 0.0)) {
                        minMaxObj.testRawValue(d);
                    }
                    ++n4;
                }
                ++n3;
            }
        } else {
            throw new AssertionException(1, 1, n2);
        }
        return minMaxObj;
    }

    public void focusCube(double d) {
        double d2;
        Matrix4d matrix4d = this.getMatrix();
        double d3 = this.m_fViewFocusFactor;
        if (matrix4d == null) {
            return;
        }
        double d4 = this.getMinCubeViewerZ();
        if (this.m_bViewRawViewerZ) {
            this.m_fViewViewerZ += d4;
            this.m_bViewRawViewerZ = false;
        }
        if ((d2 = this.m_fViewViewerZ * d) >= d4 && d2 <= d4 + (double)50000) {
            matrix4d.m32 *= d;
            double d5 = d * d3;
            this.m_Perspective.setCubeFocusFactor(this.normalizeGeom(d5, 0.0, 100.0, 1.011778466, 0.556837407));
            this.m_Perspective.setCubeViewerZ(this.normalize(d2 - d4, 0.0, 100.0, 500.0, 0.0));
        }
    }

    public Axis3DObj getAxisObj(int n) {
        switch (n) {
            case 0: {
                return this.m_O2Axis;
            }
            case 2: {
                return this.m_O1Axis;
            }
            case 1: {
                return this.m_Y1Axis;
            }
        }
        throw new AssertionException("Invalid Parameter passed !");
    }

    public BlackBoxIF getModelBlackBox(IdentObj identObj) {
        BlackBoxIF blackBoxIF;
        int n = identObj.getSeriesID();
        int n2 = identObj.getGroupID();
        boolean bl = this.m_Perspective.getExactColorByHeight();
        if (this instanceof JChart_3D_Surf && this.m_Perspective.isColorByHeight() && n != -3) {
            int n3 = this.getYCoordForHeight(n, n2);
            double d = this.getValueFromCoord(n3);
            if (!bl) {
                Vector vector = this.m_Y1Axis.getNumericLabelsAsDouble();
                int n4 = vector.size();
                double d2 = d;
                PfjAssert.pfjAssert(n4 > 1);
                boolean bl2 = false;
                int n5 = 1;
                while (n5 < n4 && !bl2) {
                    double d3;
                    double d4 = (Double)vector.elementAt(n5 - 1);
                    double d5 = (d4 + (d3 = ((Double)vector.elementAt(n5)).doubleValue())) / (double)2;
                    if (d < d5) {
                        d = d4;
                        bl2 = true;
                    }
                    ++n5;
                }
                if (!bl2) {
                    d = (Double)vector.elementAt(n4 - 1);
                }
            }
            double d6 = this.m_Y1Axis.getValueRelCoord(d);
            blackBoxIF = this.getBlackBox(identObj, d6);
        } else {
            blackBoxIF = this.getBlackBox(identObj);
        }
        return blackBoxIF;
    }

    protected int getYCoordForHeight(int n, int n2) {
        int n3 = 0;
        if (this.m_dataOK[n][n2]) {
            n3 = this.m_numYCoords[n][n2];
        }
        return n3;
    }

    public Point3d getCubeSize() {
        return new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
    }

    public double getCubeWallThickY() {
        return this.m_fCubeWallThickY;
    }

    public Access getDataAccess() {
        return this.m_Access;
    }

    public IdentObj getMajorGridId(int n) {
        return this.getAxisObj(n).getMajorGridId();
    }

    public Vector getMajorGridPositions(int n) {
        return this.getAxisObj(n).getMajorGridPositions();
    }

    public BlackBoxIF getMajorGridsBlackBox(int n) {
        return this.getAxisObj(n).getMajorGridBlackBox();
    }

    public Matrix4d getMatrix() {
        return this.m_matrix;
    }

    public double getMinCubeViewerZ() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
        boolean[][] blArray = new boolean[2][3];
        blArray[0][0] = false;
        blArray[0][1] = false;
        blArray[0][2] = false;
        blArray[1][0] = false;
        blArray[1][1] = false;
        blArray[1][2] = false;
        Model3DRectSolid model3DRectSolid = new Model3DRectSolid(this, null, null, point3d, point3d2, blArray, false, false);
        double d = model3DRectSolid.getMinZ();
        return d + (double)2000;
    }

    public IdentObj getMinorGridId(int n) {
        return this.getAxisObj(n).getMinorGridId();
    }

    public Vector getMinorGridPositions(int n) {
        return this.getAxisObj(n).getMinorGridPositions();
    }

    public BlackBoxIF getMinorGridsBlackBox(int n) {
        return this.getAxisObj(n).getMinorGridBlackBox();
    }

    public double getPanX() {
        return this.m_fViewPanX;
    }

    public double getPanY() {
        return this.m_fViewPanY;
    }

    public Perspective getPerspective() {
        return this.m_Perspective;
    }

    public double getQuantizedDataValue(int n, int n2, DataItem dataItem) {
        double d = this.getDataValue((int)n, (int)n2, (DataItem)dataItem).m_fValue;
        boolean bl = this.m_Perspective.getExactColorByHeight();
        if (!bl) {
            Vector vector = this.m_Y1Axis.getNumericLabelsAsDouble();
            int n3 = vector.size();
            PfjAssert.pfjAssert(n3 > 1);
            boolean bl2 = false;
            int n4 = 1;
            while (n4 < n3 && !bl2) {
                double d2;
                double d3 = (Double)vector.elementAt(n4 - 1);
                double d4 = (d3 + (d2 = ((Double)vector.elementAt(n4)).doubleValue())) / (double)2;
                if (d < d4) {
                    d = d3;
                    bl2 = true;
                }
                ++n4;
            }
            if (!bl2) {
                d = (Double)vector.elementAt(n3 - 1);
            }
        }
        return d;
    }

    public Point3d getViewer() {
        return new Point3d(this.m_fViewViewerX, this.m_fViewViewerY, this.m_fViewViewerZ);
    }

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_O1Axis = null;
        this.m_O2Axis = null;
        this.m_Y1Axis = null;
        this.m_bAlreadyDrawn = false;
        this.m_bChangedColor = true;
        this.m_bChangedCube = true;
        this.m_bChangedGrid = true;
        this.m_bChangedRiser = true;
        this.m_bChangedScale = true;
        this.m_bChangedView = true;
        this.m_bNoWireframeYet = true;
        this.m_bViewRawViewerZ = true;
        this.copyParams();
        this.createMatrix();
    }

    public boolean isSafeAngle() {
        return this.m_bSafeAngle;
    }

    public boolean isAxisVisible(int n, int n2) {
        return true;
    }

    protected double normalize(double d, double d2, double d3, double d4, double d5) {
        double d6;
        TDGErrorManager tDGErrorManager;
        double d7 = d2 * d4 + d5;
        double d8 = d3 * d4 + d5;
        if (d < d7) {
            tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to minimum (" + d7 + ")", null);
            d = d7;
        } else if (d > d8) {
            tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to maximum (" + d8 + ")", null);
            d = d8;
        }
        PfjAssert.pfjAssert(d4 != 0.0);
        if (d4 == 0.0) {
            double d9 = (d2 + d3) / 2.0;
            tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: bad factor, property value (")) + d + ") set to median (" + d9 + ")", null);
            d6 = d9;
        } else {
            d6 = (d - d5) / d4;
        }
        return d6;
    }

    protected double normalizeGeom(double d, double d2, double d3, double d4, double d5) {
        double d6;
        TDGErrorManager tDGErrorManager;
        double d7 = Math.pow(d4, d2) * d5;
        double d8 = Math.pow(d4, d3) * d5;
        if (d < d7) {
            tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to minimum (" + d7 + ")", null);
            d = d7;
        } else if (d > d8) {
            tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: property value (")) + d + ") set to maximum (" + d8 + ")", null);
            d = d8;
        }
        PfjAssert.pfjAssert(d4 != 0.0);
        PfjAssert.pfjAssert(d5 != 0.0);
        if (d5 == 0.0 || d4 == 0.0) {
            double d9 = (d2 + d3) / 2.0;
            tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, String.valueOf(String.valueOf("WARNING: bad base or multiplier, property value (")) + d + ") set to median (" + d9 + ")", null);
            d6 = d9;
        } else {
            d6 = Math.log(d / d5) / Math.log(d4);
        }
        return d6;
    }

    public Point projectPoint3d(Point3d point3d) {
        double d;
        double d2;
        double d3 = this.m_fViewViewerZ - point3d.z;
        if (this.m_bViewForceIsometric) {
            d2 = point3d.x - this.m_fViewViewerX;
            d = point3d.y - this.m_fViewViewerY;
        } else if (d3 == 0.0) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d2 = (point3d.x - this.m_fViewViewerX) * (this.m_fViewViewerZ / d3);
            d = (point3d.y - this.m_fViewViewerY) * (this.m_fViewViewerZ / d3);
        }
        return new Point((int)(d2 += this.m_fViewPanX), (int)(d += this.m_fViewPanY));
    }

    public Point2D projectPoint3dInDouble(Point3d point3d) {
        double d;
        double d2;
        double d3 = this.m_fViewViewerZ - point3d.z;
        if (this.m_bViewForceIsometric) {
            d2 = point3d.x - this.m_fViewViewerX;
            d = point3d.y - this.m_fViewViewerY;
        } else if (d3 == 0.0) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d2 = (point3d.x - this.m_fViewViewerX) * (this.m_fViewViewerZ / d3);
            d = (point3d.y - this.m_fViewViewerY) * (this.m_fViewViewerZ / d3);
        }
        return new Point2D.Double(d2 += this.m_fViewPanX, d += this.m_fViewPanY);
    }

    public void releaseReferences() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.releaseReferences();
        }
        if (this.m_O2Axis != null) {
            this.m_O2Axis.releaseReferences();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public void rotateCubeX(double d) {
        Matrix4d matrix4d = this.getMatrix();
        if (matrix4d == null) {
            return;
        }
        Point3d point3d = this.centerGraph(matrix4d);
        Matrix4d matrix4d2 = new Matrix4d(0, d * (Math.PI / 180));
        matrix4d.mult(matrix4d2);
        matrix4d.translate(point3d.x, point3d.y, point3d.z);
    }

    public void rotateCubeY(double d) {
        Matrix4d matrix4d = this.getMatrix();
        if (matrix4d == null) {
            return;
        }
        Point3d point3d = this.centerGraph(matrix4d);
        Matrix4d matrix4d2 = new Matrix4d(1, d * (Math.PI / 180));
        matrix4d.mult(matrix4d2);
        matrix4d.translate(point3d.x, point3d.y, point3d.z);
    }

    public void rotateCubeZ(double d) {
        Matrix4d matrix4d = this.getMatrix();
        if (matrix4d == null) {
            return;
        }
        Point3d point3d = this.centerGraph(matrix4d);
        Matrix4d matrix4d2 = new Matrix4d(2, d * (Math.PI / 180));
        matrix4d.mult(matrix4d2);
        matrix4d.translate(point3d.x, point3d.y, point3d.z);
    }

    public void scaleCube(double d) {
        Matrix4d matrix4d = this.getMatrix();
        if (matrix4d == null) {
            return;
        }
        double d2 = this.m_fViewZoomFactor;
        double d3 = d2 * d;
        if (d3 >= 0.25 && d3 <= 4.0) {
            matrix4d.scale(d);
            this.m_Perspective.setCubeZoomFactor(this.normalizeGeom(d3, 0.0, 100.0, 1.028113827, 0.25));
        }
    }

    public void setDrawOrder() {
        this.m_Floor.calcDisplayWhen(this.m_bCubeDisplay3DFloor, 2);
        this.m_LWall.calcDisplayWhen(this.m_bCubeDisplay3DLeftWall, 4);
        this.m_RWall.calcDisplayWhen(this.m_bCubeDisplay3DRightWall, 0);
    }

    public void setPanX(double d) {
        this.m_fViewPanX = d;
    }

    public void setPanY(double d) {
        this.m_fViewPanY = d;
    }

    public void setWireframePoints() {
        this.m_wirePts3D[0].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[0].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[0].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[1].x = this.m_fCubeSizeX;
        this.m_wirePts3D[1].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[1].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[2].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[2].y = this.m_fCubeSizeY;
        this.m_wirePts3D[2].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[3].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[3].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[3].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[7].x = this.m_fCubeSizeX;
        this.m_wirePts3D[7].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[7].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[8].x = this.m_fCubeSizeX;
        this.m_wirePts3D[8].y = this.m_fCubeSizeY;
        this.m_wirePts3D[8].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[9].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[9].y = this.m_fCubeSizeY;
        this.m_wirePts3D[9].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[11].x = this.m_fCubeSizeX;
        this.m_wirePts3D[12].x = this.m_fCubeSizeX;
        this.m_wirePts3D[12].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[13].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[14].y = this.m_fCubeSizeY;
        this.m_wirePts3D[15].x = this.m_fCubeSizeX;
        this.m_wirePts3D[15].y = this.m_fCubeSizeY;
        this.m_wirePts3D[16].y = this.m_fCubeSizeY;
        this.m_wirePts3D[16].z = this.m_fCubeSizeZ;
    }

    public void sort3DObjects() {
        PfjAssert.pfjAssert(!this.m_bSafeAngle && this.m_objectList != null);
        QSortAlgorithm qSortAlgorithm = new QSortAlgorithm();
        Point3d point3d = new Point3d(this.m_fViewViewerX, this.m_fViewViewerY, this.m_fViewViewerZ);
        int n = this.m_objectList.size();
        int n2 = 0;
        while (n2 < n) {
            Model3DFlatFace model3DFlatFace = (Model3DFlatFace)this.m_objectList.elementAt(n2);
            model3DFlatFace.calcDistance(this.m_matrix, point3d);
            ++n2;
        }
        qSortAlgorithm.sortDistance(this.m_objectList, point3d);
    }

    public void transformPoint3d(Point3d point3d) {
        double d = point3d.x;
        double d2 = point3d.y;
        double d3 = point3d.z;
        point3d.x = d * this.m_matrix.m00 + d2 * this.m_matrix.m10 + d3 * this.m_matrix.m20 + this.m_matrix.m30;
        point3d.y = d * this.m_matrix.m01 + d2 * this.m_matrix.m11 + d3 * this.m_matrix.m21 + this.m_matrix.m31;
        point3d.z = d * this.m_matrix.m02 + d2 * this.m_matrix.m12 + d3 * this.m_matrix.m22 + this.m_matrix.m32;
    }

    public void translateCube(double d, double d2, double d3) {
        Matrix4d matrix4d = this.getMatrix();
        if (matrix4d == null) {
            return;
        }
        matrix4d.translate(d, d2, d3);
    }

    public void updateViewParams() {
        this.copyCubeParams();
        this.copyViewParams();
    }

    public void updateParamsFromMatrix() {
        Matrix4d matrix4d = new Matrix4d(this.getMatrix());
        double d = this.m_fViewZoomFactor;
        if (d == 0.0) {
            return;
        }
        matrix4d.scale(1.0 / d);
        Matrix3d matrix3d = matrix4d.getMatrix3d();
        this.m_Perspective.setCubeRotationMatrix(matrix3d);
        this.m_Perspective.setCubeTranslationX(this.normalize(matrix4d.m30, 0.0, 100.0, 200.0, -10000.0));
        this.m_Perspective.setCubeTranslationY(this.normalize(matrix4d.m31, 0.0, 100.0, 200.0, -10000.0));
        this.m_Perspective.setCubeTranslationZ(this.normalize(matrix4d.m32, 0.0, 100.0, 200.0, -10000.0));
    }

    public boolean wantLegend() {
        return false;
    }

    public double getValueFromCoord(int n) {
        return this.m_Y1Axis.getValueFromCoord(n);
    }

    private Rectangle getWallBounds(Model3DCubeWall model3DCubeWall) {
        Rectangle rectangle = this.getPerspective().getVC().getVirtCoords();
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        Polygon polygon = model3DCubeWall.getProjectedVertices();
        int n5 = 0;
        while (n5 < polygon.npoints) {
            n = Math.min(n, polygon.xpoints[n5]);
            n2 = Math.max(n2, polygon.xpoints[n5]);
            n4 = Math.min(n4, polygon.ypoints[n5]);
            n3 = Math.max(n3, polygon.ypoints[n5]);
            ++n5;
        }
        return new Rectangle(n, n4, n2 - n, n3 - n4);
    }

    private void calculateAxisTitlePosition() {
        Rectangle rectangle = this.getWallBounds(this.m_LWall);
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        rectangle = this.getWallBounds(this.m_RWall);
        n = Math.min(n, rectangle.x);
        n2 = Math.max(n2, rectangle.x + rectangle.width);
        n3 = Math.min(n3, rectangle.y);
        n4 = Math.max(n4, rectangle.y + rectangle.height);
        rectangle = this.getWallBounds(this.m_Floor);
        n = Math.min(n, rectangle.x);
        n2 = Math.max(n2, rectangle.x + rectangle.width);
        n3 = Math.min(n3, rectangle.y);
        n4 = Math.max(n4, rectangle.y + rectangle.height);
        rectangle = new Rectangle(n, n3, n2 - n, n4 - n3);
        rectangle.grow(2000, 2000);
        this.m_O1Axis.setTitleRect(rectangle);
        this.m_O2Axis.setTitleRect(rectangle);
        this.m_Y1Axis.setTitleRect(rectangle);
    }
}

