/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.AxisSplits;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataTextPosition;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.Line;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.ZoomState;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.Polyline;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.SVD;

public abstract class JChart_2D_Standard
extends JChart_2D {
    static final CategoryIF LOG = Perspective.getInstance("ENGINE.JChart.2D_Standard");
    public static final int NO_PREVIOUS_SERIES = -2;
    static final int TWOD_MARKER_FIXUP = 3;
    RelativeAxisObj m_O1Axis;
    RelativeAxisObj m_X1Axis;
    RelativeAxisObj m_Y1Axis;
    RelativeAxisObj m_Y2Axis;
    RelativeAxisObj m_Z1Axis;
    RelativeAxisObj m_Y3Axis;
    RelativeAxisObj m_Y4Axis;
    RelativeAxisObj m_Y5Axis;
    int m_scaling;
    int[][] m_ordCoords;
    int m_barThickCoord;
    int[][] m_numXCoords;
    int[][] m_numYCoords;
    boolean[][] m_dataOK;
    String[][] m_DataLabel;
    boolean m_bDataTextDisplay;
    boolean m_bHorz;
    boolean m_bExtendToFrameEdge;
    boolean m_bIsThisAComboWithBar;
    boolean m_bSquareMarkers;
    boolean m_bMarkerDisplay;
    boolean m_bAllMarkersSameSize;
    int m_nMarkerSizeDefault;
    double[][] m_fStackedCumulativeValues;
    double[][] m_fPercentCumulativeValues;
    SeriesEnumerator m_sEnumReverseForPrev;
    int[][] m_nParetoYCoordsVC;
    int[][] m_nParetoCoordsVC;
    int[] m_nMaxParetoYCoords;
    int[] m_nPercentParetoValues;
    double[] m_fMaxParetoActuals;
    double[] m_fMinParetoActuals;
    double[][] m_fParetoYCoords;
    ArrayList m_bubbleMarkerInfo;
    private static Comparator m_bubbleComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            int n3;
            int n4;
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n5 = (Integer)objectArray[4];
            int n6 = n5 * (n4 = ((Integer)objectArray[5]).intValue());
            if (n6 > (n3 = (n2 = ((Integer)objectArray2[4]).intValue()) * (n = ((Integer)objectArray2[5]).intValue()))) {
                return -1;
            }
            if (n6 == n3) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object object) {
            return false;
        }
    };

    public void calc() {
        super.calc();
        this.m_positiveValY1 = false;
        this.m_negativeValY1 = false;
        this.m_zeroValY1 = false;
        this.m_nullValY1 = false;
        this.m_positiveValY2 = false;
        this.m_negativeValY2 = false;
        this.m_zeroValY2 = false;
        this.m_nullValY2 = false;
        this.m_positiveValX1 = false;
        this.m_negativeValX1 = false;
        this.m_zeroValX1 = false;
        this.m_nullValX1 = false;
        this.m_dualY = false;
        this.m_XY = false;
        this.m_dualYX = false;
        this.createAxes();
        int n = this.m_Perspective.getLineWidth(this.m_Perspective.getFrame());
        if (this.m_Frame != null && this.m_Perspective.getFrameDisplay()) {
            this.m_Frame.drawFrameBorders(n);
        }
        this.drawAxisBody();
        if (this.m_bAbsolute) {
            this.calcDataAbsolute();
        } else if (this.m_bStacked) {
            this.calcDataStacked();
        } else if (this.m_gt.isScalingPercent()) {
            this.calcDataPercent();
        } else if (this.m_gt.isScalingWaterfall()) {
            this.calcDataWaterfall();
        }
        if (this.m_Perspective.getGraphType() != 102) {
            this.fireInapropriateDataEvent();
        }
    }

    protected void calcBarOrdinalCoords() {
        SeriesEnumerator seriesEnumerator = this.m_sEnumForward;
        GroupsEnumerator groupsEnumerator = this.m_gEnumForward;
        int n = 0;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        this.m_smallMarker = this.m_Perspective.m_VC.virtToDestWidth(this.m_barThickCoord) <= 3;
        int n2 = 0;
        while (n2 < this.m_nSeries) {
            int n3 = seriesEnumerator.seriesAt(n2);
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
            int n4 = this.getAxisAssignment(n3);
            n = 0;
            if (this.m_gt.isDualY() && this.m_bStacked && n4 == 1) {
                n = 1;
            }
            int n5 = 0;
            while (n5 < this.m_nGroups) {
                int n6 = groupsEnumerator.groupAt(n5);
                PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
                this.m_ordCoords[n3][n6] = this.m_bAbsolute ? (int)this.m_O1Axis.getLowCoord(n2, n5) : (this.m_nTotalSeries > 1 ? (int)this.m_O1Axis.getLowCoord(n, n5) : (int)this.m_O1Axis.getLowCoord(n2, n5));
                ++n5;
            }
            ++n2;
        }
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        RelativeAxisObj relativeAxisObj = null;
        double d = 0.0;
        boolean bl = axisDescriptor.hasX1();
        DataFormat dataFormat = this.m_Access.getDataFormat();
        int n = dataFormat.getNumDataItems();
        boolean bl2 = this.m_gt.isScatter();
        boolean bl3 = this.m_gt.isBubble();
        boolean bl4 = this.m_gt.isScatterWithLabel();
        int n2 = this.m_Perspective.getDataTextFormat();
        String string = this.m_Perspective.getDataTextFormatPattern();
        String string2 = "";
        String[] stringArray = new String[n];
        boolean bl5 = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bl) {
            this.m_numXCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bl4 || this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        if ((bl2 || bl3) && !bl4 && this.m_bDataTextDisplay) {
            string2 = bl3 ? this.m_Perspective.getDataTextTemplateBubble() : this.m_Perspective.getDataTextTemplateScatter();
        }
        while (seriesEnumerator.hasMoreElements()) {
            int n3 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                DatumObj datumObj;
                DataItem dataItem;
                int n4;
                int n5 = groupsEnumerator.nextGroup();
                this.m_dataOK[n3][n5] = true;
                boolean bl6 = false;
                if ((bl2 || bl3) && !bl4 && this.m_bDataTextDisplay) {
                    n4 = 0;
                    while (n4 < n) {
                        dataItem = dataFormat.getDataItem(n4);
                        datumObj = this.getDataValue(n3, n5, dataItem);
                        d = datumObj.m_fValue;
                        if (bl5) {
                            int n6 = this.axisAssignedToSeries(n3, dataItem);
                            this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n5, n6, -3);
                            stringArray[n4] = this.m_Perspective.getNumberFormatCallBack().toString(d);
                        } else {
                            stringArray[n4] = TDGNumberFormat.toString(this.m_Perspective, n2, d, string);
                        }
                        ++n4;
                    }
                    this.m_DataLabel[n3][n5] = this.processDataTextTemplate(stringArray, string2);
                    bl6 = true;
                }
                n4 = 0;
                while (n4 < n) {
                    block29: {
                        dataItem = dataFormat.getDataItem(n4);
                        try {
                            if (dataItem.isLabel()) {
                                if (this.m_Access.isCellNumeric(n3, n5, dataItem)) {
                                    d = this.getDataValue((int)n3, (int)n5, (DataItem)dataItem).m_fValue;
                                    if (bl5) {
                                        int n7 = this.axisAssignedToSeries(n3, dataItem);
                                        this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n5, n7, -3);
                                        this.m_DataLabel[n3][n5] = this.m_Perspective.getNumberFormatCallBack().toString(d);
                                    } else {
                                        this.m_DataLabel[n3][n5] = TDGNumberFormat.toString(this.m_Perspective, n2, d, string);
                                    }
                                } else {
                                    this.m_DataLabel[n3][n5] = this.m_Access.getDataAsString(n3, n5, dataItem);
                                }
                            } else {
                                relativeAxisObj = this.whichAxisForSeries(n3, dataItem);
                                if (relativeAxisObj != null) {
                                    datumObj = this.getDataValue(n3, n5, dataItem);
                                    d = datumObj.m_fValue;
                                    if (!datumObj.m_bOK) {
                                        this.m_dataOK[n3][n5] = datumObj.m_bOK;
                                    }
                                    if (d <= 0.0 && this.isBadValueInLogscale(relativeAxisObj, d)) {
                                        this.m_dataOK[n3][n5] = false;
                                        d = 0.0;
                                    }
                                    if (this.isIgnoredOffScale(relativeAxisObj, d)) {
                                        this.m_dataOK[n3][n5] = false;
                                        d = 0.0;
                                    }
                                }
                            }
                        }
                        catch (AssertionException assertionException) {
                            if (!dataItem.isRequired()) break block29;
                            this.m_dataOK[n3][n5] = false;
                            d = 0.0;
                        }
                    }
                    if (!dataItem.isLabel() && relativeAxisObj != null) {
                        if (dataItem.getAssocAxis() == 0) {
                            this.m_numYCoords[n3][n5] = (int)relativeAxisObj.getValueCoord(d);
                        } else if (dataItem.getAssocAxis() == 7) {
                            this.m_numXCoords[n3][n5] = (int)relativeAxisObj.getValueCoord(d);
                        }
                        if (this.m_bDataTextDisplay && !bl6) {
                            if (bl5) {
                                int n8 = this.axisAssignedToSeries(n3, dataItem);
                                this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n5, n8, -3);
                                this.m_DataLabel[n3][n5] = this.m_Perspective.getNumberFormatCallBack().toString(d);
                            } else {
                                this.m_DataLabel[n3][n5] = TDGNumberFormat.toString(this.m_Perspective, n2, d, string);
                            }
                        }
                    }
                    ++n4;
                }
            }
        }
    }

    protected void calcDataPercent() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n = 2;
        boolean bl = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fPercentCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (groupsEnumerator.hasMoreElements()) {
            double d;
            int n2;
            int n3 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
            double d2 = 0.0;
            double d3 = 0.0;
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n2 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
                DatumObj datumObj = this.getDataValue(n2, n3);
                d = datumObj.m_fValue;
                this.m_dataOK[n2][n3] = datumObj.m_bOK;
                if (d >= 0.0) {
                    d2 += d;
                    continue;
                }
                d3 += d;
            }
            d3 = -d3;
            double d4 = d2 + d3;
            double d5 = d2 / d4;
            double d6 = d3 / d4;
            double d7 = 0.0;
            double d8 = 0.0;
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n2 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
                RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n2, DataItem.DI_GENERAL);
                if (relativeAxisObj == null) continue;
                d = this.getDataValue((int)n2, (int)n3).m_fValue;
                if (d >= 0.0 && d2 > 0.0) {
                    this.m_fPercentCumulativeValues[n2][n3] = d5 * (d7 += d) / d2;
                    this.m_numYCoords[n2][n3] = (int)relativeAxisObj.getValueCoord(d5 * d7 / d2);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bl) {
                        int n4 = this.axisAssignedToSeries(n2, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n2, n3, n4, -3);
                        this.m_DataLabel[n2][n3] = this.m_Perspective.getNumberFormatCallBack().toString(d5 * d / d2);
                        continue;
                    }
                    this.m_DataLabel[n2][n3] = TDGNumberFormat.toString(this.m_Perspective, n, d5 * d / d2, "");
                    continue;
                }
                if (d < 0.0 && d3 < 0.0) {
                    this.m_fPercentCumulativeValues[n2][n3] = d6 * (d8 += d) / d3;
                    this.m_numYCoords[n2][n3] = (int)relativeAxisObj.getValueCoord(d6 * d8 / d3);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bl) {
                        int n5 = this.axisAssignedToSeries(n2, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n2, n3, n5, -3);
                        this.m_DataLabel[n2][n3] = this.m_Perspective.getNumberFormatCallBack().toString(d6 * d / d3);
                        continue;
                    }
                    this.m_DataLabel[n2][n3] = TDGNumberFormat.toString(this.m_Perspective, n, d6 * d / d3, "");
                    continue;
                }
                this.m_dataOK[n2][n3] = false;
            }
        }
    }

    protected void calcParetoData() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        this.m_nParetoYCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nParetoCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nMaxParetoYCoords = new int[this.m_nTotalSeries];
        this.m_fParetoYCoords = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            this.m_nMaxParetoYCoords[n2] = 0;
            d = 0.0;
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n3 = groupsEnumerator.nextGroup();
                RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n2, null);
                if (relativeAxisObj == null) continue;
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
                DatumObj datumObj = this.getDataValue(n2, n3, DataItem.DI_GENERAL);
                d2 = datumObj.m_fValue;
                d += Math.abs(d2);
                if (d2 <= 0.0) {
                    ++n;
                    d2 = 0.0;
                }
                this.m_nParetoYCoordsVC[n2][n3] = (int)relativeAxisObj.getValueCoord(d);
                this.m_fParetoYCoords[n2][n3] = d;
                this.m_nParetoCoordsVC[n2][n3] = (int)this.m_O1Axis.getLowCoord(n2, n3);
                int n4 = n2;
                this.m_nMaxParetoYCoords[n4] = this.m_nMaxParetoYCoords[n4] + this.m_nParetoYCoordsVC[n2][n3];
            }
        }
    }

    public double getParetoValue(int n, int n2) {
        return this.m_fParetoYCoords[n][n2];
    }

    public double getPercentCumulativeValue(int n, int n2) {
        double d = 0.0;
        if (this.m_fPercentCumulativeValues != null) {
            d = this.m_fPercentCumulativeValues[n][n2];
        }
        return d;
    }

    protected void calcDataStacked() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (groupsEnumerator.hasMoreElements()) {
            int n = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
            SumObj sumObj = null.new SumObj();
            SumObj sumObj2 = this.getGroupTotals(n);
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                int n2 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
                RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n2, DataItem.DI_GENERAL);
                if (relativeAxisObj == null) continue;
                DatumObj datumObj = this.getDataValue(n2, n);
                double d = datumObj.m_fValue;
                this.m_dataOK[n2][n] = datumObj.m_bOK;
                if (d <= 0.0 && this.isBadValueInLogscale(relativeAxisObj, d)) {
                    d = 0.0;
                    this.m_dataOK[n2][n] = false;
                }
                this.processOneStackedValue(n2, n, relativeAxisObj, d, sumObj);
                int n3 = this.getAxisAssignment(n2);
                boolean bl = n3 == 1;
                boolean bl2 = d >= 0.0;
                int n4 = this.m_seriesTypes[n2];
                this.m_fStackedCumulativeValues[n2][n] = sumObj.getSum(bl2, bl, n4);
                if (!this.m_bDataTextDisplay) continue;
                this.calcDataLabel(bl2, bl, n2, n, n4, d, sumObj, sumObj2);
            }
        }
    }

    protected void calcDataWaterfall() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n = groupsEnumerator.getFirstGroup();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (groupsEnumerator.hasMoreElements()) {
            int n2 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
            SumObj sumObj = null.new SumObj();
            SumObj sumObj2 = this.getGroupTotals(n2);
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                double d;
                boolean bl;
                int n3;
                int n4 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalSeries);
                RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n4, DataItem.DI_GENERAL);
                if (relativeAxisObj == null) continue;
                DatumObj datumObj = this.getDataValue(n4, n2);
                double d2 = datumObj.m_fValue;
                this.m_dataOK[n4][n2] = datumObj.m_bOK;
                if (this.m_gt.isWaterfall() && !sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == d2 < 0.0) {
                    d2 = -d2;
                }
                if (d2 <= 0.0 && this.isBadValueInLogscale(relativeAxisObj, d2)) {
                    d2 = 0.0;
                    this.m_dataOK[n4][n2] = false;
                }
                double d3 = this.processOneStackedValue(n4, n2, relativeAxisObj, d2, sumObj);
                if (this.m_gt.isWaterfall() && n2 != n) {
                    n3 = groupsEnumerator.peekAtGroupBefore(n2);
                    PfjAssert.pfjAssert(n3 != -1);
                    bl = seriesEnumerator.getLastSeries();
                    d = this.m_fStackedCumulativeValues[bl][n3];
                    this.m_numYCoords[n4][n2] = (int)relativeAxisObj.getValueCoord(d3 += d);
                } else {
                    d = 0.0;
                }
                n3 = this.getAxisAssignment(n4);
                bl = n3 == 1;
                boolean bl2 = d2 >= 0.0;
                int n5 = this.m_seriesTypes[n4];
                this.m_fStackedCumulativeValues[n4][n2] = sumObj.getSum(bl2, bl, n5) + d;
                if (!this.m_bDataTextDisplay) continue;
                this.calcDataLabel(bl2, bl, n4, n2, n5, d2, sumObj, sumObj2);
            }
        }
    }

    protected SumObj getGroupTotals(int n) {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        SumObj sumObj = null.new SumObj();
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n2, DataItem.DI_GENERAL);
            if (relativeAxisObj == null) continue;
            DatumObj datumObj = this.getDataValue(n2, n);
            double d = datumObj.m_fValue;
            this.m_dataOK[n2][n] = datumObj.m_bOK;
            if (this.m_gt.isWaterfall() && !sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == d < 0.0) {
                d = -d;
            }
            if (d <= 0.0 && this.isBadValueInLogscale(relativeAxisObj, d)) {
                d = 0.0;
                this.m_dataOK[n2][n] = false;
            }
            this.processOneStackedValue(n2, n, relativeAxisObj, d, sumObj);
        }
        return sumObj;
    }

    private void calcDataLabel(boolean bl, boolean bl2, int n, int n2, int n3, double d, SumObj sumObj, SumObj sumObj2) {
        String string = this.m_Perspective.getDataTextFormatPattern();
        int n4 = this.m_Perspective.getDataTextFormat();
        boolean bl3 = this.m_Perspective.isNumberFormatCallBack();
        double d2 = sumObj.getSum(bl, bl2, n3);
        if (this.m_Perspective.getStackedDataValueSum()) {
            if (TDGNumberFormat.isPercentFormat(n4)) {
                double d3 = sumObj2.getSum(bl, bl2, n3);
                d2 /= d3;
            }
            if (this.m_gt.isWaterfall()) {
                d2 = this.m_fStackedCumulativeValues[n][n2];
            }
        } else {
            d2 = d;
        }
        if (bl3) {
            int n5 = this.axisAssignedToSeries(n, DataItem.DI_GENERAL);
            this.m_Perspective.getNumberFormatCallBack().setState(3, n, n2, n5, -3);
            this.m_DataLabel[n][n2] = this.m_Perspective.getNumberFormatCallBack().toString(d2);
        } else {
            this.m_DataLabel[n][n2] = TDGNumberFormat.toString(this.m_Perspective, n4, d2, string);
        }
    }

    public double getStackedCumulativeValue(int n, int n2) {
        double d = 0.0;
        if (this.m_fStackedCumulativeValues != null) {
            d = this.m_fStackedCumulativeValues[n][n2];
        }
        return d;
    }

    protected void calcOrdinalCoords() {
        PfjAssert.pfjAssert(this.m_O1Axis != null);
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.m_gEnumForward;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        int n = 0;
        while (n < this.m_nGroups) {
            int n2 = groupsEnumerator.groupAt(n);
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
            int n3 = (int)this.m_O1Axis.getCenterCoord(n);
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                int n4 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalSeries);
                this.m_ordCoords[n4][n2] = n3;
            }
            ++n;
        }
    }

    protected int calcRisersPerPixel() {
        int n;
        if (this.m_gt.getIntegerGraphType() != 17 && this.m_gt.getIntegerGraphType() != 24) {
            return 1;
        }
        if (this.isComboWithNonBar() || this.m_Frame == null) {
            return 1;
        }
        Rectangle rectangle = this.m_Frame.getBackWallBounds();
        int n2 = this.m_bHorz ? this.m_Perspective.m_VC.virtToDestHeight(rectangle.height) : this.m_Perspective.m_VC.virtToDestWidth(rectangle.width);
        if (n2 == 0) {
            n = 1;
        } else {
            n = this.m_nSeries * this.m_nGroups / n2;
            if (n < 1) {
                n = 1;
            }
        }
        return n;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bHorz = this.m_gt.isOrientHorz();
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_sEnumReverseForPrev = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        this.m_bExtendToFrameEdge = this.m_gt.isParetoType() ? false : this.m_Perspective.getExtendToFrameEdge();
        this.m_bIsThisAComboWithBar = this.isComboWithBar();
        this.m_bSquareMarkers = this.m_Perspective.getSquareMarkers();
        this.m_bMarkerDisplay = this.m_Perspective.getMarkerDisplay();
        this.m_nMarkerSizeDefault = this.m_Perspective.getMarkerSizeDefault();
    }

    protected void createAxes() {
        boolean bl;
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        AxisSplits axisSplits = new AxisSplits(this.m_Perspective);
        axisSplits.calc();
        int[] nArray = axisSplits.getAxisOffsets();
        int[] nArray2 = axisSplits.getAxisSizes();
        axisSplits.releaseReferences();
        axisSplits = null;
        this.m_scaling = this.m_gt.getScalingMethod();
        int n = this.whichOrdType();
        this.m_Perspective.setMinimumAxisTextSizeVC(16000);
        int n2 = this.m_Perspective.getAxisTextAutofitMode();
        this.m_Perspective.setAxisTextAutofitMode(0);
        if (n2 != 0) {
            this.m_Perspective.setTestLabelCalc(true);
        } else {
            this.m_Perspective.setTestLabelCalc(false);
        }
        boolean bl2 = bl = this.m_gt.getOrientation() == 2;
        if (axisDescriptor.hasZ1()) {
            this.createZ1Axis(!bl, true);
            this.calcAxis(this.m_Z1Axis);
        }
        if (axisDescriptor.hasO1()) {
            this.createOrdinalAxis(n, !bl, bl);
            this.calcAxis(this.m_O1Axis);
        } else if (axisDescriptor.hasX1()) {
            this.createX1Axis(!bl, !this.m_Perspective.getX1AxisDescending());
            this.calcAxis(this.m_X1Axis);
        }
        if (axisDescriptor.hasY2()) {
            int n3 = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++n3;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++n3;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y1_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y1_AXIS.getMajor())) {
                ++n3;
            }
            int n4 = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++n4;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++n4;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y2_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y2_AXIS.getMajor())) {
                ++n4;
            }
            if (n3 <= n4 || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
                this.createY1Axis(bl, !this.m_Perspective.getY1AxisDescending(), nArray[0], nArray2[0]);
                if (this.m_Y1Axis != null) {
                    this.calcAxis(this.m_Y1Axis);
                }
                this.createY2Axis(bl, !this.m_Perspective.getY2AxisDescending(), nArray[1], nArray2[1]);
                this.m_Y2Axis.m_requiredSteps = this.m_Y1Axis.m_numberOfSteps;
                this.calcAxis(this.m_Y2Axis);
            } else {
                this.createY2Axis(bl, !this.m_Perspective.getY2AxisDescending(), nArray[1], nArray2[1]);
                this.calcAxis(this.m_Y2Axis);
                this.createY1Axis(bl, !this.m_Perspective.getY1AxisDescending(), nArray[0], nArray2[0]);
                if (this.m_Y1Axis != null) {
                    this.m_Y1Axis.m_requiredSteps = this.m_Y2Axis.m_numberOfSteps;
                    this.calcAxis(this.m_Y1Axis);
                }
            }
        } else {
            this.createY1Axis(bl, !this.m_Perspective.getY1AxisDescending(), nArray[0], nArray2[0]);
            if (this.m_Y1Axis != null) {
                this.calcAxis(this.m_Y1Axis);
            }
        }
        if (axisDescriptor.hasY3()) {
            this.createY3Axis(bl, !this.m_Perspective.getY3AxisDescending(), nArray[2], nArray2[2]);
            this.calcAxis(this.m_Y3Axis);
        }
        if (axisDescriptor.hasY4()) {
            this.createY4Axis(bl, !this.m_Perspective.getY4AxisDescending(), nArray[3], nArray2[3]);
            this.calcAxis(this.m_Y4Axis);
        }
        if (axisDescriptor.hasY5()) {
            this.createY5Axis(bl, !this.m_Perspective.getY5AxisDescending(), nArray[4], nArray2[4]);
            this.calcAxis(this.m_Y5Axis);
        }
        this.m_Perspective.setAxisTextAutofitMode(n2);
        this.m_Perspective.setTestLabelCalc(false);
        if (this.m_Perspective.getAxisTextAutofitMode() != 0) {
            if (axisDescriptor.hasO1()) {
                if (this.m_O1Axis != null) {
                    this.m_O1Axis.calc();
                }
            } else if (axisDescriptor.hasX1() && this.m_X1Axis != null) {
                this.m_X1Axis.calc();
            }
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calc();
            }
            if (axisDescriptor.hasZ1() && this.m_Z1Axis != null) {
                this.m_Z1Axis.calc();
            }
        }
    }

    protected void calcAxis(RelativeAxisObj relativeAxisObj) {
        if (relativeAxisObj != null) {
            relativeAxisObj.calc();
            if (relativeAxisObj.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                this.m_Perspective.setMinimumAxisTextSizeVC(relativeAxisObj.getAxisTextLabelSizeVC());
            }
        }
    }

    protected MinMaxObj createMinMaxZoom(RelativeAxisObj relativeAxisObj) {
        MinMaxObj minMaxObj = null;
        if (relativeAxisObj == null) {
            return null;
        }
        PfjAssert.pfjAssert(this.isZoomingArmed());
        PfjAssert.pfjAssert(relativeAxisObj.isNumericAxis());
        ZoomState zoomState = this.m_Perspective.getZoomList().getZoomState();
        if (zoomState == null || !zoomState.isZoomed()) {
            return null;
        }
        if (relativeAxisObj.isNumericAxis()) {
            minMaxObj = zoomState.getScaleMinMax(relativeAxisObj.getAxisObjID());
        }
        return minMaxObj;
    }

    protected void createOrdinalAxis(int n, boolean bl, boolean bl2) {
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, n, bl, bl2);
    }

    protected void createX1Axis(boolean bl, boolean bl2) {
        MinMaxObj minMaxObj;
        boolean bl3 = this.m_Perspective.getX1MustIncludeZero() && !this.m_Perspective.getX1LogScale();
        MinMaxObj minMaxObj2 = this.findLimits(7, this.m_scaling, bl3, null);
        this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, minMaxObj2, bl, bl2, 0, 100);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_X1Axis)) != null) {
            this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, minMaxObj, bl, bl2, 0, 100);
        }
    }

    protected void createY1Axis(boolean bl, boolean bl2, int n, int n2) {
        MinMaxObj minMaxObj;
        boolean bl3 = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        MinMaxObj minMaxObj2 = this.findLimits(0, this.m_scaling, bl3, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj2, bl, bl2, n, n2);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_Y1Axis)) != null) {
            this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj, bl, bl2, n, n2);
        }
    }

    protected void createY2Axis(boolean bl, boolean bl2, int n, int n2) {
        MinMaxObj minMaxObj;
        boolean bl3 = this.m_Perspective.getY2MustIncludeZero() && !this.m_Perspective.getY2LogScale();
        MinMaxObj minMaxObj2 = this.findLimits(1, this.m_scaling, bl3, null);
        if (this.m_nDepthRadius > 0 && this.m_nDepthAngle > 90 && !bl) {
            bl2 = !bl2;
        }
        this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, minMaxObj2, bl, bl2, n, n2);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_Y2Axis)) != null) {
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, minMaxObj, bl, bl2, n, n2);
        }
    }

    protected void createZ1Axis(boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl4 && !bl3;
        MinMaxObj minMaxObj = this.findLimits(8, this.m_scaling, bl6, null);
        this.m_Z1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Z1_AXIS, minMaxObj, bl, bl2, 0, 100, bl5);
    }

    protected void createY3Axis(boolean bl, boolean bl2, int n, int n2) {
        MinMaxObj minMaxObj;
        AxisTemplate axisTemplate = AxisTemplate.Y3_AXIS;
        IdentObj identObj = axisTemplate.getAxis();
        boolean bl3 = this.m_Perspective.getScaleMustIncludeZero(identObj) && !this.m_Perspective.getLogScale(identObj);
        MinMaxObj minMaxObj2 = this.findLimits(axisTemplate.getAxisObjID(), this.m_scaling, bl3, null);
        this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, axisTemplate, minMaxObj2, bl, bl2, n, n2);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_Y3Axis)) != null) {
            this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, axisTemplate, minMaxObj, bl, bl2, n, n2);
        }
    }

    protected void createY4Axis(boolean bl, boolean bl2, int n, int n2) {
        MinMaxObj minMaxObj;
        AxisTemplate axisTemplate = AxisTemplate.Y4_AXIS;
        IdentObj identObj = axisTemplate.getAxis();
        boolean bl3 = this.m_Perspective.getScaleMustIncludeZero(identObj) && !this.m_Perspective.getLogScale(identObj);
        MinMaxObj minMaxObj2 = this.findLimits(axisTemplate.getAxisObjID(), this.m_scaling, bl3, null);
        this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, axisTemplate, minMaxObj2, bl, bl2, n, n2);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, axisTemplate, minMaxObj, bl, bl2, n, n2);
        }
    }

    protected void createY5Axis(boolean bl, boolean bl2, int n, int n2) {
        MinMaxObj minMaxObj;
        AxisTemplate axisTemplate = AxisTemplate.Y5_AXIS;
        IdentObj identObj = axisTemplate.getAxis();
        boolean bl3 = this.m_Perspective.getScaleMustIncludeZero(identObj) && !this.m_Perspective.getLogScale(identObj);
        MinMaxObj minMaxObj2 = this.findLimits(axisTemplate.getAxisObjID(), this.m_scaling, bl3, null);
        this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, axisTemplate, minMaxObj2, bl, bl2, n, n2);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, axisTemplate, minMaxObj, bl, bl2, n, n2);
        }
    }

    private void drawAxisBody() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcAxisBody();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.calcAxisBody();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcAxisBody();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calcAxisBody();
        }
        if (this.m_Y3Axis != null) {
            this.m_Y3Axis.calcAxisBody();
        }
        if (this.m_Y4Axis != null) {
            this.m_Y4Axis.calcAxisBody();
        }
        if (this.m_Y5Axis != null) {
            this.m_Y5Axis.calcAxisBody();
        }
    }

    protected void drawDataValues() {
        int n;
        int n2;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        IdentObj identObj = this.m_Perspective.getDataText();
        Vector<String> vector = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension dimension = new Dimension(5000, 1600);
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
        while (groupsEnumerator.hasMoreElements()) {
            n2 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
                vector.addElement(this.m_DataLabel[n][n2]);
            }
        }
        int n3 = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(identObj), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n3, vector, dimension, this.m_Perspective.m_VC);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                Rectangle rectangle;
                n2 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                if (!this.m_dataOK[n][n2] || this.m_DataLabel[n][n2] == null || (rectangle = this.calcDataValuePosition(n, n2, dimension)) == null) continue;
                IdentObj identObj2 = new IdentObj(identObj.getObjectID(), n, n2);
                new DetLabel(this.m_Detectiv, identObj2, this.m_DataLabel[n][n2], rectangle, textStyleObj, (BlackBoxIF)blackBoxObj, false, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Rectangle calcDataValuePosition(int n, int n2, Dimension dimension) {
        int n3;
        int n4;
        int n5;
        double d;
        Point point;
        double d2;
        Rectangle rectangle = null;
        int n6 = this.m_numYCoords[n][n2];
        Axis2DObj axis2DObj = (Axis2DObj)this.whichAxisForSeries(n, null);
        if (axis2DObj == null) return rectangle;
        int n7 = (int)axis2DObj.getValueCoord(0.0);
        boolean bl = axis2DObj.isDescending();
        boolean bl2 = bl ? n6 > n7 : n6 < n7;
        int n8 = this.prevSeriesForAxis(n, n2, axis2DObj, bl2);
        int n9 = 0;
        boolean bl3 = false;
        if (n8 != -2) {
            bl3 = true;
            n9 = this.m_numYCoords[n8][n2];
        }
        boolean bl4 = this.m_Perspective.getNonZeroBaseline(axis2DObj.getAxisIdentObj());
        double d3 = this.m_Perspective.getNonZeroBaselineValue(axis2DObj.getAxisIdentObj());
        if (bl4 && this.m_bAbsolute && !this.m_gt.isStockType() && !this.m_gt.isParetoType() && axis2DObj.isLogScale() && d3 <= 0.0) {
            bl4 = false;
        }
        int n10 = 0;
        if (bl4) {
            n10 = d3 <= axis2DObj.getMaxValue() ? (int)axis2DObj.getValueCoord(d3) : (int)axis2DObj.getValueCoord(axis2DObj.getBaseMax());
        }
        int n11 = this.m_Perspective.getDataTextPosition();
        int n12 = this.m_Perspective.getGraphType();
        Point point2 = this.getCoords(n, n2);
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            d2 = this.calcFrontOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d2);
            if (this.m_gt.isBLAType() && this.m_seriesTypes[n] == 2) {
                Rectangle rectangle2 = this.m_Frame.getBackWallBounds();
                if (rectangle2 == null) {
                    String string = "Can't draw data labels for 2.5D lines when m_Frame has no bounding rect";
                    throw new AssertionException(string);
                }
                d = 12.0;
                n5 = this.m_Perspective.getDataLineThickness();
                double d4 = this.m_bHorz ? (double)rectangle2.width / d : (double)rectangle2.height / d;
                n4 = (int)(d4 * (double)n5 / (double)100);
                if (this.m_bHorz) {
                    point2.x = bl2 ? (point2.x -= n4 / 2) : (point2.x += n4 / 2);
                } else {
                    point2.y = bl2 ? (point2.y -= n4 / 2) : (point2.y += n4 / 2);
                }
            }
        } else {
            point = this.m_Frame.getDepthOffset(1.0);
        }
        d2 = this.getDataValue((int)n, (int)n2).m_fValue;
        int n13 = this.getBaseCoord(n);
        d = this.getStackedCumulativeValue(n, n2);
        n4 = 0;
        double d5 = axis2DObj.getMaxValue();
        double d6 = axis2DObj.getMinValue();
        n5 = this.m_bHorz ? point2.x : point2.y;
        int n14 = bl2 ? (int)axis2DObj.getValueCoord(d6) : (int)axis2DObj.getValueCoord(d5);
        if (this.m_gt.isLAType() && (bl2 ? point2.y < n14 : point2.y > n14)) {
            return null;
        }
        if (n12 == 25 || n12 == 27 || n12 == 29 || n12 == 37 || n12 == 18 || n12 == 20 || n12 == 22 || n12 == 32) {
            n4 = 1;
        }
        if (bl2) {
            if (n5 < n14) {
                if (this.m_gt.isBLAType()) {
                    if (this.m_seriesTypes[n] == 2) return null;
                    if (this.m_seriesTypes[n] == 3) {
                        return null;
                    }
                    if (n4 != 0) {
                        if (n8 != -2 && n9 <= n14) {
                            return null;
                        }
                        if (d5 < 0.0) {
                            d2 = d5 < d - d2 ? d6 - d5 : (d2 -= d - d6);
                            d = d6 - d5;
                        } else {
                            d2 -= d - d6;
                            d = d6;
                        }
                    }
                }
                if (d6 >= 0.0) {
                    return null;
                }
                if (this.m_bHorz) {
                    point2.x = n14;
                } else {
                    point2.y = n14;
                }
            } else if (n4 != 0 && d5 < 0.0) {
                if (d2 < d - d5) {
                    d2 = d - d5;
                }
                d -= d5;
            }
        } else if (n5 > n14) {
            if (this.m_gt.isBLAType()) {
                if (this.m_seriesTypes[n] == 2) return null;
                if (this.m_seriesTypes[n] == 3) {
                    return null;
                }
                if (n4 != 0) {
                    if (n8 != -2 && n9 >= n14) {
                        return null;
                    }
                    if (d6 > 0.0) {
                        d2 = d6 > d - d2 ? d5 - d6 : (d2 -= d - d5);
                        d = d5 - d6;
                    } else {
                        d2 -= d - d5;
                        d = d5;
                    }
                }
            }
            if (d5 <= 0.0) {
                return null;
            }
            if (this.m_bHorz) {
                point2.x = n14;
            } else {
                point2.y = n14;
            }
        } else if (n4 != 0 && d6 > 0.0) {
            if (d2 > d - d6) {
                d2 = d - d6;
            }
            d -= d6;
        }
        if (bl2) {
            n3 = (int)axis2DObj.getValueCoord(d5);
            if (n13 > n3) {
                n13 = n3;
            }
        } else {
            n3 = (int)axis2DObj.getValueCoord(d6);
            if (n13 < n3) {
                n13 = n3;
            }
        }
        if (this.m_gt.isLAType() && n13 == n3 && (bl2 ? point2.y > n13 : point2.y < n13)) {
            return null;
        }
        if (bl2) {
            if (n5 >= n13 && this.m_gt.isBLAType()) {
                if (this.m_seriesTypes[n] != 2) {
                    if (this.m_seriesTypes[n] != 3) return null;
                }
                if (n5 > n13) {
                    return null;
                }
            }
        } else if (n5 <= n13 && this.m_gt.isBLAType()) {
            if (this.m_seriesTypes[n] != 2) {
                if (this.m_seriesTypes[n] != 3) return null;
            }
            if (n5 < n13) {
                return null;
            }
        }
        double d7 = this.getPercentCumulativeValue(n, n2);
        double d8 = this.m_Perspective.getDataTextAngle(n, n2);
        double d9 = this.m_Perspective.getDataTextRadius(n, n2);
        boolean bl5 = this.isComboWithNonBar();
        DataTextPosition dataTextPosition = new DataTextPosition(n11, n12, point, n13, point2, dimension, d2, d, d7, this.m_bHorz, this.isAxisAscending(n), d8, d9, bl5, n9, bl3, bl4, n10, d3, this.m_Perspective);
        return dataTextPosition.calcPosition();
    }

    protected void drawEquationText(CurveFitIF curveFitIF, double[] dArray, int n, double d) {
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        IdentObj identObj = this.m_Perspective.getCurveFitEquationText();
        IdentObj identObj2 = this.m_Perspective.getCurveFitEquationText(n);
        Dimension dimension = new Dimension(5000, 1600);
        int n2 = curveFitIF.numCoeffs();
        String[] stringArray = new String[n2 + 1];
        boolean bl = this.m_Perspective.isNumberFormatCallBack();
        int n3 = this.m_Perspective.getDataTextFormat();
        String string = this.m_Perspective.getDataTextFormatPattern();
        boolean bl2 = false;
        int n4 = 1;
        while (n4 <= n2) {
            if (bl) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, n, -3, -1, -3);
                stringArray[n4] = this.m_Perspective.getNumberFormatCallBack().toString(dArray[n4]);
            } else {
                stringArray[n4] = TDGNumberFormat.toString(this.m_Perspective, n3, dArray[n4], string);
            }
            ++n4;
        }
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), this.m_Perspective.getFontSizeAbsolute(), this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
        n4 = this.m_Perspective.getFontSizeAbsolute() ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj2);
        Rectangle rectangle = this.m_Perspective.getRect(identObj2);
        IdentObj identObj3 = new IdentObj(identObj2);
        String string2 = curveFitIF.createEquation(stringArray, this.m_Perspective.getCurveFitHighOrderFirst());
        if (bl2) {
            String string3;
            if (bl) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, n, -3, -1, -3);
                string3 = this.m_Perspective.getNumberFormatCallBack().toString(d);
            } else {
                string3 = TDGNumberFormat.toString(this.m_Perspective, n3, d, string);
            }
            string2 = String.valueOf(string2) + ", " + string3;
        }
        new DetLabel(this.m_Detectiv, identObj3, string2, rectangle, textStyleObj, (BlackBoxIF)blackBoxObj, true, null);
    }

    protected void drawFitLines() {
        if (this.m_bHorz) {
            return;
        }
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            CurveFitIF curveFitIF = this.m_Perspective.getCurveObj(n);
            if (curveFitIF == null) continue;
            this.drawOneFitLine(n, curveFitIF);
        }
    }

    protected void drawOneFitLine(int n, CurveFitIF curveFitIF) {
        Object object;
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n2 = curveFitIF.numCoeffs();
        int n3 = 0;
        int n4 = groupsEnumerator.getFirstGroup();
        double[] dArray = new double[1];
        double[] dArray2 = new double[this.m_nTotalGroups + 1];
        double[] dArray3 = new double[this.m_nTotalGroups + 1];
        int n5 = 0;
        while (n5 < this.m_nTotalGroups) {
            try {
                object = this.getDataValuesXY(n, n5);
                dArray2[++n3] = ((Point2D)object).getX();
                dArray3[n3] = ((Point2D)object).getY();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n5;
        }
        if (n3 < n2) {
            return;
        }
        double[] dArray4 = new double[n2 + 1];
        try {
            SVD.fit(curveFitIF, dArray2, dArray3, null, n3, dArray4, dArray);
        }
        catch (Exception exception) {
            return;
        }
        object = this.m_Perspective.getCurveFitLineRiser(n);
        int n6 = this.m_Perspective.getLineWidth((IdentObj)object);
        if (n6 < 1) {
            n6 = 1;
        }
        int n7 = this.m_Perspective.m_VC.destToVirtHeight(n6);
        int n8 = this.m_Perspective.getCurveFitNumSegments();
        if (n8 > this.m_nTotalGroups) {
            switch (this.m_Perspective.getCurveFitType(n)) {
                case 4: 
                case 5: 
                case 9: {
                    n8 = this.m_nTotalGroups + 1;
                    break;
                }
                default: {
                    n8 = this.m_nTotalGroups;
                }
            }
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n9 = 0;
        while (groupsEnumerator.hasMoreElements()) {
            n5 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalGroups);
            try {
                Point2D point2D = this.getDataValuesXY(n, n5);
                if (point2D.getX() < d) {
                    d = point2D.getX();
                }
                if (point2D.getX() > d2) {
                    d2 = point2D.getX();
                }
                ++n9;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n9 < 2) {
            return;
        }
        double d3 = (d2 - d) / (double)(n8 - 1);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, (IdentObj)object);
        Polygon polygon = new Polygon();
        int n10 = 0;
        while (n10 < n8) {
            try {
                double d4 = d + (double)n10 * d3;
                double d5 = curveFitIF.compute(d4, dArray4);
                Point point = this.getVCPositionsXY(n, d4 - (double)n4, d5);
                if (point != null) {
                    polygon.addPoint(point.x, point.y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n10;
        }
        if (polygon.npoints >= 2) {
            Polyline polyline = new Polyline(polygon.xpoints, polygon.ypoints, polygon.npoints, n7);
            new DetPolygon(this.m_Detectiv, (IdentObj)object, polyline.m_polygon, (BlackBoxIF)blackBoxObj, null);
            if (this.m_Perspective.getCurveFitEquationDisplay()) {
                this.drawEquationText(curveFitIF, dArray4, n, dArray[0]);
            }
        }
    }

    protected void drawLines(boolean bl) {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n = 0;
        int n2 = 0;
        Point point = null;
        Point point2 = null;
        BlackBoxIF blackBoxIF = null;
        int n3 = 0;
        int n4 = Perspective.SOLID;
        boolean bl2 = false;
        Vector<LineDesc> vector = new Vector<LineDesc>();
        Object var14_13 = null;
        Object var15_14 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        Point point3 = null;
        while (seriesEnumerator.hasMoreElements()) {
            n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            if (this.m_seriesTypes[n] != 2) continue;
            IdentObj identObj = new IdentObj(-3, n);
            groupsEnumerator.reset();
            if (groupsEnumerator.hasMoreElements()) {
                bl2 = true;
            }
            while (groupsEnumerator.hasMoreElements()) {
                double d;
                boolean bl5;
                int n5;
                n2 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                if (!groupsEnumerator.hasMoreElements()) continue;
                int n6 = groupsEnumerator.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[n][n6]) {
                    while (groupsEnumerator.hasMoreElements() && !this.m_dataOK[n][n6]) {
                        n6 = groupsEnumerator.nextGroup();
                        n6 = groupsEnumerator.peekAtNextGroup();
                    }
                }
                PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
                if (!this.m_dataOK[n][n2] || !this.m_dataOK[n][n6]) continue;
                blackBoxIF = this.assignSeriesColor(n, n2);
                blackBoxIF.setTransparentBorderColor(false);
                if (blackBoxIF.getFillColor() != null) {
                    blackBoxIF.setBorderColor(blackBoxIF.getFillColor());
                }
                point = this.getCoords(n, n2);
                point2 = this.getCoords(n, n6);
                n4 = this.m_Perspective.getLineStyle(identObj);
                point3 = new Point(point2);
                RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
                IdentObj identObj2 = relativeAxisObj.getAxisIdentObj();
                bl3 = this.m_Perspective.getScaleMaxAuto(identObj2);
                bl4 = this.m_Perspective.getScaleMinAuto(identObj2);
                double d2 = this.getDataValue((int)n, (int)n2, (DataItem)DataItem.DI_GENERAL).m_fValue;
                double d3 = this.getDataValue((int)n, (int)n6, (DataItem)DataItem.DI_GENERAL).m_fValue;
                double d4 = relativeAxisObj.getMaxValue();
                double d5 = relativeAxisObj.getMinValue();
                int n7 = (int)relativeAxisObj.getValueCoord(d4);
                int n8 = (int)relativeAxisObj.getValueCoord(d5);
                if (relativeAxisObj.isDescending()) {
                    n5 = n8;
                    n8 = n7;
                    n7 = n5;
                    bl5 = bl4;
                    bl4 = bl3;
                    bl3 = bl5;
                }
                if (!bl3) {
                    if (this.m_numYCoords[n][n2] > n7 && this.m_numYCoords[n][n6] > n7) continue;
                    if (this.m_numYCoords[n][n2] > n7) {
                        if (this.m_bHorz) {
                            double d6 = this.calcyPosition(point, point2, n7);
                            point.x = n7;
                            point.y = (int)d6;
                        } else {
                            d = this.calcxPosition(point, point2, n7);
                            point.y = n7;
                            point.x = (int)d;
                        }
                    } else if (this.m_numYCoords[n][n6] > n7) {
                        if (this.m_bHorz) {
                            double d7 = this.calcyPosition(point, point2, n7);
                            point2.x = n7;
                            point2.y = (int)d7;
                        } else {
                            d = this.calcxPosition(point, point2, n7);
                            point2.y = n7;
                            point2.x = (int)d;
                        }
                    }
                }
                if (!bl4) {
                    if (this.m_numYCoords[n][n2] < n8 && this.m_numYCoords[n][n6] < n8) continue;
                    if (this.m_numYCoords[n][n2] < n8) {
                        if (this.m_bHorz) {
                            double d8 = this.calcyPosition(point, point2, n8);
                            point.x = n8;
                            point.y = (int)d8;
                        } else {
                            d = this.calcxPosition(point, point2, n8);
                            point.y = n8;
                            point.x = (int)d;
                        }
                    } else if (this.m_numYCoords[n][n6] < n8) {
                        if (this.m_bHorz) {
                            double d9 = this.calcyPosition(point, point2, n8);
                            point2.x = n8;
                            point2.y = (int)d9;
                        } else {
                            d = this.calcxPosition(point, point2, n8);
                            point2.y = n8;
                            point2.x = (int)d;
                        }
                    }
                }
                n3 = this.m_Perspective.getLineWidth(identObj);
                n5 = 1;
                if (this.m_nFillMissingData != 0) {
                    bl5 = this.m_Access.m_DataStorage.isMissingDataFilledIn(n, n2);
                    int n9 = this.m_Perspective.getNumMissingDataSegments();
                    if (bl5 && n9 != 0) {
                        this.drawMissingLineData(n9, point, point2, n, n2, blackBoxIF, n3, n4);
                        n5 = 0;
                    }
                }
                if (n5 == 0) continue;
                LineDesc lineDesc = null.new LineDesc();
                lineDesc.setLineDesc(point, n, n2);
                vector.addElement(lineDesc);
                LineDesc lineDesc2 = null.new LineDesc();
                lineDesc2.setLineDesc(point2, n, n2);
                vector.addElement(lineDesc2);
                point3.y = point2.y;
                if (blackBoxIF.getTransparentFillColor()) continue;
                new DetLine(this.m_Detectiv, new IdentObj(258, n, n2), point.x, point.y, point2.x, point2.y, blackBoxIF, null, n3, n4);
            }
            if (!bl || !this.m_dataOK[n][0] || !this.m_dataOK[n][n2] || !bl2) continue;
            point = this.getCoords(n, n2);
            point2 = this.getCoords(n, 0);
            blackBoxIF = this.assignSeriesColor(n, n2);
            if (blackBoxIF.getFillColor() != null) {
                blackBoxIF.setBorderColor(blackBoxIF.getFillColor());
            }
            n3 = this.m_Perspective.getLineWidth(identObj);
            n4 = this.m_Perspective.getLineStyle(identObj);
            if (blackBoxIF.getTransparentFillColor()) continue;
            new DetLine(this.m_Detectiv, new IdentObj(258, n, n2), point.x, point.y, point2.x, point2.y, blackBoxIF, null, n3, n4);
        }
    }

    protected void drawMissingLineData(int n, Point point, Point point2, int n2, int n3, BlackBoxIF blackBoxIF, int n4, int n5) {
        Line line = new Line(point, point2);
        int n6 = n * 2 + 1;
        int n7 = 1;
        while (n7 < n6) {
            Point point3 = line.fractionalPoint(n7, n6);
            Point point4 = line.fractionalPoint(n7 + 1, n6);
            IdentObj identObj = new IdentObj(258, n2, n3);
            new DetLine(this.m_Detectiv, identObj, point3.x, point3.y, point4.x, point4.y, blackBoxIF, null, n4, n5);
            ++n7;
            ++n7;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawMarkers() {
        var1_1 = this.getResetSeriesEnumerator();
        var2_2 = this.getResetGroupsEnumerator();
        var6_3 = 0;
        var7_4 = 0;
        if (this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isScatter() || this.m_gt.isBubble()) ** GOTO lbl40
        return;
lbl-1000:
        // 1 sources

        {
            var6_3 = var1_1.nextSeries();
            PfjAssert.pfjAssert(var6_3 >= 0 && var6_3 < this.m_nTotalSeries);
            if (this.m_seriesTypes[var6_3] != 2) continue;
            var11_11 = new IdentObj(-3, var6_3);
            var12_12 = var6_3 % this.m_nSeriesLooping;
            var13_13 = new IdentObj(-3, var12_12);
            var3_5 = this.getMarkerShape(var13_13);
            var10_10 = this.whichAxisForSeries(var6_3, null);
            var14_14 = (int)var10_10.getValueCoord(var10_10.getMaxValue());
            var15_15 = (int)var10_10.getValueCoord(var10_10.getMinValue());
            if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
                var3_5 = MarkerTemplateArray.PRESET_BUBBLE;
            }
            var2_2.reset();
            while (var2_2.hasMoreElements()) {
                var7_4 = var2_2.nextGroup();
                PfjAssert.pfjAssert(var7_4 >= 0 && var7_4 < this.m_nTotalGroups);
                if (!this.m_dataOK[var6_3][var7_4] || this.m_gt.isBLAType() && (this.m_numYCoords[var6_3][var7_4] > var14_14 || this.m_numYCoords[var6_3][var7_4] < var15_15)) continue;
                var5_7 = this.getCoords(var6_3, var7_4);
                var8_8 = var9_9 = this.getMarkerSize(var6_3, var7_4);
                if (this.m_bSquareMarkers) {
                    var16_16 = this.m_Perspective.m_VC.virtToDestWidth((double)var8_8);
                    if (var16_16 > (var18_17 = this.m_Perspective.m_VC.virtToDestHeight((double)var9_9))) {
                        var8_8 = (int)((double)var8_8 * var18_17 / var16_16);
                    } else {
                        var9_9 = (int)((double)var9_9 * var16_16 / var18_17);
                    }
                }
                this.m_smallMarker = this.m_autoGradient != false && this.m_Perspective.m_VC.virtToDestWidth(var8_8) <= 8;
                var4_6 = this.assignSeriesColor(var6_3, var7_4);
                if (this.m_gt.isBubble()) {
                    this._addBubbleMarker(this.m_Detectiv, new IdentObj(259, var6_3, var7_4), var3_5, var5_7, var8_8, var9_9, var4_6, this.m_rClip, true);
                    continue;
                }
                new MarkerObj(this.m_Detectiv, new IdentObj(259, var6_3, var7_4), var3_5, var5_7, var8_8, var9_9, var4_6, null, true);
            }
lbl40:
            // 3 sources

            ** while (var1_1.hasMoreElements())
        }
lbl41:
        // 1 sources

        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjs();
        }
    }

    private void _addBubbleMarker(Detectiv detectiv, IdentObj identObj, MarkerTemplate markerTemplate, Point point, int n, int n2, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] objectArray = new Object[]{detectiv, identObj, markerTemplate, point, new Integer(n), new Integer(n2), blackBoxIF, rectangle, new Boolean(bl)};
        this.m_bubbleMarkerInfo.add(objectArray);
    }

    private void _createBubbleMarkerObjs() {
        if (this.m_bubbleMarkerInfo != null) {
            Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            Iterator iterator = this.m_bubbleMarkerInfo.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                Detectiv detectiv = (Detectiv)objectArray[0];
                IdentObj identObj = (IdentObj)objectArray[1];
                MarkerTemplate markerTemplate = (MarkerTemplate)objectArray[2];
                Point point = (Point)objectArray[3];
                int n = (Integer)objectArray[4];
                int n2 = (Integer)objectArray[5];
                BlackBoxIF blackBoxIF = (BlackBoxIF)objectArray[6];
                Rectangle rectangle = (Rectangle)objectArray[7];
                boolean bl = (Boolean)objectArray[8];
                new MarkerObj(detectiv, identObj, markerTemplate, point, n, n2, blackBoxIF, rectangle, bl);
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkers(int n) {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimension = this.getTransparentMarkerDimension();
        while (seriesEnumerator.hasMoreElements()) {
            int n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            if (this.m_seriesTypes[n2] != n) continue;
            groupsEnumerator.reset();
            RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n2, null);
            int n3 = (int)relativeAxisObj.getValueCoord(relativeAxisObj.getMaxValue());
            int n4 = (int)relativeAxisObj.getValueCoord(relativeAxisObj.getMinValue());
            if (relativeAxisObj.isDescending()) {
                int n5 = n4;
                n4 = n3;
                n3 = n5;
            }
            while (groupsEnumerator.hasMoreElements()) {
                int n6 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
                if (!this.m_dataOK[n2][n6] || !this.m_gt.isPolar() && !this.m_gt.isRadarType() && (this.m_numYCoords[n2][n6] > n3 || this.m_numYCoords[n2][n6] < n4)) continue;
                IdentObj identObj = new IdentObj(259, n2, n6);
                SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj, false);
                simpleBlackBoxObj.setTransparentFillColor(true);
                Point point = this.getCoords(n2, n6);
                new MarkerObj(this.m_Detectiv, identObj, markerTemplate, point, dimension.width, dimension.height, simpleBlackBoxObj, null, true, false, 0, 0, 0, false);
            }
        }
    }

    protected Dimension getTransparentMarkerDimension() {
        double d;
        int n;
        int n2 = this.m_Perspective.getTransparentMarkerSize();
        int n3 = n2 == 0 ? (n = this.m_Perspective.getMarkerSizeDefault()) : (n = n2);
        double d2 = this.m_Perspective.m_VC.virtToDestWidth((double)n3);
        if (d2 > (d = this.m_Perspective.m_VC.virtToDestHeight((double)n))) {
            n3 = (int)((double)n3 * d / d2);
        } else {
            n = (int)((double)n * d2 / d);
        }
        Dimension dimension = new Dimension(n3, n);
        return dimension;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawAllMarkersWithDepth(boolean var1_1) {
        var2_2 = this.getResetSeriesEnumerator();
        if (!(this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame != null) ** GOTO lbl10
        throw new AssertionException("Can't draw 2.5D markers without m_Frame");
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.nextSeries();
            this.drawMarkersWithDepth(var3_3, var1_1);
lbl10:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl11:
        // 1 sources

        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjsWithDepth();
        }
    }

    protected void drawMarkersWithDepth(int n, boolean bl) {
        int n2;
        int n3;
        Point point;
        Point point2;
        boolean bl2;
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl2 = !bl;
        if (!(this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
        IdentObj identObj = relativeAxisObj.getAxisIdentObj();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
        if (this.m_seriesTypes[n] != 2) {
            return;
        }
        int n4 = n % this.m_nSeriesLooping;
        IdentObj identObj2 = this.m_Perspective.getSeries(n4);
        MarkerTemplate markerTemplate = this.getMarkerShape(identObj2);
        if (markerTemplate.m_markerType == 2) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
            markerTemplate = MarkerTemplateArray.PRESET_BUBBLE;
        }
        if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
            double d = this.calcFrontOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point2 = this.m_Frame.getDepthOffset(d);
            double d2 = this.calcBackOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d2);
            n3 = point2.x - point.x;
            n2 = point2.y - point.y;
            n3 = 3 * n3;
            n2 = 3 * n2;
        } else {
            point2 = new Point();
            point = new Point();
            n3 = 0;
            n2 = 0;
        }
        groupsEnumerator.reset();
        int n5 = (int)relativeAxisObj.getValueCoord(relativeAxisObj.getMaxValue());
        int n6 = (int)relativeAxisObj.getValueCoord(relativeAxisObj.getMinValue());
        while (groupsEnumerator.hasMoreElements()) {
            int n7;
            int n8 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n8 >= 0 && n8 < this.m_nTotalGroups);
            if (!this.m_dataOK[n][n8] || this.m_gt.isBLAType() && (this.m_numYCoords[n][n8] > n5 || this.m_numYCoords[n][n8] < n6)) continue;
            Point point3 = this.getCoords(n, n8);
            Point point4 = new Point(point3.x - point2.x, point3.y - point2.y);
            int n9 = n7 = this.getMarkerSize(n, n8);
            if (this.m_bSquareMarkers) {
                double d;
                double d3 = this.m_Perspective.m_VC.virtToDestWidth((double)n9);
                if (d3 > (d = this.m_Perspective.m_VC.virtToDestHeight((double)n7))) {
                    n9 = (int)((double)n9 * d / d3);
                } else {
                    n7 = (int)((double)n7 * d3 / d);
                }
            }
            BlackBoxIF blackBoxIF = this.assignSeriesColor(n, n8);
            IdentObj identObj3 = new IdentObj(259, n, n8);
            identObj3.setMiscID(0);
            if (this.m_gt.isBubble()) {
                this._addBubbleMarkerWithDepth(this.m_Detectiv, identObj3, markerTemplate, point4, n9, n7, blackBoxIF, this.m_rClip, true, true, n3, n2, this.m_nDepthAngle);
                continue;
            }
            new MarkerObj(this.m_Detectiv, identObj3, markerTemplate, point4, n9, n7, blackBoxIF, null, true, bl2, n3, n2, this.m_nDepthAngle);
        }
    }

    private void _addBubbleMarkerWithDepth(Detectiv detectiv, IdentObj identObj, MarkerTemplate markerTemplate, Point point, int n, int n2, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, int n3, int n4, int n5) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] objectArray = new Object[]{detectiv, identObj, markerTemplate, point, new Integer(n), new Integer(n2), blackBoxIF, rectangle, new Boolean(bl), new Boolean(bl2), new Integer(n3), new Integer(n4), new Integer(n5)};
        this.m_bubbleMarkerInfo.add(objectArray);
    }

    private void _createBubbleMarkerObjsWithDepth() {
        if (this.m_bubbleMarkerInfo != null) {
            Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            Iterator iterator = this.m_bubbleMarkerInfo.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                Detectiv detectiv = (Detectiv)objectArray[0];
                IdentObj identObj = (IdentObj)objectArray[1];
                MarkerTemplate markerTemplate = (MarkerTemplate)objectArray[2];
                Point point = (Point)objectArray[3];
                int n = (Integer)objectArray[4];
                int n2 = (Integer)objectArray[5];
                BlackBoxIF blackBoxIF = (BlackBoxIF)objectArray[6];
                Rectangle rectangle = (Rectangle)objectArray[7];
                boolean bl = (Boolean)objectArray[8];
                boolean bl2 = (Boolean)objectArray[9];
                int n3 = (Integer)objectArray[10];
                int n4 = (Integer)objectArray[11];
                int n5 = (Integer)objectArray[12];
                new MarkerObj(detectiv, identObj, markerTemplate, point, n, n2, blackBoxIF, rectangle, bl, bl2, n3, n4, n5);
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkersWithDepth(int n, int n2) {
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        Point point = new Point();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimension = this.getTransparentMarkerDimension();
        if (this.m_seriesTypes[n] == n2) {
            int n3;
            int n4;
            Point point2;
            Point point3;
            if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
                double d = this.calcFrontOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
                point3 = this.m_Frame.getDepthOffset(d);
                double d2 = this.calcBackOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
                point2 = this.m_Frame.getDepthOffset(d2);
                n4 = point3.x - point2.x;
                n3 = point3.y - point2.y;
                n4 = 3 * n4;
                n3 = 3 * n3;
            } else {
                point3 = new Point();
                point2 = new Point();
                n4 = 0;
                n3 = 0;
            }
            n3 = 0;
            n4 = 0;
            groupsEnumerator.reset();
            RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
            int n5 = (int)relativeAxisObj.getValueCoord(relativeAxisObj.getMaxValue());
            int n6 = (int)relativeAxisObj.getValueCoord(relativeAxisObj.getMinValue());
            if (relativeAxisObj.isDescending()) {
                int n7 = n6;
                n6 = n5;
                n5 = n7;
            }
            while (groupsEnumerator.hasMoreElements()) {
                int n8 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n8 >= 0 && n8 < this.m_nTotalGroups);
                if (!this.m_dataOK[n][n8] || !this.m_gt.isPolar() && !this.m_gt.isRadarType() && (this.m_numYCoords[n][n8] > n5 || this.m_numYCoords[n][n8] < n6)) continue;
                Point point4 = this.getCoords(n, n8);
                point.x = point4.x - point3.x;
                point.y = point4.y - point3.y;
                IdentObj identObj = new IdentObj(259, n, n8);
                identObj.setMiscID(0);
                SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj, false);
                simpleBlackBoxObj.setTransparentFillColor(true);
                new MarkerObj(this.m_Detectiv, identObj, markerTemplate, point, dimension.width, dimension.height, simpleBlackBoxObj, null, true, true, n4, n3, this.m_nDepthAngle, false);
            }
        }
    }

    protected MinMaxObj findLimits(int n, int n2, boolean bl, MinMaxObj minMaxObj) {
        MinMaxObj minMaxObj2;
        block98: {
            int n3;
            int[] nArray;
            int n4;
            DataFormat dataFormat;
            int n5;
            double d;
            block99: {
                block91: {
                    d = 0.0;
                    n5 = 0;
                    minMaxObj2 = this.findPreScaledLimits(n, n2, bl);
                    if (minMaxObj2 != null) {
                        return minMaxObj2;
                    }
                    minMaxObj2 = new MinMaxObj(bl);
                    dataFormat = this.m_Access.getDataFormat();
                    n4 = dataFormat.getNumDataItems();
                    nArray = new int[this.m_nTotalSeries];
                    n3 = 0;
                    while (n3 < this.m_nTotalSeries) {
                        nArray[n3] = this.getAxisAssignment(n3);
                        ++n3;
                    }
                    this.setNonDataLimits(minMaxObj2);
                    if (n2 != 1) break block91;
                    n3 = 0;
                    while (n3 < this.m_nTotalSeries) {
                        block92: {
                            if ((n == 0 || n == 1 || n == 2 || n == 3 || n == 4) && nArray[n3] != n) break block92;
                            if (n == 1) {
                                this.m_dualY = true;
                            }
                            if (n == 7) {
                                this.m_XY = true;
                            }
                            if (this.m_dualY && this.m_XY) {
                                this.m_dualYX = true;
                                this.m_dualY = false;
                                this.m_XY = false;
                            }
                            int n6 = 0;
                            while (n6 < this.m_nTotalGroups) {
                                int n7 = 0;
                                while (n7 < n4) {
                                    block93: {
                                        double d2;
                                        block97: {
                                            block94: {
                                                DatumObj datumObj;
                                                block96: {
                                                    block95: {
                                                        DataItem dataItem = dataFormat.getDataItem(n7);
                                                        if (dataItem.ignoreInScaling() || !AxisTemplate.isSameType(dataItem.getAssocAxis(), n)) break block93;
                                                        datumObj = this.getDataValue(n3, n6, dataItem);
                                                        d2 = datumObj.m_fValue;
                                                        if (d2 == 0.0 && !datumObj.m_bOK) {
                                                            if (n == 0) {
                                                                this.m_nullValY1 = true;
                                                            } else if (n == 1) {
                                                                this.m_nullValY2 = true;
                                                            } else if (n == 7) {
                                                                this.m_nullValX1 = true;
                                                            }
                                                        }
                                                        if (!datumObj.m_bOK) break block93;
                                                        if (!(d2 <= 0.0) || !this.isBadValueInLogscale(n, d2)) break block94;
                                                        if (n != 0) break block95;
                                                        if (d2 == 0.0 && datumObj.m_bOK) {
                                                            this.m_zeroValY1 = true;
                                                        } else if (d2 == 0.0 && !datumObj.m_bOK) {
                                                            this.m_nullValY1 = true;
                                                        } else {
                                                            this.m_negativeValY1 = true;
                                                        }
                                                        break block93;
                                                    }
                                                    if (n != 1) break block96;
                                                    if (d2 == 0.0 && datumObj.m_bOK) {
                                                        this.m_zeroValY2 = true;
                                                    } else if (d2 == 0.0 && !datumObj.m_bOK) {
                                                        this.m_nullValY2 = true;
                                                    } else {
                                                        this.m_negativeValY2 = true;
                                                    }
                                                    break block93;
                                                }
                                                if (n != 7) break block97;
                                                if (d2 == 0.0 && datumObj.m_bOK) {
                                                    this.m_zeroValX1 = true;
                                                } else if (d2 == 0.0 && !datumObj.m_bOK) {
                                                    this.m_nullValX1 = true;
                                                } else {
                                                    this.m_negativeValX1 = true;
                                                }
                                                break block93;
                                            }
                                            if (n == 0) {
                                                this.m_positiveValY1 = true;
                                            } else if (n == 1) {
                                                this.m_positiveValY2 = true;
                                            } else if (n == 7) {
                                                this.m_positiveValX1 = true;
                                            }
                                        }
                                        if (minMaxObj == null || !(d2 < minMaxObj.getAdjMin()) && !(d2 > minMaxObj.getAdjMax())) {
                                            minMaxObj2.testRawValue(d2);
                                        }
                                    }
                                    ++n7;
                                }
                                ++n6;
                            }
                        }
                        ++n3;
                    }
                    break block98;
                }
                if (n2 != 2) break block99;
                SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
                GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
                while (groupsEnumerator.hasMoreElements()) {
                    int n8 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n8 >= 0 && n8 < this.m_nTotalGroups);
                    SumObj sumObj = null.new SumObj();
                    seriesEnumerator.reset();
                    while (seriesEnumerator.hasMoreElements()) {
                        n3 = seriesEnumerator.nextSeries();
                        PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                        if ((n == 0 || n == 1 || n == 2 || n == 3 || n == 4) && nArray[n3] != n) continue;
                        if (n == 1) {
                            this.m_dualY = true;
                        }
                        if (n == 7) {
                            this.m_XY = true;
                        }
                        if (this.m_dualY && this.m_XY) {
                            this.m_dualYX = true;
                            this.m_dualY = false;
                            this.m_XY = false;
                        }
                        int n9 = 0;
                        while (n9 < n4) {
                            block100: {
                                double d3;
                                block104: {
                                    block101: {
                                        DatumObj datumObj;
                                        block103: {
                                            block102: {
                                                DataItem dataItem = dataFormat.getDataItem(n9);
                                                if (dataItem.ignoreInScaling() || !AxisTemplate.isSameType(dataItem.getAssocAxis(), n)) break block100;
                                                datumObj = this.getDataValue(n3, n8, dataItem);
                                                d3 = datumObj.m_fValue;
                                                if (d3 == 0.0 && !datumObj.m_bOK) {
                                                    if (n == 0) {
                                                        this.m_nullValY1 = true;
                                                    } else if (n == 1) {
                                                        this.m_nullValY2 = true;
                                                    } else if (n == 7) {
                                                        this.m_nullValX1 = true;
                                                    }
                                                }
                                                if (!datumObj.m_bOK) break block100;
                                                if (!(d3 <= 0.0) || !this.isBadValueInLogscale(n, d3)) break block101;
                                                if (n != 0) break block102;
                                                if (d3 == 0.0 && datumObj.m_bOK) {
                                                    this.m_zeroValY1 = true;
                                                } else if (d3 == 0.0 && !datumObj.m_bOK) {
                                                    this.m_nullValY1 = true;
                                                } else {
                                                    this.m_negativeValY1 = true;
                                                }
                                                break block100;
                                            }
                                            if (n != 1) break block103;
                                            if (d3 == 0.0 && datumObj.m_bOK) {
                                                this.m_zeroValY2 = true;
                                            } else if (d3 == 0.0 && !datumObj.m_bOK) {
                                                this.m_nullValY2 = true;
                                            } else {
                                                this.m_negativeValY2 = true;
                                            }
                                            break block100;
                                        }
                                        if (n != 7) break block104;
                                        if (d3 == 0.0 && datumObj.m_bOK) {
                                            this.m_zeroValX1 = true;
                                        } else if (d3 == 0.0 && !datumObj.m_bOK) {
                                            this.m_nullValX1 = true;
                                        } else {
                                            this.m_negativeValX1 = true;
                                        }
                                        break block100;
                                    }
                                    if (n == 0) {
                                        this.m_positiveValY1 = true;
                                    } else if (n == 1) {
                                        this.m_positiveValY2 = true;
                                    } else if (n == 7) {
                                        this.m_positiveValX1 = true;
                                    }
                                }
                                boolean bl2 = d3 >= 0.0;
                                boolean bl3 = n == 1;
                                int n10 = this.m_seriesTypes[n3];
                                double d4 = sumObj.getSum(bl2, bl3, n10) + d3;
                                sumObj.setSum(bl2, bl3, n10, d4);
                                minMaxObj2.testRawValue(d4);
                            }
                            ++n9;
                        }
                    }
                }
                break block98;
            }
            if (n2 == 5) {
                SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
                GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
                while (groupsEnumerator.hasMoreElements()) {
                    int n11 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n11 >= 0 && n11 < this.m_nTotalGroups);
                    SumObj sumObj = null.new SumObj();
                    seriesEnumerator.reset();
                    while (seriesEnumerator.hasMoreElements()) {
                        n3 = seriesEnumerator.nextSeries();
                        PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                        if ((n == 0 || n == 1 || n == 2 || n == 3 || n == 4) && nArray[n3] != n) continue;
                        int n12 = 0;
                        while (n12 < n4) {
                            DataItem dataItem = dataFormat.getDataItem(n12);
                            if (!dataItem.ignoreInScaling() && AxisTemplate.isSameType(dataItem.getAssocAxis(), n)) {
                                DatumObj datumObj = this.getDataValue(n3, n11, dataItem);
                                double d5 = datumObj.m_fValue;
                                if (datumObj.m_bOK) {
                                    if (!sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == d5 < 0.0) {
                                        d5 = -d5;
                                    }
                                    if (!(d5 <= 0.0) || !this.isBadValueInLogscale(n, d5)) {
                                        boolean bl4 = d5 >= 0.0;
                                        boolean bl5 = n == 1;
                                        int n13 = this.m_seriesTypes[n3];
                                        double d6 = sumObj.getSum(bl4, bl5, n13) + d5;
                                        sumObj.setSum(bl4, bl5, n13, d6);
                                        minMaxObj2.testRawValue(d6 += d);
                                        if (n3 == seriesEnumerator.getLastSeries()) {
                                            d = d6;
                                        }
                                    }
                                }
                            }
                            ++n12;
                        }
                    }
                }
            } else if (n2 == 3) {
                n3 = 0;
                block10: while (n3 < this.m_nTotalSeries) {
                    if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 || nArray[n3] == n) {
                        int n14 = 0;
                        while (n14 < this.m_nTotalGroups) {
                            int n15 = 0;
                            while (n15 < n4) {
                                DataItem dataItem = dataFormat.getDataItem(n15);
                                if (!dataItem.ignoreInScaling() && AxisTemplate.isSameType(dataItem.getAssocAxis(), n)) {
                                    DatumObj datumObj = this.getDataValue(n3, n14, dataItem);
                                    double d7 = datumObj.m_fValue;
                                    if (datumObj.m_bOK) {
                                        if (d7 < 0.0) {
                                            this.m_negativeVal = true;
                                            break block10;
                                        }
                                        if (d7 == 0.0 && datumObj.m_bOK) {
                                            this.m_zeroVal = true;
                                            ++n5;
                                        }
                                        if (d7 > 0.0) {
                                            this.m_positiveVal = true;
                                        }
                                    }
                                }
                                ++n15;
                            }
                            ++n14;
                        }
                    }
                    ++n3;
                }
                minMaxObj2.testRawValue(1.0);
                minMaxObj2.testRawValue(0.0);
            } else if (n2 == 4) {
                n3 = 0;
                while (n3 < this.m_nTotalSeries) {
                    int n16 = 0;
                    while (n16 < this.m_nTotalGroups) {
                        if (n == 7) {
                            int n17 = 0;
                            while (n17 < n4) {
                                DataItem dataItem = dataFormat.getDataItem(n17);
                                if (!dataItem.ignoreInScaling()) {
                                    DatumObj datumObj = this.getDataValue(n3, n16, dataItem);
                                    double d8 = datumObj.m_fValue;
                                    if (!(!datumObj.m_bOK || d8 <= 0.0 && this.isBadValueInLogscale(n, d8))) {
                                        minMaxObj2.testRawValue(d8);
                                    }
                                }
                                ++n17;
                            }
                        } else {
                            throw new AssertionException("FindLimit should not be called for Y1 axis");
                        }
                        ++n16;
                    }
                    ++n3;
                }
            } else {
                throw new AssertionException(1, 5, n2);
            }
        }
        return minMaxObj2;
    }

    public int getBaseCoord(int n) {
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
        boolean bl = this.m_Perspective.getScaleFromZero() || relativeAxisObj.hasNegData() && !this.m_bAbsolute;
        int n2 = bl ? (int)relativeAxisObj.getValueCoord(0.0) : (int)relativeAxisObj.getBaseCoord();
        return n2;
    }

    public int getDataCoord(int n, int n2) {
        return this.getDataCoord(n, n2, DataItem.DI_GENERAL, false);
    }

    public int getDataCoord(int n, int n2, DataItem dataItem, boolean bl) {
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, dataItem);
        double d = this.getDataValue((int)n, (int)n2, (DataItem)dataItem).m_fValue;
        if (bl) {
            return this.getDataCoordCum(n, n2, dataItem);
        }
        return (int)relativeAxisObj.getValueCoord(d);
    }

    public int getDataCoordCum(int n, int n2, DataItem dataItem) {
        return this.m_numYCoords[n][n2];
    }

    public double getDataFromCoord(int n, int n2, int n3) {
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, DataItem.DI_GENERAL);
        return relativeAxisObj.getValueFromCoord(n3);
    }

    public double getDataFromCoord(int n, int n2, DataItem dataItem, int n3) {
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, dataItem);
        return relativeAxisObj.getValueFromCoord(n3);
    }

    public DatumObj getDataValue(int n, int n2, DataItem dataItem) {
        DatumObj datumObj = super.getDataValue(n, n2, dataItem);
        double d = datumObj.m_fValue;
        boolean bl = datumObj.m_bOK;
        if (this.m_gt.isRiserArea() && !this.m_bAbsolute && d < 0.0) {
            datumObj = new DatumObj(-d, bl);
        }
        return datumObj;
    }

    public DatumObj getDataValue(int n, int n2) {
        DatumObj datumObj = super.getDataValue(n, n2);
        double d = datumObj.m_fValue;
        boolean bl = datumObj.m_bOK;
        if (this.m_gt.isRiserArea() && !this.m_bAbsolute && d < 0.0) {
            datumObj = new DatumObj(-d, bl);
        }
        return datumObj;
    }

    public double getAutoLowerSplitValue(IdentObj identObj) {
        if (identObj == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && identObj.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y1Axis != null && identObj.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y2Axis != null && identObj.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoLowerSplitValue();
        }
        return Double.NaN;
    }

    public double getAutoHigherSplitValue(IdentObj identObj) {
        if (identObj == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && identObj.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y1Axis != null && identObj.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y2Axis != null && identObj.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoHigherSplitValue();
        }
        return Double.NaN;
    }

    public int getMarkerSize(int n, int n2) {
        return this.m_Perspective.getMarkerSize(n, n2);
    }

    public MarkerTemplate getMarkerShape(IdentObj identObj) {
        MarkerTemplate markerTemplate = this.m_Perspective.getMarkerTemplate(identObj);
        return markerTemplate;
    }

    public double getQuantizedDataValue(int n, int n2, DataItem dataItem) {
        double d = this.getDataValue((int)n, (int)n2, (DataItem)dataItem).m_fValue;
        boolean bl = this.m_Perspective.getExactColorByHeight();
        if (!bl) {
            Vector vector = this.m_Y1Axis.getNumericLabelsAsDouble();
            int n3 = vector.size();
            PfjAssert.pfjAssert(n3 > 1);
            boolean bl2 = false;
            int n4 = 1;
            while (n4 < n3 && !bl2) {
                double d2;
                double d3 = (Double)vector.elementAt(n4 - 1);
                double d4 = (d3 + (d2 = ((Double)vector.elementAt(n4)).doubleValue())) / (double)2;
                if (d < d4) {
                    d = d3;
                    bl2 = true;
                }
                ++n4;
            }
            if (!bl2) {
                d = (Double)vector.elementAt(n3 - 1);
            }
        }
        return d;
    }

    public RelativeAxisObj getX1Axis() {
        return this.m_X1Axis;
    }

    public RelativeAxisObj getY1Axis() {
        return this.m_Y1Axis;
    }

    public RelativeAxisObj getY2Axis() {
        return this.m_Y2Axis;
    }

    public RelativeAxisObj getO1Axis() {
        return this.m_O1Axis;
    }

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_O1Axis = null;
        this.m_X1Axis = null;
        this.m_Y1Axis = null;
        this.m_Y2Axis = null;
        this.m_Z1Axis = null;
    }

    protected boolean isAxisAscending(int n) {
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, DataItem.DI_GENERAL);
        return relativeAxisObj.isAscending();
    }

    public boolean isComboWithBar() {
        boolean bl = false;
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (seriesEnumerator.hasMoreElements() && !bl) {
            int n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            if (this.m_seriesTypes[n] != 1) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isComboWithNonBar() {
        boolean bl = false;
        if (this.m_Perspective.getGraphType() == 102) {
            return false;
        }
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (seriesEnumerator.hasMoreElements() && !bl) {
            int n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            if (this.m_seriesTypes[n] == 1) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isZoomingArmed() {
        boolean bl = this.m_Perspective.getZoomList().isCurrentlyZoomed();
        return bl;
    }

    protected int prevSeriesForAxis(int n, int n2) {
        SeriesEnumerator seriesEnumerator = this.m_sEnumReverseForPrev;
        int n3 = -2;
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n4;
            int n5 = seriesEnumerator.nextSeries();
            if (n5 >= n || (n4 = this.getAxisAssignment(n5)) != n2) continue;
            n3 = n5;
            break;
        }
        return n3;
    }

    protected int prevSeriesForAxis(int n, int n2, int n3, boolean bl) {
        SeriesEnumerator seriesEnumerator = this.m_sEnumReverseForPrev;
        int n4 = -2;
        int n5 = this.m_seriesTypes[n];
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n6;
            boolean bl2;
            RelativeAxisObj relativeAxisObj;
            int n7;
            int n8 = seriesEnumerator.nextSeries();
            if (n8 >= n || (n7 = this.getAxisAssignment(n8)) != n3 || !this.m_dataOK[n8][n2]) continue;
            switch (n7) {
                case 7: {
                    relativeAxisObj = this.m_X1Axis;
                    break;
                }
                case 0: {
                    relativeAxisObj = this.m_Y1Axis;
                    break;
                }
                case 1: {
                    relativeAxisObj = this.m_Y2Axis;
                    break;
                }
                case 2: {
                    relativeAxisObj = this.m_Y3Axis;
                    break;
                }
                case 3: {
                    relativeAxisObj = this.m_Y4Axis;
                    break;
                }
                case 4: {
                    relativeAxisObj = this.m_Y5Axis;
                    break;
                }
                case 8: {
                    relativeAxisObj = this.m_Z1Axis;
                    break;
                }
                default: {
                    throw new AssertionException(String.valueOf(String.valueOf("Invalid axis = ")) + n7);
                }
            }
            int n9 = (int)relativeAxisObj.getValueCoord(0.0);
            boolean bl3 = bl2 = this.m_numYCoords[n8][n2] < n9;
            if (!bl2 && this.getDataValue((int)n8, (int)n2, (DataItem)DataItem.DI_GENERAL).m_fValue < 0.0) {
                bl2 = true;
            }
            if (bl2 != bl || (n6 = this.m_seriesTypes[n8]) != n5) continue;
            n4 = n8;
            break;
        }
        return n4;
    }

    protected int prevSeriesForAxis(int n, int n2, RelativeAxisObj relativeAxisObj, boolean bl) {
        return this.prevSeriesForAxis(n, n2, relativeAxisObj.getAxisObjID(), bl);
    }

    protected int prevSeriesForAxis(int n, RelativeAxisObj relativeAxisObj) {
        return this.prevSeriesForAxis(n, relativeAxisObj.getAxisObjID());
    }

    protected double processOneStackedValue(int n, int n2, RelativeAxisObj relativeAxisObj, double d, SumObj sumObj) {
        int n3;
        boolean bl;
        boolean bl2 = d >= 0.0;
        double d2 = sumObj.getSum(bl2, bl = relativeAxisObj == this.m_Y2Axis, n3 = this.m_seriesTypes[n]) + d;
        if (this.isIgnoredOffScale(relativeAxisObj, d2)) {
            this.m_dataOK[n][n2] = false;
        } else {
            sumObj.setSum(bl2, bl, n3, d2);
            this.m_numYCoords[n][n2] = (int)relativeAxisObj.getValueCoord(d2);
        }
        return d2;
    }

    public void releaseReferences() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.releaseReferences();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.releaseReferences();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.releaseReferences();
        }
        if (this.m_Z1Axis != null) {
            this.m_Z1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public boolean seriesAssignedToBothAxes() {
        boolean bl = false;
        boolean bl2 = false;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            int n2 = this.getAxisAssignment(n);
            if ((bl |= n2 == 0) && (bl2 |= n2 != 0)) break;
        }
        return bl && bl2;
    }

    public void setNonDataLimits(MinMaxObj minMaxObj) {
    }

    protected RelativeAxisObj whichAxisForSeries(int n, DataItem dataItem) {
        RelativeAxisObj relativeAxisObj;
        int n2 = this.axisAssignedToSeries(n, dataItem);
        switch (n2) {
            case 7: {
                relativeAxisObj = this.m_X1Axis;
                break;
            }
            case 0: {
                relativeAxisObj = this.m_Y1Axis;
                break;
            }
            case 1: {
                relativeAxisObj = this.m_Y2Axis;
                break;
            }
            case 2: {
                relativeAxisObj = this.m_Y3Axis;
                break;
            }
            case 3: {
                relativeAxisObj = this.m_Y4Axis;
                break;
            }
            case 4: {
                relativeAxisObj = this.m_Y5Axis;
                break;
            }
            case 8: {
                relativeAxisObj = this.m_Z1Axis;
                break;
            }
            default: {
                relativeAxisObj = null;
            }
        }
        return relativeAxisObj;
    }

    public int axisAssignedToSeries(int n, DataItem dataItem) {
        int n2;
        if (this.m_gt.isMultiY()) {
            n2 = this.getAxisAssignment(n);
        } else {
            n2 = dataItem == null ? 0 : dataItem.getAssocAxis();
            if (n2 == 0) {
                n2 = this.getAxisAssignment(n);
            }
        }
        return n2;
    }

    protected int whichOrdType() {
        int n = 1;
        if (this.m_bExtendToFrameEdge && !this.m_bIsThisAComboWithBar) {
            n = 6;
        } else if (this.m_gt.isRiserBar()) {
            if (this.m_bAbsolute) {
                n = 0;
            } else if (this.m_bStacked && this.m_gt.isDualY() && !this.m_gt.isBipolar() && this.seriesAssignedToBothAxes()) {
                n = 3;
            }
        } else if (this.m_gt.isRiserArea() || this.m_gt.isRiserMarker()) {
            n = 2;
        } else if (this.m_gt.isParetoType()) {
            n = 10;
        }
        return n;
    }

    String ReplaceMacro(String string, String string2, String string3) {
        int n;
        String string4 = "";
        string4 = string;
        while ((n = string4.indexOf(string2)) != -1) {
            String string5 = string4.substring(0, n);
            string5 = String.valueOf(string5) + string3;
            string4 = string5 = String.valueOf(string5) + string4.substring(n += string2.length(), string4.length());
        }
        return string4;
    }

    protected abstract Point getCoords(int var1, int var2);

    protected abstract String processDataTextTemplate(String[] var1, String var2);

    protected double calcxPosition(Point point, Point point2, double d) {
        double d2 = point2.x;
        double d3 = point.x;
        double d4 = point.y;
        double d5 = point2.y;
        double d6 = (d4 - d5) / (d3 - d2);
        double d7 = d4 - d3 * d6;
        double d8 = (d - d7) / d6;
        return d8;
    }

    protected double calcyPosition(Point point, Point point2, double d) {
        double d2 = point2.x;
        double d3 = point.x;
        double d4 = point.y;
        double d5 = point2.y;
        double d6 = (d4 - d5) / (d3 - d2);
        double d7 = d4 - d3 * d6;
        double d8 = d6 * d + d7;
        return d8;
    }

    protected Point checkEndPointVertical(Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        if (point.x != point2.x) {
            point3.y = point2.y;
            point3.x = point.x;
            return point3;
        }
        return point2;
    }

    protected void checkEndPointVert(Vector vector, Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        LineDesc lineDesc = (LineDesc)vector.lastElement();
        Point point4 = lineDesc.getPt();
        lineDesc = null.new LineDesc();
        if (point.x != point4.x) {
            point3.y = point4.y;
            point3.x = point.x;
            lineDesc.setLineDesc(point3, n, n2);
        } else {
            lineDesc.setLineDesc(point4, n, n2);
        }
        vector.add(lineDesc);
    }

    protected void checkStartPointHoriz(Vector vector, Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        LineDesc lineDesc = null.new LineDesc();
        if (point.y != point2.y) {
            lineDesc = null.new LineDesc();
            point3.y = point.y;
            point3.x = point2.x;
            lineDesc.setLineDesc(point3, n, n2);
            vector.add(lineDesc);
        }
    }

    protected Point checkStartPointHorizontal(Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        if (point.y != point2.y) {
            point3.y = point.y;
            point3.x = point2.x;
            return point3;
        }
        return point2;
    }

    protected Point checkStartPointVertical(Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        if (point.x != point2.x) {
            point3.y = point2.y;
            point3.x = point.x;
            return point3;
        }
        return point2;
    }

    protected Point checkEndPointHorizontal(Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        if (point.y != point2.y) {
            point3.y = point.y;
            point3.x = point2.x;
            return point3;
        }
        return point2;
    }

    protected void checkStartPointVert(Vector vector, Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        LineDesc lineDesc = null.new LineDesc();
        if (point.x != point2.x) {
            point3.y = point2.y;
            point3.x = point.x;
            lineDesc.setLineDesc(point3, n, n2);
        } else {
            lineDesc.setLineDesc(point2, n, n2);
        }
        vector.add(lineDesc);
    }

    protected void checkEndPointHoriz(Vector vector, Point point, int n, int n2, Point point2) {
        Point point3 = new Point();
        LineDesc lineDesc = (LineDesc)vector.lastElement();
        Point point4 = lineDesc.getPt();
        if (point.y != point4.y) {
            lineDesc = null.new LineDesc();
            point3.y = point.y;
            point3.x = point4.x;
            lineDesc.setLineDesc(point3, n, n2);
            vector.add(lineDesc);
        }
    }

    class LineDesc {
        protected Point m_pt;
        protected int m_nSeries;
        protected int m_nGroup;

        LineDesc() {
        }

        public void LineDesc() {
            this.m_pt = null;
            this.m_nSeries = 0;
            this.m_nGroup = 0;
        }

        public void LineDesc(Point point, int n, int n2) {
            this.m_pt = point;
            this.m_nSeries = n;
            this.m_nGroup = n2;
        }

        public void setLineDesc(Point point, int n, int n2) {
            this.m_pt = point;
            this.m_nSeries = n;
            this.m_nGroup = n2;
        }

        public int getGroup() {
            return this.m_nGroup;
        }

        public int getSeries() {
            return this.m_nSeries;
        }

        public Point getPt() {
            return this.m_pt;
        }
    }

    class SumObj {
        double[] m_sumPosY1 = new double[3];
        double[] m_sumPosY2 = new double[3];
        double[] m_sumNegY1 = new double[3];
        double[] m_sumNegY2 = new double[3];
        boolean m_bFirstSetIsPositive;
        boolean m_bFirstTime = true;

        public double getSum(boolean bl, boolean bl2, int n) {
            int n2;
            switch (n) {
                case 2: {
                    n2 = 1;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            if (bl) {
                if (bl2) {
                    return this.m_sumPosY2[n2];
                }
                return this.m_sumPosY1[n2];
            }
            if (bl2) {
                return this.m_sumNegY2[n2];
            }
            return this.m_sumNegY1[n2];
        }

        public void setSum(boolean bl, boolean bl2, int n, double d) {
            switch (n) {
                case 2: {
                    int n2 = 1;
                    break;
                }
                case 3: {
                    int n2 = 2;
                    break;
                }
                default: {
                    int n2 = 0;
                }
            }
            if (bl) {
                if (bl2) {
                    this.m_sumPosY2[n2] = d;
                } else {
                    this.m_sumPosY1[n2] = d;
                }
            } else if (bl2) {
                this.m_sumNegY2[n2] = d;
            } else {
                this.m_sumNegY1[n2] = d;
            }
            if (this.m_bFirstTime) {
                this.m_bFirstSetIsPositive = bl;
                this.m_bFirstTime = false;
            }
        }
    }
}

