/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.FrameObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;

public class JChart_2D_Spec
extends JChart_2D_Standard {
    protected RelativeAxisObj m_O2Axis;

    public void calc() {
        super.calc();
        this.drawSpectralMarkers();
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
    }

    protected Rectangle calcDataValuePosition(int n, int n2, Dimension dimension) {
        Rectangle rectangle = this.m_Frame.getBackWallBounds();
        int n3 = dimension.width;
        int n4 = dimension.height;
        double d = (double)rectangle.width / (double)this.m_nGroups;
        double d2 = (double)rectangle.height / (double)this.m_nSeries;
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        int n5 = seriesEnumerator.getRelativeSeries(n);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int n6 = groupsEnumerator.getRelativeGroup(n2);
        double d3 = (double)rectangle.x + (double)n6 * d;
        double d4 = (double)(rectangle.y + rectangle.height) - (double)(n5 + 1) * d2;
        int n7 = (int)(d3 + (d - (double)n3) / (double)2);
        int n8 = (int)(d4 + (d2 - (double)n4) / (double)2);
        Rectangle rectangle2 = new Rectangle(n7, n8, n3, n4);
        return rectangle2;
    }

    public void calcLegend() {
        if (this.m_Legend == null) {
            return;
        }
        if (this.m_Legend.isSpectralLegend()) {
            this.m_Legend.setY1Axis(this.m_Y1Axis);
        }
        this.m_Legend.calc();
    }

    protected void createAxes() {
        int n = 2;
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = !this.m_Perspective.getY1AxisDescending();
        boolean bl4 = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        boolean bl5 = false;
        int n3 = 0;
        int n4 = 100;
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, 7, bl, bl2);
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calc();
        }
        this.m_O2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O2_AXIS, 8, !bl, !bl2);
        if (this.m_O2Axis != null) {
            this.m_O2Axis.calc();
        }
        MinMaxObj minMaxObj = this.findLimits(0, n2, bl4, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj, bl, bl3, n3, n4, bl5);
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calc();
        }
    }

    public void createFrame() {
        this.m_Frame = new FrameObj(this.m_Perspective, true);
    }

    public void createLegend() {
        this.m_Legend = new LegendObj(this.m_Perspective, this.m_Access, this, true);
    }

    public void drawSpectralMarkers() {
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Rectangle rectangle = this.m_Frame.getBackWallBounds();
        int n = this.m_Perspective.getMarkerShape(this.m_Perspective.getSpectralMarker());
        boolean bl = true;
        if (this.m_nSeries == 0 || this.m_nGroups == 0) {
            return;
        }
        double d = (double)rectangle.width / (double)this.m_nGroups;
        double d2 = (double)rectangle.height / (double)this.m_nSeries;
        while (seriesEnumerator.hasMoreElements()) {
            int n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            int n3 = seriesEnumerator.getRelativeSeries(n2);
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nSeries);
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n4 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalGroups);
                int n5 = groupsEnumerator.getRelativeGroup(n4);
                PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nGroups);
                if (!this.m_dataOK[n2][n4]) continue;
                double d3 = this.getQuantizedDataValue(n2, n4);
                IdentObj identObj = new IdentObj(330, n2, n4);
                double d4 = this.m_Y1Axis.getValueRelCoord(d3);
                BlackBoxIF blackBoxIF = this.getBlackBox(identObj, d4);
                double d5 = (double)rectangle.x + (double)n5 * d;
                double d6 = (double)(rectangle.y + rectangle.height) - (double)(n3 + 1) * d2;
                if (n == 0) {
                    new DetRect(this.m_Detectiv, identObj, (int)d5, (int)d6, (int)d, (int)d2, blackBoxIF, false, true);
                    continue;
                }
                MarkerTemplate markerTemplate = this.m_Perspective.getMarkerTemplate(n);
                int n6 = (int)(d5 + d / (double)2);
                int n7 = (int)(d6 + d2 / (double)2);
                Point point = new Point(n6, n7);
                int n8 = 1800;
                int n9 = (int)(d * (double)100 / (double)n8);
                int n10 = (int)(d2 * (double)100 / (double)n8);
                if (this.m_bSquareMarkers) {
                    double d7;
                    double d8 = this.m_Perspective.m_VC.virtToDestWidth((double)n9);
                    if (d8 > (d7 = this.m_Perspective.m_VC.virtToDestHeight((double)n10))) {
                        n9 = (int)((double)n9 * d7 / d8);
                    } else {
                        n10 = (int)((double)n10 * d8 / d7);
                    }
                }
                new MarkerObj(this.m_Detectiv, identObj, markerTemplate, point, n9, n10, blackBoxIF, this.m_rClip, false);
            }
        }
    }

    protected Point getCoords(int n, int n2) {
        Rectangle rectangle = this.m_Frame.getBackWallBounds();
        double d = (double)rectangle.width / (double)this.m_nSeries;
        double d2 = (double)rectangle.height / (double)this.m_nGroups;
        double d3 = (double)rectangle.x + ((double)n + 0.5) * d;
        double d4 = (double)rectangle.y + ((double)n2 + 0.5) * d2;
        Point point = new Point((int)d3, (int)d4);
        return point;
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        String string2 = string;
        return string2;
    }

    public void releaseReferences() {
        if (this.m_O2Axis != null) {
            this.m_O2Axis.releaseReferences();
        }
        super.releaseReferences();
    }
}

