/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;

public class JChart_2D_BLA
extends JChart_2D_Standard {
    public static final double DEPTH_FACTOR = 12.0;
    public static final double UNSHADED = 1.0;
    public static final double SHADING_FRONT = 1.0;
    public static final double SHADING_TOP = 0.8;
    public static final double SHADING_SIDE = 0.6;
    public static final double SHADING_BOTTOM = 0.4;
    public static final boolean DRAW_NEG_SERIES = true;
    public static final boolean DRAW_POS_SERIES = false;
    boolean m_bFromZero;
    boolean m_bBipolar;
    boolean m_bDualY;
    boolean m_bBarAsPictograph;
    int m_nLineThick;
    Point[] m_seriesBackOffsets;
    Point[] m_seriesFrontOffsets;
    boolean m_bTransparentMarkers;
    boolean m_bNonZeroBaseline;
    int m_baseLineYCoord;
    private static final int INVISIBLE_RECT_SIZE = 3;

    public void calc() {
        this.m_bTransparentMarkers = this.m_Perspective.getTransparentMarkers();
        this.m_baseLineYCoord = 0;
        super.calc();
        this.calcFrontBackOffsets();
        if (this.m_gt.isRiserBar() && this.isComboWithBar()) {
            this.calcBarOrdinalCoords();
        } else {
            this.calcOrdinalCoords();
        }
        if (this.m_bBipolar && this.wantDepthEffect()) {
            this.calcBiPolarTwoHalfD();
        } else {
            if (this.m_bBipolar) {
                this.drawDualAxisLine();
            }
            this.drawAreaRisers();
            this.drawBarRisers();
            this.drawLineRisers();
        }
        if (this.m_gt.isWaterfall()) {
            this.drawWaterfallLines();
        }
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
        if (this.m_bAbsolute) {
            this.drawFitLines();
        }
    }

    private void calcBiPolarTwoHalfD() {
        boolean bl = this.m_bHorz && this.m_nDepthAngle > 90;
        this.drawDualAxisLine();
        this.drawAreaRisers(true, bl, !bl);
        this.drawAxisBarRisers(bl, !bl);
        if (bl) {
            this.drawAxisLineRisers(0);
        } else {
            this.drawAxisLineRisers(1);
        }
        this.drawAreaRisers(true, !bl, bl);
        this.drawAxisBarRisers(!bl, bl);
        if (!bl) {
            this.drawAxisLineRisers(0);
        } else {
            this.drawAxisLineRisers(1);
        }
    }

    private void calcFrontBackOffsets() {
        if (this.wantDepthEffect()) {
            this.m_seriesBackOffsets = new Point[this.m_nTotalSeries];
            this.m_seriesFrontOffsets = new Point[this.m_nTotalSeries];
            SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
            while (seriesEnumerator.hasMoreElements()) {
                int n = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
                this.m_seriesBackOffsets[n] = this.calcSeriesOffset(n, false);
                this.m_seriesFrontOffsets[n] = this.calcSeriesOffset(n, true);
            }
        }
    }

    private void drawDualAxisLine() {
        if (this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double d = (double)this.m_Perspective.getDualAxisSplitPosition() / (double)100;
            this.m_Frame.drawSeparator(this.m_bHorz, d);
        }
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double d = 0.0;
        int n = this.calcRisersPerPixel();
        boolean bl = this.m_Perspective.isNumberFormatCallBack();
        int n2 = this.m_Perspective.getDataTextFormat();
        String string = this.m_Perspective.getDataTextFormatPattern();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n3 = seriesEnumerator.nextSeries();
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n4 = groupsEnumerator.nextGroup();
                this.m_dataOK[n3][n4] = true;
                RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n3, null);
                if (relativeAxisObj == null) continue;
                DatumObj datumObj = this.getDataValue(n3, n4, DataItem.DI_GENERAL);
                d = datumObj.m_fValue;
                if (!datumObj.m_bOK) {
                    this.m_dataOK[n3][n4] = false;
                }
                if (d <= 0.0 && relativeAxisObj.isLogScale()) {
                    this.m_dataOK[n3][n4] = false;
                    d = 0.0;
                }
                if (this.isIgnoredOffScale(relativeAxisObj, d)) {
                    this.m_dataOK[n3][n4] = false;
                    d = 0.0;
                }
                this.m_numYCoords[n3][n4] = (int)relativeAxisObj.getValueCoord(d);
                if (!this.m_bDataTextDisplay) continue;
                if (bl) {
                    int n5 = this.axisAssignedToSeries(n3, DataItem.DI_GENERAL);
                    this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n4, n5, -3);
                    this.m_DataLabel[n3][n4] = this.m_Perspective.getNumberFormatCallBack().toString(d);
                    continue;
                }
                this.m_DataLabel[n3][n4] = TDGNumberFormat.toString(this.m_Perspective, n2, d, string);
            }
        }
        this.calcOverdrawEliminate(n);
    }

    private void calcOverdrawEliminate(int n) {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        if (this.m_Perspective.getOverdrawSkip() && n > 4) {
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n2 = groupsEnumerator.nextGroup();
                int n3 = this.m_nSeries / n - 1;
                int n4 = 1;
                while (n4 < n3) {
                    int n5;
                    int n6 = n4 * n;
                    int n7 = n6 + n;
                    PfjAssert.pfjAssert(n7 <= this.m_nSeries);
                    int n8 = -1;
                    int n9 = -1;
                    int n10 = Integer.MAX_VALUE;
                    int n11 = -2147483647;
                    int n12 = n6;
                    while (n12 < n7) {
                        n5 = seriesEnumerator.seriesAt(n12);
                        PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
                        if (this.m_dataOK[n5][n2]) {
                            int n13 = this.m_numYCoords[n5][n2];
                            if (n13 < n10) {
                                n10 = n13;
                                n8 = n5;
                            }
                            if (n13 > n11) {
                                n11 = n13;
                                n9 = n5;
                            }
                        }
                        ++n12;
                    }
                    if (n8 != -1) {
                        n12 = n6;
                        while (n12 < n7) {
                            n5 = seriesEnumerator.seriesAt(n12);
                            PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
                            if (n5 != n8 && n5 != n9) {
                                this.m_dataOK[n5][n2] = false;
                            }
                            ++n12;
                        }
                    }
                    ++n4;
                }
            }
        }
    }

    public Point calcSeriesOffset(int n, boolean bl) {
        Point point;
        if (bl) {
            double d = this.calcFrontOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d);
        } else {
            double d = this.calcBackOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d);
        }
        return point;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bFromZero = this.m_gt.isWaterfall() ? false : this.m_Perspective.getScaleFromZero();
        this.m_bBipolar = this.m_gt.isBipolar();
        this.m_bDualY = this.m_gt.isDualY();
        this.m_bBarAsPictograph = this.m_nDepthRadius > 0 ? false : this.m_Perspective.getDisplayBarAsPictograph();
        this.m_nLineThick = this.m_Perspective.getDataLineThickness();
    }

    private void drawAreaRisers() {
        if (this.m_nGroups >= 2) {
            if (this.wantDepthEffect()) {
                if (this.m_bBipolar) {
                    this.drawAreaRisers(true, false, true);
                }
                this.drawAreaRisers(true, true, false);
            } else {
                if (this.m_bBipolar) {
                    this.drawAreaRisers(false, false, true);
                }
                this.drawAreaRisers(false, true, false);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawAreaRisers(boolean var1_1, boolean var2_2, boolean var3_3) {
        block53: {
            block52: {
                var4_4 = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
                var6_5 = null;
                var9_6 = 0;
                var16_7 = null;
                var17_8 = null;
                var18_9 = 0;
                var19_10 = 0;
                var20_11 = false;
                var22_12 = false;
                var24_13 = this.m_nDepthAngle > 90;
                var25_14 = false;
                var26_15 = false;
                var27_16 = 0.0;
                var29_17 = null;
                var30_18 = null;
                var31_19 = new Vector<Vector<E>>();
                var32_20 = var2_2 != false ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
                if (!var1_1) break block52;
                if (this.m_bAbsolute) ** GOTO lbl-1000
                v0 = this.m_bHorz ? var32_20 != var24_13 : var32_20;
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                var20_11 = v1;
                break block53;
            }
            var20_11 = this.m_bAbsolute == false;
        }
        var21_21 = var20_11 == false;
        var5_22 = this.getResetSeriesEnumerator(var21_21);
        while (var5_22.hasMoreElements()) {
            var8_24 = var5_22.nextSeries();
            PfjAssert.pfjAssert(var8_24 >= 0 && var8_24 < this.m_nTotalSeries);
            var30_18 = null;
            var33_28 = new Vector<E>();
            var34_29 = 0;
            if (this.m_seriesTypes[var8_24] != 3) continue;
            var6_5 = this.whichAxisForSeries(var8_24, null);
            var35_30 = (int)var6_5.getValueCoord(var6_5.getMaxValue());
            var36_31 = (int)var6_5.getValueCoord(var6_5.getMinValue());
            if (var32_20) {
                var37_32 = var36_31;
                var36_31 = var35_30;
                var35_30 = var37_32;
            }
            if (var6_5 == null) continue;
            var37_32 = var6_5.getAxisObjID();
            if (var2_2 != false ? var37_32 != 0 && this.m_bBipolar != false : var3_3 != false && var37_32 != 1 && this.m_bBipolar != false) continue;
            var19_10 = (int)var6_5.getBaseCoord();
            var18_9 = (int)var6_5.getValueCoord(0.0);
            if (var19_10 > var35_30) {
                var19_10 = var35_30;
            } else if (var19_10 < var36_31) {
                var19_10 = var36_31;
            }
            if (var18_9 > var35_30) {
                var18_9 = var35_30;
            } else if (var18_9 < var36_31) {
                var18_9 = var36_31;
            }
            var38_33 = var6_5.getAxisIdentObj();
            this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(var38_33);
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                var27_16 = this.m_Perspective.getNonZeroBaselineValue(var38_33);
                if (var6_5.isLogScale() && var27_16 <= (double)false) {
                    this.m_bNonZeroBaseline = false;
                }
            }
            if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                v2 = var25_14 = var27_16 < (double)false;
                this.m_baseLineYCoord = var25_14 ? (var27_16 >= var6_5.getMinValue() ? (int)var6_5.getValueCoord(var27_16) : (int)var6_5.getValueCoord(var6_5.getBaseMin())) : (var27_16 <= var6_5.getMaxValue() ? (int)var6_5.getValueCoord(var27_16) : (int)var6_5.getValueCoord(var6_5.getBaseMax()));
                var39_34 = this.getDataValue(var8_24, var9_6, DataItem.DI_GENERAL);
                var26_15 = var39_34.m_fValue < (double)false;
            }
            var4_4.reset();
            while (var4_4.hasMoreElements()) {
                var9_6 = var4_4.nextGroup();
                PfjAssert.pfjAssert(var9_6 >= 0 && var9_6 < this.m_nTotalGroups);
                if (!var4_4.hasMoreElements()) continue;
                var10_25 = var4_4.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[var8_24][var10_25]) {
                    while (var4_4.hasMoreElements() && !this.m_dataOK[var8_24][var10_25]) {
                        var10_25 = var4_4.nextGroup();
                        var10_25 = var4_4.peekAtNextGroup();
                    }
                }
                PfjAssert.pfjAssert(var10_25 >= 0 && var10_25 < this.m_nTotalGroups);
                if (this.m_dataOK[var8_24][var9_6] && this.m_dataOK[var8_24][var10_25]) {
                    var39_34 = this.getPointInfo(var33_28, var8_24, var9_6);
                    var40_35 = this.getPointInfo(var33_28, var8_24, var10_25);
                    var7_23 = this.assignSeriesColor(var8_24, var9_6);
                    var17_8 = this.getCoords(var8_24, var9_6);
                    var16_7 = this.getCoords(var8_24, var10_25);
                    var29_17 = new Point(var16_7);
                    var30_18 = new Point(var17_8);
                    if (this.m_numYCoords[var8_24][var9_6] > var35_30 && this.m_numYCoords[var8_24][var10_25] > var35_30) {
                        if (this.m_bHorz) {
                            var17_8.x = var16_7.x = var35_30;
                        } else {
                            var17_8.y = var16_7.y = var35_30;
                        }
                    } else if (this.m_numYCoords[var8_24][var9_6] > var35_30) {
                        if (this.m_bHorz) {
                            var41_36 = this.calcyPosition(var17_8, var16_7, var35_30);
                            var17_8.x = var35_30;
                            var17_8.y = (int)var41_36;
                        } else {
                            var41_36 = this.calcxPosition(var17_8, var16_7, var35_30);
                            var17_8.y = var35_30;
                            var17_8.x = (int)var41_36;
                        }
                    } else if (this.m_numYCoords[var8_24][var10_25] > var35_30) {
                        if (this.m_bHorz) {
                            var41_37 = this.calcyPosition(var17_8, var16_7, var35_30);
                            var16_7.x = var35_30;
                            var16_7.y = (int)var41_37;
                        } else {
                            var41_38 = this.calcxPosition(var17_8, var16_7, var35_30);
                            var16_7.y = var35_30;
                            var16_7.x = (int)var41_38;
                        }
                    }
                    if (this.m_numYCoords[var8_24][var9_6] < var36_31 && this.m_numYCoords[var8_24][var10_25] < var36_31) {
                        if (this.m_bHorz) {
                            var17_8.x = var16_7.x = var36_31;
                        } else {
                            var17_8.y = var16_7.y = var36_31;
                        }
                    } else if (this.m_numYCoords[var8_24][var9_6] < var36_31) {
                        if (this.m_bHorz) {
                            var41_36 = this.calcyPosition(var17_8, var16_7, var36_31);
                            var17_8.x = var36_31;
                            var17_8.y = (int)var41_36;
                        } else {
                            var41_36 = this.calcxPosition(var17_8, var16_7, var36_31);
                            var17_8.y = var36_31;
                            var17_8.x = (int)var41_36;
                        }
                    } else if (this.m_numYCoords[var8_24][var10_25] < var36_31) {
                        if (this.m_bHorz) {
                            var41_36 = this.calcyPosition(var17_8, var16_7, var36_31);
                            var16_7.x = var36_31;
                            var16_7.y = (int)var41_36;
                        } else {
                            var41_36 = this.calcxPosition(var17_8, var16_7, var36_31);
                            var16_7.y = var36_31;
                            var16_7.x = (int)var41_36;
                        }
                    }
                    var14_26 = var17_8.x;
                    var15_27 = var17_8.y;
                    if (var34_29 == 0 && !this.m_bHorz) {
                        var39_34.lt = var41_39 = this.checkStartPointVertical(var30_18, var8_24, var9_6, var17_8);
                    } else if (var34_29 == 0 && this.m_bHorz) {
                        var39_34.lt = var41_40 = this.checkStartPointHorizontal(var30_18, var8_24, var9_6, var17_8);
                    }
                    var39_34.rt = var17_8;
                    var40_35.lt = var16_7;
                    ++var34_29;
                    var29_17.y = var16_7.y;
                    continue;
                }
                if (var34_29 != 0) {
                    if (this.m_bHorz) {
                        var39_34 = this.checkEndPointHorizontal(var29_17, var8_24, var9_6, var16_7);
                        var40_35 = this.getPointInfo(var33_28, var8_24, var9_6);
                        var40_35.rt = var39_34;
                    } else {
                        var39_34 = this.checkEndPointVertical(var29_17, var8_24, var9_6, var16_7);
                        var40_35 = this.getPointInfo(var33_28, var8_24, var9_6);
                        var40_35.rt = var39_34;
                    }
                    var34_29 = 0;
                }
                if (!this.m_dataOK[var8_24][var9_6]) {
                    var39_34 = this.getPointInfo(var33_28, var8_24, var9_6);
                    var39_34.setStatus(0);
                    var39_34.rt = var39_34.lt = this.getCoords(var8_24, var9_6);
                }
                if (var10_25 != this.m_nTotalGroups - 1) continue;
                var39_34 = this.getPointInfo(var33_28, var8_24, var10_25);
                var39_34.setStatus(0);
                var39_34.rt = var39_34.lt = this.getCoords(var8_24, var10_25);
            }
            if (var34_29 != 0) {
                if (this.m_bHorz) {
                    var39_34 = this.checkEndPointHorizontal(var29_17, var8_24, var9_6, var16_7);
                    var40_35 = this.getPointInfo(var33_28, var8_24, var9_6);
                    var40_35.rt = var39_34;
                } else {
                    var39_34 = this.checkEndPointVertical(var29_17, var8_24, var9_6, var16_7);
                    var40_35 = this.getPointInfo(var33_28, var8_24, var9_6);
                    var40_35.rt = var39_34;
                }
            }
            var31_19.add(var33_28);
        }
        if (var1_1) {
            this.drawAreaRiserFromVector25D(var31_19, var6_5, var18_9, var19_10, var21_21);
        } else {
            this.drawAreaRiserFromVector(var31_19, var6_5, var18_9, var19_10);
        }
        if (!var1_1 && !this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
            this.drawTransparentMarkers(3);
        }
    }

    private void drawAxisBarRisers(boolean bl, boolean bl2) {
        if (this.m_bAbsolute) {
            this.drawAxisBarRisersAbsolute(bl, bl2);
        } else if (this.m_bDualY && !this.m_bBipolar) {
            this.drawAxisBarRisersStackedDualY(bl, bl2);
        } else {
            this.drawAxisBarRisersStacked(bl, bl2);
        }
    }

    private void drawAxisBarRisersAbsolute(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6 = bl5 = this.m_nDepthAngle > 90;
        if (this.m_bHorz) {
            bl4 = true;
            bl3 = true;
        } else {
            bl4 = bl5;
            bl3 = bl5;
        }
        boolean bl7 = !bl3;
        boolean bl8 = !bl4;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl7);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, bl8);
        int n = seriesEnumerator.getFirstSeries();
        int n2 = seriesEnumerator.getLastSeries();
        int n3 = groupsEnumerator.getFirstGroup();
        while (groupsEnumerator.hasMoreElements()) {
            int n4;
            RelativeAxisObj relativeAxisObj;
            int n5;
            int n6 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
            if (bl) {
                seriesEnumerator.reset();
                while (seriesEnumerator.hasMoreElements()) {
                    n5 = seriesEnumerator.nextSeries();
                    PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
                    if (this.m_seriesTypes[n5] != 1 || (relativeAxisObj = this.whichAxisForSeries(n5, null)) == null || (n4 = relativeAxisObj.getAxisObjID()) != 0 && this.m_bBipolar) continue;
                    this.drawOneBarRiser(n5, n6, seriesEnumerator, groupsEnumerator);
                }
            }
            if (!bl2 || !this.m_bBipolar) continue;
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n5 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
                relativeAxisObj = this.whichAxisForSeries(n5, null);
                if (relativeAxisObj == null || (n4 = relativeAxisObj.getAxisObjID()) != 1 && this.m_bBipolar) continue;
                this.drawOneBarRiser(n5, n6, seriesEnumerator, groupsEnumerator);
            }
        }
    }

    private void drawAxisBarRisersStacked(boolean bl, boolean bl2) {
        boolean bl3 = this.m_nDepthAngle > 90;
        boolean bl4 = this.m_bHorz || bl3;
        boolean bl5 = !bl4;
        boolean bl6 = bl ? this.m_Y1Axis.isDescending() : this.m_Y2Axis.isDescending();
        boolean bl7 = this.m_bHorz ? bl6 != bl3 : bl6;
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, bl5);
        while (groupsEnumerator.hasMoreElements()) {
            int n = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
            if (bl7) {
                this.drawBarGroup(n, bl, bl2, true, false, groupsEnumerator);
                this.drawBarGroup(n, bl, bl2, false, true, groupsEnumerator);
                continue;
            }
            this.drawBarGroup(n, bl, bl2, true, true, groupsEnumerator);
            this.drawBarGroup(n, bl, bl2, false, false, groupsEnumerator);
        }
    }

    private void drawAxisBarRisersStackedDualY(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = this.m_nDepthAngle > 90;
        boolean bl5 = this.m_bHorz || bl4;
        boolean bl6 = !bl5;
        boolean bl7 = false;
        boolean bl8 = this.m_bHorz || bl4;
        boolean bl9 = this.m_Y1Axis.isDescending();
        boolean bl10 = this.m_Y2Axis.isDescending();
        boolean bl11 = this.m_bHorz ? bl9 != bl4 : (bl3 = bl9);
        boolean bl12 = this.m_bHorz ? bl10 != bl4 : bl10;
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, bl6);
        while (groupsEnumerator.hasMoreElements()) {
            int n = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
            if (bl8) {
                if (bl12) {
                    this.drawBarGroup(n, false, bl2, !bl7, false, groupsEnumerator);
                    this.drawBarGroup(n, false, bl2, bl7, true, groupsEnumerator);
                } else {
                    this.drawBarGroup(n, false, bl2, !bl7, true, groupsEnumerator);
                    this.drawBarGroup(n, false, bl2, bl7, false, groupsEnumerator);
                }
                if (bl3) {
                    this.drawBarGroup(n, bl, false, !bl7, false, groupsEnumerator);
                    this.drawBarGroup(n, bl, false, bl7, true, groupsEnumerator);
                    continue;
                }
                this.drawBarGroup(n, bl, false, !bl7, true, groupsEnumerator);
                this.drawBarGroup(n, bl, false, bl7, false, groupsEnumerator);
                continue;
            }
            if (bl3) {
                this.drawBarGroup(n, bl, false, !bl7, false, groupsEnumerator);
                this.drawBarGroup(n, bl, false, bl7, true, groupsEnumerator);
            } else {
                this.drawBarGroup(n, bl, false, !bl7, true, groupsEnumerator);
                this.drawBarGroup(n, bl, false, bl7, false, groupsEnumerator);
            }
            if (bl12) {
                this.drawBarGroup(n, false, bl2, !bl7, false, groupsEnumerator);
                this.drawBarGroup(n, false, bl2, bl7, true, groupsEnumerator);
                continue;
            }
            this.drawBarGroup(n, false, bl2, !bl7, true, groupsEnumerator);
            this.drawBarGroup(n, false, bl2, bl7, false, groupsEnumerator);
        }
    }

    private void drawAxisLineRisers(int n) {
        boolean bl = this.m_nDepthAngle > 90;
        boolean bl2 = this.m_bHorz || bl;
        boolean bl3 = !bl2;
        boolean bl4 = true;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl4);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, bl3);
        while (seriesEnumerator.hasMoreElements()) {
            int n2;
            RelativeAxisObj relativeAxisObj;
            int n3 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
            if (this.m_seriesTypes[n3] != 2 || (relativeAxisObj = this.whichAxisForSeries(n3, null)) == null || (n2 = relativeAxisObj.getAxisObjID()) != n && (!this.m_bAbsolute || this.m_bBipolar)) continue;
            if (this.m_Perspective.getConnectLineMarkers()) {
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    int n4 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalGroups);
                    if (!bl3 && n4 == groupsEnumerator.getFirstGroup()) continue;
                    this.drawOneLineRiser(n3, n4, groupsEnumerator);
                }
            }
            if (this.m_nDepthRadius <= 0) continue;
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawMarkersWithDepth(n3, true);
            } else {
                this.drawMarkersWithDepth(n3, false);
            }
            if (this.m_bMarkerDisplay || !this.m_bTransparentMarkers) continue;
            this.drawTransparentMarkersWithDepth(n3, 2);
        }
    }

    private void drawBarAsPictograph(Axis2DObj axis2DObj, Rectangle rectangle, IdentObj identObj, BlackBoxIF blackBoxIF) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = axis2DObj.getNumMajorGrids();
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.y;
        int n4 = rectangle.x;
        int n5 = rectangle.x + rectangle.width;
        double d = axis2DObj.getBaseCoord();
        int n6 = 0;
        while (n6 <= n) {
            Rectangle rectangle3;
            double d2 = axis2DObj.getMajorGridPos(n6);
            double d3 = axis2DObj.scaleToVC(d2);
            double d4 = d3 - d;
            if (this.m_bHorz) {
                if (axis2DObj.isAscending()) {
                    if (d > (double)n4) {
                        n4 = (int)d;
                    }
                    if (d3 >= (double)(rectangle.x + rectangle.width)) {
                        n5 = rectangle.x + rectangle.width;
                        rectangle2.x = n4;
                        rectangle2.width = (int)d4;
                        rectangle3 = new Rectangle(this.m_rClip);
                        if (n5 < rectangle3.x + rectangle3.width) {
                            rectangle3.width = n5 - rectangle3.x;
                        }
                        new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, rectangle3);
                    } else if (d3 > (double)n4 + d4 / (double)10) {
                        n5 = (int)d3;
                        rectangle2.x = n4;
                        rectangle2.width = n5 - n4;
                        new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, this.m_rClip);
                        d = d3;
                    }
                } else {
                    if (d < (double)n5) {
                        n5 = (int)d;
                    }
                    if (d3 < (double)rectangle.x) {
                        rectangle2.x = n4 = rectangle.x;
                        rectangle2.width = n5 - n4;
                        rectangle3 = new Rectangle(this.m_rClip);
                        if (n4 > rectangle3.x) {
                            rectangle3.x = n4;
                        }
                        new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, rectangle3);
                    } else if (d3 < (double)n5 - d4 / (double)10) {
                        rectangle2.x = n4 = (int)d3;
                        rectangle2.width = n5 - n4;
                        new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, this.m_rClip);
                        d = d3;
                    }
                }
            } else if (axis2DObj.isAscending()) {
                if (d > (double)n3) {
                    n3 = (int)d;
                }
                if (d3 >= (double)(rectangle.y + rectangle.height)) {
                    n2 = rectangle.y + rectangle.height;
                    rectangle2.y = n3;
                    rectangle2.height = (int)d4;
                    rectangle3 = new Rectangle(this.m_rClip);
                    if (n2 < rectangle3.y + rectangle3.height) {
                        rectangle3.height = n2 - rectangle3.y;
                    }
                    new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, rectangle3);
                    break;
                }
                if (d3 > (double)n3 + d4 / (double)10) {
                    n2 = (int)d3;
                    rectangle2.y = n3;
                    rectangle2.height = n2 - n3;
                    new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, this.m_rClip);
                    d = d3;
                }
            } else {
                if (d < (double)n2) {
                    n2 = (int)d;
                }
                if (d3 <= (double)rectangle.y) {
                    rectangle2.y = n3 = rectangle.y;
                    rectangle2.height = n2 - n3;
                    rectangle3 = new Rectangle(this.m_rClip);
                    if (n3 > rectangle3.y) {
                        rectangle3.y = n3;
                    }
                    new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, rectangle3);
                    break;
                }
                if (d3 < (double)n2 - d4 / (double)10) {
                    rectangle2.y = n3 = (int)d3;
                    rectangle2.height = n2 - n3;
                    new DetRect(this.m_Detectiv, identObj, rectangle2, blackBoxIF, this.m_rClip);
                    d = d3;
                }
            }
            ++n6;
        }
    }

    private void drawBarGroup(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, GroupsEnumerator groupsEnumerator) {
        boolean bl5 = !bl3;
        int n2 = groupsEnumerator.getFirstGroup();
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl5);
        int n3 = seriesEnumerator.getFirstSeries();
        int n4 = seriesEnumerator.getLastSeries();
        while (seriesEnumerator.hasMoreElements()) {
            boolean bl6;
            RelativeAxisObj relativeAxisObj;
            int n5 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
            if (this.m_seriesTypes[n5] != 1 || (relativeAxisObj = this.whichAxisForSeries(n5, null)) == null) continue;
            int n6 = (int)relativeAxisObj.getValueCoord(0.0);
            boolean bl7 = relativeAxisObj.isDescending();
            boolean bl8 = bl7 ? this.m_numYCoords[n5][n] > n6 : (bl6 = this.m_numYCoords[n5][n] < n6);
            if (!bl6 && this.getDataValue((int)n5, (int)n, (DataItem)DataItem.DI_GENERAL).m_fValue < 0.0) {
                bl6 = true;
            }
            if (bl6 != bl4) continue;
            int n7 = relativeAxisObj.getAxisObjID();
            if (!bl && n7 == 0 || !bl2 && n7 == 1) continue;
            this.drawOneBarRiser(n5, n, seriesEnumerator, groupsEnumerator);
        }
    }

    private void drawBarRisers() {
        if (this.m_bBipolar) {
            this.drawAxisBarRisers(false, true);
            this.drawAxisBarRisers(true, false);
        } else if (this.m_bDualY) {
            this.drawAxisBarRisers(true, true);
        } else {
            this.drawAxisBarRisers(true, false);
        }
    }

    private void drawLineRisers() {
        if (this.wantDepthEffect()) {
            this.drawLinesWithDepth();
        } else {
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawLines(false);
            }
            this.drawMarkers();
            if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
                this.drawTransparentMarkers(2);
            }
        }
    }

    protected void drawLinesWithDepth() {
        if (this.m_bBipolar) {
            this.drawAxisLineRisers(1);
            this.drawAxisLineRisers(0);
        } else if (this.m_bDualY) {
            this.drawAxisLineRisers(0);
            this.drawAxisLineRisers(1);
        } else {
            this.drawAxisLineRisers(0);
        }
    }

    private void drawOneBarRiser(int n, int n2, SeriesEnumerator seriesEnumerator, GroupsEnumerator groupsEnumerator) {
        int n3 = 0;
        int n4 = this.m_numYCoords[n][n2];
        double d = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_dataOK[n][n2] && this.m_seriesTypes[n] == 1) {
            Axis2DObj axis2DObj;
            int n5 = seriesEnumerator.getFirstSeries();
            int n6 = seriesEnumerator.getLastSeries();
            int n7 = groupsEnumerator.getFirstGroup();
            int n8 = groupsEnumerator.getLastGroup();
            if (this.m_gt.isWaterfall()) {
                int n9;
                if (n6 < n5) {
                    n9 = n6;
                    n6 = n5;
                    n5 = n9;
                }
                if (n8 < n7) {
                    n9 = n8;
                    n8 = n7;
                    n7 = n9;
                }
            }
            if ((axis2DObj = (Axis2DObj)this.whichAxisForSeries(n, null)) != null) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                boolean bl3;
                DatumObj datumObj;
                int n16 = (int)axis2DObj.getValueCoord(0.0);
                boolean bl4 = axis2DObj.isDescending();
                boolean bl5 = this.m_bBarAsPictograph && axis2DObj.getNumMajorGrids() > 1;
                BlackBoxIF blackBoxIF = this.assignSeriesColor(n, n2);
                BlackBoxIF blackBoxIF2 = this.getMissingDataBlackBox(n, n2);
                if (blackBoxIF2 == null) {
                    blackBoxIF2 = blackBoxIF;
                }
                RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
                IdentObj identObj = relativeAxisObj.getAxisIdentObj();
                this.m_bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(identObj);
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    d = this.m_Perspective.getNonZeroBaselineValue(identObj);
                    if (axis2DObj.isLogScale() && d <= 0.0) {
                        this.m_bNonZeroBaseline = false;
                    }
                }
                if (this.m_gt.isWaterfall()) {
                    datumObj = this.getDataValue(n, n2, DataItem.DI_GENERAL);
                    bl3 = datumObj.m_bOK && datumObj.m_fValue < 0.0;
                    n15 = this.prevSeriesForAxis(n, axis2DObj);
                } else {
                    boolean bl6 = bl3 = bl4 ? n4 > n16 : n4 < n16;
                    if (!bl3 && this.getDataValue((int)n, (int)n2, (DataItem)DataItem.DI_GENERAL).m_fValue < d) {
                        bl6 = true;
                    }
                    n15 = this.prevSeriesForAxis(n, n2, axis2DObj, bl6);
                }
                boolean bl7 = this.wantRisersFromZero(axis2DObj);
                int n17 = this.m_bAbsolute || n15 == -2 ? (bl7 ? n16 : (int)axis2DObj.getBaseCoord()) : this.m_numYCoords[n15][n2];
                if (bl7) {
                    n14 = bl4 != bl3 ? n4 : n17;
                    n13 = bl4 != bl3 ? n17 : n4;
                } else {
                    n14 = bl4 ? n4 : n17;
                    int n18 = n13 = bl4 ? n17 : n4;
                }
                if (bl4 && this.m_bNonZeroBaseline) {
                    int n19 = n14;
                    n14 = n13;
                    n13 = n19;
                }
                if (this.m_gt.isWaterfall()) {
                    if (n2 != n7 && n == n5) {
                        int n20 = n2 - 1;
                        if (bl4) {
                            n13 = this.m_numYCoords[n6][n20];
                        } else {
                            n14 = this.m_numYCoords[n6][n20];
                        }
                    }
                    if (n13 < n14) {
                        int n21 = n13;
                        n13 = n14;
                        n14 = n21;
                    }
                }
                if (this.m_bHorz) {
                    n3 = n14;
                    n12 = n13;
                    n11 = !this.m_gt.isRiserBar() ? this.m_ordCoords[n][n2] - this.m_barThickCoord / 2 : this.m_ordCoords[n][n2];
                    n10 = n11 + this.m_barThickCoord;
                } else {
                    n11 = n14;
                    n10 = n13;
                    n3 = !this.m_gt.isRiserBar() ? this.m_ordCoords[n][n2] - this.m_barThickCoord / 2 : this.m_ordCoords[n][n2];
                    n12 = n3 + this.m_barThickCoord;
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    boolean bl8 = bl = d < 0.0;
                    this.m_baseLineYCoord = bl ? (d >= relativeAxisObj.getMinValue() ? (int)relativeAxisObj.getValueCoord(d) : (int)relativeAxisObj.getValueCoord(relativeAxisObj.getBaseMin())) : (d <= relativeAxisObj.getMaxValue() ? (int)relativeAxisObj.getValueCoord(d) : (int)relativeAxisObj.getValueCoord(relativeAxisObj.getBaseMax()));
                    datumObj = this.getDataValue(n, n2, DataItem.DI_GENERAL);
                    boolean bl9 = bl2 = datumObj.m_fValue < 0.0;
                }
                if (this.m_bNonZeroBaseline && this.m_bAbsolute) {
                    if (this.m_bHorz) {
                        if (!bl) {
                            if (bl2) {
                                if (n13 <= this.m_baseLineYCoord) {
                                    n12 = this.m_baseLineYCoord;
                                } else if (n13 > this.m_baseLineYCoord) {
                                    n3 = this.m_baseLineYCoord;
                                }
                            } else if (n13 >= this.m_baseLineYCoord) {
                                n3 = this.m_baseLineYCoord;
                            } else if (n13 < this.m_baseLineYCoord) {
                                n3 = n12;
                                n12 = this.m_baseLineYCoord;
                            }
                        } else if (bl2) {
                            if (n13 <= this.m_baseLineYCoord) {
                                n12 = this.m_baseLineYCoord;
                            } else if (n13 > this.m_baseLineYCoord) {
                                n12 = this.m_baseLineYCoord;
                            }
                        } else if (n13 >= this.m_baseLineYCoord) {
                            n3 = this.m_baseLineYCoord;
                        } else if (n13 < this.m_baseLineYCoord) {
                            n3 = n12;
                            n12 = this.m_baseLineYCoord;
                        }
                    } else if (!bl) {
                        if (bl2) {
                            if (n13 <= this.m_baseLineYCoord) {
                                n10 = this.m_baseLineYCoord;
                            } else if (n13 > this.m_baseLineYCoord) {
                                n11 = this.m_baseLineYCoord;
                            }
                        } else if (n13 >= this.m_baseLineYCoord) {
                            n11 = this.m_baseLineYCoord;
                        } else if (n13 < this.m_baseLineYCoord) {
                            n11 = n10;
                            n10 = this.m_baseLineYCoord;
                        }
                    } else if (bl2) {
                        if (n14 >= this.m_baseLineYCoord) {
                            n10 = n11;
                            n11 = this.m_baseLineYCoord;
                        } else if (n14 < this.m_baseLineYCoord) {
                            n10 = this.m_baseLineYCoord;
                        }
                    } else if (n13 >= this.m_baseLineYCoord) {
                        n11 = this.m_baseLineYCoord;
                    } else if (n13 < this.m_baseLineYCoord) {
                        n11 = n10;
                        n10 = this.m_baseLineYCoord;
                    }
                }
                Rectangle rectangle = new Rectangle(n3, n11, n12 - n3, n10 - n11);
                int n22 = (int)axis2DObj.getValueCoord(axis2DObj.getMaxValue());
                int n23 = (int)axis2DObj.getValueCoord(axis2DObj.getMinValue());
                if (bl4) {
                    int n24 = n23;
                    n23 = n22;
                    n22 = n24;
                }
                if (!this.m_bHorz) {
                    if (rectangle.y >= n22 && rectangle.height != 0 && rectangle.y + rectangle.height >= n22 || rectangle.y <= n23 && rectangle.height != 0 && rectangle.y + rectangle.height <= n23) {
                        return;
                    }
                    if (rectangle.y < n23) {
                        rectangle.height -= n23 - rectangle.y;
                        rectangle.y = n23;
                    }
                    if (rectangle.y + rectangle.height > n22) {
                        rectangle.height = n22 - rectangle.y;
                    }
                } else {
                    if (rectangle.x >= n22 && rectangle.width != 0 && rectangle.x + rectangle.width >= n22 || rectangle.x <= n23 && rectangle.width != 0 && rectangle.x + rectangle.width <= n23) {
                        return;
                    }
                    if (rectangle.x < n23) {
                        rectangle.width -= n23 - rectangle.x;
                        rectangle.x = n23;
                    }
                    if (rectangle.x + rectangle.width > n22) {
                        rectangle.width = n22 - rectangle.x;
                    }
                }
                if (this.wantDepthEffect() && this.m_Frame != null) {
                    if (rectangle.width < 0 || rectangle.height < 0) {
                        return;
                    }
                    VC vC = this.m_Perspective.getVC();
                    if (!this.m_bHorz && (rectangle.height == 0 || vC.virtToDestHeight(rectangle.height) == 0) || this.m_bHorz && (rectangle.width == 0 || vC.virtToDestWidth(rectangle.width) == 0)) {
                        double d2 = relativeAxisObj.getMinValue();
                        double d3 = relativeAxisObj.getMaxValue();
                        double d4 = this.getDataValue((int)n, (int)n2, (DataItem)DataItem.DI_GENERAL).m_fValue;
                        if (d4 < d2 || d4 > d3) {
                            return;
                        }
                    }
                    if (this.m_autoGradient && !this.m_smallMarker && this.m_Perspective.m_VC.virtToDestHeight(rectangle.height) <= 3) {
                        SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(n, n2), this.m_bWantRiserBorder);
                        this.drawTwoHalfDBarRiser(n, n2, rectangle, simpleBlackBoxObj);
                    } else {
                        this.drawTwoHalfDBarRiser(n, n2, rectangle, blackBoxIF2);
                    }
                } else {
                    IdentObj identObj2 = new IdentObj(277, n, n2);
                    if (bl5) {
                        this.drawBarAsPictograph(axis2DObj, rectangle, identObj2, blackBoxIF2);
                    } else {
                        double d5;
                        int n25 = 0;
                        VC vC = this.m_Perspective.getVC();
                        if (!(this.m_bHorz || rectangle.height != 0 && vC.virtToDestHeight(rectangle.height) != 0)) {
                            d5 = 0.0;
                            if (this.m_bAbsolute && this.m_bNonZeroBaseline) {
                                d5 = d;
                            }
                            double d6 = relativeAxisObj.getMinValue();
                            double d7 = relativeAxisObj.getMaxValue();
                            double d8 = this.getDataValue((int)n, (int)n2, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (d8 >= d6 && d8 <= d7) {
                                if (d8 < 0.0) {
                                    rectangle.y -= vC.destToVirtHeight(3);
                                    rectangle.height = vC.destToVirtHeight(3);
                                    n25 = 1;
                                } else {
                                    rectangle.height = vC.destToVirtHeight(3);
                                    n25 = 2;
                                }
                            }
                        } else if (this.m_bHorz && (rectangle.width == 0 || vC.virtToDestWidth(rectangle.width) == 0)) {
                            d5 = relativeAxisObj.getMinValue();
                            double d9 = relativeAxisObj.getMaxValue();
                            double d10 = this.getDataValue((int)n, (int)n2, (DataItem)DataItem.DI_GENERAL).m_fValue;
                            if (d10 >= d5 && d10 <= d9) {
                                if (d10 < 0.0) {
                                    rectangle.x -= vC.destToVirtWidth(3);
                                    rectangle.width = vC.destToVirtWidth(3);
                                    n25 = 4;
                                } else {
                                    rectangle.width = vC.destToVirtWidth(3);
                                    n25 = 3;
                                }
                            }
                        }
                        if (this.m_autoGradient && !this.m_smallMarker && this.m_Perspective.m_VC.virtToDestHeight(rectangle.height) <= 3) {
                            SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(n, n2), this.m_bWantRiserBorder);
                            new DetRect(this.m_Detectiv, identObj2, rectangle, simpleBlackBoxObj, this.m_rClip, n25);
                        } else {
                            new DetRect(this.m_Detectiv, identObj2, rectangle, blackBoxIF2, this.m_rClip, n25);
                        }
                    }
                }
            }
        }
    }

    private void drawTwoHalfDBarRiser(int n, int n2, Rectangle rectangle, BlackBoxIF blackBoxIF) {
        Serializable serializable;
        double d;
        Polygon polygon;
        Point point = this.m_seriesBackOffsets[n];
        Point point2 = this.m_seriesFrontOffsets[n];
        rectangle.x -= point2.x;
        rectangle.y -= point2.y;
        if (this.m_nDepthAngle != 90) {
            int n3 = this.m_nDepthAngle > 90 ? rectangle.x : rectangle.x + rectangle.width;
            polygon = new Polygon();
            polygon.addPoint(n3, rectangle.y);
            polygon.addPoint(n3, rectangle.y + rectangle.height);
            polygon.addPoint(n3 + (point2.x - point.x), rectangle.y + rectangle.height + (point2.y - point.y));
            polygon.addPoint(n3 + (point2.x - point.x), rectangle.y + (point2.y - point.y));
            polygon.addPoint(n3, rectangle.y);
            d = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
            serializable = new IdentObj(312, n, n2);
            SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(n, n2), this.m_bWantRiserBorder);
            new DetPolygon(this.m_Detectiv, (IdentObj)serializable, polygon, (BlackBoxIF)simpleBlackBoxObj, d);
        }
        if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
            polygon = new Polygon();
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width + (point2.x - point.x), rectangle.y + rectangle.height + (point2.y - point.y));
            polygon.addPoint(rectangle.x + (point2.x - point.x), rectangle.y + rectangle.height + (point2.y - point.y));
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            d = 0.8;
            IdentObj identObj = new IdentObj(313, n, n2);
            serializable = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(n, n2), this.m_bWantRiserBorder);
            new DetPolygon(this.m_Detectiv, identObj, polygon, (BlackBoxIF)((Object)serializable), d);
        }
        IdentObj identObj = new IdentObj(277, n, n2);
        if (this.m_bColorAutoshadeRisers) {
            d = 1.0;
            polygon = new Polygon();
            polygon.addPoint(rectangle.x, rectangle.y);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x, rectangle.y);
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d);
        } else {
            new DetRect(this.m_Detectiv, identObj, rectangle, blackBoxIF, null);
        }
    }

    private void drawOneLineRiser(int n, int n2, GroupsEnumerator groupsEnumerator) {
        boolean bl;
        boolean bl2;
        Polygon polygon;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl3;
        double d;
        int n7;
        int n8;
        Point point;
        boolean bl4;
        double d2 = 1.0;
        int n9 = this.m_numYCoords[n][n2];
        int n10 = groupsEnumerator.getFirstGroup();
        int n11 = groupsEnumerator.getLastGroup();
        int n12 = groupsEnumerator.peekAtGroupBefore(n2);
        int n13 = groupsEnumerator.peekAtGroupAfter(n2);
        int n14 = groupsEnumerator.peekAtGroupAfter(n13);
        int n15 = groupsEnumerator.peekAtGroupBefore(n12);
        boolean bl5 = this.m_nDepthAngle > 90;
        boolean bl6 = n10 <= n11;
        boolean bl7 = false;
        boolean bl8 = false;
        PfjAssert.pfjAssert(n10 >= 0 && n11 >= 0 && n2 >= 0 && n2 < this.m_nTotalGroups);
        if (bl6) {
            if (n13 == -1) {
                return;
            }
            if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && this.m_dataOK[n][n2] && !this.m_dataOK[n][n13]) {
                while (groupsEnumerator.hasMoreElements() && !this.m_dataOK[n][n13]) {
                    int n16 = groupsEnumerator.nextGroup();
                    n13 = groupsEnumerator.peekAtGroupAfter(n16);
                    n12 = groupsEnumerator.peekAtGroupBefore(n16);
                    n14 = groupsEnumerator.peekAtGroupAfter(n16);
                    n15 = groupsEnumerator.peekAtGroupBefore(n16);
                }
            }
            if (!this.m_dataOK[n][n2] || !this.m_dataOK[n][n13]) {
                return;
            }
        } else {
            if (n12 == -1) {
                return;
            }
            if (!this.m_dataOK[n][n2] || !this.m_dataOK[n][n12]) {
                return;
            }
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D lines without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D lines without m_Frame");
        }
        Rectangle rectangle = this.m_Frame.getBackWallBounds();
        if (rectangle == null) {
            throw new AssertionException("Can't draw 2.5D lines when m_Frame has no bounding rect");
        }
        double d3 = this.m_bHorz ? (double)rectangle.width / 12.0 : (double)rectangle.height / 12.0;
        int n17 = (int)(d3 * (double)this.m_nLineThick / (double)100);
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
        int n18 = (int)relativeAxisObj.getValueCoord(0.0);
        boolean bl9 = relativeAxisObj.isDescending();
        BlackBoxIF blackBoxIF = this.assignSeriesColor(n, n2);
        BlackBoxIF blackBoxIF2 = this.getMissingDataBlackBox(n, n2);
        if (blackBoxIF2 == null) {
            blackBoxIF2 = blackBoxIF;
        }
        boolean bl10 = bl9 ? n9 > n18 : (bl4 = n9 < n18);
        if (this.wantDepthEffect()) {
            Point point2 = this.m_seriesBackOffsets[n];
            point = this.m_seriesFrontOffsets[n];
            n8 = point.x - point2.x;
            n7 = point.y - point2.y;
        } else {
            point = new Point();
            n8 = 0;
            n7 = 0;
        }
        Polygon polygon2 = new Polygon();
        Point point3 = this.getCoords(n, n2);
        Point point4 = bl6 ? this.getCoords(n, n13) : this.getCoords(n, n12);
        IdentObj identObj = relativeAxisObj.getAxisIdentObj();
        bl7 = this.m_Perspective.getScaleMaxAuto(identObj);
        bl8 = this.m_Perspective.getScaleMinAuto(identObj);
        double d4 = relativeAxisObj.getMaxValue();
        double d5 = relativeAxisObj.getMinValue();
        int n19 = (int)relativeAxisObj.getValueCoord(d4);
        int n20 = (int)relativeAxisObj.getValueCoord(d5);
        if (bl9) {
            int n21 = n20;
            n20 = n19;
            n19 = n21;
            boolean bl11 = bl8;
            bl8 = bl7;
            bl7 = bl11;
        }
        if (!bl7) {
            if (this.m_numYCoords[n][n2] > n19 && this.m_numYCoords[n][n13] > n19) {
                return;
            }
            if (this.m_numYCoords[n][n2] > n19) {
                if (this.m_bHorz) {
                    double d6 = this.calcyPosition(point3, point4, n19);
                    point3.x = n19;
                    point3.y = (int)d6;
                } else {
                    d = this.calcxPosition(point3, point4, n19);
                    point3.y = n19;
                    point3.x = (int)d;
                }
            } else if (this.m_numYCoords[n][n13] > n19) {
                if (this.m_bHorz) {
                    double d7 = this.calcyPosition(point3, point4, n19);
                    point4.x = n19;
                    point4.y = (int)d7;
                } else {
                    d = this.calcxPosition(point3, point4, n19);
                    point4.y = n19;
                    point4.x = (int)d;
                }
            }
        }
        if (!bl8) {
            if (this.m_numYCoords[n][n2] < n20 && this.m_numYCoords[n][n13] < n20) {
                return;
            }
            if (this.m_numYCoords[n][n2] < n20) {
                if (this.m_bHorz) {
                    double d8 = this.calcyPosition(point3, point4, n20);
                    point3.x = n20;
                    point3.y = (int)d8;
                } else {
                    d = this.calcxPosition(point3, point4, n20);
                    point3.y = n20;
                    point3.x = (int)d;
                }
            } else if (this.m_numYCoords[n][n13] < n20) {
                if (this.m_bHorz) {
                    double d9 = this.calcyPosition(point3, point4, n20);
                    point4.x = n20;
                    point4.y = (int)d9;
                } else {
                    d = this.calcxPosition(point3, point4, n20);
                    point4.y = n20;
                    point4.x = (int)d;
                }
            }
        }
        int n22 = point3.x - point.x;
        int n23 = point3.y - point.y;
        int n24 = point4.x - point.x;
        int n25 = point4.y - point.y;
        if (this.m_bHorz) {
            n22 += n17 / 2;
            n24 += n17 / 2;
        } else {
            n23 += n17 / 2;
            n25 += n17 / 2;
        }
        polygon2.addPoint(n22, n23);
        polygon2.addPoint(n24, n25);
        double d10 = Math.atan2(n25 - n23, n24 - n22);
        double d11 = d10 * 57.29577951308232;
        if (this.m_nDepthAngle <= 90) {
            bl3 = this.m_bHorz ? d11 < (double)(this.m_nDepthAngle - 180) : d11 > (double)this.m_nDepthAngle;
        } else {
            boolean bl12 = bl3 = d11 + (double)180 < (double)this.m_nDepthAngle;
        }
        if (this.m_bHorz) {
            n6 = n24 - n17;
            n5 = n25;
            n4 = n22 - n17;
            n3 = n23;
        } else {
            n6 = n24;
            n5 = n25 - n17;
            n4 = n22;
            n3 = n23 - n17;
        }
        polygon2.addPoint(n6, n5);
        polygon2.addPoint(n4, n3);
        polygon2.addPoint(n22, n23);
        if (bl3) {
            polygon = new Polygon();
            polygon.addPoint(n6, n5);
            polygon.addPoint(n4, n3);
            polygon.addPoint(n4 + n8, n3 + n7);
            polygon.addPoint(n6 + n8, n5 + n7);
            polygon.addPoint(n6, n5);
        } else {
            polygon = new Polygon();
            polygon.addPoint(n22, n23);
            polygon.addPoint(n24, n25);
            polygon.addPoint(n24 + n8, n25 + n7);
            polygon.addPoint(n22 + n8, n23 + n7);
            polygon.addPoint(n22, n23);
        }
        if (this.m_bColorAutoshadeRisers) {
            d2 = this.m_bHorz ? 0.6 : (bl3 ? 0.4 : 0.8);
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(318, n, n2), polygon, blackBoxIF2, d2);
        if (this.m_bColorAutoshadeRisers) {
            d2 = 1.0;
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(258, n, n2), polygon2, blackBoxIF2, d2);
        boolean bl13 = bl2 = bl5 || this.m_bHorz;
        if (bl6) {
            bl = bl2 ? n2 == n10 || n12 != -1 && !this.m_dataOK[n][n12] : n13 == n11 || n14 != -1 && !this.m_dataOK[n][n14];
        } else if (bl2) {
            bl = n2 == n11 || n13 != -1 && !this.m_dataOK[n][n13];
        } else {
            boolean bl14 = bl = n12 == n10 || n15 != -1 && !this.m_dataOK[n][n15];
        }
        if (bl) {
            Polygon polygon3 = new Polygon();
            if (bl2) {
                polygon3.addPoint(n22, n23);
                polygon3.addPoint(n4, n3);
                polygon3.addPoint(n4 + n8, n3 + n7);
                polygon3.addPoint(n22 + n8, n23 + n7);
                polygon3.addPoint(n22, n23);
            } else {
                polygon3.addPoint(n24, n25);
                polygon3.addPoint(n6, n5);
                polygon3.addPoint(n6 + n8, n5 + n7);
                polygon3.addPoint(n24 + n8, n25 + n7);
                polygon3.addPoint(n24, n25);
            }
            if (this.m_bColorAutoshadeRisers) {
                d2 = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(317, n, n2), polygon3, blackBoxIF2, d2);
        }
    }

    protected void drawWaterfallLines() {
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        int n = seriesEnumerator.getLastSeries();
        IdentObj identObj = this.m_Perspective.getWaterfallLine();
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        int n2 = this.m_Perspective.getLineWidth(identObj);
        int n3 = this.m_Perspective.getLineStyle(identObj);
        while (groupsEnumerator.hasMoreElements()) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n8 >= 0 && n8 < this.m_nTotalGroups);
            int n9 = groupsEnumerator.peekAtGroupBefore(n8);
            if (n9 == -1) continue;
            if (this.m_bHorz) {
                n7 = this.m_ordCoords[n][n9] + this.m_barThickCoord;
                n6 = this.m_ordCoords[n][n8];
                n4 = n5 = this.m_numYCoords[n][n9];
            } else {
                n5 = this.m_ordCoords[n][n9];
                n4 = this.m_ordCoords[n][n8] + this.m_barThickCoord;
                n6 = n7 = this.m_numYCoords[n][n9];
            }
            new DetLine(this.m_Detectiv, identObj, n5, n7, n4, n6, (BlackBoxIF)blackBoxObj, null, n2, n3);
        }
    }

    protected Point getCoords(int n, int n2) {
        int n3 = !this.m_bIsThisAComboWithBar && this.m_bExtendToFrameEdge ? this.m_ordCoords[n][n2] : (this.m_gt.isRiserBar() ? this.m_ordCoords[n][n2] + this.m_barThickCoord / 2 : this.m_ordCoords[n][n2]);
        Point point = this.m_bHorz ? new Point(this.m_numYCoords[n][n2], n3) : new Point(n3, this.m_numYCoords[n][n2]);
        return point;
    }

    protected Point getVCPositionsXY(int n, double d, double d2) throws AssertionException {
        int n2;
        SeriesEnumerator seriesEnumerator = this.m_sEnumForward;
        int n3 = seriesEnumerator.getFirstSeries();
        Axis2DObj axis2DObj = (Axis2DObj)this.m_O1Axis;
        Axis2DObj axis2DObj2 = (Axis2DObj)this.whichAxisForSeries(n, null);
        int n4 = (int)axis2DObj.getLowCoord((double)(n - n3), d);
        int n5 = (int)axis2DObj2.getValueCoord(d2);
        if (n5 > (n2 = (int)axis2DObj2.getValueCoord(axis2DObj2.getMaxValue()))) {
            return null;
        }
        int n6 = this.m_Perspective.getGraphType();
        int n7 = n6 >= 41 && n6 <= 47 || n6 >= 31 && n6 <= 35 ? n4 : n4 + this.m_barThickCoord / 2;
        if (this.wantDepthEffect()) {
            Point point = this.m_seriesFrontOffsets[n];
            n7 -= point.x;
            n5 -= point.y;
        }
        if (this.m_bHorz) {
            return new Point(n5, n7);
        }
        return new Point(n7, n5);
    }

    public boolean isBottomStackedArea(int n) {
        return this.isVisibleStackedArea(n, false);
    }

    public boolean isTopStackedArea(int n) {
        return this.isVisibleStackedArea(n, true);
    }

    public boolean isVisibleStackedArea(int n, boolean bl) {
        int n2 = this.getAxisAssignment(n);
        boolean bl2 = !bl;
        boolean bl3 = true;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl2);
        while (bl3 && seriesEnumerator.hasMoreElements()) {
            boolean bl4;
            int n3 = seriesEnumerator.nextSeries();
            boolean bl5 = bl2 ? n3 >= n : (bl4 = n3 <= n);
            if (bl4) break;
            if (this.m_seriesTypes[n3] != 3 || this.getAxisAssignment(n3) != n2) continue;
            bl3 = false;
        }
        return bl3;
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        String string2 = string;
        return string2;
    }

    protected boolean wantDepthEffect() {
        return this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect();
    }

    protected boolean wantRisersFromZero(RelativeAxisObj relativeAxisObj) {
        boolean bl;
        if (this.m_gt.isWaterfall()) {
            bl = false;
        } else {
            bl = this.m_bFromZero;
            if (!bl) {
                bl = relativeAxisObj.hasNegData() && !this.m_bAbsolute && !relativeAxisObj.isLogScale();
            }
        }
        return bl;
    }

    protected void drawAreaRiserFromVector(Vector vector, RelativeAxisObj relativeAxisObj, int n, int n2) {
        BlackBoxIF blackBoxIF = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = vector.size();
        int n6 = 0;
        while (n6 < n5) {
            Vector vector2 = (Vector)vector.elementAt(n6);
            Polygon polygon = new Polygon();
            int n7 = -1;
            int n8 = -1;
            boolean bl = false;
            while (!bl) {
                n7 = this.getStartGroupInSeriesVect(vector2, n7 + 1);
                n8 = this.getEndGroupInSeriesVect(vector2, n7 + 1);
                if (n7 == -1) break;
                if (n8 - n7 > 0) {
                    int n9 = n7;
                    while (n9 <= n8) {
                        PointInfo pointInfo = (PointInfo)vector2.elementAt(n9);
                        n3 = pointInfo.series;
                        n4 = pointInfo.group;
                        polygon.addPoint(pointInfo.lt.x, pointInfo.lt.y);
                        if (!pointInfo.lt.equals(pointInfo.rt)) {
                            polygon.addPoint(pointInfo.rt.x, pointInfo.rt.y);
                        }
                        if (n9 == n8) {
                            Object object;
                            PointInfo pointInfo2 = (PointInfo)vector2.elementAt(n7);
                            if (this.m_bAbsolute || n6 == n5 - 1) {
                                object = (PointInfo)vector2.elementAt(n8);
                                if (this.m_bHorz) {
                                    int n10 = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(relativeAxisObj) ? n : n2);
                                    polygon.addPoint(n10, ((PointInfo)object).rt.y);
                                    polygon.addPoint(n10, pointInfo2.lt.y);
                                } else {
                                    int n11 = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(relativeAxisObj) ? n : n2);
                                    polygon.addPoint(((PointInfo)object).rt.x, n11);
                                    polygon.addPoint(pointInfo2.lt.x, n11);
                                }
                                polygon.addPoint(pointInfo2.lt.x, pointInfo2.lt.y);
                                blackBoxIF = this.assignSeriesColor(n3, n4);
                                new DetPolygon(this.m_Detectiv, new IdentObj(256, n3), polygon, blackBoxIF, this.m_rClip);
                                polygon = new Polygon();
                            } else {
                                object = (Vector)vector.elementAt(n6 + 1);
                                int n12 = n8;
                                while (n12 >= n7) {
                                    PointInfo pointInfo3 = (PointInfo)((Vector)object).elementAt(n12);
                                    polygon.addPoint(pointInfo3.rt.x, pointInfo3.rt.y);
                                    if (!pointInfo3.lt.equals(pointInfo3.rt)) {
                                        polygon.addPoint(pointInfo3.lt.x, pointInfo3.lt.y);
                                    }
                                    --n12;
                                }
                                polygon.addPoint(pointInfo2.lt.x, pointInfo2.lt.y);
                                blackBoxIF = this.assignSeriesColor(n3, n4);
                                new DetPolygon(this.m_Detectiv, new IdentObj(256, n3), polygon, blackBoxIF, this.m_rClip);
                                polygon = new Polygon();
                            }
                        }
                        ++n9;
                    }
                }
                n7 = n8;
            }
            ++n6;
        }
    }

    protected void drawAreaRiserFromVector25D(Vector vector, RelativeAxisObj relativeAxisObj, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        int n5 = vector.size();
        int n6 = 0;
        while (n6 < n5) {
            Vector vector2 = (Vector)vector.elementAt(n6);
            Vector<Object> vector3 = new Vector<Object>();
            Vector<Point> vector4 = new Vector<Point>();
            Vector<Object> vector5 = new Vector<Object>();
            Vector<Point> vector6 = new Vector<Point>();
            Vector<Object> vector7 = new Vector<Object>();
            int n7 = -1;
            int n8 = -1;
            boolean bl2 = false;
            while (!bl2) {
                n7 = this.getStartGroupInSeriesVect(vector2, n7 + 1);
                n8 = this.getEndGroupInSeriesVect(vector2, n7 + 1);
                if (n7 == -1) break;
                if (n8 - n7 > 0) {
                    int n9 = n7;
                    while (n9 <= n8) {
                        PointInfo pointInfo = (PointInfo)vector2.elementAt(n9);
                        n3 = pointInfo.series;
                        n4 = pointInfo.group;
                        vector3.add(pointInfo.lt);
                        vector4.add(pointInfo.lt);
                        if (n9 == n7) {
                            vector5.add(pointInfo.lt);
                        }
                        if (!pointInfo.lt.equals(pointInfo.rt)) {
                            vector3.add(pointInfo.rt);
                            vector4.add(pointInfo.rt);
                        }
                        if (n9 == n8) {
                            Object object;
                            Object object2;
                            vector6.add(pointInfo.rt);
                            PointInfo pointInfo2 = (PointInfo)vector2.elementAt(n7);
                            int n10 = bl ? 0 : n5 - 1;
                            if (this.m_bAbsolute || n6 == n10) {
                                Point point;
                                object2 = (PointInfo)vector2.elementAt(n8);
                                if (this.m_bHorz) {
                                    int n11 = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(relativeAxisObj) ? n : n2);
                                    point = new Point(n11, ((PointInfo)object2).rt.y);
                                    object = new Point(n11, pointInfo2.lt.y);
                                } else {
                                    int n12 = this.m_bNonZeroBaseline && this.m_bAbsolute ? this.m_baseLineYCoord : (this.wantRisersFromZero(relativeAxisObj) ? n : n2);
                                    point = new Point(((PointInfo)object2).rt.x, n12);
                                    object = new Point(pointInfo2.lt.x, n12);
                                }
                                vector3.add(point);
                                vector3.add(object);
                                vector5.add(object);
                                vector6.add(point);
                                vector7.add(point);
                                vector7.add(object);
                                vector3.add(pointInfo2.lt);
                            } else {
                                object2 = bl ? (Vector)vector.elementAt(n6 - 1) : (Vector)vector.elementAt(n6 + 1);
                                int n13 = n8;
                                while (n13 >= n7) {
                                    object = (PointInfo)((Vector)object2).elementAt(n13);
                                    vector3.add(((PointInfo)object).rt);
                                    vector7.add(((PointInfo)object).rt);
                                    if (n13 == n8) {
                                        vector6.add(((PointInfo)object).rt);
                                    }
                                    if (n13 == n7) {
                                        vector5.add(((PointInfo)object).lt);
                                    }
                                    if (!((PointInfo)object).lt.equals(((PointInfo)object).rt)) {
                                        vector3.add(((PointInfo)object).lt);
                                        vector7.add(((PointInfo)object).lt);
                                    }
                                    --n13;
                                }
                                vector3.add(pointInfo2.lt);
                            }
                            this.draw25DPolygon(vector3, vector4, vector5, vector6, vector7, bl, n3, n4);
                            vector3 = new Vector();
                            vector4 = new Vector();
                            vector5 = new Vector();
                            vector6 = new Vector();
                            vector7 = new Vector();
                        }
                        ++n9;
                    }
                }
                n7 = n8;
            }
            if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
                this.drawTransparentMarkersWithDepth(n3, 3);
            }
            ++n6;
        }
    }

    private int getStartGroupInSeriesVect(Vector vector, int n) {
        int n2 = n;
        while (n2 < vector.size()) {
            PointInfo pointInfo = (PointInfo)vector.elementAt(n2);
            if (pointInfo.getStatus() == 1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int getEndGroupInSeriesVect(Vector vector, int n) {
        int n2 = n;
        while (n2 < vector.size()) {
            PointInfo pointInfo = (PointInfo)vector.elementAt(n2);
            if (pointInfo.getStatus() == 0) {
                return n2 - 1;
            }
            if (n2 == vector.size() - 1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private PointInfo getPointInfo(Vector vector, int n, int n2) {
        if (vector.size() == 0) {
            PointInfo pointInfo = null.new PointInfo(n, n2);
            vector.add(pointInfo);
            return pointInfo;
        }
        PointInfo pointInfo = (PointInfo)vector.lastElement();
        if (pointInfo.group == n2) {
            return pointInfo;
        }
        pointInfo = null.new PointInfo(n, n2);
        vector.add(pointInfo);
        return pointInfo;
    }

    private void draw25DPolygon(Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, boolean bl, int n, int n2) {
        int n3;
        int n4;
        int n5;
        Serializable serializable;
        Serializable serializable2;
        BlackBoxIF blackBoxIF = this.assignSeriesColor(n, n2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        boolean bl2 = this.m_nDepthAngle > 90;
        boolean bl3 = bl2 || this.m_bHorz;
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
        boolean bl4 = relativeAxisObj.isDescending();
        int n6 = (int)relativeAxisObj.getValueCoord(0.0);
        BlackBoxIF blackBoxIF2 = this.getMissingDataBlackBox(n, n2);
        if (blackBoxIF2 == null) {
            blackBoxIF2 = blackBoxIF;
        }
        BlackBoxIF blackBoxIF3 = blackBoxIF2;
        if (blackBoxIF2 instanceof BlackBoxObj) {
            serializable2 = new BlackBoxObj((BlackBoxObj)blackBoxIF2);
            serializable2.setFillType(1);
            blackBoxIF3 = serializable2;
        }
        if (this.wantDepthEffect()) {
            serializable = this.m_seriesBackOffsets[n];
            serializable2 = this.m_seriesFrontOffsets[n];
            n5 = ((Point)serializable2).x - ((Point)serializable).x;
            n4 = ((Point)serializable2).y - ((Point)serializable).y;
        } else {
            serializable2 = new Point();
            n5 = 0;
            n4 = 0;
        }
        serializable = new Polygon();
        Polygon polygon = null;
        Polygon polygon2 = null;
        Point point = null;
        int n7 = 0;
        while (n7 < vector.size()) {
            point = (Point)vector.elementAt(n7);
            ((Polygon)serializable).addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
            ++n7;
        }
        if (this.m_bAbsolute || this.isTopStackedArea(n)) {
            if (this.m_bColorAutoshadeRisers) {
                double d5 = d2 = this.m_bHorz ? 0.6 : 0.8;
            }
            if (!bl3) {
                n3 = 0;
                while (n3 < vector2.size() - 1) {
                    polygon = new Polygon();
                    point = (Point)vector2.elementAt(n3);
                    polygon.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    Point point2 = (Point)vector2.elementAt(n3 + 1);
                    polygon.addPoint(point2.x - ((Point)serializable2).x, point2.y - ((Point)serializable2).y);
                    polygon.addPoint(point2.x - ((Point)serializable2).x + n5, point2.y - ((Point)serializable2).y + n4);
                    polygon.addPoint(point.x - ((Point)serializable2).x + n5, point.y - ((Point)serializable2).y + n4);
                    polygon.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, n), polygon, blackBoxIF3, d2);
                    ++n3;
                }
            } else {
                n3 = vector2.size() - 1;
                while (n3 > 0) {
                    polygon = new Polygon();
                    point = (Point)vector2.elementAt(n3);
                    polygon.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    Point point3 = (Point)vector2.elementAt(n3 - 1);
                    polygon.addPoint(point3.x - ((Point)serializable2).x, point3.y - ((Point)serializable2).y);
                    polygon.addPoint(point3.x - ((Point)serializable2).x + n5, point3.y - ((Point)serializable2).y + n4);
                    polygon.addPoint(point.x - ((Point)serializable2).x + n5, point.y - ((Point)serializable2).y + n4);
                    polygon.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(314, n), polygon, blackBoxIF3, d2);
                    --n3;
                }
            }
        }
        if (this.m_bAbsolute || this.isBottomStackedArea(n)) {
            if (this.m_bColorAutoshadeRisers) {
                double d6 = d4 = this.m_bHorz ? 0.6 : 0.8;
            }
            if (!bl3) {
                n3 = 0;
                while (n3 < vector5.size() - 1) {
                    polygon2 = new Polygon();
                    point = (Point)vector5.elementAt(n3);
                    polygon2.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    Point point4 = (Point)vector5.elementAt(n3 + 1);
                    polygon2.addPoint(point4.x - ((Point)serializable2).x, point4.y - ((Point)serializable2).y);
                    polygon2.addPoint(point4.x - ((Point)serializable2).x + n5, point4.y - ((Point)serializable2).y + n4);
                    polygon2.addPoint(point.x - ((Point)serializable2).x + n5, point.y - ((Point)serializable2).y + n4);
                    polygon2.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(316, n), polygon2, blackBoxIF3, d4);
                    ++n3;
                }
            } else {
                n3 = vector5.size() - 1;
                while (n3 > 0) {
                    polygon2 = new Polygon();
                    point = (Point)vector5.elementAt(n3);
                    polygon2.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    Point point5 = (Point)vector5.elementAt(n3 - 1);
                    polygon2.addPoint(point5.x - ((Point)serializable2).x, point5.y - ((Point)serializable2).y);
                    polygon2.addPoint(point5.x - ((Point)serializable2).x + n5, point5.y - ((Point)serializable2).y + n4);
                    polygon2.addPoint(point.x - ((Point)serializable2).x + n5, point.y - ((Point)serializable2).y + n4);
                    polygon2.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
                    new DetPolygon(this.m_Detectiv, new IdentObj(316, n), polygon2, blackBoxIF3, d4);
                    --n3;
                }
            }
        }
        if (bl3) {
            Polygon polygon3 = new Polygon();
            point = (Point)vector3.elementAt(0);
            Point point6 = (Point)vector3.elementAt(1);
            polygon3.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
            polygon3.addPoint(point6.x - ((Point)serializable2).x, point6.y - ((Point)serializable2).y);
            polygon3.addPoint(point6.x - ((Point)serializable2).x + n5, point6.y - ((Point)serializable2).y + n4);
            polygon3.addPoint(point.x - ((Point)serializable2).x + n5, point.y - ((Point)serializable2).y + n4);
            polygon3.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
            if (this.m_bColorAutoshadeRisers) {
                d3 = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(315, n), polygon3, blackBoxIF3, d3);
        } else {
            Polygon polygon4 = new Polygon();
            point = (Point)vector4.elementAt(0);
            Point point7 = (Point)vector4.elementAt(1);
            polygon4.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
            polygon4.addPoint(point7.x - ((Point)serializable2).x, point7.y - ((Point)serializable2).y);
            polygon4.addPoint(point7.x - ((Point)serializable2).x + n5, point7.y - ((Point)serializable2).y + n4);
            polygon4.addPoint(point.x - ((Point)serializable2).x + n5, point.y - ((Point)serializable2).y + n4);
            polygon4.addPoint(point.x - ((Point)serializable2).x, point.y - ((Point)serializable2).y);
            if (this.m_bColorAutoshadeRisers) {
                d3 = this.m_bHorz ? 0.8 : 0.6;
            }
            new DetPolygon(this.m_Detectiv, new IdentObj(315, n), polygon4, blackBoxIF3, d3);
        }
        if (this.m_bColorAutoshadeRisers) {
            d = 1.0;
        }
        new DetPolygon(this.m_Detectiv, new IdentObj(256, n), (Polygon)serializable, blackBoxIF2, d);
    }

    private class PointInfo {
        public Point lt;
        public Point rt;
        public static final int NULL_STATUS = 0;
        public static final int OK_STATUS = 1;
        public int group = -1;
        public int series = -1;
        int status = 1;

        public PointInfo(int n, int n2) {
            this.series = n;
            this.group = n2;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int n) {
            this.status = n;
        }
    }
}

