/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Rectangle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.FrameObj;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;

public abstract class JChart_2D
extends JChart_Base {
    FrameObj m_Frame;
    Rectangle m_rClip;
    int m_nBaseType;
    int[] m_seriesTypes;
    int[] m_axisAssignments;
    int[] m_seriesPlanes;
    int m_nDepthPlanes;
    int m_nDepthAngle;
    int m_nDepthRadius;

    public void calc() {
        Rectangle rectangle = null;
        super.calc();
        this.createFrame();
        if (this.m_Frame != null) {
            this.m_Frame.calc();
        }
        if (this.m_Frame != null) {
            rectangle = this.m_Perspective.getFrameRect(false);
        }
        this.m_rClip = rectangle != null && !rectangle.isEmpty() ? rectangle : null;
    }

    public double calcBackOffset(int n, int n2) {
        if (n2 == 0) {
            return 0.0;
        }
        double d = 1.0 / (double)n2;
        double d2 = d * (double)n;
        return d2;
    }

    public void calcDataScrollers() {
        this.m_Frame.calcDataScrollers();
    }

    public int calcDepthPlanes() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.m_seriesPlanes = new int[this.m_nTotalSeries];
        if (this.m_bAbsolute) {
            int n3;
            int n4;
            while (seriesEnumerator.hasMoreElements()) {
                n4 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalSeries);
                n3 = this.m_seriesTypes[n4];
                if (n3 == 1) {
                    bl = true;
                    continue;
                }
                if (n3 == 3) {
                    this.m_seriesPlanes[n4] = n2++;
                    ++n;
                    continue;
                }
                if (n3 == 2) {
                    bl3 = true;
                    ++n;
                    continue;
                }
                if (n3 == 12) {
                    bl = true;
                    continue;
                }
                throw new AssertionException(String.valueOf(String.valueOf("Unknown riser type = ")) + n3 + " for series = " + n4);
            }
            int n5 = n2;
            if (bl) {
                ++n;
                seriesEnumerator.reset();
                while (seriesEnumerator.hasMoreElements()) {
                    n4 = seriesEnumerator.nextSeries();
                    n3 = this.m_seriesTypes[n4];
                    if (n3 == 1) {
                        this.m_seriesPlanes[n4] = n5;
                    }
                    if (n3 != 12) continue;
                    n = 2;
                }
                ++n5;
            }
            if (bl3) {
                seriesEnumerator.reset();
                while (seriesEnumerator.hasMoreElements()) {
                    n4 = seriesEnumerator.nextSeries();
                    n3 = this.m_seriesTypes[n4];
                    if (n3 != 2) continue;
                    this.m_seriesPlanes[n4] = n5++;
                }
            }
        } else {
            int n6;
            int n7;
            int n8 = 0;
            while (seriesEnumerator.hasMoreElements()) {
                n7 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n7 >= 0 && n7 < this.m_nTotalSeries);
                n6 = this.m_seriesTypes[n7];
                switch (n6) {
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 3: {
                        this.m_seriesPlanes[n7] = n8;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        bl3 = true;
                        break;
                    }
                    default: {
                        throw new AssertionException(String.valueOf(String.valueOf("unknown seriesType = ")) + n6);
                    }
                }
            }
            if (bl2) {
                ++n;
                ++n8;
            }
            if (bl) {
                seriesEnumerator.reset();
                while (seriesEnumerator.hasMoreElements()) {
                    n7 = seriesEnumerator.nextSeries();
                    n6 = this.m_seriesTypes[n7];
                    if (n6 != 1) continue;
                    this.m_seriesPlanes[n7] = n8;
                }
                ++n;
                ++n8;
            }
            if (bl3) {
                seriesEnumerator.reset();
                while (seriesEnumerator.hasMoreElements()) {
                    n7 = seriesEnumerator.nextSeries();
                    n6 = this.m_seriesTypes[n7];
                    if (n6 != 2) continue;
                    this.m_seriesPlanes[n7] = n8;
                }
                ++n;
            }
        }
        return n;
    }

    public double calcFrontOffset(int n, int n2) {
        if (n2 == 0) {
            return 0.0;
        }
        double d = 1.0 / (double)n2;
        double d2 = d * (double)n + d;
        return d2;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_nDepthRadius = this.m_Perspective.getDepthRadius();
        this.m_nDepthAngle = this.m_Perspective.getDepthAngle();
        this.m_nBaseType = this.m_gt.getRiserType();
        this.m_seriesTypes = this.m_Perspective.getSeriesTypes();
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            this.m_nDepthPlanes = this.calcDepthPlanes();
        }
        this.m_axisAssignments = new int[this.m_nTotalSeries];
        if (this.m_gt.isDualY() || this.m_gt.isParetoType() || this.m_gt.isMultiY()) {
            int n = 0;
            while (n < this.m_nTotalSeries) {
                this.m_axisAssignments[n] = this.m_Perspective.getAxisAssignment(n);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.m_nTotalSeries) {
                this.m_axisAssignments[n] = 0;
                ++n;
            }
        }
    }

    public void createFrame() {
        this.m_Frame = new FrameObj(this.m_Perspective);
    }

    public int getAxisAssignment(int n) {
        return this.m_axisAssignments[n];
    }

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_Frame = null;
    }

    public boolean isGroupScrollerPresent() {
        boolean bl = false;
        if (this.m_Frame != null) {
            bl = this.m_Frame.isGroupScrollerPresent();
        }
        return bl;
    }

    public Rectangle getLeftFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getLeftEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getRightFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getRightEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getBottomFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getBottomEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public void releaseReferences() {
        if (this.m_Frame != null) {
            this.m_Frame.releaseReferences();
        }
        super.releaseReferences();
    }
}

