/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.Perspective;

public class DataTextPosition {
    int m_nDataTextPosition;
    int m_nGraphType;
    Point m_ptTwoHalfDOffset;
    int m_nBaseCoord;
    Point m_ptCenterTop;
    Dimension m_dimLabel;
    boolean m_bHoriz;
    double m_fDataValue;
    boolean m_bIsAxisAscending;
    double m_fStackedCumVal;
    double m_fPercentCumVal;
    double m_fAngle;
    double m_fDist;
    boolean m_bIsCombo;
    int m_nPrevCoord;
    boolean m_bPrevCoordValid;
    boolean m_bBaseLine;
    int m_baseLineYCoord;
    double m_fBaseLineVal;
    Perspective m_Perspective;

    public DataTextPosition(int n, int n2, Point point, int n3, Point point2, Dimension dimension, double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5, boolean bl3, int n4, boolean bl4, boolean bl5, int n5, double d6, Perspective perspective) {
        this.m_nDataTextPosition = n;
        this.m_nGraphType = n2;
        this.m_ptTwoHalfDOffset = point;
        this.m_nBaseCoord = n3;
        this.m_ptCenterTop = point2;
        this.m_dimLabel = dimension;
        this.m_fDataValue = d;
        this.m_fStackedCumVal = d2;
        this.m_fPercentCumVal = d3;
        this.m_bHoriz = bl;
        this.m_bIsAxisAscending = bl2;
        this.m_fAngle = d4;
        this.m_fDist = d5;
        this.m_bIsCombo = bl3;
        this.m_nPrevCoord = n4;
        this.m_bPrevCoordValid = bl4;
        this.m_bBaseLine = bl5;
        this.m_baseLineYCoord = n5;
        this.m_fBaseLineVal = d6;
        this.m_Perspective = perspective;
    }

    protected Rectangle calcPosition() {
        Rectangle rectangle;
        int n = this.restrictPosition();
        switch (n) {
            case 0: {
                rectangle = this.calcPositionCustom();
                break;
            }
            default: {
                rectangle = this.calcPositionAbove();
                break;
            }
            case 2: {
                rectangle = this.calcPositionCenterTop();
                break;
            }
            case 3: {
                rectangle = this.calcPositionBelow();
                break;
            }
            case 4: {
                rectangle = this.calcPositionCenter();
                break;
            }
            case 5: {
                rectangle = this.calcPositionBase();
                break;
            }
            case 6: {
                rectangle = this.calcPositionBubble();
            }
        }
        if (this.m_ptTwoHalfDOffset != null) {
            rectangle.x -= this.m_ptTwoHalfDOffset.x;
            rectangle.y -= this.m_ptTwoHalfDOffset.y;
        }
        return rectangle;
    }

    protected Rectangle calcPositionCenterTop() {
        Rectangle rectangle = new Rectangle(this.m_ptCenterTop.x - this.m_dimLabel.width / 2, this.m_ptCenterTop.y - this.m_dimLabel.height / 2, this.m_dimLabel.width, this.m_dimLabel.height);
        return rectangle;
    }

    protected Rectangle calcPositionCustom() {
        Rectangle rectangle = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            this.m_fAngle -= (double)90;
        }
        if (this.m_fDataValue > 0.0) {
            rectangle.x += (int)(Math.cos(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * (double)40);
            rectangle.y += (int)(Math.sin(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * (double)40);
        } else {
            rectangle.x -= (int)(Math.cos(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * (double)40);
            rectangle.y -= (int)(Math.sin(this.m_fAngle * (Math.PI / 180)) * this.m_fDist * (double)40);
        }
        return rectangle;
    }

    protected Rectangle calcPositionAbove() {
        Rectangle rectangle = this.calcPositionCenterTop();
        double d = 0.0;
        if (this.m_bBaseLine) {
            d = this.m_fBaseLineVal;
        }
        if (this.m_bHoriz) {
            rectangle.x = this.m_bIsAxisAscending && this.m_fDataValue >= d ? (rectangle.x += this.m_dimLabel.width / 2 + this.m_Perspective.getVC().destToVirtWidth(3)) : (rectangle.x -= this.m_dimLabel.width / 2 + this.m_Perspective.getVC().destToVirtWidth(1));
        } else {
            rectangle.y = this.m_bIsAxisAscending && this.m_fDataValue >= d ? (rectangle.y += this.m_dimLabel.height / 2) : (rectangle.y -= this.m_dimLabel.height / 2);
        }
        return rectangle;
    }

    protected Rectangle calcPositionBubble() {
        Rectangle rectangle = this.calcPositionCenterTop();
        double d = 0.0;
        if (this.m_bBaseLine) {
            d = this.m_fBaseLineVal;
        }
        if (this.m_bHoriz) {
            rectangle.x = this.m_bIsAxisAscending ? (rectangle.x += this.m_dimLabel.width / 2) : (rectangle.x -= this.m_dimLabel.width / 2);
            rectangle.y = this.m_bIsAxisAscending ? (rectangle.y += this.m_dimLabel.height / 2) : (rectangle.y -= this.m_dimLabel.height / 2);
        }
        return rectangle;
    }

    protected Rectangle calcPositionBelow() {
        Rectangle rectangle = this.calcPositionCenterTop();
        double d = 0.0;
        if (this.m_bBaseLine) {
            d = this.m_fBaseLineVal;
        }
        if (this.m_bHoriz) {
            rectangle.x = this.m_bIsAxisAscending ? (rectangle.x -= this.m_dimLabel.width / 2) : (rectangle.x += this.m_dimLabel.width / 2);
            if (this.m_fDataValue < d) {
                rectangle.x += this.m_dimLabel.width;
            }
        } else {
            rectangle.y = this.m_bIsAxisAscending && this.m_fDataValue > d ? (rectangle.y -= this.m_dimLabel.height / 2) : (rectangle.y += this.m_dimLabel.height / 2);
        }
        return rectangle;
    }

    protected Rectangle calcPositionCenter() {
        Rectangle rectangle = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            switch (this.m_nGraphType) {
                case 30: {
                    if (this.m_bPrevCoordValid) {
                        rectangle.x = Math.min(this.m_ptCenterTop.x, this.m_nPrevCoord) + (Math.abs(this.m_ptCenterTop.x - this.m_nPrevCoord) - this.m_dimLabel.width) / 2;
                        break;
                    }
                    rectangle.x = Math.min(this.m_ptCenterTop.x, this.m_nBaseCoord) + (Math.abs(this.m_ptCenterTop.x - this.m_nBaseCoord) - this.m_dimLabel.width) / 2;
                    break;
                }
                case 25: 
                case 27: 
                case 29: 
                case 37: {
                    double d = this.m_fDataValue / this.m_fStackedCumVal;
                    int n = this.m_ptCenterTop.x;
                    int n2 = this.m_nBaseCoord;
                    int n3 = n - n2;
                    int n4 = (int)(d * (double)n3);
                    int n5 = n - n4;
                    int n6 = n - n5;
                    rectangle.x = n5 + n6 / 2;
                    rectangle.x -= this.m_dimLabel.width / 2;
                    break;
                }
                default: {
                    int n = this.m_nBaseCoord;
                    if (this.m_bBaseLine) {
                        n = this.m_baseLineYCoord;
                    }
                    rectangle.x = Math.min(this.m_ptCenterTop.x, n) + (Math.abs(this.m_ptCenterTop.x - n) - this.m_dimLabel.width) / 2;
                }
            }
        } else {
            switch (this.m_nGraphType) {
                case 23: {
                    if (this.m_bPrevCoordValid) {
                        rectangle.y = Math.min(this.m_ptCenterTop.y, this.m_nPrevCoord) + (Math.abs(this.m_ptCenterTop.y - this.m_nPrevCoord) - this.m_dimLabel.height) / 2;
                        break;
                    }
                    rectangle.y = Math.min(this.m_ptCenterTop.y, this.m_nBaseCoord) + (Math.abs(this.m_ptCenterTop.y - this.m_nBaseCoord) - this.m_dimLabel.height) / 2;
                    break;
                }
                case 18: 
                case 20: 
                case 22: 
                case 32: {
                    double d = this.m_fDataValue / this.m_fStackedCumVal;
                    int n = this.m_ptCenterTop.y;
                    int n7 = this.m_nBaseCoord;
                    int n8 = n - n7;
                    int n9 = (int)(d * (double)n8);
                    int n10 = n - n9;
                    int n11 = n - n10;
                    rectangle.y = n10 + n11 / 2;
                    rectangle.y -= this.m_dimLabel.height / 2;
                    break;
                }
                default: {
                    int n = this.m_nBaseCoord;
                    if (this.m_bBaseLine) {
                        n = this.m_baseLineYCoord;
                    }
                    rectangle.y = Math.min(this.m_ptCenterTop.y, n) + (Math.abs(this.m_ptCenterTop.y - n) - this.m_dimLabel.height) / 2;
                }
            }
        }
        return rectangle;
    }

    protected Rectangle calcPositionBase() {
        double d = 0.0;
        int n = this.m_nBaseCoord;
        if (this.m_bBaseLine) {
            d = this.m_fBaseLineVal;
            n = this.m_baseLineYCoord;
        }
        Rectangle rectangle = this.calcPositionCenterTop();
        if (this.m_bHoriz) {
            switch (this.m_nGraphType) {
                case 30: {
                    if (this.m_bPrevCoordValid) {
                        rectangle.x = Math.min(this.m_ptCenterTop.x, this.m_nPrevCoord);
                        break;
                    }
                    rectangle.x = Math.min(this.m_ptCenterTop.x, this.m_nBaseCoord);
                    break;
                }
                case 25: 
                case 27: 
                case 29: 
                case 37: {
                    int n2;
                    double d2 = this.m_fDataValue / this.m_fStackedCumVal;
                    int n3 = this.m_ptCenterTop.x;
                    int n4 = this.m_nBaseCoord;
                    int n5 = n3 - n4;
                    int n6 = (int)(d2 * (double)n5);
                    rectangle.x = n2 = n3 - n6;
                    break;
                }
                default: {
                    rectangle.x = n;
                }
            }
            if (this.m_fDataValue < d) {
                rectangle.x -= this.m_dimLabel.width;
            }
        } else {
            switch (this.m_nGraphType) {
                case 23: {
                    if (this.m_bPrevCoordValid) {
                        rectangle.y = Math.min(this.m_ptCenterTop.y, this.m_nPrevCoord);
                        break;
                    }
                    rectangle.y = Math.min(this.m_ptCenterTop.y, this.m_nBaseCoord);
                    break;
                }
                case 18: 
                case 20: 
                case 22: 
                case 32: {
                    int n7;
                    double d3 = this.m_fDataValue / this.m_fStackedCumVal;
                    int n8 = this.m_ptCenterTop.y;
                    int n9 = this.m_nBaseCoord;
                    int n10 = n8 - n9;
                    int n11 = (int)(d3 * (double)n10);
                    rectangle.y = n7 = n8 - n11;
                    break;
                }
                default: {
                    rectangle.y = n;
                }
            }
            if (this.m_fDataValue < d) {
                rectangle.y -= this.m_dimLabel.height;
            }
        }
        return rectangle;
    }

    protected int restrictPosition() {
        int n = this.m_nDataTextPosition;
        switch (this.m_nGraphType) {
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                if (this.m_nDataTextPosition != 4 && this.m_nDataTextPosition != 5) break;
                n = 1;
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                n = 6;
            }
        }
        if ((this.m_nDataTextPosition == 4 || this.m_nDataTextPosition == 5) && this.m_bIsCombo) {
            n = 1;
        }
        return n;
    }
}

