/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataChunk;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.PfjAssert;

public class DataStorage
implements Serializable {
    public static final int USER_PAGE = 0;
    public static final int MISSING_DATA_PAGE = 1;
    private DataRange m_DataExtents;
    private Vector m_chunks = new Vector();
    private Object[][] m_dataGrid;

    public DataStorage() {
        this.m_DataExtents = new DataRange();
    }

    public DataStorage(DataStorage dataStorage) {
        if (dataStorage.m_dataGrid != null) {
            this.m_dataGrid = (Object[][])dataStorage.m_dataGrid.clone();
        } else {
            Enumeration enumeration = dataStorage.m_chunks.elements();
            while (enumeration.hasMoreElements()) {
                DataChunk dataChunk = (DataChunk)enumeration.nextElement();
                DataChunk dataChunk2 = new DataChunk(dataChunk);
                this.m_chunks.addElement(dataChunk2);
            }
        }
        this.m_DataExtents = new DataRange(dataStorage.m_DataExtents);
    }

    public DataStorage(double[][] dArray) {
        this();
        this.setDataMatrix(dArray);
    }

    public DataStorage(double[][] dArray, int n, int n2) {
        this();
        this.setDataMatrix(n, n2, dArray);
    }

    public DataStorage(double[] dArray, int n) {
        this();
        this.setDataRow(n, dArray);
    }

    public DataStorage(double[] dArray, int n, int n2) {
        this();
        this.setDataRow(n, n2, dArray);
    }

    public void dumpPage() {
        this.dumpPage(0);
    }

    public void dumpPage(int n) {
        Enumeration enumeration = this.m_chunks.elements();
        while (enumeration.hasMoreElements()) {
            DataChunk dataChunk = (DataChunk)enumeration.nextElement();
            if (!dataChunk.isOnPage(n)) continue;
            dataChunk.dumpChunk();
        }
    }

    public DataChunk findChunk(int n, int n2, int n3) {
        int n4 = this.m_chunks.size();
        int n5 = 0;
        while (n5 < n4) {
            DataChunk dataChunk = (DataChunk)this.m_chunks.elementAt(n5);
            if (dataChunk.contains(n, n2, n3)) {
                return dataChunk;
            }
            ++n5;
        }
        return null;
    }

    public Object getData(int n, int n2) {
        Object object = null;
        PfjAssert.pfjAssert(n >= 0 && n2 >= 0);
        if (this.m_dataGrid != null) {
            object = this.m_dataGrid[n][n2];
        } else {
            DataChunk dataChunk = this.findChunk(0, n, n2);
            if (dataChunk == null) {
                PfjAssert.pfjAssert(dataChunk, String.valueOf(String.valueOf("Cell Not In Chunk for row = ")) + n + ", col = " + n2);
            }
            object = dataChunk.getData(n, n2);
        }
        if (object == null) {
            throw new AssertionException(String.valueOf(String.valueOf("Empty Cell for row = ")) + n + ", col = " + n2);
        }
        return object;
    }

    public double getDataAsDouble(int n, int n2) {
        Object object = this.getData(n, n2);
        if (DataStorage.isObjectNumeric(object)) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        throw new AssertionException(String.valueOf(String.valueOf("Cell at row = ")) + n + ", col = " + n2 + " is NOT a Number.");
    }

    public String getDataAsString(int n, int n2) {
        Object object = this.getData(n, n2);
        if (object == null) {
            throw new AssertionException(String.valueOf(String.valueOf("Cell at row = ")) + n + ", col = " + n2 + " is NULL");
        }
        String string = object.toString();
        return string;
    }

    public DataRange getDataExtents() {
        return this.m_DataExtents;
    }

    public boolean isCellNumeric(int n, int n2) {
        Object object = this.getData(n, n2);
        return DataStorage.isObjectNumeric(object);
    }

    public static boolean isObjectNumeric(Object object) {
        if (object == null) {
            return false;
        }
        boolean bl = false;
        if (object instanceof Number) {
            bl = true;
        }
        return bl;
    }

    public void setData(int n, int n2, double d) {
        this.setData(n, n2, new Double(d));
    }

    public void setData(int n, int n2, Object object) {
        PfjAssert.pfjAssert(n >= 0 && n2 >= 0);
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.m_dataGrid != null) {
            this.m_dataGrid[n][n2] = object;
        } else {
            DataChunk dataChunk = this.findChunk(0, n, n2);
            if (dataChunk == null) {
                dataChunk = new DataChunk(0, n, n2);
                this.m_chunks.addElement(dataChunk);
            }
            if (object instanceof Double && ((Double)object).isNaN()) {
                object = null;
            }
            dataChunk.setData(n, n2, object);
            if (object != null) {
                this.m_DataExtents.extendTo(n, n2);
            }
            this.setFillMissingData(n, n2, false);
        }
    }

    public void deleteRow(int n) {
        if (this.m_dataGrid != null) {
            int n2 = n;
            while (n2 < this.m_dataGrid.length) {
                this.m_dataGrid[n2] = this.m_dataGrid[n2 + 1];
                ++n2;
            }
            this.m_dataGrid[this.m_dataGrid.length - 1] = null;
        } else {
            DataChunk dataChunk;
            int n3 = this.m_DataExtents.getNumRows();
            int n4 = this.m_DataExtents.getNumCols();
            int n5 = n;
            while (n5 + 1 < n3) {
                int n6 = 0;
                while (n6 < n4) {
                    DataChunk dataChunk2;
                    dataChunk = this.findChunk(0, n5, n6);
                    if (dataChunk != null && (dataChunk2 = this.findChunk(0, n5 + 1, n6)) != null) {
                        dataChunk.setData(n5, n6, dataChunk2.getData(n5 + 1, n6));
                    }
                    ++n6;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < n4) {
                dataChunk = this.findChunk(0, n3 - 1, n5);
                if (dataChunk != null) {
                    dataChunk.setData(n3 - 1, n5, null);
                }
                ++n5;
            }
        }
        this.m_DataExtents.shrinkTo(this.m_DataExtents.getRowStart(), this.m_DataExtents.getColStart(), this.m_DataExtents.getRowStop() - 1, this.m_DataExtents.getColStop());
    }

    public void deleteCol(int n) {
        if (this.m_dataGrid != null) {
            int n2 = 0;
            while (n2 < this.m_dataGrid.length) {
                if (this.m_dataGrid[n2] != null) {
                    int n3 = n;
                    while (n3 < this.m_dataGrid[n2].length) {
                        this.m_dataGrid[n2][n3] = this.m_dataGrid[n2][n3 + 1];
                        ++n3;
                    }
                    this.m_dataGrid[n2][this.m_dataGrid[n2].length - 1] = null;
                }
                ++n2;
            }
        } else {
            DataChunk dataChunk;
            int n4 = this.m_DataExtents.getNumRows();
            int n5 = this.m_DataExtents.getNumCols();
            int n6 = n;
            while (n6 + 1 < n5) {
                int n7 = 0;
                while (n7 < n4) {
                    DataChunk dataChunk2;
                    dataChunk = this.findChunk(0, n7, n6);
                    if (dataChunk != null && (dataChunk2 = this.findChunk(0, n7, n6 + 1)) != null) {
                        dataChunk.setData(n7, n6, dataChunk2.getData(n7, n6 + 1));
                    }
                    ++n7;
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < n4) {
                dataChunk = this.findChunk(0, n6, n5 - 1);
                if (dataChunk != null) {
                    dataChunk.setData(n6, n5 - 1, null);
                }
                ++n6;
            }
        }
        this.m_DataExtents.shrinkTo(this.m_DataExtents.getRowStart(), this.m_DataExtents.getColStart(), this.m_DataExtents.getRowStop(), this.m_DataExtents.getColStop() - 1);
    }

    public void setDataMatrix(double[][] dArray) {
        this.setDataMatrix(0, 0, dArray);
    }

    public void setDataMatrix(Object[][] objectArray) {
        this.setDataMatrix(0, 0, objectArray);
    }

    public void setDataMatrix(int n, int n2, double[][] dArray) {
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                this.setData(n + n5, n2 + n6, new Double(dArray[n5][n6]));
                ++n6;
            }
            ++n5;
        }
    }

    public void setDataMatrix(int n, int n2, Object[][] objectArray) {
        int n3 = objectArray.length;
        int n4 = objectArray[0].length;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                this.setData(n + n5, n2 + n6, objectArray[n5][n6]);
                ++n6;
            }
            ++n5;
        }
    }

    public void setDataRow(int n, double[] dArray) {
        this.setDataRow(n, 0, dArray);
    }

    public void setDataRow(int n, Object[] objectArray) {
        this.setDataRow(n, 0, objectArray);
    }

    public void setDataRow(int n, int n2, double[] dArray) {
        int n3 = dArray.length;
        int n4 = 0;
        while (n4 < n3) {
            this.setData(n, n2 + n4, new Double(dArray[n4]));
            ++n4;
        }
    }

    public void setDataRow(int n, int n2, Object[] objectArray) {
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            this.setData(n, n2 + n4, objectArray[n4]);
            ++n4;
        }
    }

    public void setFillMissingData(int n, int n2, boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        DataChunk dataChunk = this.findChunk(1, n, n2);
        if (dataChunk == null) {
            dataChunk = new DataChunk(1, n, n2);
            this.m_chunks.addElement(dataChunk);
        }
        dataChunk.setData(n, n2, bl2);
    }

    public boolean isMissingDataFilledIn(int n, int n2) {
        Boolean bl;
        PfjAssert.pfjAssert(n >= 0 && n2 >= 0);
        if (this.m_dataGrid != null) {
            return false;
        }
        DataChunk dataChunk = this.findChunk(1, n, n2);
        if (dataChunk == null) {
            PfjAssert.pfjAssert(dataChunk, String.valueOf(String.valueOf("Cell Not In Chunk for row = ")) + n + ", col = " + n2);
        }
        if ((bl = (Boolean)dataChunk.getData(n, n2)) == null) {
            throw new AssertionException(String.valueOf(String.valueOf("Empty Missing Data Cell for row = ")) + n + ", col = " + n2);
        }
        return bl;
    }

    public void setGridSize(int n, int n2) {
        this.m_dataGrid = new Object[n][n2];
        this.m_DataExtents.extendTo(n - 1, n2 - 1);
    }
}

